/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.BuildSmacker;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.BuildSmacker.BitBuffer;
import ru.m210projects.BuildSmacker.Frame;
import ru.m210projects.BuildSmacker.Header;
import ru.m210projects.BuildSmacker.HuffmanTree;
import ru.m210projects.BuildSmacker.SMKAudio;

public class SMKFile {
    private static final byte[] palmap = new byte[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 65, 69, 73, 77, 81, 85, 89, 93, 97, 101, 105, 109, 113, 117, 121, 125, -126, -122, -118, -114, -110, -106, -102, -98, -94, -90, -86, -82, -78, -74, -70, -66, -61, -57, -53, -49, -45, -41, -37, -33, -29, -25, -21, -17, -13, -9, -5, -1};
    private static final short[] block_runs = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 128, 256, 512, 1024, 2048};
    private static final int TREE_MMAP = 0;
    private static final int TREE_MCLR = 1;
    private static final int TREE_FULL = 2;
    private static final int TREE_TYPE = 3;
    private static final int BLK_MONO = 0;
    private static final int BLK_FULL = 1;
    private static final int BLK_SKIP = 2;
    private static final int BLK_FILL = 3;
    private Header header;
    private Frame[] frames;
    private HuffmanTree[] tree;
    private HuffmanTree.Node[] audTree;
    private int currentFrame;
    private byte[] oldPalette;
    private byte[] currentPalette;
    private SMKAudio[] audio;
    private ByteBuffer frameBuffer;
    private BitBuffer bit;
    private boolean videoEnable;
    private boolean[] audioEnable = new boolean[7];

    public SMKFile(ByteBuffer fp) throws Exception {
        int i;
        int i2;
        this.header = new Header(fp);
        this.audio = new SMKAudio[7];
        int mask = 0;
        for (i2 = 0; i2 < 7; ++i2) {
            if (!this.header.isAudioExists(i2)) continue;
            mask |= 1 << i2;
        }
        Track.Audio.setMask(mask);
        this.frames = new Frame[this.getFrames()];
        for (i2 = 0; i2 < this.getFrames(); ++i2) {
            this.frames[i2] = new Frame(fp.getInt() & 0xFFFFFFFC);
        }
        for (i2 = 0; i2 < this.getFrames(); ++i2) {
            this.frames[i2].flags = fp.get();
        }
        this.bit = new BitBuffer();
        int pos = fp.position();
        this.bit.wrap(fp);
        this.tree = new HuffmanTree[4];
        this.audTree = new HuffmanTree.Node[4];
        for (i = 0; i < 4; ++i) {
            this.tree[i] = new HuffmanTree(this.bit){

                @Override
                protected void message(String message) {
                    SMKFile.this.message(message);
                }
            };
        }
        fp.position(pos + this.header.TreesSize);
        for (i = 0; i < this.getFrames(); ++i) {
            byte[] data = new byte[this.frames[i].size];
            fp.get(data);
            this.frames[i].buf = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.currentFrame = -1;
    }

    public int setFrame(int frame) {
        if (frame >= this.getFrames()) {
            return 2;
        }
        int frameSize = this.frames[frame].size;
        if (frameSize == 0) {
            this.message("setFrame() - Warning: frame " + frame + ": frameSize is 0");
            return -1;
        }
        if (frame == this.currentFrame) {
            return this.frames[this.currentFrame].flags & 1;
        }
        this.currentFrame = frame;
        this.frames[this.currentFrame].buf.rewind();
        if (!this.decodePalette(this.currentFrame, this.videoEnable)) {
            this.message("setFrame() - Error: frame " + this.currentFrame + ": insufficient data for a palette rec");
            return -1;
        }
        int tr = this.decodeAudio(this.currentFrame);
        if (tr != -1) {
            this.message("setFrame() - Error: frame " + this.currentFrame + ": insufficient data for audio[" + tr + "] rec");
            return -1;
        }
        if (this.videoEnable) {
            this.decodeVideo(this.currentFrame);
        }
        return this.frames[this.currentFrame].flags & 1;
    }

    public byte[] getPalette() {
        if (this.currentPalette == null) {
            int palframe = -1;
            for (int i = 0; i < this.getFrames(); ++i) {
                if ((this.frames[i].flags & 1) == 0) continue;
                palframe = i;
                this.frames[i].buf.rewind();
                break;
            }
            this.decodePalette(palframe, true);
        }
        return this.currentPalette;
    }

    public int getWidth() {
        return this.header.Width;
    }

    public int getHeight() {
        return this.header.Height;
    }

    public int getFrames() {
        return this.header.Frames;
    }

    public Header.Signature getSignature() {
        return this.header.getSignature();
    }

    public SMKAudio getAudio(int num) {
        if (this.audio[num] == null && this.isAudioExists(num)) {
            this.audio[num] = new SMKAudio(this.header.getAudioRate(num), this.header.getAudioChannels(num), this.header.getAudioBits(num), this.header.AudioSize[num]);
        }
        return this.audio[num];
    }

    public boolean isAudioExists(int num) {
        return this.audioEnable[num] && this.header.isAudioExists(num);
    }

    public void setEnable(Track opt, int mask) {
        switch (opt.ordinal()) {
            case 0: {
                this.videoEnable = (mask & 0x80) != 0;
                break;
            }
            case 1: {
                for (int i = 0; i < 7; ++i) {
                    this.audioEnable[i] = (mask & 1 << i) != 0;
                }
                break;
            }
            case 2: {
                this.videoEnable = (mask & 0x80) != 0;
                for (int i = 0; i < 7; ++i) {
                    this.audioEnable[i] = (mask & 1 << i) != 0;
                }
                break;
            }
        }
    }

    public int getFrame() {
        return this.currentFrame;
    }

    public int getRate() {
        return this.header.FrameRate;
    }

    public ByteBuffer getVideoBuffer() {
        return this.frameBuffer;
    }

    public ByteBuffer getAudioBuffer(int num) {
        int totalsize = 0;
        for (int fr = 0; fr < this.getFrames(); ++fr) {
            ByteBuffer data = this.frames[fr].buf;
            data.rewind();
            byte flags = this.frames[fr].flags;
            if ((flags & 1) != 0) {
                int pos = data.position();
                int size = 4 * (data.get() & 0xFF);
                data.position(pos + size);
            }
            for (int track = 0; track < 7; ++track) {
                if ((flags & 2 << track) == 0) continue;
                int pos = data.position();
                int size = data.getInt();
                if (this.audioEnable[track]) {
                    totalsize = this.header.getAudioCompressionType(track) == Header.AudioCompression.PCM ? (totalsize += size) : (totalsize += data.getInt());
                }
                data.position(pos + size);
            }
        }
        if (totalsize == 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(totalsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int fr = 0; fr < this.getFrames(); ++fr) {
            SMKAudio aud;
            ByteBuffer data = this.frames[fr].buf;
            data.rewind();
            this.decodePalette(fr, false);
            this.decodeAudio(fr);
            if ((this.frames[fr].flags & 2 << num) == 0 || (aud = this.audio[num]) == null) continue;
            bb.put(aud.buffer, 0, aud.size);
        }
        bb.rewind();
        return bb;
    }

    private boolean decodePalette(int frame, boolean enabled) {
        ByteBuffer data = this.frames[frame].buf;
        if ((this.frames[frame].flags & 1) != 0) {
            int pos = data.position();
            int size = 4 * (data.get() & 0xFF);
            if (size > data.remaining()) {
                return false;
            }
            if (enabled) {
                this.decodePalette(data);
            }
            data.position(pos + size);
        }
        return true;
    }

    private void decodePalette(ByteBuffer p) {
        if (this.currentPalette == null) {
            this.oldPalette = new byte[768];
            this.currentPalette = new byte[768];
        }
        System.arraycopy(this.currentPalette, 0, this.oldPalette, 0, 768);
        int sz = 0;
        while (sz < 256) {
            if ((p.get(p.position()) & 0x80) != 0) {
                sz += (p.get() & 0x7F) + 1;
                continue;
            }
            if ((p.get(p.position()) & 0x40) != 0) {
                int j = (p.get() & 0x3F) + 1;
                int off = (p.get() & 0xFF) * 3;
                while (j-- != 0 && sz < 256) {
                    System.arraycopy(this.oldPalette, off, this.currentPalette, 3 * sz, 3);
                    off += 3;
                    ++sz;
                }
                continue;
            }
            for (int c = 0; c < 3; ++c) {
                this.currentPalette[3 * sz + c] = palmap[p.get() & 0x3F];
            }
            ++sz;
        }
    }

    private int decodeAudio(int frame) {
        ByteBuffer data = this.frames[frame].buf;
        for (int track = 0; track < 7; ++track) {
            if ((this.frames[frame].flags & 2 << track) == 0) continue;
            int pos = data.position();
            int size = data.getInt();
            if (size == 0 || size > data.remaining()) {
                return track;
            }
            if (this.audioEnable[track]) {
                this.decodeAudio(data, track);
            }
            data.position(pos + size);
        }
        return -1;
    }

    private int decodeAudio(ByteBuffer data, int nTrack) {
        Arrays.fill(this.audTree, null);
        SMKAudio aud = this.getAudio(nTrack);
        switch (this.header.getAudioCompressionType(nTrack)) {
            case PCM: {
                aud.size = data.capacity();
                data.get(aud.buffer);
                break;
            }
            case DPCM: {
                int unpack;
                if (data.remaining() < 4) {
                    this.message("audio() - Error: need 4 bytes to get unpacked output buffer size");
                    return -1;
                }
                aud.size = data.getInt();
                this.bit.wrap(data);
                if (this.bit.getBit() == 0) {
                    this.message("audio() - Error: initial getBit returned 0");
                    return -1;
                }
                Header.AudioChannels channels = aud.getChannels();
                if (channels.get() - 1 != this.bit.getBit()) {
                    this.message("audio() - Error: mono/stereo mismatch");
                    return -1;
                }
                Header.AudioBits bits = aud.getBits();
                if (bits.get() != (this.bit.getBit() == 1 ? 16 : 8)) {
                    this.message("audio() - Error: 8-/16-bit mismatch");
                    return -1;
                }
                int j = 1;
                int k = 1;
                try {
                    this.audTree[0] = new HuffmanTree.Node(this.bit);
                    if (bits == Header.AudioBits.aud16bit) {
                        this.audTree[1] = new HuffmanTree.Node(this.bit);
                        k = 2;
                    }
                    if (channels == Header.AudioChannels.Stereo) {
                        this.audTree[2] = new HuffmanTree.Node(this.bit);
                        j = 2;
                        k = 2;
                        if (bits == Header.AudioBits.aud16bit) {
                            this.audTree[3] = new HuffmanTree.Node(this.bit);
                            k = 4;
                        }
                    }
                }
                catch (Exception e) {
                    this.message("audio() - Error: trees initialization failed!");
                    return -1;
                }
                if (channels == Header.AudioChannels.Stereo) {
                    unpack = this.bit.getByte();
                    if (bits == Header.AudioBits.aud16bit) {
                        aud.buffer[1] = (byte)this.bit.getByte();
                        aud.buffer[1] = (byte)(aud.buffer[1] | unpack << 8);
                    } else {
                        aud.buffer[1] = (byte)unpack;
                    }
                }
                unpack = this.bit.getByte();
                if (bits == Header.AudioBits.aud16bit) {
                    aud.buffer[0] = (byte)this.bit.getByte();
                    aud.buffer[0] = (byte)(aud.buffer[0] | unpack << 8);
                } else {
                    aud.buffer[0] = (byte)unpack;
                }
                while (k < aud.size) {
                    short value;
                    int unpack2;
                    if (bits == Header.AudioBits.aud8bit) {
                        unpack = this.audTree[0].lookup(this.bit);
                        aud.buffer[j] = (byte)(unpack + aud.buffer[j - channels.get()] & 0xFF);
                        ++j;
                        ++k;
                    } else {
                        unpack = this.audTree[0].lookup(this.bit);
                        unpack2 = this.audTree[1].lookup(this.bit);
                        value = (short)((unpack | unpack2 << 8) + aud.buffer[j - channels.get()] & 0xFF);
                        aud.buffer[j++] = (byte)(value & 0xFF);
                        aud.buffer[j++] = (byte)(value >>> 8 & 0xFF);
                        k += 2;
                    }
                    if (channels != Header.AudioChannels.Stereo) continue;
                    if (bits == Header.AudioBits.aud8bit) {
                        unpack = this.audTree[2].lookup(this.bit);
                        aud.buffer[j] = (byte)(unpack + aud.buffer[j - 2] & 0xFF);
                        ++j;
                        ++k;
                        continue;
                    }
                    unpack = this.audTree[2].lookup(this.bit);
                    unpack2 = this.audTree[3].lookup(this.bit);
                    value = (short)((unpack | unpack2 << 8) + aud.buffer[j - 2] & 0xFF);
                    aud.buffer[j++] = (byte)(value & 0xFF);
                    aud.buffer[j++] = (byte)(value >>> 8 & 0xFF);
                    k += 2;
                }
                break;
            }
        }
        return 0;
    }

    private boolean decodeVideo(int frame) {
        if (this.frameBuffer == null) {
            this.frameBuffer = ByteBuffer.wrap(new byte[this.getWidth() * this.getHeight()]).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.bit.wrap(this.frames[frame].buf);
        for (int i = 0; i < 4; ++i) {
            this.tree[i].reset();
        }
        this.frameBuffer.rewind();
        int blk = 0;
        int bw = this.getWidth() >> 2;
        int bh = this.getHeight() >> 2;
        int blocks = bw * bh;
        int stride = this.getWidth();
        while (blk < blocks) {
            int type = this.tree[3].getCode(this.bit);
            int run = block_runs[type >> 2 & 0x3F];
            switch (type & 3) {
                case 0: {
                    while (run-- != 0 && blk < blocks) {
                        int clr = this.tree[1].getCode(this.bit);
                        int map = this.tree[0].getCode(this.bit);
                        int ptr = blk / bw * (stride * 4) + blk % bw * 4;
                        byte hi = (byte)(clr >> 8);
                        byte lo = (byte)(clr & 0xFF);
                        int shift = 1;
                        for (int i = 0; i < 4; ++i) {
                            for (int k = 0; k < 4; ++k) {
                                this.frameBuffer.put(ptr + k, (map & shift) != 0 ? hi : lo);
                                shift <<= 1;
                            }
                            ptr += stride;
                        }
                        ++blk;
                    }
                    break;
                }
                case 1: {
                    int ptr;
                    int mode = 0;
                    if (this.header.getSignature() == Header.Signature.SMK4) {
                        if (this.bit.getBit() != 0) {
                            mode = 1;
                        } else if (this.bit.getBit() != 0) {
                            mode = 2;
                        }
                    }
                    while (run-- != 0 && blk < blocks) {
                        ptr = blk / bw * (stride * 4) + blk % bw * 4;
                        switch (mode) {
                            case 0: {
                                int i;
                                for (i = 0; i < 4; ++i) {
                                    this.frameBuffer.putInt(ptr, this.tree[2].getCode(this.bit) << 16 | this.tree[2].getCode(this.bit));
                                    ptr += stride;
                                }
                                break;
                            }
                            case 1: {
                                int j;
                                for (int k = 0; k < 2; ++k) {
                                    int pix = this.tree[2].getCode(this.bit);
                                    for (j = 0; j < 2; ++j) {
                                        for (int i = 0; i < 4; ++i) {
                                            this.frameBuffer.put(ptr + i, i < 2 ? (byte)pix : (byte)(pix >> 8));
                                        }
                                        ptr += stride;
                                    }
                                }
                                break;
                            }
                            case 2: {
                                int j;
                                int i;
                                for (i = 0; i < 2; ++i) {
                                    int col = this.tree[2].getCode(this.bit) << 16 | this.tree[2].getCode(this.bit);
                                    for (j = 0; j < 2; ++j) {
                                        this.frameBuffer.putInt(ptr, col);
                                        ptr += stride;
                                    }
                                }
                                break;
                            }
                        }
                        ++blk;
                    }
                    break;
                }
                case 2: {
                    while (run-- != 0 && blk < blocks) {
                        ++blk;
                    }
                    break;
                }
                case 3: {
                    int ptr;
                    int mode = type >> 8;
                    while (run-- != 0 && blk < blocks) {
                        ptr = blk / bw * (stride * 4) + blk % bw * 4;
                        int col = mode * 0x1010101;
                        for (int i = 0; i < 4; ++i) {
                            this.frameBuffer.putInt(ptr, col);
                            ptr += stride;
                        }
                        ++blk;
                    }
                    break;
                }
            }
        }
        return true;
    }

    protected void message(String message) {
        System.err.println(message);
    }

    public static enum Track {
        Video(128),
        Audio(1),
        All(255);

        private int mask;

        private Track(int mask) {
            this.mask = mask;
        }

        public int mask() {
            return this.mask;
        }

        protected void setMask(int mask) {
            this.mask = mask;
        }
    }
}

