/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import java.util.Objects;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Point;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Duke3D.Animate;
import ru.m210projects.Duke3D.DSector;
import ru.m210projects.Duke3D.Gamedef;
import ru.m210projects.Duke3D.Gameutils;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.LoadSave;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Screens.DemoScreen;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Spawn;
import ru.m210projects.Duke3D.Types.GameType;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.View;
import ru.m210projects.Duke3D.Weapons;

public class Actors {
    public static final int[] tempshort = new int[Engine.MAXSECTORS];
    public static final byte[] statlist = new byte[]{0, 1, 6, 10, 12, 2, 5};
    public static int actor_tog = 0;
    public static int otherp;

    public static boolean badguy(Sprite s) {
        if (s == null) {
            return false;
        }
        switch (s.getPicnum()) {
            case 675: 
            case 1267: 
            case 1550: 
            case 1680: 
            case 1681: 
            case 1682: 
            case 1715: 
            case 1725: 
            case 1741: 
            case 1742: 
            case 1744: 
            case 1820: 
            case 1880: 
            case 1920: 
            case 1921: 
            case 1960: 
            case 2000: 
            case 2001: 
            case 2045: 
            case 2120: 
            case 2150: 
            case 2160: 
            case 2165: 
            case 2360: 
            case 2370: 
            case 2371: 
            case 2372: 
            case 2373: 
            case 2374: 
            case 2375: 
            case 2376: 
            case 2377: 
            case 2420: 
            case 2630: 
            case 2710: 
            case 2760: 
            case 4740: {
                return true;
            }
            case 5180: 
            case 5310: 
            case 5311: {
                if (Globals.currentGame.getCON().type != 20) break;
                return true;
            }
        }
        return Globals.currentGame.getCON().actortype[s.getPicnum()] != 0;
    }

    public static boolean badguypic(int pn) {
        switch (pn) {
            case 675: 
            case 1267: 
            case 1550: 
            case 1680: 
            case 1681: 
            case 1682: 
            case 1715: 
            case 1725: 
            case 1741: 
            case 1742: 
            case 1744: 
            case 1820: 
            case 1880: 
            case 1920: 
            case 1921: 
            case 1960: 
            case 2000: 
            case 2001: 
            case 2045: 
            case 2120: 
            case 2150: 
            case 2160: 
            case 2165: 
            case 2360: 
            case 2370: 
            case 2371: 
            case 2372: 
            case 2373: 
            case 2374: 
            case 2375: 
            case 2376: 
            case 2377: 
            case 2420: 
            case 2630: 
            case 2710: 
            case 2760: 
            case 4740: {
                return true;
            }
            case 5180: 
            case 5310: 
            case 5311: {
                if (Globals.currentGame.getCON().type != 20) break;
                return true;
            }
        }
        return pn < Engine.MAXTILES && Globals.currentGame.getCON().actortype[pn] != 0;
    }

    public static int LocateTheLocator(int n, int sn) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(7); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sn != -1 && sn != sp.getSectnum() || n != sp.getLotag()) continue;
            return node.getIndex();
        }
        return -1;
    }

    public static boolean ifsquished(int i, int p) {
        Sprite sp = Main.boardService.getSprite(i);
        if (sp == null) {
            return false;
        }
        boolean squishme = false;
        if (sp.getPicnum() == 1405 && Globals.ud.clipping) {
            return false;
        }
        Sector sc = Main.boardService.getSector(sp.getSectnum());
        if (sc == null) {
            return false;
        }
        int floorceildist = sc.getFloorz() - sc.getCeilingz();
        if (sc.getLotag() != 23) {
            if (sp.getPal() == 1) {
                squishme = floorceildist < 8192 && (sc.getLotag() & 0x8000) == 0;
            } else {
                boolean bl = squishme = floorceildist < 3072;
            }
        }
        if (squishme) {
            View.FTA(10, Globals.ps[p]);
            if (Actors.badguy(sp)) {
                sp.setXvel(0);
            }
            if (sp.getPal() == 1) {
                Globals.hittype[i].picnum = 2595;
                Globals.hittype[i].extra = 1;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void hitradius(int i, int r, int hp1, int hp2, int hp3, int hp4) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return;
        }
        if ((s.getPicnum() != 2605 || s.getXrepeat() >= 11) && s.getPicnum() != 1646) {
            Actors.tempshort[0] = s.getSectnum();
            int sectcnt = 0;
            int sectend = 1;
            int sect = 0;
            do {
                int dasect;
                Sector sec;
                if ((sec = Main.boardService.getSector(dasect = tempshort[sectcnt++])) == null || sec.getWallNode() == null) continue;
                if (sec.getCeilingz() - s.getZ() >> 8 < r) {
                    Wall walptr = sec.getWallNode().get();
                    int d = Pragmas.klabs(walptr.getX() - s.getX()) + Pragmas.klabs(walptr.getY() - s.getY());
                    if (d < r) {
                        DSector.checkhitceiling(dasect);
                    } else {
                        Wall w3 = walptr.getWall2().getWall2();
                        d = Pragmas.klabs(w3.getX() - s.getX()) + Pragmas.klabs(w3.getY() - s.getY());
                        if (d < r) {
                            DSector.checkhitceiling(dasect);
                        }
                    }
                }
                int startwall = sec.getWallptr();
                int endwall = startwall + sec.getWallnum();
                for (int x = startwall; x < endwall; ++x) {
                    int y1;
                    int x1;
                    Wall wal = Main.boardService.getWall(x);
                    if (wal == null || Pragmas.klabs(wal.getX() - s.getX()) + Pragmas.klabs(wal.getY() - s.getY()) >= r) continue;
                    short nextsect = wal.getNextsector();
                    if (nextsect >= 0) {
                        int ndasect;
                        for (ndasect = sectend - 1; ndasect >= 0 && tempshort[ndasect] != nextsect; --ndasect) {
                        }
                        if (ndasect < 0) {
                            Actors.tempshort[sectend++] = nextsect;
                        }
                    }
                    if ((sect = Main.engine.updatesector(x1 = (wal.getX() + wal.getWall2().getX() >> 1) + s.getX() >> 1, y1 = (wal.getY() + wal.getWall2().getY() >> 1) + s.getY() >> 1, sect)) < 0 || !Main.engine.cansee(x1, y1, s.getZ(), sect, s.getX(), s.getY(), s.getZ(), s.getSectnum())) continue;
                    DSector.checkhitwall(i, x, wal.getX(), wal.getY(), s.getZ(), s.getPicnum());
                }
            } while (sectcnt < sectend);
        }
        int q = -4096 + (Main.engine.krand() & 0x1FFF);
        for (int x = 0; x < 7; ++x) {
            ListNode<Sprite> node = Main.boardService.getStatNode(statlist[x]);
            while (node != null) {
                ListNode<Sprite> nextj = node.getNext();
                Sprite sj = node.get();
                int j = node.getIndex();
                Sprite sowner = Main.boardService.getSprite(s.getOwner());
                if (!(sowner != null && sowner.getPicnum() == 1405 && sj.getPicnum() == 1405 && Globals.ud.coop != 0 && Globals.ud.ffire == 0 && s.getOwner() != j || sowner != null && s.getPicnum() == 1891 && (sowner.getPicnum() == 5180 && sj.getPicnum() == 5180 || sowner.getPicnum() == 5310 && sj.getPicnum() == 5310))) {
                    if (x == 0 || x >= 5 || Gameutils.AFLAMABLE(sj.getPicnum())) {
                        if (!(s.getPicnum() == 1646 && (sj.getCstat() & 0x101) == 0 || DSector.dist(s, sj) >= r || Actors.badguy(sj) && !Main.engine.cansee(sj.getX(), sj.getY(), sj.getZ() + q, sj.getSectnum(), s.getX(), s.getY(), s.getZ() + q, s.getSectnum()))) {
                            DSector.checkhitsprite(j, i);
                        }
                    } else if (!(sj.getExtra() < 0 || sj == s || sj.getPicnum() != 2566 && !Actors.badguy(sj) && sj.getPicnum() != 902 && sj.getPicnum() != 901 && (sj.getCstat() & 0x101) == 0 && sj.getPicnum() != 1518 || s.getPicnum() == 1646 && sj.getPicnum() != 1550 && (j == s.getOwner() || sj.getXrepeat() < 24) || s.getPicnum() == 1650 && j == s.getOwner())) {
                        if (sj.getPicnum() == 1405) {
                            sj.setZ(sj.getZ() - 9728);
                        }
                        int d = DSector.dist(s, sj);
                        if (sj.getPicnum() == 1405) {
                            sj.setZ(sj.getZ() + 9728);
                        }
                        if (d < r && Main.engine.cansee(sj.getX(), sj.getY(), sj.getZ() - 2048, sj.getSectnum(), s.getX(), s.getY(), s.getZ() - 3072, s.getSectnum())) {
                            Globals.hittype[j].ang = EngineUtils.getAngle(sj.getX() - s.getX(), sj.getY() - s.getY());
                            Globals.hittype[j].picnum = s.getPicnum() == 2605 && sj.getExtra() > 0 ? 2605 : (s.getPicnum() == 1646 || s.getPicnum() == 1891 ? (int)s.getPicnum() : (s.getPicnum() != 5163 || sowner != null && sowner.getPicnum() != 1405 ? (s.getPicnum() == 5304 ? 1891 : 1670) : 1891));
                            if (s.getPicnum() != 1646 && s.getPicnum() != 5304) {
                                if (d < r / 3) {
                                    if (hp4 == hp3) {
                                        ++hp4;
                                    }
                                    Globals.hittype[j].extra = hp3 + Main.engine.krand() % (hp4 - hp3);
                                } else if (d < 2 * r / 3) {
                                    if (hp3 == hp2) {
                                        ++hp3;
                                    }
                                    Globals.hittype[j].extra = hp2 + Main.engine.krand() % (hp3 - hp2);
                                } else {
                                    if (hp2 == hp1) {
                                        ++hp2;
                                    }
                                    Globals.hittype[j].extra = hp1 + Main.engine.krand() % (hp2 - hp1);
                                }
                                if (sj.getPicnum() != 1975 && sj.getPicnum() != 2360 && sj.getPicnum() != 1960 && sj.getPicnum() != 2630 && sj.getPicnum() != 2710 && sj.getPicnum() != 2760 && sj.getPicnum() != 4740) {
                                    if (sj.getXvel() < 0) {
                                        sj.setXvel(0);
                                    }
                                    sj.setXvel(sj.getXvel() + (s.getExtra() << 2));
                                }
                                if (sj.getPicnum() == 1294 || sj.getPicnum() == 1312 || sj.getPicnum() == 1317 || sj.getPicnum() == 1321 || sj.getPicnum() == 1325 || sj.getPicnum() == 1323 || sj.getPicnum() == 1334 || sj.getPicnum() == 1395 || sj.getPicnum() == 1336 || sj.getPicnum() == 3450 || sj.getPicnum() == 4864 || sj.getPicnum() == 753 || sj.getPicnum() == 869 || sj.getPicnum() == 1353 || sj.getPicnum() == 902 || sj.getPicnum() == 901) {
                                    DSector.checkhitsprite(j, i);
                                }
                            } else if (s.getExtra() == 0) {
                                Globals.hittype[j].extra = 0;
                            }
                            if (sj.getPicnum() != 1670 && sowner != null && sowner.getStatnum() < 1024) {
                                if (sj.getPicnum() == 1405) {
                                    short p = sj.getYvel();
                                    if (Globals.hittype[j].picnum == 1891 && sowner.getPicnum() == 1405) {
                                        Globals.ps[p].numloogs = -1 - s.getYvel();
                                    }
                                    if (Globals.ps[p].newowner >= 0) {
                                        Globals.ps[p].newowner = (short)-1;
                                        Globals.ps[p].posx = Globals.ps[p].oposx;
                                        Globals.ps[p].posy = Globals.ps[p].oposy;
                                        Globals.ps[p].posz = Globals.ps[p].oposz;
                                        Globals.ps[p].ang = Globals.ps[p].oang;
                                        Globals.ps[p].cursectnum = Main.engine.updatesector(Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].cursectnum);
                                        Player.setpal(Globals.ps[p]);
                                        System.err.println("a8?");
                                        for (ListNode<Sprite> k = Main.boardService.getStatNode(1); k != null; k = k.getNext()) {
                                            Sprite sp = k.get();
                                            if (sp.getPicnum() != 621) continue;
                                            sp.setYvel(0);
                                        }
                                    }
                                }
                                Globals.hittype[j].owner = s.getOwner();
                            }
                        }
                    }
                }
                node = nextj;
            }
        }
    }

    public static int movesprite(int spritenum, int xchange, int ychange, int zchange, int cliptype) {
        int moveHit;
        Sprite spr = Main.boardService.getSprite(spritenum);
        if (spr == null) {
            return 0;
        }
        boolean bg = Actors.badguy(spr);
        Main.game.pInt.setsprinterpolate(spritenum, spr);
        if (spr.getStatnum() == 5 || bg && spr.getXrepeat() < 4) {
            spr.setX(spr.getX() + (xchange * 4 >> 2));
            spr.setY(spr.getY() + (ychange * 4 >> 2));
            spr.setZ(spr.getZ() + (zchange * 4 >> 2));
            if (bg) {
                Main.engine.setsprite(spritenum, spr.getX(), spr.getY(), spr.getZ());
            }
            return 0;
        }
        short dasectnum = spr.getSectnum();
        int daz = spr.getZ();
        int h = Main.engine.getTile(spr.getPicnum()).getHeight() * spr.getYrepeat() << 1;
        daz -= h;
        if (bg) {
            int oldx = spr.getX();
            int oldy = spr.getY();
            if (spr.getXrepeat() > 60) {
                moveHit = Main.engine.clipmove(spr.getX(), spr.getY(), daz, dasectnum, (long)xchange * 4L << 11, (long)ychange * 4L << 11, 1024, 1024, 1024, cliptype);
            } else {
                int cd = 192;
                if (spr.getPicnum() == 2120) {
                    cd = 292;
                } else if ((Globals.currentGame.getCON().actortype[spr.getPicnum()] & 3) != 0) {
                    cd = spr.getClipdist() << 2;
                }
                moveHit = Main.engine.clipmove(spr.getX(), spr.getY(), daz, dasectnum, (long)xchange * 4L << 11, (long)ychange * 4L << 11, cd, 1024, 1024, cliptype);
            }
            spr.setX(Engine.clipmove_x);
            spr.setY(Engine.clipmove_y);
            dasectnum = Engine.clipmove_sectnum;
            Sector sec = Main.boardService.getSector(dasectnum);
            if (sec == null || Globals.hittype[spritenum].actorstayput >= 0 && Globals.hittype[spritenum].actorstayput != dasectnum || spr.getPicnum() == 2710 && spr.getPal() == 0 && sec.getLotag() != 3 || (spr.getPicnum() == 2630 || spr.getPicnum() == 2710) && sec.getLotag() == 1 || sec.getLotag() == 1 && (spr.getPicnum() == 2120 || spr.getPicnum() == 1680 && spr.getZvel() == 0)) {
                if (dasectnum < 0) {
                    dasectnum = 0;
                    sec = Main.boardService.getSector(dasectnum);
                }
                spr.setX(oldx);
                spr.setY(oldy);
                if (sec != null && sec.getLotag() == 1 && spr.getPicnum() == 2120) {
                    spr.setAng((short)(Main.engine.krand() & 0x7FF));
                } else if ((Globals.hittype[spritenum].temp_data[0] & 3) == 1 && spr.getPicnum() != 1920) {
                    spr.setAng((short)(Main.engine.krand() & 0x7FF));
                }
                Main.engine.setsprite(spritenum, oldx, oldy, spr.getZ());
                return 0x40000000 + dasectnum;
            }
            int nHitType = moveHit & 0xE0000000;
            if ((nHitType == Integer.MIN_VALUE || nHitType == -1073741824) && Globals.hittype[spritenum].cgg == 0) {
                spr.setAng(spr.getAng() + 768);
            }
        } else {
            moveHit = spr.getStatnum() == 4 ? Main.engine.clipmove(spr.getX(), spr.getY(), daz, dasectnum, (long)xchange * 4L << 11, (long)ychange * 4L << 11, 8, 1024, 1024, cliptype) : Main.engine.clipmove(spr.getX(), spr.getY(), daz, dasectnum, (long)xchange * 4L << 11, (long)ychange * 4L << 11, spr.getClipdist() << 2, 1024, 1024, cliptype);
            spr.setX(Engine.clipmove_x);
            spr.setY(Engine.clipmove_y);
            dasectnum = Engine.clipmove_sectnum;
        }
        if (dasectnum >= 0 && dasectnum != spr.getSectnum()) {
            Main.engine.changespritesect(spritenum, dasectnum);
        }
        if ((daz = spr.getZ() + (zchange * 4 >> 3)) > Globals.hittype[spritenum].ceilingz && daz <= Globals.hittype[spritenum].floorz) {
            spr.setZ(daz);
        } else if (moveHit == 0) {
            return 0x40000000 + dasectnum;
        }
        return moveHit;
    }

    public static boolean ssp(int i, int cliptype) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return false;
        }
        int movetype = Actors.movesprite(i, s.getXvel() * EngineUtils.cos(s.getAng() & 0x7FF) >> 14, s.getXvel() * EngineUtils.sin(s.getAng() & 0x7FF) >> 14, s.getZvel(), cliptype);
        return movetype == 0;
    }

    public static void insertspriteq(int i) {
        if (Globals.currentGame.getCON().spriteqamount > 0) {
            Sprite qspr = Main.boardService.getSprite(Globals.spriteq[Globals.spriteqloc]);
            if (qspr != null) {
                qspr.setXrepeat(0);
            }
            Globals.spriteq[Globals.spriteqloc] = (short)i;
            Globals.spriteqloc = (short)((Globals.spriteqloc + 1) % Globals.currentGame.getCON().spriteqamount);
        } else {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr != null) {
                spr.setXrepeat(0);
                spr.setYrepeat(0);
            }
        }
    }

    public static void ms(int i) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return;
        }
        s.setX(s.getX() + (s.getXvel() * EngineUtils.cos(s.getAng() & 0x7FF) >> 14));
        s.setY(s.getY() + (s.getXvel() * EngineUtils.sin(s.getAng() & 0x7FF) >> 14));
        int j = Globals.hittype[i].temp_data[1];
        int k = Globals.hittype[i].temp_data[2];
        Sector sec = Main.boardService.getSector(s.getSectnum());
        if (sec != null) {
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Point p = EngineUtils.rotatepoint(0, 0, Globals.msx[j], Globals.msy[j], k & 0x7FF);
                Main.engine.dragpoint(wn.getIndex(), s.getX() + p.getX(), s.getY() + p.getY());
                ++j;
            }
        }
    }

    public static void movefta() {
        ListNode<Sprite> ni = Main.boardService.getStatNode(2);
        while (ni != null) {
            int psect;
            ListNode<Sprite> nexti = ni.getNext();
            Sprite s = ni.get();
            int i = ni.getIndex();
            int p = DSector.findplayer(s);
            int ssect = psect = s.getSectnum();
            Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
            if (psp != null && psp.getExtra() > 0) {
                Sector sec;
                if (DSector.player_dist < 30000) {
                    ++Globals.hittype[i].timetosleep;
                    if (Globals.hittype[i].timetosleep >= DSector.player_dist >> 8) {
                        boolean cansee;
                        if (Actors.badguy(s)) {
                            int py;
                            int px = Globals.ps[p].oposx + 64 - (Main.engine.krand() & 0x7F);
                            psect = Main.engine.updatesector(px, py = Globals.ps[p].oposy + 64 - (Main.engine.krand() & 0x7F), psect);
                            if (psect == -1) {
                                ni = nexti;
                                continue;
                            }
                            int sx = s.getX() + 64 - (Main.engine.krand() & 0x7F);
                            int sy = s.getY() + 64 - (Main.engine.krand() & 0x7F);
                            if ((ssect = Main.engine.updatesector(px, py, ssect)) == -1) {
                                ni = nexti;
                                continue;
                            }
                            int pz = Globals.ps[p].oposz - Main.engine.krand() % 8192;
                            int sz = s.getZ() - Main.engine.krand() % 13312;
                            cansee = Main.engine.cansee(sx, sy, sz, s.getSectnum(), px, py, pz, Globals.ps[p].cursectnum);
                        } else {
                            int pz = Globals.ps[p].oposz - ((Main.engine.krand() & 0x1F) << 8);
                            int sz = s.getZ() - ((Main.engine.krand() & 0x1F) << 8);
                            cansee = Main.engine.cansee(s.getX(), s.getY(), sz, s.getSectnum(), Globals.ps[p].oposx, Globals.ps[p].oposy, pz, Globals.ps[p].cursectnum);
                        }
                        if (cansee) {
                            switch (s.getPicnum()) {
                                case 904: 
                                case 1026: 
                                case 1062: 
                                case 1227: 
                                case 1228: 
                                case 1229: 
                                case 1232: 
                                case 1238: 
                                case 1240: 
                                case 1390: 
                                case 2566: 
                                case 4580: 
                                case 4581: 
                                case 4582: {
                                    Sector sec2 = Main.boardService.getSector(s.getSectnum());
                                    if (sec2 != null) {
                                        if ((sec2.getCeilingstat() & 1) != 0) {
                                            s.setShade(sec2.getCeilingshade());
                                        } else {
                                            s.setShade(sec2.getFloorshade());
                                        }
                                    }
                                    Globals.hittype[i].timetosleep = 0;
                                    Main.engine.changespritestat(i, 6);
                                    break;
                                }
                                default: {
                                    Globals.hittype[i].timetosleep = 0;
                                    Sounds.check_fta_sounds(i);
                                    Main.engine.changespritestat(i, 1);
                                    break;
                                }
                            }
                        } else {
                            Globals.hittype[i].timetosleep = 0;
                        }
                    }
                }
                if (Actors.badguy(s) && (sec = Main.boardService.getSector(s.getSectnum())) != null) {
                    if ((sec.getCeilingstat() & 1) != 0) {
                        s.setShade(sec.getCeilingshade());
                    } else {
                        s.setShade(sec.getFloorshade());
                    }
                }
            }
            ni = nexti;
        }
    }

    public static int ifhitsectors(short sectnum) {
        for (ListNode<Sprite> ni = Main.boardService.getStatNode(5); ni != null; ni = ni.getNext()) {
            Sprite sp = ni.get();
            if (sp.getPicnum() != 1890 || sectnum != sp.getSectnum()) continue;
            return ni.getIndex();
        }
        return -1;
    }

    public static int ifhitbyweapon(int sn) {
        Sprite npc = Main.boardService.getSprite(sn);
        if (npc == null) {
            return -1;
        }
        if (Globals.hittype[sn].extra >= 0 && npc.getExtra() >= 0) {
            if (npc.getPicnum() == 1405) {
                if (Globals.ud.god && Globals.hittype[sn].picnum != 1646) {
                    return -1;
                }
                short p = npc.getYvel();
                int j = Globals.hittype[sn].owner;
                Sprite jspr = Main.boardService.getSprite(j);
                if (jspr != null && jspr.getPicnum() == 1405 && Globals.ud.coop == 1 && Globals.ud.ffire == 0) {
                    return -1;
                }
                npc.setExtra(npc.getExtra() - Globals.hittype[sn].extra);
                if (jspr != null && npc.getExtra() <= 0 && Globals.hittype[sn].picnum != 1641) {
                    npc.setExtra(0);
                    Globals.ps[p].wackedbyactor = (short)j;
                    if (jspr.getPicnum() == 1405 && p != jspr.getYvel()) {
                        Globals.ps[p].frag_ps = jspr.getYvel();
                    }
                    Globals.hittype[sn].owner = Globals.ps[p].i;
                }
                switch (Globals.hittype[sn].picnum) {
                    case 26: 
                    case 981: 
                    case 1079: 
                    case 1238: 
                    case 1247: 
                    case 1670: 
                    case 2605: {
                        Globals.ps[p].posxv += Globals.hittype[sn].extra * EngineUtils.cos(Globals.hittype[sn].ang & 0x7FF) << 2;
                        Globals.ps[p].posyv += Globals.hittype[sn].extra * EngineUtils.sin(Globals.hittype[sn].ang & 0x7FF) << 2;
                        break;
                    }
                    default: {
                        Globals.ps[p].posxv += Globals.hittype[sn].extra * EngineUtils.cos(Globals.hittype[sn].ang & 0x7FF) << 1;
                        Globals.ps[p].posyv += Globals.hittype[sn].extra * EngineUtils.sin(Globals.hittype[sn].ang & 0x7FF) << 1;
                        break;
                    }
                }
            } else {
                if (Globals.hittype[sn].extra == 0 && Globals.hittype[sn].picnum == 1646 && npc.getXrepeat() < 24) {
                    return -1;
                }
                if (Globals.hittype[sn].picnum == 5180 && npc.getXrepeat() < 48 && Globals.hittype[sn].picnum != 1670 && Globals.hittype[sn].picnum != 2605) {
                    return -1;
                }
                npc.setExtra(npc.getExtra() - Globals.hittype[sn].extra);
                Sprite npcOwner = Main.boardService.getSprite(npc.getOwner());
                if (npc.getPicnum() != 1960 && npcOwner != null && npcOwner.getStatnum() < 1024) {
                    npc.setOwner((short)Globals.hittype[sn].owner);
                }
            }
            Globals.hittype[sn].extra = -1;
            return Globals.hittype[sn].picnum;
        }
        if (Globals.ud.multimode < 2 || Globals.hittype[sn].picnum != 1891 || Globals.hittype[sn].extra >= 0 || npc.getExtra() > 0 || npc.getPicnum() != 1405 || Globals.ps[npc.getYvel()].numloogs > 0 || Globals.hittype[sn].owner < 0) {
            Globals.hittype[sn].extra = -1;
            return -1;
        }
        Sprite jspr = Main.boardService.getSprite(Globals.hittype[sn].owner);
        if (jspr != null) {
            short p = npc.getYvel();
            npc.setExtra(0);
            Globals.ps[p].wackedbyactor = (short)Globals.hittype[sn].owner;
            if (jspr.getPicnum() == 1405 && p != Globals.hittype[sn].owner) {
                Globals.ps[p].frag_ps = (short)Globals.hittype[sn].owner;
            }
            Globals.hittype[sn].owner = Globals.ps[p].i;
            Globals.hittype[sn].extra = -1;
            return 1891;
        }
        return -1;
    }

    public static void movecyclers() {
        for (int q = Globals.numcyclers - 1; q >= 0; --q) {
            byte cshade;
            Sector sec = Main.boardService.getSector(Globals.cyclers[q][0]);
            if (sec == null) continue;
            int t = Globals.cyclers[q][3];
            int j = t + (EngineUtils.sin(Globals.cyclers[q][1] & 0x7FF) >> 10);
            if (j < (cshade = (byte)Globals.cyclers[q][2])) {
                j = cshade;
            } else if (j > t) {
                j = t;
            }
            short[] sArray = Globals.cyclers[q];
            sArray[1] = (short)(sArray[1] + sec.getExtra());
            if (Globals.cyclers[q][5] == 0) continue;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wal = wn.get();
                if (wal.getHitag() == 1) continue;
                wal.setShade(j);
                Wall nwal = Main.boardService.getWall(wal.getNextwall());
                if ((wal.getCstat() & 2) == 0 || nwal == null) continue;
                nwal.setShade(j);
            }
            sec.setCeilingshade(j);
            sec.setFloorshade(j);
        }
    }

    public static void movedummyplayers() {
        ListNode<Sprite> ni = Main.boardService.getStatNode(13);
        while (ni != null) {
            ListNode<Sprite> nexti = ni.getNext();
            int i = ni.getIndex();
            Sprite s = ni.get();
            Sprite sonwer = Main.boardService.getSprite(s.getOwner());
            if (sonwer == null) {
                ni = nexti;
                continue;
            }
            short p = sonwer.getYvel();
            Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
            Sector psec = Main.boardService.getSector(Globals.ps[p].cursectnum);
            if (Globals.ps[p].on_crane >= 0 || psec != null && psec.getLotag() != 1 || psp != null && psp.getExtra() <= 0) {
                Globals.ps[p].dummyplayersprite = (short)-1;
                Main.engine.deletesprite(i);
                ni = nexti;
                continue;
            }
            Sector sec = Main.boardService.getSector(s.getSectnum());
            if (sec != null) {
                if (Globals.ps[p].on_ground && Globals.ps[p].on_warping_sector == 1 && psec != null && psec.getLotag() == 1) {
                    s.setCstat(257);
                    s.setZ(sec.getCeilingz() + 6912);
                    s.setAng((short)Globals.ps[p].ang);
                    Globals.hittype[i].temp_data[0] = Globals.hittype[i].temp_data[0] == 8 ? 0 : Globals.hittype[i].temp_data[0] + 1;
                } else {
                    if (sec.getLotag() != 2) {
                        s.setZ(sec.getFloorz());
                    }
                    s.setCstat(32768);
                }
            }
            s.setX(s.getX() + (Globals.ps[p].posx - Globals.ps[p].oposx));
            s.setY(s.getY() + (Globals.ps[p].posy - Globals.ps[p].oposy));
            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
            ni = nexti;
        }
    }

    public static void moveplayers() {
        ListNode<Sprite> ni = Main.boardService.getStatNode(10);
        while (ni != null) {
            Sector sec;
            ListNode<Sprite> nexti = ni.getNext();
            Sprite s = ni.get();
            int i = ni.getIndex();
            PlayerStruct p = Globals.ps[s.getYvel()];
            if (s.getOwner() >= 0) {
                if (p.newowner >= 0) {
                    Main.game.pInt.setsprinterpolate(i, s);
                    s.setX(p.oposx);
                    s.setY(p.oposy);
                    s.setZ(p.oposz + 9728);
                    s.setAng((short)p.oang);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                } else {
                    Sprite psp;
                    int otherx = 0;
                    if (Globals.ud.multimode > 1) {
                        otherp = DSector.findotherplayer(s.getYvel());
                        otherx = DSector.player_dist;
                    } else {
                        otherp = s.getYvel();
                    }
                    Gamedef.execute(Globals.currentGame.getCON(), i, s.getYvel(), otherx);
                    if (Globals.ud.multimode > 1 && (psp = Main.boardService.getSprite(Globals.ps[Actors.otherp].i)) != null && psp.getExtra() > 0 && s.getYrepeat() > 32 && psp.getYrepeat() < 32 && otherx < 1400 && p.knee_incs == 0) {
                        p.knee_incs = 1;
                        p.weapon_pos = (short)-1;
                        p.actorsqu = Globals.ps[Actors.otherp].i;
                    }
                    if (Globals.ud.god) {
                        s.setExtra((short)Globals.currentGame.getCON().max_player_health);
                        s.setCstat(257);
                        p.jetpack_amount = (short)1599;
                    }
                    if (s.getExtra() > 0) {
                        Globals.hittype[i].owner = i;
                        if (!Globals.ud.god && (DSector.ceilingspace(s.getSectnum()) || DSector.floorspace(s.getSectnum()))) {
                            Player.quickkill(p);
                        }
                    } else {
                        p.posx = s.getX();
                        p.posy = s.getY();
                        p.posz = s.getZ() - 5120;
                        p.newowner = (short)-1;
                        Sprite wackedSpr = Main.boardService.getSprite(p.wackedbyactor);
                        if (wackedSpr != null && wackedSpr.getStatnum() < 1024) {
                            p.ang += Gamedef.getincangle(p.ang, (float)EngineUtils.getAngle(wackedSpr.getX() - p.posx, wackedSpr.getY() - p.posy)) / 2.0f;
                            p.ang = ru.m210projects.Build.Gameutils.BClampAngle(p.ang);
                        }
                        if (Globals.ud.multimode < 2 && LoadSave.lastload != null && LoadSave.lastload.exists() && !DemoScreen.isDemoPlaying() && Main.game.getProcessor().isKeyJustPressed(66)) {
                            Main.game.changeScreen(Main.gLoadingScreen.setTitle(LoadSave.lastload.getName()));
                            Main.gLoadingScreen.init(() -> {
                                if (!LoadSave.loadgame(LoadSave.lastload)) {
                                    Main.game.GameMessage("Can't load game!");
                                }
                            });
                            return;
                        }
                    }
                    s.setAng((short)p.ang);
                }
            } else {
                if (p.holoduke_on == -1) {
                    Main.engine.deletesprite(i);
                    ni = nexti;
                    continue;
                }
                Main.game.pInt.setsprinterpolate(i, s);
                s.setCstat(0);
                if (s.getXrepeat() < 42) {
                    s.setXrepeat(s.getXrepeat() + 4);
                    s.setCstat(s.getCstat() | 2);
                } else {
                    s.setXrepeat(42);
                }
                if (s.getYrepeat() < 36) {
                    s.setYrepeat(s.getYrepeat() + 4);
                } else {
                    s.setYrepeat(36);
                    sec = Main.boardService.getSector(s.getSectnum());
                    if (sec != null) {
                        if (sec.getLotag() != 2) {
                            Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                        }
                        if (s.getZvel() == 0 && sec.getLotag() == 1) {
                            s.setZ(s.getZ() + 8192);
                        }
                    }
                }
                if (s.getExtra() < 8) {
                    s.setXvel(128);
                    s.setAng((short)p.ang);
                    s.setExtra(s.getExtra() + 1);
                    Actors.ssp(i, 65537);
                } else {
                    s.setAng((short)(2047.0f - p.ang));
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                }
            }
            sec = Main.boardService.getSector(s.getSectnum());
            if (sec != null) {
                if ((sec.getCeilingstat() & 1) != 0) {
                    s.setShade(s.getShade() + (sec.getCeilingshade() - s.getShade() >> 1));
                } else {
                    s.setShade(s.getShade() + (sec.getFloorshade() - s.getShade() >> 1));
                }
            }
            ni = nexti;
        }
    }

    public static void movefx() {
        ListNode<Sprite> ni = Main.boardService.getStatNode(11);
        block4: while (ni != null) {
            ListNode<Sprite> nexti = ni.getNext();
            Sprite s = ni.get();
            int i = ni.getIndex();
            switch (s.getPicnum()) {
                case 9: {
                    if (s.getExtra() == 66) {
                        Spawn.spawn(i, s.getHitag());
                        Main.engine.deletesprite(i);
                        ni = nexti;
                        continue block4;
                    }
                    if (s.getExtra() <= 53) break;
                    s.setExtra(s.getExtra() + 1);
                    break;
                }
                case 5: {
                    int x;
                    Sprite psp;
                    short ht = s.getHitag();
                    if (Globals.hittype[i].temp_data[1] != (Main.cfg.isNoSound() ? 0 : 1)) {
                        Globals.hittype[i].temp_data[1] = Main.cfg.isNoSound() ? 0 : 1;
                        Globals.hittype[i].temp_data[0] = 0;
                    }
                    if ((psp = Main.boardService.getSprite(Globals.ps[Globals.screenpeek].i)) == null) break;
                    Sector sec = Main.boardService.getSector(s.getSectnum());
                    if (s.getLotag() >= 1000 && s.getLotag() < 2000) {
                        x = DSector.ldist(psp, s);
                        if (x < ht && Globals.hittype[i].temp_data[0] == 0) {
                            Sounds.setReverb(true, (float)(s.getLotag() - 1000) / 255.0f);
                            Globals.hittype[i].temp_data[0] = 1;
                        }
                        if (x < ht || Globals.hittype[i].temp_data[0] != 1) break;
                        Sounds.setReverb(false, 0.0f);
                        Globals.hittype[i].temp_data[0] = 0;
                        break;
                    }
                    if (sec == null || s.getLotag() >= 999 || sec.getLotag() >= 9) break;
                    Objects.requireNonNull(Main.cfg);
                    if (sec.getFloorz() == sec.getCeilingz()) break;
                    if (s.getLotag() < 500 && (Globals.currentGame.getCON().soundm[s.getLotag()] & 2) != 0) {
                        x = DSector.dist(psp, s);
                        if (x < ht && Globals.hittype[i].temp_data[0] == 0 && Sounds.isAvailable(Globals.currentGame.getCON().soundpr[s.getLotag()] - 1)) {
                            if (Sounds.numenvsnds == Main.cfg.getMaxvoices()) {
                                ListNode<Sprite> nj;
                                for (nj = Main.boardService.getStatNode(11); nj != null; nj = nj.getNext()) {
                                    int index = nj.getIndex();
                                    Sprite sp = nj.get();
                                    if (s.getPicnum() != 5 || index == i || sp.getLotag() >= 999 || Globals.hittype[index].temp_data[0] != 1 || DSector.dist(sp, psp) <= x) continue;
                                    Sounds.stopenvsound(sp.getLotag(), index);
                                    break;
                                }
                                if (nj == null) {
                                    ni = nexti;
                                    continue block4;
                                }
                            }
                            Sounds.spritesound(s.getLotag(), i);
                            Globals.hittype[i].temp_data[0] = 1;
                        }
                        if (x >= ht && Globals.hittype[i].temp_data[0] == 1) {
                            Globals.hittype[i].temp_data[0] = 0;
                            Sounds.stopenvsound(s.getLotag(), i);
                        }
                    }
                    if (s.getLotag() >= 500 || (Globals.currentGame.getCON().soundm[s.getLotag()] & 0x10) == 0) break;
                    if (Globals.hittype[i].temp_data[4] > 0) {
                        Globals.hittype[i].temp_data[4] = Globals.hittype[i].temp_data[4] - 1;
                        break;
                    }
                    short p = Mmulti.connecthead;
                    while (p >= 0) {
                        if (p == Mmulti.myconnectindex && Globals.ps[p].cursectnum == s.getSectnum()) {
                            int j = s.getLotag() + (Globals.global_random & 0xFFFF) % (s.getHitag() + 1);
                            Sounds.sound(j);
                            Globals.hittype[i].temp_data[4] = 1040 + Globals.global_random % 1040;
                        }
                        p = Mmulti.connectpoint2[p];
                    }
                    break;
                }
            }
            ni = nexti;
        }
    }

    public static void movefallers() {
        ListNode<Sprite> ni = Main.boardService.getStatNode(12);
        while (ni != null) {
            int x;
            ListNode<Sprite> nexti = ni.getNext();
            Sprite s = ni.get();
            int i = ni.getIndex();
            Sector sec = Main.boardService.getSector(s.getSectnum());
            if (Globals.hittype[i].temp_data[0] == 0) {
                s.setZ(s.getZ() - 4096);
                Globals.hittype[i].temp_data[1] = s.getAng();
                x = s.getExtra();
                int id = Actors.ifhitbyweapon(i);
                if (id >= 0) {
                    if (id == 916 || id == 2605 || id == 1670 || id == 1247 || id == 1079) {
                        if (s.getExtra() <= 0) {
                            Globals.hittype[i].temp_data[0] = 1;
                            for (ListNode<Sprite> node = Main.boardService.getStatNode(12); node != null; node = node.getNext()) {
                                Sprite sprite = node.get();
                                if (sprite.getHitag() != s.getHitag()) continue;
                                Globals.hittype[node.getIndex()].temp_data[0] = 1;
                                sprite.setCstat(sprite.getCstat() & 0xFFBF);
                                if (sprite.getPicnum() != 1255 && sprite.getPicnum() != 1250) continue;
                                sprite.setCstat(sprite.getCstat() | 0x8000);
                            }
                        }
                    } else {
                        Globals.hittype[i].extra = 0;
                        s.setExtra(x);
                    }
                }
                s.setAng(Globals.hittype[i].temp_data[1]);
                s.setZ(s.getZ() + 4096);
            } else if (Globals.hittype[i].temp_data[0] == 1) {
                if (s.getLotag() > 0) {
                    s.setLotag(s.getLotag() - 3);
                    if (s.getLotag() <= 0) {
                        s.setXvel(32 + Main.engine.krand() & 0x3F);
                        s.setZvel(-(1024 + (Main.engine.krand() & 0x3FF)));
                    }
                } else {
                    if (s.getXvel() > 0) {
                        s.setXvel(s.getXvel() - 8);
                        Actors.ssp(i, 65537);
                    }
                    x = DSector.floorspace(s.getSectnum()) ? 0 : (DSector.ceilingspace(s.getSectnum()) ? Globals.currentGame.getCON().gc / 6 : Globals.currentGame.getCON().gc);
                    if (sec != null) {
                        if (s.getZ() < sec.getFloorz() - 256) {
                            s.setZvel(s.getZvel() + x);
                            if (s.getZvel() > 6144) {
                                s.setZvel(6144);
                            }
                            s.setZ(s.getZ() + s.getZvel());
                        }
                        if (sec.getFloorz() - s.getZ() < 4096) {
                            int j = 1 + (Main.engine.krand() & 7);
                            for (int xx = 0; xx < j; ++xx) {
                                Gameutils.RANDOMSCRAP(s, i);
                            }
                            Main.engine.deletesprite(i);
                        }
                    }
                }
            }
            ni = nexti;
        }
    }

    private static void Detonate(Sprite s, int i, int[] t) {
        Globals.earthquaketime = (short)16;
        for (ListNode<Sprite> ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
            Sprite sp = ni.get();
            int j = ni.getIndex();
            if (s.getHitag() != sp.getHitag()) continue;
            if (sp.getLotag() == 13) {
                if (Globals.hittype[j].temp_data[2] != 0) continue;
                Globals.hittype[j].temp_data[2] = 1;
                continue;
            }
            if (sp.getLotag() == 8) {
                Globals.hittype[j].temp_data[4] = 1;
                continue;
            }
            if (sp.getLotag() == 18) {
                if (Globals.hittype[j].temp_data[0] != 0) continue;
                Globals.hittype[j].temp_data[0] = 1;
                continue;
            }
            if (sp.getLotag() != 21) continue;
            Globals.hittype[j].temp_data[0] = 1;
        }
        s.setZ(s.getZ() - 8192);
        if (t[3] == 1 && s.getXrepeat() != 0 || s.getLotag() == -99) {
            short x = s.getExtra();
            Spawn.spawn(i, 1890);
            Actors.hitradius(i, Globals.currentGame.getCON().seenineblastradius, x >> 2, x - (x >> 1), x - (x >> 2), x);
            Sounds.spritesound(14, i);
        }
        if (s.getXrepeat() != 0) {
            for (int x = 0; x < 8; ++x) {
                Gameutils.RANDOMSCRAP(s, i);
            }
        }
        Main.engine.deletesprite(i);
    }

    /*
     * Unable to fully structure code
     */
    public static void movestandables() {
        ni = Main.boardService.getStatNode(6);
        while (ni != null) {
            block184: {
                block193: {
                    block194: {
                        block192: {
                            block186: {
                                block188: {
                                    block191: {
                                        block190: {
                                            block189: {
                                                block187: {
                                                    block185: {
                                                        nexti = ni.getNext();
                                                        i = ni.getIndex();
                                                        s = ni.get();
                                                        t = Globals.hittype[i].temp_data;
                                                        sect = s.getSectnum();
                                                        sec = Main.boardService.getSector(sect);
                                                        if (sec != null) break block185;
                                                        Main.engine.deletesprite(i);
                                                        break block184;
                                                    }
                                                    Main.game.pInt.setsprinterpolate(i, s);
                                                    if (!Gameutils.IFWITHIN(s, 1222, 1225)) break block186;
                                                    if (s.getXvel() != 0) {
                                                        Gamedef.getglobalz(i);
                                                    }
                                                    if (t[0] != 0) break block187;
                                                    nj = Main.boardService.getSectNode(t[1]);
                                                    while (nj != null) {
                                                        nextj = nj.getNext();
                                                        sp = nj.get();
                                                        switch (sp.getStatnum()) {
                                                            case 1: 
                                                            case 2: 
                                                            case 6: 
                                                            case 10: {
                                                                s.setAng(EngineUtils.getAngle(Globals.msx[t[4] + 1] - s.getX(), Globals.msy[t[4] + 1] - s.getY()));
                                                                Main.engine.setsprite(nj.getIndex(), Globals.msx[t[4] + 1], Globals.msy[t[4] + 1], sp.getZ());
                                                                t[0] = t[0] + 1;
                                                                break block184;
                                                            }
                                                            default: {
                                                                nj = nextj;
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    break block188;
                                                }
                                                if (t[0] != 1) break block189;
                                                if (s.getXvel() < 184) {
                                                    s.setPicnum(1223);
                                                    s.setXvel(s.getXvel() + 8);
                                                }
                                                Actors.ssp(i, 65537);
                                                if (sect == t[1]) {
                                                    t[0] = t[0] + 1;
                                                }
                                                break block188;
                                            }
                                            if (t[0] != 2 && t[0] != 7) break block190;
                                            s.setZ(s.getZ() + 1536);
                                            if (t[0] == 2) {
                                                if (sec.getFloorz() - s.getZ() < 16384 && s.getPicnum() > 1222) {
                                                    s.setPicnum(s.getPicnum() - 1);
                                                }
                                                if (sec.getFloorz() - s.getZ() < 5120) {
                                                    t[0] = t[0] + 1;
                                                }
                                            }
                                            if (t[0] == 7 && sec.getFloorz() - s.getZ() < 16384) {
                                                if (s.getPicnum() > 1222) {
                                                    s.setPicnum(s.getPicnum() - 1);
                                                } else {
                                                    if (s.getOwner() == -2) {
                                                        p = DSector.findplayer(s);
                                                        Sounds.spritesound(38, Globals.ps[p].i);
                                                        if (Globals.ps[p].on_crane == i) {
                                                            Globals.ps[p].on_crane = (short)-1;
                                                        }
                                                    }
                                                    t[0] = t[0] + 1;
                                                    s.setOwner(-1);
                                                }
                                            }
                                            break block188;
                                        }
                                        if (t[0] != 3) break block191;
                                        s.setPicnum(s.getPicnum() + 1);
                                        if (s.getPicnum() != 1224) break block188;
                                        p = DSector.checkcursectnums(t[1]);
                                        if (p >= 0 && Globals.ps[p].on_ground) {
                                            s.setOwner(-2);
                                            Globals.ps[p].on_crane = (short)i;
                                            Sounds.spritesound(38, Globals.ps[p].i);
                                            Globals.ps[p].ang = ru.m210projects.Build.Gameutils.BClampAngle(s.getAng() + 1024);
                                            Globals.ps[p].posxv = 0;
                                            Globals.ps[p].posyv = 0;
                                            Globals.ps[p].poszv = 0;
                                            psp = Main.boardService.getSprite(Globals.ps[p].i);
                                            if (psp != null) {
                                                psp.setXvel(0);
                                            }
                                            Globals.ps[p].look_ang = 0;
                                            Globals.ps[p].rotscrnang = 0;
                                        } else {
                                            node = Main.boardService.getSectNode(t[1]);
                                            while (node != null) {
                                                nextj = node.getNext();
                                                switch (node.get().getStatnum()) {
                                                    case 1: 
                                                    case 6: {
                                                        s.setOwner(node.getIndex());
                                                    }
                                                }
                                                node = nextj;
                                            }
                                        }
                                        t[0] = t[0] + 1;
                                        t[2] = 0;
                                        break block184;
                                    }
                                    if (t[0] == 4) {
                                        t[2] = t[2] + 1;
                                        if (t[2] > 10) {
                                            t[0] = t[0] + 1;
                                        }
                                    } else if (t[0] == 5 || t[0] == 8) {
                                        if (t[0] == 8 && s.getPicnum() < 1224 && sec.getFloorz() - s.getZ() > 8192) {
                                            s.setPicnum(s.getPicnum() + 1);
                                        }
                                        if (s.getZ() < Globals.msx[t[4] + 2]) {
                                            t[0] = t[0] + 1;
                                            s.setXvel(0);
                                        } else {
                                            s.setZ(s.getZ() - 1536);
                                        }
                                    } else if (t[0] == 6) {
                                        if (s.getXvel() < 192) {
                                            s.setXvel(s.getXvel() + 8);
                                        }
                                        s.setAng(EngineUtils.getAngle(Globals.msx[t[4]] - s.getX(), Globals.msy[t[4]] - s.getY()));
                                        Actors.ssp(i, 65537);
                                        if ((s.getX() - Globals.msx[t[4]]) * (s.getX() - Globals.msx[t[4]]) + (s.getY() - Globals.msy[t[4]]) * (s.getY() - Globals.msy[t[4]]) < 16384) {
                                            t[0] = t[0] + 1;
                                        }
                                    } else if (t[0] == 9) {
                                        t[0] = 0;
                                    }
                                }
                                if (Main.boardService.isValidSprite(Globals.msy[t[4] + 2])) {
                                    Main.game.pInt.setsprinterpolate(Globals.msy[t[4] + 2], Main.boardService.getSprite(Globals.msy[t[4] + 2]));
                                    Main.engine.setsprite((short)Globals.msy[t[4] + 2], s.getX(), s.getY(), s.getZ() - 8704);
                                }
                                if (s.getOwner() != -1) {
                                    p = DSector.findplayer(s);
                                    j = Actors.ifhitbyweapon(i);
                                    if (j >= 0) {
                                        if (s.getOwner() == -2 && Globals.ps[p].on_crane == i) {
                                            Globals.ps[p].on_crane = (short)-1;
                                        }
                                        s.setOwner(-1);
                                        s.setPicnum(1222);
                                    } else if (s.getOwner() >= 0) {
                                        Main.engine.setsprite(s.getOwner(), s.getX(), s.getY(), s.getZ());
                                        s.setZvel(0);
                                    } else if (s.getOwner() == -2) {
                                        Globals.ps[p].oposx = Globals.ps[p].posx;
                                        Globals.ps[p].oposy = Globals.ps[p].posy;
                                        Globals.ps[p].oposz = Globals.ps[p].posz;
                                        Globals.ps[p].oang = Globals.ps[p].ang;
                                        Globals.ps[p].opyoff = Globals.ps[p].pyoff;
                                        if (Main.IsOriginalDemo()) {
                                            Globals.ps[p].posx = s.getX() - (EngineUtils.cos((int)Globals.ps[p].ang & 2047) >> 6);
                                            Globals.ps[p].posy = s.getY() - (EngineUtils.sin((int)Globals.ps[p].ang & 2047) >> 6);
                                        } else {
                                            Globals.ps[p].posx = (int)((double)s.getX() - ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(Globals.ps[p].ang)) / 64.0);
                                            Globals.ps[p].posy = (int)((double)s.getY() - ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(Globals.ps[p].ang)) / 64.0);
                                        }
                                        Globals.ps[p].posz = s.getZ() + 512;
                                        Main.engine.setsprite(Globals.ps[p].i, Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].posz);
                                        psp = Main.boardService.getSprite(Globals.ps[p].i);
                                        if (psp != null) {
                                            Globals.ps[p].cursectnum = psp.getSectnum();
                                        }
                                    }
                                }
                                break block184;
                            }
                            if (!Gameutils.IFWITHIN(s, 563, 566)) break block192;
                            if (t[0] > 0) {
                                if (t[0] < 20) {
                                    t[0] = t[0] + 1;
                                    s.setPicnum(s.getPicnum() + 1);
                                    if (s.getPicnum() == 566) {
                                        s.setPicnum(564);
                                    }
                                } else {
                                    DSector.findplayer(s);
                                    x = DSector.player_dist;
                                    if (x > 512) {
                                        t[0] = 0;
                                        s.setPicnum(563);
                                    } else {
                                        t[0] = 1;
                                    }
                                }
                            }
                            break block184;
                        }
                        if (!Gameutils.AFLAMABLE(s.getPicnum())) break block193;
                        if (Globals.hittype[i].temp_data[0] != 1) ** GOTO lbl211
                        Globals.hittype[i].temp_data[1] = Globals.hittype[i].temp_data[1] + 1;
                        if ((Globals.hittype[i].temp_data[1] & 3) > 0) break block184;
                        if (s.getPicnum() != 990 || Globals.hittype[i].temp_data[1] != 32) break block194;
                        s.setCstat(0);
                        j = Spawn.spawn(i, 1226);
                        sp = Main.boardService.getSprite(j);
                        if (sp != null) {
                            sp.setShade(127);
                        }
                        ** GOTO lbl199
                    }
                    if (s.getShade() >= 64) {
                        Main.engine.deletesprite(i);
                    } else {
                        s.setShade(s.getShade() + 1);
lbl199:
                        // 2 sources

                        j = s.getXrepeat() - (Main.engine.krand() & 7);
                        if (j < 10) {
                            Main.engine.deletesprite(i);
                        } else {
                            s.setXrepeat((short)j);
                            j = s.getYrepeat() - (Main.engine.krand() & 7);
                            if (j < 4) {
                                Main.engine.deletesprite(i);
                            } else {
                                s.setYrepeat(j);
lbl211:
                                // 2 sources

                                if (s.getPicnum() == 951) {
                                    Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                                    sec2 = Main.boardService.getSector(s.getSectnum());
                                    if (sec2 != sec) {
                                        Console.out.println("Actors(1500) sec2 != sec", OsdColor.RED);
                                    }
                                    if (sec2 != null) {
                                        Globals.hittype[i].ceilingz = sec2.getCeilingz();
                                    }
                                }
                            }
                        }
                    }
                    break block184;
                }
                if (s.getPicnum() == 2566) {
                    if (Globals.hittype[i].temp_data[2] > 0) {
                        Globals.hittype[i].temp_data[2] = Globals.hittype[i].temp_data[2] - 1;
                        if (Globals.hittype[i].temp_data[2] == 8) {
                            Sounds.spritesound(17, i);
                            for (j = 0; j < 5; ++j) {
                                Gameutils.RANDOMSCRAP(s, i);
                            }
                            x = s.getExtra();
                            Actors.hitradius(i, Globals.currentGame.getCON().tripbombblastradius, x >> 2, x >> 1, x - (x >> 2), x);
                            j = Spawn.spawn(i, 1890);
                            spr = Main.boardService.getSprite(j);
                            if (spr != null) {
                                spr.setAng(s.getAng());
                                spr.setXvel(348);
                                Actors.ssp(j, 65537);
                            }
                            for (node = Main.boardService.getStatNode(5); node != null; node = node.getNext()) {
                                sp = node.get();
                                if (sp.getPicnum() != 2567 || s.getHitag() != sp.getHitag()) continue;
                                sp.setXrepeat(0);
                                sp.setYrepeat(0);
                            }
                            Main.engine.deletesprite(i);
                        }
                    } else {
                        x = s.getExtra();
                        s.setExtra(1);
                        l = s.getAng();
                        j = Actors.ifhitbyweapon(i);
                        if (j >= 0) {
                            Globals.hittype[i].temp_data[2] = 16;
                        }
                        s.setExtra((short)x);
                        s.setAng(l);
                        if (Globals.hittype[i].temp_data[0] < 32) {
                            DSector.findplayer(s);
                            x = DSector.player_dist;
                            if (x > 768) {
                                Globals.hittype[i].temp_data[0] = Globals.hittype[i].temp_data[0] + 1;
                            } else if (Globals.hittype[i].temp_data[0] > 16) {
                                Globals.hittype[i].temp_data[0] = Globals.hittype[i].temp_data[0] + 1;
                            }
                        }
                        if (Globals.hittype[i].temp_data[0] == 32) {
                            l = s.getAng();
                            s.setAng((short)Globals.hittype[i].temp_data[5]);
                            Globals.hittype[i].temp_data[3] = s.getX();
                            Globals.hittype[i].temp_data[4] = s.getY();
                            s.setX(s.getX() + (EngineUtils.sin(Globals.hittype[i].temp_data[5] + 512 & 2047) >> 9));
                            s.setY(s.getY() + (EngineUtils.sin(Globals.hittype[i].temp_data[5] & 2047) >> 9));
                            s.setZ(s.getZ() - 768);
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            m = Engine.pHitInfo.hitsprite;
                            Globals.hittype[i].lastvx = x;
                            s.setAng(l);
                            for (x = Player.hitasprite(i); x > 0; x -= 1024) {
                                j = Spawn.spawn(i, 2567);
                                sp = Main.boardService.getSprite(j);
                                if (sp == null) continue;
                                Main.engine.setsprite(j, sp.getX(), sp.getY(), sp.getZ());
                                sp.setHitag(s.getHitag());
                                Globals.hittype[j].temp_data[1] = sp.getZ();
                                s.setX(s.getX() + (EngineUtils.cos(Globals.hittype[i].temp_data[5] & 2047) >> 4));
                                s.setY(s.getY() + (EngineUtils.sin(Globals.hittype[i].temp_data[5] & 2047) >> 4));
                                if (x >= 1024) continue;
                                sp.setXrepeat((short)(x >> 5));
                                break;
                            }
                            Globals.hittype[i].temp_data[0] = Globals.hittype[i].temp_data[0] + 1;
                            s.setX(Globals.hittype[i].temp_data[3]);
                            s.setY(Globals.hittype[i].temp_data[4]);
                            s.setZ(s.getZ() + 768);
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            Globals.hittype[i].temp_data[3] = 0;
                            if (m >= 0) {
                                Globals.hittype[i].temp_data[2] = 13;
                                Sounds.spritesound(16, i);
                            } else {
                                Globals.hittype[i].temp_data[2] = 0;
                            }
                        }
                        if (Globals.hittype[i].temp_data[0] == 33) {
                            Globals.hittype[i].temp_data[1] = Globals.hittype[i].temp_data[1] + 1;
                            Globals.hittype[i].temp_data[3] = s.getX();
                            Globals.hittype[i].temp_data[4] = s.getY();
                            s.setX(s.getX() + (EngineUtils.sin(Globals.hittype[i].temp_data[5] + 512 & 2047) >> 9));
                            s.setY(s.getY() + (EngineUtils.sin(Globals.hittype[i].temp_data[5] & 2047) >> 9));
                            s.setZ(s.getZ() - 768);
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            x = Player.hitasprite(i);
                            s.setX(Globals.hittype[i].temp_data[3]);
                            s.setY(Globals.hittype[i].temp_data[4]);
                            s.setZ(s.getZ() + 768);
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            if (Globals.hittype[i].lastvx != x) {
                                Globals.hittype[i].temp_data[2] = 13;
                                Sounds.spritesound(16, i);
                            }
                        }
                    }
                } else if (s.getPicnum() >= 546 && s.getPicnum() <= 549) {
                    if (s.getHitag() > 0) {
                        t[0] = s.getCstat();
                        t[1] = s.getAng();
                        j = Actors.ifhitbyweapon(i);
                        if (j == 916 || j == 2605 || j == 1670 || j == 1247 || j == 1079) {
                            for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
                                sp = node.get();
                                if (s.getHitag() != sp.getHitag() || sp.getPicnum() != 1079 && sp.getPicnum() != 1247 || sp.getShade() == -32) continue;
                                sp.setShade(-32);
                            }
                            Actors.Detonate(s, i, t);
                        } else {
                            s.setCstat((short)t[0]);
                            s.setAng((short)t[1]);
                            s.setExtra(0);
                        }
                    }
                } else if (s.getPicnum() == 916) {
                    j = Actors.ifhitbyweapon(i);
                    if (j != -1) {
                        for (k = 0; k < 16; ++k) {
                            zv = -(Main.engine.krand() & 4095) - (s.getZvel() >> 2);
                            ve = (Main.engine.krand() & 63) + 64;
                            va = Main.engine.krand() & 2047;
                            pn = 2408 + (Main.engine.krand() & 3);
                            sz = s.getZ() - Main.engine.krand() % 12288;
                            j = Spawn.EGS(s.getSectnum(), s.getX(), s.getY(), sz, pn, -8, 48, 48, va, ve, zv, i, 5);
                            sp = Main.boardService.getSprite(j);
                            if (sp == null) continue;
                            sp.setPal(2);
                        }
                        Spawn.spawn(i, 1890);
                        Sounds.spritesound(14, i);
                        Sounds.spritesound(20, i);
                        if (s.getHitag() > 0) {
                            for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
                                sp = node.get();
                                if (s.getHitag() != sp.getHitag() || sp.getPicnum() != 1079 && sp.getPicnum() != 1247 || sp.getShade() == -32) continue;
                                sp.setShade(-32);
                            }
                            x = s.getExtra();
                            Spawn.spawn(i, 1890);
                            Actors.hitradius(i, Globals.currentGame.getCON().pipebombblastradius, x >> 2, x - (x >> 1), x - (x >> 2), x);
                            Sounds.spritesound(14, i);
                            Actors.Detonate(s, i, t);
                        } else {
                            Actors.hitradius(i, Globals.currentGame.getCON().seenineblastradius, 10, 15, 20, 25);
                            Main.engine.deletesprite(i);
                        }
                    }
                } else if (s.getPicnum() == 1079 || s.getPicnum() == 1247 || s.getPicnum() == 1248 || s.getPicnum() == 1249) {
                    if (s.getShade() != -32 && s.getShade() != -33) {
                        j = false;
                        if (s.getXrepeat() != 0) {
                            v0 = j = Actors.ifhitbyweapon(i) >= 0;
                        }
                        if (j || s.getShade() == -31) {
                            if (j) {
                                s.setLotag(0);
                            }
                            t[3] = 1;
                            for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
                                sp = node.get();
                                if (s.getHitag() != sp.getHitag() || sp.getPicnum() != 1247 && sp.getPicnum() != 1079) continue;
                                sp.setShade(-32);
                            }
                        }
                    } else if (s.getShade() == -32) {
                        if (s.getLotag() > 0) {
                            s.setLotag(s.getLotag() - 3);
                            if (s.getLotag() <= 0) {
                                s.setLotag(-99);
                            }
                        } else {
                            s.setShade(-33);
                        }
                    } else if (s.getXrepeat() > 0) {
                        Globals.hittype[i].temp_data[2] = Globals.hittype[i].temp_data[2] + 1;
                        if (Globals.hittype[i].temp_data[2] == 3) {
                            if (s.getPicnum() == 1079) {
                                Globals.hittype[i].temp_data[2] = 0;
                                Actors.Detonate(s, i, t);
                            } else if (s.getPicnum() != 1249) {
                                Globals.hittype[i].temp_data[2] = 0;
                                if (s.getPicnum() == 1248) {
                                    s.setPicnum(s.getPicnum() + 1);
                                } else if (s.getPicnum() == 1247) {
                                    s.setPicnum(1248);
                                }
                            } else {
                                Actors.Detonate(s, i, t);
                            }
                        }
                    } else {
                        Actors.Detonate(s, i, t);
                    }
                } else if (s.getPicnum() == 8) {
                    if (s.getYvel() == 1) {
                        s.setHitag(s.getHitag() - 1);
                        if (s.getHitag() <= 0) {
                            DSector.operatesectors(sect, i);
                            for (node = Main.boardService.getSectNode(sect); node != null; node = node.getNext()) {
                                sp = node.get();
                                j = node.getIndex();
                                if (sp.getStatnum() == 3) {
                                    switch (sp.getLotag()) {
                                        case 2: 
                                        case 21: 
                                        case 31: 
                                        case 32: 
                                        case 36: {
                                            Globals.hittype[j].temp_data[0] = 1;
                                            break;
                                        }
                                        case 3: {
                                            Globals.hittype[j].temp_data[4] = 1;
                                        }
                                    }
                                    continue;
                                }
                                if (sp.getStatnum() != 6) continue;
                                switch (sp.getPicnum()) {
                                    case 1079: 
                                    case 1247: {
                                        sp.setShade(-31);
                                    }
                                }
                            }
                            Main.engine.deletesprite(i);
                        }
                    }
                } else {
                    block13 : switch (s.getPicnum()) {
                        case 499: 
                        case 502: {
                            if (s.getXrepeat() == 0) {
                                Main.engine.deletesprite(i);
                                break;
                            }
                            DSector.findplayer(s);
                            x = DSector.player_dist;
                            if (x < 2048) {
                                if (s.getYvel() != 1) break;
                                Globals.camsprite = (short)i;
                                break;
                            }
                            if (Globals.camsprite != -1 && Globals.hittype[i].temp_data[0] == 1) {
                                Globals.camsprite = (short)-1;
                                Globals.hittype[i].temp_data[0] = 0;
                                Globals.VIEWSCR_Lock = 199;
                            }
                            break;
                        }
                        case 1272: {
                            if (s.getXvel() == 0) {
                                s.setXvel(1);
                            }
                            if (Actors.ssp(i, 65537)) {
                                Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                                if ((Main.engine.krand() & 1) != 0) {
                                    s.setZvel(s.getZvel() - 256);
                                }
                                if (Pragmas.klabs(s.getXvel()) >= 48) break;
                                s.setXvel(s.getXvel() + (Main.engine.krand() & 3));
                                break;
                            }
                            Main.engine.deletesprite(i);
                            break;
                        }
                        case 4525: 
                        case 4526: 
                        case 4527: 
                        case 4528: {
                            DSector.findplayer(s);
                            x = DSector.player_dist;
                            if (x <= 20480) {
                                while (true) {
                                    if (t[2] != 0) {
                                        t[2] = t[2] - 1;
                                        break block13;
                                    }
                                    if ((s.getXrepeat() | s.getYrepeat()) == 0) {
                                        s.setXrepeat((short)t[0]);
                                        s.setYrepeat((short)t[1]);
                                    }
                                    if ((Main.engine.krand() & 8) != 0) break;
                                    t[0] = s.getXrepeat();
                                    t[1] = s.getYrepeat();
                                    t[2] = Globals.global_random & 4;
                                    s.setXrepeat(0);
                                    s.setYrepeat(0);
                                }
                                s.setPicnum(s.getPicnum() + 1);
                                if ((Main.engine.krand() & 1) != 0 && sec.getFloorpicnum() == 859) {
                                    Sounds.spritesound(21, i);
                                }
                                if (s.getPicnum() != 4529) break;
                                s.setPicnum(4525);
                            }
                            break;
                        }
                        case 634: 
                        case 635: 
                        case 636: 
                        case 637: {
                            DSector.findplayer(s);
                            x = DSector.player_dist;
                            if (x <= 20480) {
                                if (t[3] == 0) {
                                    t[3] = sec.getFloorshade();
                                }
                                while (true) {
                                    if (t[2] != 0) {
                                        t[2] = t[2] - 1;
                                        sec.setFloorshade(20);
                                        sec.setCeilingshade(20);
                                        break block13;
                                    }
                                    if ((s.getXrepeat() | s.getYrepeat()) == 0) {
                                        s.setXrepeat((short)t[0]);
                                        s.setYrepeat((short)t[1]);
                                        break;
                                    }
                                    if ((Main.engine.krand() & 8) != 0) break;
                                    t[0] = s.getXrepeat();
                                    t[1] = s.getYrepeat();
                                    t[2] = Globals.global_random & 4;
                                    s.setXrepeat(0);
                                    s.setYrepeat(0);
                                }
                                s.setPicnum(s.getPicnum() + 1);
                                l = Globals.global_random & 7;
                                s.setXrepeat((short)(l + 8));
                                if ((l & 1) != 0) {
                                    s.setCstat(s.getCstat() ^ 2);
                                }
                                if (s.getPicnum() == 635 && (Main.engine.krand() & 7) == 0 && sec.getFloorpicnum() == 859) {
                                    Sounds.spritesound(21, i);
                                }
                                if (s.getPicnum() == 638) {
                                    s.setPicnum(634);
                                }
                                if ((s.getPicnum() & 1) != 0) {
                                    sec.setFloorshade(0);
                                    sec.setCeilingshade(0);
                                    break;
                                }
                                sec.setFloorshade(20);
                                sec.setCeilingshade(20);
                            }
                            break;
                        }
                        case 660: {
                            if (t[1] != 0) {
                                t[1] = t[1] - 1;
                                if (t[1] != 0) break;
                                s.setCstat(s.getCstat() & 32767);
                                break;
                            }
                            Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                            Actors.ssp(i, 65537);
                            if (s.getXvel() > 0) {
                                s.setXvel(s.getXvel() - 2);
                            }
                            if (s.getZvel() != 0) break;
                            s.setCstat(s.getCstat() | 32768);
                            if (s.getPal() != 2 && s.getHitag() == 0) {
                                Sounds.spritesound(92, i);
                            }
                            if ((sp = Main.boardService.getSprite(s.getOwner())) != null && sp.getPicnum() != 660) {
                                Main.engine.deletesprite(i);
                                break;
                            }
                            Main.game.pInt.setsprinterpolate(i, s);
                            s.setZ(t[0]);
                            t[1] = 48 + (Main.engine.krand() & 31);
                            break;
                        }
                        case 160: {
                            j = Pragmas.klabs(sec.getCeilingz() - sec.getFloorz()) >> 9;
                            s.setYrepeat((short)(j + 4));
                            s.setXrepeat(16);
                            s.setZ(sec.getFloorz());
                            break;
                        }
                        case 3: {
                            if (t[1] == 1 && s.getHitag() >= 0) {
                                x = sec.getFloorz();
                                if (t[3] == 1) {
                                    if (x >= t[2]) {
                                        Main.game.pInt.setfloorinterpolate(sect, sec);
                                        sec.setFloorz(x);
                                        t[1] = 0;
                                        break;
                                    }
                                    Main.game.pInt.setfloorinterpolate(sect, sec);
                                    sec.setFloorz(sec.getFloorz() + sec.getExtra());
                                    p = DSector.checkcursectnums(sect);
                                    if (p >= 0) {
                                        Globals.ps[p].posz += sec.getExtra();
                                    }
                                } else {
                                    if (x <= s.getZ()) {
                                        Main.game.pInt.setfloorinterpolate(sect, sec);
                                        sec.setFloorz(s.getZ());
                                        t[1] = 0;
                                        break;
                                    }
                                    Main.game.pInt.setfloorinterpolate(sect, sec);
                                    sec.setFloorz(sec.getFloorz() - sec.getExtra());
                                    p = DSector.checkcursectnums(sect);
                                    if (p >= 0) {
                                        Globals.ps[p].posz -= sec.getExtra();
                                    }
                                }
                            } else if (t[5] != 1) {
                                p = DSector.checkcursectnums(sect);
                                if (p >= 0 && (Globals.ps[p].on_ground || s.getAng() == 512)) {
                                    if (t[0] == 0 && !DSector.check_activator_motion(s.getLotag())) {
                                        t[0] = 1;
                                        t[1] = 1;
                                        t[3] = t[3] ^ 1;
                                        DSector.operatemasterswitches(s.getLotag());
                                        DSector.operateactivators(s.getLotag(), p);
                                        if (s.getHitag() > 0) {
                                            s.setHitag(s.getHitag() - 1);
                                            if (s.getHitag() == 0) {
                                                t[5] = 1;
                                            }
                                        }
                                    }
                                } else {
                                    t[0] = 0;
                                }
                                if (t[1] != 1) break;
                                for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
                                    j = node.getIndex();
                                    sp = node.get();
                                    if (j == i || sp.getPicnum() != 3 || sp.getLotag() != s.getLotag()) continue;
                                    Globals.hittype[j].temp_data[1] = 1;
                                    Globals.hittype[j].temp_data[3] = t[3];
                                }
                            }
                            break;
                        }
                        case 1232: 
                        case 4580: 
                        case 4581: 
                        case 4582: {
                            Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                            j = Actors.ifhitbyweapon(i);
                            if (j < 0) break;
                            Sounds.spritesound(18, i);
                            for (j = 0; j < 10; ++j) {
                                Gameutils.RANDOMSCRAP(s, i);
                            }
                            if (s.getLotag() != 0) {
                                Spawn.spawn(i, s.getLotag());
                            }
                            Main.engine.deletesprite(i);
                            break;
                        }
                        case 904: 
                        case 921: 
                        case 1026: 
                        case 1062: 
                        case 1227: 
                        case 1228: 
                        case 1229: 
                        case 1238: 
                        case 1240: 
                        case 1250: 
                        case 1255: 
                        case 1390: 
                        case 2333: {
                            p = DSector.findplayer(s);
                            Gamedef.execute(Globals.currentGame.getCON(), i, p, DSector.player_dist);
                            break;
                        }
                        case 662: {
                            p = DSector.findplayer(s);
                            Gamedef.execute(Globals.currentGame.getCON(), i, p, DSector.player_dist);
                            break;
                        }
                    }
                }
            }
            ni = nexti;
        }
    }

    public static void bounce(int i) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return;
        }
        int xvect = Pragmas.mulscale(s.getXvel(), EngineUtils.sin(s.getAng() + 512 & 0x7FF), 10);
        int yvect = Pragmas.mulscale(s.getXvel(), EngineUtils.sin(s.getAng() & 0x7FF), 10);
        int zvect = s.getZvel();
        short hitsect = s.getSectnum();
        Sector hsec = Main.boardService.getSector(hitsect);
        if (hsec == null || hsec.getWallNode() == null) {
            return;
        }
        int daang = hsec.getWallNode().get().getWallAngle();
        int k = s.getZ() < Globals.hittype[i].floorz + Globals.hittype[i].ceilingz >> 1 ? hsec.getCeilingheinum() : hsec.getFloorheinum();
        int dax = Pragmas.mulscale(k, EngineUtils.sin(daang & 0x7FF), 14);
        int day = Pragmas.mulscale(k, EngineUtils.sin(daang + 1536 & 0x7FF), 14);
        int daz = 4096;
        k = xvect * dax + yvect * day + zvect * daz;
        int l = dax * dax + day * day + daz * daz;
        if (Pragmas.klabs(k) >> 14 < l) {
            k = Pragmas.divscale(k, l, 17);
            xvect -= Pragmas.mulscale(dax, k, 16);
            yvect -= Pragmas.mulscale(day, k, 16);
            zvect -= Pragmas.mulscale(daz, k, 16);
        }
        s.setZvel(zvect);
        s.setXvel(EngineUtils.sqrt(Pragmas.dmulscale(xvect, xvect, yvect, yvect, 8)));
        s.setAng(EngineUtils.getAngle(xvect, yvect));
    }

    /*
     * Exception decompiling
     */
    public static void movetransports() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CASE]], but top level block is 5[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public static void moveactors() {
        ni = Main.boardService.getStatNode(1);
        while (ni != null) {
            block265: {
                block264: {
                    nexti = ni.getNext();
                    i = ni.getIndex();
                    s = ni.get();
                    sect = s.getSectnum();
                    sec = Main.boardService.getSector(sect);
                    if (s.getXrepeat() != 0 && sec != null) break block264;
                    Main.engine.deletesprite(i);
                    break block265;
                }
                t = Globals.hittype[i].temp_data;
                Main.game.pInt.clearspriteinterpolate(i);
                Main.game.pInt.setsprinterpolate(i, s);
                block0 : switch (s.getPicnum()) {
                    case 1891: {
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        Gamedef.execute(Globals.currentGame.getCON(), i, p, x);
                        t[0] = t[0] + 1;
                        if (sec.getLotag() == 2) {
                            flame = Main.boardService.getSprite(Spawn.spawn(i, 1890));
                            if (flame == null) break;
                            flame.setShade(127);
                            Main.engine.deletesprite(i);
                            break;
                        }
                        dax = s.getX();
                        day = s.getY();
                        daz = s.getZ();
                        xvel = s.getXvel();
                        zvel = s.getZvel();
                        Gamedef.getglobalz(i);
                        ds = t[0] / 6;
                        if (s.getXrepeat() < 80) {
                            size = s.getXrepeat() + ds;
                            s.setXrepeat(size);
                            s.setYrepeat(size);
                        }
                        s.setClipdist(s.getClipdist() + ds);
                        if (t[0] <= 2) {
                            t[3] = Main.engine.krand() % 10;
                        }
                        if (t[0] > 30) {
                            flame = Main.boardService.getSprite(Spawn.spawn(i, 1890));
                            if (flame == null) break;
                            flame.setShade(127);
                            Main.engine.deletesprite(i);
                            break;
                        }
                        moveHit = Actors.movesprite(i, xvel * EngineUtils.sin(s.getAng() + 512 & 2047) >> 14, xvel * EngineUtils.sin(s.getAng() & 2047) >> 14, zvel, 0x1000040);
                        if (s.getSectnum() < 0) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if ((moveHit & -536870912) != -1073741824 && (sec2 = Main.boardService.getSector(s.getSectnum())) != null) {
                            if (s.getZ() < Globals.hittype[i].ceilingz) {
                                moveHit = 0x40000000 + s.getSectnum();
                                s.setZvel(-1);
                            } else if (s.getZ() > Globals.hittype[i].floorz && sec2.getLotag() != 1 || s.getZ() > Globals.hittype[i].floorz + 4096 && sec2.getLotag() == 1) {
                                moveHit = 0x40000000 + s.getSectnum();
                                if (sec2.getLotag() != 1) {
                                    s.setZvel(1);
                                }
                            }
                        }
                        if (moveHit == 0) break;
                        s.setXvel(0);
                        s.setYvel(0);
                        s.setZvel(0);
                        if ((moveHit & -536870912) == -1073741824) {
                            DSector.checkhitsprite(moveHit &= 0x1FFFFFFF, i);
                            hspr = Main.boardService.getSprite(moveHit);
                            if (hspr != null && hspr.getPicnum() == 1405) {
                                Sounds.spritesound(moveHit, 2);
                            }
                        } else if ((moveHit & -536870912) == -2147483648) {
                            Main.engine.setsprite(i, dax, day, daz);
                            DSector.checkhitwall(i, moveHit &= 0x1FFFFFFF, s.getX(), s.getY(), s.getZ(), s.getPicnum());
                        } else if ((moveHit & -536870912) == 0x40000000) {
                            Main.engine.setsprite(i, dax, day, daz);
                            if (s.getZvel() < 0) {
                                DSector.checkhitceiling(s.getSectnum());
                            }
                        }
                        if (s.getXrepeat() >= 10) {
                            x = s.getExtra();
                            Actors.hitradius(i, Globals.currentGame.getCON().rpgblastradius, x >> 2, x >> 1, x - (x >> 2), x);
                            break;
                        }
                        x = s.getExtra() + (Globals.global_random & 3);
                        Actors.hitradius(i, Globals.currentGame.getCON().rpgblastradius >> 1, x >> 2, x >> 1, x - (x >> 2), x);
                        break;
                    }
                    case 4359: 
                    case 4361: {
                        if ((s.getCstat() & 32) != 0) {
                            t[0] = t[0] + 1;
                            if (t[0] <= 60) break;
                            t[0] = 0;
                            s.setCstat(401);
                            s.setExtra(1);
                            break;
                        }
                        j = (short)Actors.ifhitbyweapon(i);
                        if (j < 0) break;
                        s.setCstat(160);
                        k = true;
                        for (node = Main.boardService.getStatNode(1); node != null; node = node.getNext()) {
                            sp = node.get();
                            if (sp.getLotag() != s.getLotag() || sp.getPicnum() != s.getPicnum() || (sp.getHitag() == 0 || (sp.getCstat() & 32) != 0) && (sp.getHitag() != 0 || (sp.getCstat() & 32) == 0)) continue;
                            k = false;
                            break;
                        }
                        if (!k) break;
                        DSector.operateactivators(s.getLotag(), -1);
                        DSector.operateforcefields(i, s.getLotag());
                        DSector.operatemasterswitches(s.getLotag());
                        break;
                    }
                    case 3190: 
                    case 3200: 
                    case 3210: {
                        Globals.hittype[i].temp_data[0] = Globals.hittype[i].temp_data[0] + 1;
                        if (Globals.hittype[i].temp_data[0] > Globals.currentGame.getCON().respawnitemtime) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (Globals.hittype[i].temp_data[0] >= Globals.currentGame.getCON().respawnitemtime >> 1 && Globals.hittype[i].temp_data[0] < (Globals.currentGame.getCON().respawnitemtime >> 1) + (Globals.currentGame.getCON().respawnitemtime >> 2)) {
                            s.setPicnum(3200);
                        } else if (Globals.hittype[i].temp_data[0] > (Globals.currentGame.getCON().respawnitemtime >> 1) + (Globals.currentGame.getCON().respawnitemtime >> 2)) {
                            s.setPicnum(3210);
                        }
                        Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                        ** GOTO lbl940
                    }
                    case 1346: 
                    case 2491: {
                        s.setZ(s.getZ() + s.getZvel());
                        t[0] = t[0] + 1;
                        if (t[0] == 4) {
                            Sounds.spritesound(232, i);
                        }
                        if (t[0] > 208) {
                            Sounds.sound(9);
                            for (j = 0; j < 32; ++j) {
                                Gameutils.RANDOMSCRAP(s, i);
                            }
                            Globals.earthquaketime = (short)16;
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if ((t[0] & 3) == 0) {
                            Spawn.spawn(i, 1890);
                        }
                        Actors.ssp(i, 65537);
                        ** GOTO lbl940
                    }
                    case 1267: {
                        Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                        if (Actors.ssp(i, 65537)) {
                            if ((Main.engine.krand() & 255) < 3) {
                                Sounds.spritesound(247, i);
                            }
                            s.setAng(s.getAng() + (Main.engine.krand() & 31) - 15 + (EngineUtils.sin(t[0] << 8 & 2047) >> 11));
                        } else {
                            Globals.hittype[i].temp_data[0] = Globals.hittype[i].temp_data[0] + 1;
                            if (Globals.hittype[i].temp_data[0] > 1) {
                                Main.engine.deletesprite(i);
                                break;
                            }
                            s.setAng((short)(Main.engine.krand() & 2047));
                        }
                        if (s.getXvel() < 128) {
                            s.setXvel(s.getXvel() + 2);
                        }
                        s.setAng(s.getAng() + (Main.engine.krand() & 3) - 6);
                        ** GOTO lbl940
                    }
                    case 901: 
                    case 902: {
                        if (s.getXvel() == 0) ** GOTO lbl203
                        node = Main.boardService.getStatNode(0);
                        while (node != null) {
                            nextj = node.getNext();
                            sp = node.get();
                            if (sp.getPicnum() == 903 && DSector.ldist(sp, s) < 52) {
                                Main.engine.deletesprite(i);
                                break block0;
                            }
                            node = nextj;
                        }
                        moveHit = Main.engine.clipmove(s.getX(), s.getY(), s.getZ(), s.getSectnum(), ((long)s.getXvel() * (long)EngineUtils.sin(s.getAng() + 512 & 2047) >> 14) * 4L << 11, ((long)s.getXvel() * (long)EngineUtils.sin(s.getAng() & 2047) >> 14) * 4L << 11, 24, 1024, 1024, 0x1000040);
                        if (Engine.clipmove_sectnum != -1) {
                            s.setX(Engine.clipmove_x);
                            s.setY(Engine.clipmove_y);
                            s.setZ(Engine.clipmove_z);
                            s.setSectnum(Engine.clipmove_sectnum);
                        }
                        if ((nHitObject = moveHit & -536870912) != 0) {
                            if (nHitObject == -2147483648) {
                                hwal = Main.boardService.getWall(moveHit &= 0x1FFFFFFF);
                                if (hwal != null) {
                                    k = hwal.getWallAngle();
                                    s.setAng((k << 1) - s.getAng() & 2047);
                                }
                            } else if (nHitObject == -1073741824) {
                                DSector.checkhitsprite(i, moveHit &= 0x1FFFFFFF);
                            }
                        }
                        s.setXvel(s.getXvel() - 1);
                        if (s.getXvel() < 0) {
                            s.setXvel(0);
                        }
                        if (s.getPicnum() == 901) {
                            s.setCstat(257);
                            s.setCstat(s.getCstat() | 4 & s.getXvel());
                            s.setCstat(s.getCstat() | 8 & s.getXvel());
                        }
                        ** GOTO lbl940
lbl203:
                        // 1 sources

                        p = (short)DSector.findplayer(s);
                        x = DSector.player_dist;
                        if (x < 1596 && (fj = Gamedef.getincangle(Globals.ps[p].ang, (float)EngineUtils.getAngle(s.getX() - Globals.ps[p].posx, s.getY() - Globals.ps[p].posy))) > -64.0f && fj < 64.0f && (Globals.sync[p].bits & 0x20000000) != 0 && Globals.ps[p].toggle_key_flag == 1) {
                            for (node = Main.boardService.getStatNode(1); node != null; node = node.getNext()) {
                                sp = node.get();
                                if (sp.getPicnum() != 902 && sp.getPicnum() != 901 || !((fj = Gamedef.getincangle(Globals.ps[p].ang, (float)EngineUtils.getAngle(sp.getX() - Globals.ps[p].posx, sp.getY() - Globals.ps[p].posy))) > -64.0f) || !(fj < 64.0f)) continue;
                                DSector.findplayer(sp);
                                l = DSector.player_dist;
                                if (x > l) break;
                            }
                            if (node == null) {
                                if (s.getPal() == 12) {
                                    s.setXvel(164);
                                } else {
                                    s.setXvel(140);
                                }
                                s.setAng((short)Globals.ps[p].ang);
                                Globals.ps[p].toggle_key_flag = (short)2;
                            }
                        }
                        if (x >= 512 || s.getSectnum() != Globals.ps[p].cursectnum) ** GOTO lbl940
                        s.setAng(EngineUtils.getAngle(s.getX() - Globals.ps[p].posx, s.getY() - Globals.ps[p].posy));
                        s.setXvel(48);
                        ** GOTO lbl940
                    }
                    case 2590: {
                        if (s.getYvel() == 0) {
                            s.setYvel(1);
                            for (l = 512; l < 1536; l += 128) {
                                for (j = 0; j < 2048; j += 128) {
                                    k = Spawn.spawn(i, 2590);
                                    sp = Main.boardService.getSprite(k);
                                    if (sp == null) continue;
                                    sp.setCstat(385);
                                    sp.setClipdist(64);
                                    sp.setAng((short)j);
                                    sp.setZvel((short)(EngineUtils.sin(l & 2047) >> 5));
                                    sp.setXvel((short)(EngineUtils.cos(l & 2047) >> 9));
                                    sp.setOwner(i);
                                }
                            }
                        }
                        if (t[3] > 0) {
                            if (s.getZvel() < 6144) {
                                s.setZvel(s.getZvel() + 192);
                            }
                            s.setZ(s.getZ() + s.getZvel());
                            if (s.getZ() > sec.getFloorz()) {
                                s.setZ(sec.getFloorz());
                            }
                            t[3] = t[3] - 1;
                            if (t[3] != 0) break;
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (t[2] <= 10) break;
                        for (node = Main.boardService.getStatNode(5); node != null; node = node.getNext()) {
                            sp = node.get();
                            if (sp.getOwner() != i || sp.getPicnum() != 2590) continue;
                            Globals.hittype[node.getIndex()].temp_data[1] = 1 + (Main.engine.krand() & 63);
                        }
                        t[3] = 64;
                        break;
                    }
                    case 1960: {
                        Gamedef.getglobalz(i);
                        if ((sec.getCeilingstat() & 1) != 0) {
                            s.setShade(s.getShade() + (sec.getCeilingshade() - s.getShade() >> 1));
                        } else {
                            s.setShade(s.getShade() + (sec.getFloorshade() - s.getShade() >> 1));
                        }
                        if (s.getZ() < sec.getCeilingz() + 8192) {
                            s.setZ(sec.getCeilingz() + 8192);
                        }
                        if (Globals.ud.multimode < 2 && Actors.actor_tog != 0) {
                            s.setCstat(32768);
                            break;
                        }
                        if (Actors.ifhitbyweapon(i) >= 0) {
                            if (s.getExtra() < 0 && t[0] != -1) {
                                t[0] = -1;
                                s.setExtra(0);
                            }
                            Sounds.spritesound(128, i);
                            Gameutils.RANDOMSCRAP(s, i);
                        }
                        if (t[0] == -1) {
                            s.setZ(s.getZ() + 1024);
                            t[2] = t[2] + 1;
                            if ((t[2] & 3) == 0) {
                                Spawn.spawn(i, 1890);
                            }
                            Gamedef.getglobalz(i);
                            s.setAng(s.getAng() + 96);
                            s.setXvel(128);
                            if (Actors.ssp(i, 65537) && s.getZ() <= Globals.hittype[i].floorz) break;
                            for (l = 0; l < 16; ++l) {
                                Gameutils.RANDOMSCRAP(s, i);
                            }
                            Sounds.spritesound(17, i);
                            Spawn.spawn(i, 2000);
                            Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + 1);
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (s.getZ() > Globals.hittype[i].floorz - 12288) {
                            s.setZ(Globals.hittype[i].floorz - 12288);
                        }
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        j = s.getOwner();
                        if (t[0] >= 4) {
                            t[2] = t[2] + 1;
                            if ((t[2] & 15) == 0) {
                                a = s.getAng();
                                s.setAng((short)Globals.hittype[i].tempang);
                                Sounds.spritesound(127, i);
                                Weapons.shoot(i, 1625);
                                s.setAng(a);
                            }
                            if (t[2] > 78 || !Main.engine.cansee(s.getX(), s.getY(), s.getZ() - 4096, s.getSectnum(), Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].posz, Globals.ps[p].cursectnum)) {
                                t[0] = 0;
                                t[2] = 0;
                            } else {
                                Globals.hittype[i].tempang += Gamedef.getincangle(Globals.hittype[i].tempang, EngineUtils.getAngle(Globals.ps[p].posx - s.getX(), Globals.ps[p].posy - s.getY())) / 3;
                            }
                        } else if (t[0] == 2 || t[0] == 3) {
                            t[3] = 0;
                            if (s.getXvel() > 0) {
                                s.setXvel(s.getXvel() - 16);
                            } else {
                                s.setXvel(0);
                            }
                            if (t[0] == 2) {
                                l = Globals.ps[p].posz - s.getZ();
                                if (Pragmas.klabs(l) < 12288) {
                                    t[0] = 3;
                                } else {
                                    s.setZ(s.getZ() + (Gameutils.sgn(Globals.ps[p].posz - s.getZ()) << 10));
                                }
                            } else {
                                t[2] = t[2] + 1;
                                if (t[2] > 78 || !Main.engine.cansee(s.getX(), s.getY(), s.getZ() - 4096, s.getSectnum(), Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].posz, Globals.ps[p].cursectnum)) {
                                    t[0] = 1;
                                    t[2] = 0;
                                } else if ((t[2] & 15) == 0) {
                                    Sounds.spritesound(127, i);
                                    Weapons.shoot(i, 1625);
                                }
                            }
                            s.setAng(s.getAng() + (Gamedef.getincangle(s.getAng(), EngineUtils.getAngle(Globals.ps[p].posx - s.getX(), Globals.ps[p].posy - s.getY())) >> 2));
                        }
                        if (t[0] != 2 && t[0] != 3) {
                            js = Main.boardService.getSprite(j);
                            v0 = l = js == null ? 0 : DSector.ldist(js, s);
                            if (l <= 1524) {
                                a = s.getAng();
                                s.setXvel(s.getXvel() >> 1);
                            } else {
                                a = EngineUtils.getAngle(js.getX() - s.getX(), js.getY() - s.getY());
                            }
                            if (t[0] == 1 || t[0] == 4) {
                                v1 = l = js == null ? 0 : DSector.dist(js, s);
                                if (l <= 1524) {
                                    t[0] = t[0] == 1 ? 0 : 5;
                                } else if (s.getXvel() < 256) {
                                    s.setXvel(s.getXvel() + 32);
                                }
                                if (t[0] < 2) {
                                    t[2] = t[2] + 1;
                                }
                                if (x < 6144 && t[0] < 2 && t[2] > 104) {
                                    t[0] = 2 + (Main.engine.krand() & 2);
                                    t[2] = 0;
                                    Globals.hittype[i].tempang = s.getAng();
                                }
                            }
                            if (t[0] == 0 || t[0] == 5) {
                                t[0] = t[0] == 0 ? 1 : 4;
                                s.setOwner(Actors.LocateTheLocator(s.getHitag(), -1));
                                j = s.getOwner();
                                if (j == -1) {
                                    j = Globals.hittype[i].temp_data[5];
                                    s.setHitag(j);
                                    s.setOwner(Actors.LocateTheLocator(j, -1));
                                    j = s.getOwner();
                                    if (j == -1) {
                                        Main.engine.deletesprite(i);
                                        break;
                                    }
                                } else {
                                    s.setHitag(s.getHitag() + 1);
                                }
                            }
                            t[3] = Gamedef.getincangle(s.getAng(), a);
                            s.setAng(s.getAng() + (t[3] >> 3));
                            js = Main.boardService.getSprite(j);
                            if (js != null && s.getZ() < js.getZ()) {
                                s.setZ(s.getZ() + 1024);
                            } else {
                                s.setZ(s.getZ() - 1024);
                            }
                        }
                        if (Globals.Sound[125].getSoundOwnerCount() == 0) {
                            Sounds.spritesound(125, i);
                        }
                        Actors.ssp(i, 65537);
                        break;
                    }
                    case 2300: 
                    case 2309: {
                        Gamedef.getglobalz(i);
                        j = Globals.hittype[i].floorz - Globals.hittype[i].ceilingz >> 9;
                        if (j > 255) {
                            j = 255;
                        }
                        if ((x = 25 - (j >> 1)) < 8) {
                            x = 8;
                        } else if (x > 48) {
                            x = 48;
                        }
                        s.setYrepeat((short)j);
                        s.setXrepeat((short)x);
                        s.setZ(Globals.hittype[i].floorz);
                        break;
                    }
                    case 2370: 
                    case 2371: 
                    case 2372: 
                    case 2373: 
                    case 2374: 
                    case 2375: 
                    case 2376: 
                    case 2377: {
                        if (Globals.ud.multimode < 2) {
                            if (Actors.actor_tog == 1) {
                                s.setCstat(-32768);
                                break;
                            }
                            if (Actors.actor_tog == 2) {
                                s.setCstat(257);
                            }
                        }
                        t[1] = t[1] + 128;
                        if ((sec.getFloorstat() & 1) != 0) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        if (x > 20480) {
                            ++Globals.hittype[i].timetosleep;
                            if (Globals.hittype[i].timetosleep > 1536) {
                                Globals.hittype[i].timetosleep = 0;
                                Main.engine.changespritestat(i, 2);
                                break;
                            }
                        }
                        if (t[0] == -5) {
                            t[3] = t[3] + 1;
                            if (t[3] > 280) {
                                s.setPal(0);
                                t[0] = 0;
                                break;
                            }
                            Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                            s.setCstat(257);
                            s.setPicnum(2372);
                            s.setExtra(1);
                            s.setPal(1);
                            j = Actors.ifhitbyweapon(i);
                            if (j >= 0) {
                                if (j == 1641) break;
                                for (j = 16; j >= 0; --j) {
                                    vz = 1024 - (Main.engine.krand() & 1023);
                                    ve = 32 + (Main.engine.krand() & 63);
                                    va = Main.engine.krand() & 2047;
                                    k = Spawn.EGS(s.getSectnum(), s.getX(), s.getY(), s.getZ(), 1031 + j % 3, -32, 36, 36, va, ve, vz, i, 5);
                                    ks = Main.boardService.getSprite(k);
                                    if (ks == null) continue;
                                    ks.setPal(1);
                                }
                                if (!Main.gGameScreen.IsOriginalGame()) {
                                    Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + 1);
                                }
                                Sounds.spritesound(19, i);
                                Main.engine.deletesprite(i);
                                break;
                            }
                            if (x >= 1024 || Globals.ps[p].quick_kick != 0 || !((fj = Gamedef.getincangle(Globals.ps[p].ang, (float)EngineUtils.getAngle(s.getX() - Globals.ps[p].posx, s.getY() - Globals.ps[p].posy))) > -128.0f) || !(fj < 128.0f)) break;
                            Globals.ps[p].quick_kick = (short)14;
                            break;
                        }
                        if (x < 1596) {
                            s.setCstat(0);
                        } else {
                            s.setCstat(257);
                        }
                        if (t[0] == -4) {
                            psp = Main.boardService.getSprite(Globals.ps[p].i);
                            if (psp == null) break;
                            if (psp.getExtra() < 1) {
                                t[0] = 0;
                                break;
                            }
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            s.setAng((short)Globals.ps[p].ang);
                            if (((Globals.sync[p].bits & 4) != 0 || Globals.ps[p].quick_kick > 0) && psp.getExtra() > 0 && (Globals.ps[p].quick_kick > 0 || Globals.ps[p].curr_weapon != 10 && Globals.ps[p].curr_weapon != 5 && Globals.ps[p].curr_weapon != 8 && Globals.ps[p].ammo_amount[Globals.ps[p].curr_weapon] >= 0)) {
                                for (x = 0; x < 8; ++x) {
                                    vz = -(Main.engine.krand() & 4095) - (s.getZvel() >> 2);
                                    ve = (Main.engine.krand() & 63) + 64;
                                    va = Main.engine.krand() & 2047;
                                    j = Spawn.EGS(sect, s.getX(), s.getY(), s.getZ() - 2048, 2408 + (Main.engine.krand() & 3), -8, 48, 48, va, ve, vz, i, 5);
                                    js = Main.boardService.getSprite(j);
                                    if (js == null) continue;
                                    js.setPal(6);
                                }
                                Sounds.spritesound(149, i);
                                Sounds.spritesound(69, i);
                                if ((Main.engine.krand() & 255) < 32 && (js = Main.boardService.getSprite(j = Spawn.spawn(i, 1226))) != null) {
                                    js.setPal(0);
                                }
                                Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + 1);
                                t[0] = -3;
                                if (Globals.ps[p].somethingonplayer == i) {
                                    Globals.ps[p].somethingonplayer = (short)-1;
                                }
                                Main.engine.deletesprite(i);
                                break;
                            }
                            s.setZ(Globals.ps[p].posz + Globals.ps[p].pyoff - t[2] + 2048);
                            s.setZ(s.getZ() + (100 - (int)Globals.ps[p].horiz << 4));
                            if (t[2] > 512) {
                                t[2] = t[2] - 128;
                            }
                            if (t[2] < 348) {
                                t[2] = t[2] + 128;
                            }
                            if (Globals.ps[p].newowner >= 0) {
                                Globals.ps[p].newowner = (short)-1;
                                Globals.ps[p].posx = Globals.ps[p].oposx;
                                Globals.ps[p].posy = Globals.ps[p].oposy;
                                Globals.ps[p].posz = Globals.ps[p].oposz;
                                Globals.ps[p].ang = Globals.ps[p].oang;
                                Main.game.pInt.setsprinterpolate(Globals.ps[p].i, psp);
                                Globals.ps[p].cursectnum = Main.engine.updatesector(Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].cursectnum);
                                Player.setpal(Globals.ps[p]);
                                Globals.ps[p].UpdatePlayerLoc();
                                for (n = Main.boardService.getStatNode(1); n != null; n = n.getNext()) {
                                    sp = ni.get();
                                    if (sp.getPicnum() != 621) continue;
                                    sp.setYvel(0);
                                }
                            }
                            if (t[3] > 0) {
                                frames = new short[]{5, 5, 6, 6, 7, 7, 6, 5};
                                s.setPicnum((short)(2370 + frames[t[3] & 7]));
                                if (t[3] == 5) {
                                    Globals.ps[p].getPlayerSprite().setExtra(Globals.ps[p].getPlayerSprite().getExtra() - (5 + (Main.engine.krand() & 3)));
                                    Sounds.spritesound(34, i);
                                }
                                t[3] = t[3] < 7 ? t[3] + 1 : 0;
                            } else {
                                s.setPicnum(2375);
                                if (Gameutils.rnd(32)) {
                                    t[3] = 1;
                                }
                            }
                            s.setXrepeat((short)(20 + (EngineUtils.sin(t[1] & 2047) >> 13)));
                            s.setYrepeat((short)(15 + (EngineUtils.sin(t[1] & 2047) >> 13)));
                            if (Main.IsOriginalDemo()) {
                                s.setX(Globals.ps[p].posx + (EngineUtils.sin((int)Globals.ps[p].ang + 512 & 2047) >> 7));
                                s.setY(Globals.ps[p].posy + (EngineUtils.sin((int)Globals.ps[p].ang & 2047) >> 7));
                                break;
                            }
                            s.setX((int)((double)Globals.ps[p].posx + ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(Globals.ps[p].ang)) / 127.0));
                            s.setY((int)((double)Globals.ps[p].posy + ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(Globals.ps[p].ang)) / 127.0));
                            break;
                        }
                        if (s.getXvel() < 64 && x < 768 && Globals.ps[p].somethingonplayer == -1) {
                            Globals.ps[p].somethingonplayer = (short)i;
                            t[2] = t[0] == 3 || t[0] == 2 ? 3072 : -3328;
                            t[0] = -4;
                        }
                        if ((j = Actors.ifhitbyweapon(i)) >= 0) {
                            Sounds.spritesound(149, i);
                            if (Main.gGameScreen.IsOriginalGame()) {
                                Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + 1);
                            }
                            if (Globals.ps[p].somethingonplayer == i) {
                                Globals.ps[p].somethingonplayer = (short)-1;
                            }
                            if (j == 1641) {
                                Sounds.spritesound(303, i);
                                t[0] = -5;
                                t[3] = 0;
                                break;
                            }
                            if (!Main.gGameScreen.IsOriginalGame()) {
                                Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + 1);
                            }
                            if ((Main.engine.krand() & 255) < 32 && (js = Main.boardService.getSprite(j = Spawn.spawn(i, 1226))) != null) {
                                js.setPal(0);
                            }
                            for (x = 0; x < 8; ++x) {
                                vz = -(Main.engine.krand() & 4095) - (s.getZvel() >> 2);
                                ve = (Main.engine.krand() & 63) + 64;
                                va = Main.engine.krand() & 2047;
                                j = Spawn.EGS(sect, s.getX(), s.getY(), s.getZ() - 2048, 2408 + (Main.engine.krand() & 3), -8, 48, 48, va, ve, vz, i, 5);
                                js = Main.boardService.getSprite(j);
                                if (js == null) continue;
                                js.setPal(6);
                            }
                            t[0] = -3;
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (t[0] == -1) {
                            Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                            s.setCstat(s.getCstat() & 65527);
                            s.setPicnum(2374);
                            if (s.getXrepeat() > 32) {
                                s.setXrepeat(s.getXrepeat() - (Main.engine.krand() & 7));
                            }
                            if (s.getYrepeat() > 16) {
                                s.setYrepeat(s.getYrepeat() - (Main.engine.krand() & 7));
                                break;
                            }
                            s.setXrepeat(40);
                            s.setYrepeat(16);
                            t[5] = -1;
                            t[0] = 0;
                            break;
                        }
                        if (t[0] != -2) {
                            Gamedef.getglobalz(i);
                        }
                        if (t[0] == -2) {
                            Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                            ts = Main.boardService.getSprite(t[5]);
                            if (ts == null) break;
                            ts.setXvel(0);
                            l = ts.getAng();
                            s.setZ(ts.getZ());
                            s.setX(ts.getX() + (EngineUtils.cos(l & 2047) >> 11));
                            s.setY(ts.getY() + (EngineUtils.sin(l & 2047) >> 11));
                            s.setPicnum((short)(2372 + (Globals.global_random & 1)));
                            if (s.getYrepeat() < 64) {
                                s.setYrepeat(s.getYrepeat() + 2);
                                break;
                            }
                            if (s.getXrepeat() < 32) {
                                s.setXrepeat(s.getXrepeat() + 4);
                                break;
                            }
                            t[0] = -1;
                            x = DSector.ldist(s, ts);
                            if (x >= 768) break;
                            ts.setXrepeat(0);
                            break;
                        }
                        if (Gameutils.rnd(32)) {
                            block50: for (n = Main.boardService.getSectNode(sect); n != null; n = n.getNext()) {
                                sp = n.get();
                                switch (sp.getPicnum()) {
                                    case 1680: 
                                    case 2000: 
                                    case 2120: 
                                    case 4610: {
                                        if (DSector.ldist(s, sp) >= 768 || Pragmas.klabs(s.getZ() - sp.getZ()) >= 8192) continue block50;
                                        t[5] = n.getIndex();
                                        t[0] = -2;
                                        t[1] = 0;
                                        break block0;
                                    }
                                }
                            }
                        }
                        if (t[0] == 0 || t[0] == 2) {
                            s.setPicnum(2370);
                            if ((Main.engine.krand() & 511) == 0) {
                                Sounds.spritesound(163, i);
                            }
                            if (t[0] == 2) {
                                s.setZvel(0);
                                s.setCstat(s.getCstat() & 65527);
                                if ((sec.getCeilingstat() & 1) != 0 || Globals.hittype[i].ceilingz + 6144 < s.getZ()) {
                                    s.setZ(s.getZ() + 2048);
                                    t[0] = 3;
                                    break;
                                }
                            } else {
                                s.setCstat(s.getCstat() | 8);
                                Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                            }
                            if ((Globals.everyothertime & '\u0001') != 0) {
                                Actors.ssp(i, 65537);
                            }
                            if (s.getXvel() > 96) {
                                s.setXvel(s.getXvel() - 2);
                                break;
                            }
                            if (s.getXvel() < 32) {
                                s.setXvel(s.getXvel() + 4);
                            }
                            s.setXvel((short)(64 - (EngineUtils.sin(t[1] + 512 & 2047) >> 9)));
                            s.setAng(s.getAng() + (Gamedef.getincangle(s.getAng(), EngineUtils.getAngle(Globals.ps[p].posx - s.getX(), Globals.ps[p].posy - s.getY())) >> 3));
                            s.setXrepeat((short)(36 + (EngineUtils.sin(t[1] + 512 & 2047) >> 11)));
                            s.setYrepeat((short)(16 + (EngineUtils.sin(t[1] & 2047) >> 13)));
                            if (Gameutils.rnd(4) && (sec.getCeilingstat() & 1) == 0 && Pragmas.klabs(Globals.hittype[i].floorz - Globals.hittype[i].ceilingz) < 49152) {
                                s.setZvel(0);
                                t[0] = t[0] + 1;
                            }
                        }
                        if (t[0] == 1) {
                            s.setPicnum(2370);
                            if (s.getYrepeat() < 40) {
                                s.setYrepeat(s.getYrepeat() + 8);
                            }
                            if (s.getXrepeat() > 8) {
                                s.setXrepeat(s.getXrepeat() - 4);
                            }
                            if (s.getZvel() > -3072) {
                                s.setZvel(s.getZvel() - 348);
                            }
                            s.setZ(s.getZ() + s.getZvel());
                            if (s.getZ() < Globals.hittype[i].ceilingz + 4096) {
                                s.setZ(Globals.hittype[i].ceilingz + 4096);
                                s.setXvel(0);
                                t[0] = 2;
                            }
                        }
                        if (t[0] != 3) break;
                        s.setPicnum(2371);
                        Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                        if (s.getZ() > Globals.hittype[i].floorz - 2048) {
                            s.setYrepeat(s.getYrepeat() - 4);
                            s.setXrepeat(s.getXrepeat() + 2);
                        } else {
                            if (s.getYrepeat() < 36) {
                                s.setYrepeat(s.getYrepeat() + 8);
                            }
                            if (s.getXrepeat() > 8) {
                                s.setXrepeat(s.getXrepeat() - 4);
                            }
                        }
                        if (s.getZ() <= Globals.hittype[i].floorz - 2048) break;
                        s.setZ(Globals.hittype[i].floorz - 2048);
                        t[0] = 0;
                        s.setXvel(0);
                        break;
                    }
                    case 940: 
                    case 1650: {
                        Globals.hittype[Spawn.spawn((int)i, (int)4095)].temp_data[0] = 3;
                    }
                    case 26: {
                        if ((s.getCstat() & 32768) != 0) {
                            t[2] = t[2] - 1;
                            if (t[2] > 0) break;
                            Sounds.spritesound(70, i);
                            Spawn.spawn(i, 1630);
                            s.setCstat(257);
                            break;
                        }
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        if (x < 1220) {
                            s.setCstat(s.getCstat() & -258);
                        } else {
                            s.setCstat(s.getCstat() | 257);
                        }
                        l = 0;
                        switch (l) {
                            default: 
                        }
                        if (t[3] == 0 && Actors.ifhitbyweapon(i) >= 0) {
                            t[3] = 1;
                            t[4] = 0;
                            s.setXvel(0);
                        } else {
                            if (s.getPicnum() != 940) {
                                Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                                if (sec.getLotag() != 1 && s.getZ() >= Globals.hittype[i].floorz - 256 && s.getYvel() < 3) {
                                    if (s.getYvel() > 0 || s.getYvel() == 0 && Globals.hittype[i].floorz == sec.getFloorz()) {
                                        Sounds.spritesound(13, i);
                                    }
                                    s.setZvel((short)(-(4 - s.getYvel() << 8)));
                                    sec2 = Main.boardService.getSector(s.getSectnum());
                                    if (sec2 != sec) {
                                        Console.out.println("Actors(3598) sec2 != sec", OsdColor.RED);
                                    }
                                    if (sec2 != null && sec2.getLotag() == 2) {
                                        s.setZvel(s.getZvel() >> 2);
                                    }
                                    s.setYvel(s.getYvel() + 1);
                                }
                                if (s.getZ() < Globals.hittype[i].ceilingz) {
                                    s.setZ(Globals.hittype[i].ceilingz + 768);
                                    s.setZvel(0);
                                }
                            }
                            moveHit = Actors.movesprite(i, s.getXvel() * EngineUtils.cos(s.getAng() & 2047) >> 14, s.getXvel() * EngineUtils.sin(s.getAng() & 2047) >> 14, s.getZvel(), 65537);
                            sec2 = Main.boardService.getSector(s.getSectnum());
                            if (sec2 != null && sec2.getLotag() == 1 && s.getZvel() == 0) {
                                s.setZ(s.getZ() + 8192);
                                if (t[5] == 0) {
                                    t[5] = 1;
                                    Spawn.spawn(i, 1380);
                                }
                            } else {
                                t[5] = 0;
                            }
                            if (!(t[3] != 0 || s.getPicnum() != 940 && s.getPicnum() != 1650 || moveHit == 0 && x >= 844)) {
                                t[3] = 1;
                                t[4] = 0;
                                s.setXvel(0);
                            } else {
                                spo = Main.boardService.getSprite(s.getOwner());
                                l = spo != null && spo.getPicnum() == 1405 ? (int)spo.getYvel() : -1;
                                if (s.getXvel() > 0) {
                                    s.setXvel(s.getXvel() - 5);
                                    if (sec.getLotag() == 2) {
                                        s.setXvel(s.getXvel() - 10);
                                    }
                                    if (s.getXvel() < 0) {
                                        s.setXvel(0);
                                    }
                                    if ((s.getXvel() & 8) != 0) {
                                        s.setCstat(s.getCstat() ^ 4);
                                    }
                                }
                                if ((moveHit & -536870912) == -2147483648) {
                                    DSector.checkhitwall(i, moveHit &= 0x1FFFFFFF, s.getX(), s.getY(), s.getZ(), s.getPicnum());
                                    hwall = Main.boardService.getWall(moveHit);
                                    if (hwall != null) {
                                        k = hwall.getWallAngle();
                                        s.setAng((short)((k << 1) - s.getAng() & 2047));
                                        s.setXvel(s.getXvel() >> 1);
                                    }
                                }
                            }
                        }
                        if (Main.game.isGameType(GameType.NAM) && s.getPicnum() == 26) {
                            extra = s.getExtra();
                            s.setExtra(extra - 1);
                            if (extra <= 0) {
                                t[3] = 1;
                            }
                        }
                        if (l >= 0 && Globals.ps[l].hbomb_on == 0 || t[3] == 1) {
                            t[4] = t[4] + 1;
                            if (t[4] == 2) {
                                x = s.getExtra();
                                m = 0;
                                switch (s.getPicnum()) {
                                    case 26: {
                                        m = Globals.currentGame.getCON().pipebombblastradius;
                                        break;
                                    }
                                    case 1650: {
                                        m = Globals.currentGame.getCON().morterblastradius;
                                        break;
                                    }
                                    case 940: {
                                        m = Globals.currentGame.getCON().bouncemineblastradius;
                                    }
                                }
                                Actors.hitradius(i, m, x >> 2, x >> 1, x - (x >> 2), x);
                                Spawn.spawn(i, 1890);
                                if (s.getZvel() == 0) {
                                    Spawn.spawn(i, 2219);
                                }
                                Sounds.spritesound(14, i);
                                for (x = 0; x < 8; ++x) {
                                    Gameutils.RANDOMSCRAP(s, i);
                                }
                            }
                            if (s.getYrepeat() != 0) {
                                s.setYrepeat(0);
                                break;
                            }
                            if (t[4] > 20) {
                                if (s.getOwner() != i || !Globals.ud.respawn_items) {
                                    Main.engine.deletesprite(i);
                                    break;
                                }
                                t[2] = Globals.currentGame.getCON().respawnitemtime;
                                Spawn.spawn(i, 3190);
                                s.setCstat(-32768);
                                s.setYrepeat(9);
                                break;
                            }
                        } else if (s.getPicnum() == 26 && x < 788 && t[0] > 7 && s.getXvel() == 0 && Main.engine.cansee(s.getX(), s.getY(), s.getZ() - 2048, s.getSectnum(), Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].posz, Globals.ps[p].cursectnum) && Globals.ps[p].ammo_amount[5] < Globals.currentGame.getCON().max_ammo_amount[5]) {
                            if (Globals.ud.coop >= 1 && s.getOwner() == i) {
                                for (j = 0; j < Globals.ps[p].weapreccnt; ++j) {
                                    if (Globals.ps[p].weaprecs[j] == s.getPicnum()) break block0;
                                }
                                if (Globals.ps[p].weapreccnt < 16) {
                                    v2 = Globals.ps[p].weapreccnt;
                                    Globals.ps[p].weapreccnt = (short)(v2 + 1);
                                    Globals.ps[p].weaprecs[v2] = s.getPicnum();
                                }
                            }
                            Weapons.addammo(5, Globals.ps[p], 1);
                            Sounds.spritesound(210, Globals.ps[p].i);
                            if (!Globals.ps[p].gotweapon[5] || s.getOwner() == Globals.ps[p].i) {
                                Weapons.addweapon(Globals.ps[p], 5);
                            }
                            if ((spo = Main.boardService.getSprite(s.getOwner())) != null && spo.getPicnum() != 1405) {
                                Globals.ps[p].pals[0] = 0;
                                Globals.ps[p].pals[1] = 32;
                                Globals.ps[p].pals[2] = 0;
                                Globals.ps[p].pals_time = 32;
                            }
                            if (s.getOwner() != i || !Globals.ud.respawn_items) {
                                if (s.getOwner() == i && Globals.ud.coop >= 1) break;
                                Main.engine.deletesprite(i);
                                break;
                            }
                            t[2] = Globals.currentGame.getCON().respawnitemtime;
                            Spawn.spawn(i, 3190);
                            s.setCstat(-32768);
                        }
                        if (t[0] >= 8) break;
                        t[0] = t[0] + 1;
                        break;
                    }
                    case 579: 
                    case 1096: {
                        break;
                    }
                    case 578: 
                    case 1088: {
                        if (t[4] == 1) {
                            block53: for (node = Main.boardService.getSectNode(sect); node != null; node = node.getNext()) {
                                sp = node.get();
                                switch (sp.getPicnum()) {
                                    case 1: {
                                        if (sp.getLotag() != 1) continue block53;
                                        sp.setLotag(-1);
                                        sp.setHitag(-1);
                                        continue block53;
                                    }
                                    case 1088: {
                                        sp.setPicnum(1096);
                                        continue block53;
                                    }
                                    case 578: {
                                        sp.setPicnum(579);
                                        continue block53;
                                    }
                                    case 580: 
                                    case 1092: {
                                        sp.setCstat(-32768);
                                    }
                                }
                            }
                            break;
                        }
                        if (t[1] >= 20) {
                            t[4] = 1;
                            break;
                        }
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        t[2] = t[2] + 1;
                        if (t[2] == 4) {
                            t[2] = 0;
                        }
                        if (x < 4096) {
                            if ((Main.engine.krand() & 255) < 16) {
                                if (Globals.Sound[211].getSoundOwnerCount() < 1) {
                                    Sounds.spritesound(211, Globals.ps[p].i);
                                }
                                Sounds.spritesound(21, i);
                                Globals.ps[p].getPlayerSprite().setExtra(Globals.ps[p].getPlayerSprite().getExtra() - 1);
                                Globals.ps[p].pals_time = 32;
                                Globals.ps[p].pals[0] = 32;
                                Globals.ps[p].pals[1] = 0;
                                Globals.ps[p].pals[2] = 0;
                            }
                            t[0] = t[0] + 128;
                            if (t[3] == 0) {
                                t[3] = 1;
                            }
                        } else {
                            t[3] = 0;
                        }
                        if (t[1] != 0) {
                            t[1] = t[1] + 1;
                            t[4] = s.getZ();
                            s.setZ(sec.getFloorz());
                            dz = sec.getFloorz() - sec.getCeilingz();
                            if (dz != 0) {
                                s.setZ(s.getZ() - Main.engine.krand() % dz);
                            }
                            block33 : switch (t[1]) {
                                case 3: {
                                    Actors.hitradius(i, 4096, Globals.currentGame.getCON().impact_damage << 2, Globals.currentGame.getCON().impact_damage << 2, Globals.currentGame.getCON().impact_damage << 2, Globals.currentGame.getCON().impact_damage << 2);
                                    for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
                                        sp = node.get();
                                        if (sp.getPicnum() != 8 || sp.getHitag() != s.getHitag() || sp.getYvel() != 0) continue;
                                        sp.setYvel(1);
                                    }
                                    break;
                                }
                                case 4: 
                                case 7: 
                                case 10: 
                                case 15: {
                                    node = Main.boardService.getSectNode(sect);
                                    while (node != null) {
                                        next = node.getNext();
                                        j = node.getIndex();
                                        if (j != i) {
                                            Main.engine.deletesprite(j);
                                            break block33;
                                        }
                                        node = next;
                                    }
                                    break;
                                }
                            }
                            for (x = 0; x < 16; ++x) {
                                Gameutils.RANDOMSCRAP(s, i);
                            }
                            s.setZ(t[4]);
                            t[4] = 0;
                            break;
                        }
                        if (Actors.ifhitbyweapon(i) < 0) break;
                        for (x = 0; x < 32; ++x) {
                            Gameutils.RANDOMSCRAP(s, i);
                        }
                        if (s.getExtra() >= 0) break;
                        t[1] = 1;
                        break;
                    }
                    case 621: {
                        if (t[0] != 0) break;
                        t[1] = t[1] + 8;
                        if (Globals.currentGame.getCON().camerashitable != '\u0000' && Actors.ifhitbyweapon(i) >= 0) {
                            t[0] = 1;
                            s.setCstat(-32768);
                            for (x = 0; x < 5; ++x) {
                                Gameutils.RANDOMSCRAP(s, i);
                            }
                            break;
                        }
                        if (s.getHitag() <= 0) break;
                        if (t[1] < s.getHitag()) {
                            s.setAng(s.getAng() + 8);
                            break;
                        }
                        if (t[1] < s.getHitag() * 3) {
                            s.setAng(s.getAng() - 8);
                            break;
                        }
                        if (t[1] < s.getHitag() << 2) {
                            s.setAng(s.getAng() + 8);
                            break;
                        }
                        t[1] = 8;
                        s.setAng(s.getAng() + 16);
                        break;
                    }
lbl940:
                    // 7 sources

                    default: {
                        if (Globals.ud.multimode < 2 && Actors.badguy(s)) {
                            if (Actors.actor_tog == 1) {
                                s.setCstat(-32768);
                                break;
                            }
                            if (Actors.actor_tog == 2) {
                                s.setCstat(257);
                            }
                        }
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        Gamedef.execute(Globals.currentGame.getCON(), i, p, x);
                    }
                }
            }
            ni = nexti;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void moveexplosions() {
        ni = Main.boardService.getStatNode(5);
        while (ni != null) {
            block116: {
                block115: {
                    nexti = ni.getNext();
                    i = ni.getIndex();
                    t = Globals.hittype[i].temp_data;
                    s = ni.get();
                    sect = s.getSectnum();
                    if (sect >= 0 && s.getXrepeat() != 0) break block115;
                    Main.engine.deletesprite(i);
                    break block116;
                }
                Main.game.pInt.setsprinterpolate(i, s);
                switch (s.getPicnum()) {
                    case 5296: {
                        if (Globals.currentGame.getCON().type != 20) break;
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        Gamedef.execute(Globals.currentGame.getCON(), i, p, x);
                        owner = Main.boardService.getSprite(s.getOwner());
                        if (owner == null) break;
                        if (owner.getPicnum() != 5180) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (owner.getXrepeat() >= 24 || owner.getPal() == 1) {
                            s.setCstat(s.getCstat() | 32768);
                        } else {
                            s.setCstat(s.getCstat() & -32769);
                        }
                        dx = owner.getX() - Globals.ps[p].getPlayerSprite().getX();
                        dy = owner.getY() - Globals.ps[p].getPlayerSprite().getY();
                        dist = Math.sqrt(dx * dx + dy * dy);
                        if (dist != 0.0) {
                            dx /= dist;
                            dy /= dist;
                        }
                        s.setX((int)((double)owner.getX() - dx * -10.0));
                        s.setY((int)((double)owner.getY() - dy * -10.0));
                        s.setZ(owner.getZ() + 2048);
                        if (owner.getExtra() <= 0) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        ** GOTO lbl380
                    }
                    case 925: 
                    case 926: 
                    case 1007: 
                    case 1008: 
                    case 1009: 
                    case 1046: {
                        if ((Globals.global_random / (s.getLotag() + 1) & 31) > 4) {
                            s.setShade(-127);
                            break;
                        }
                        s.setShade(127);
                        break;
                    }
                    case 2296: 
                    case 2297: 
                    case 2298: 
                    case 2299: {
                        if (t[0] == 182) break;
                        s.setZ(s.getZ() + 16 + (Main.engine.krand() & 15));
                        t[0] = t[0] + 1;
                        if (t[0] % 9 != 0) break;
                        s.setYrepeat(s.getYrepeat() + 1);
                        break;
                    }
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: {
                        if (t[0] == 0) break;
                        spo = Main.boardService.getSprite(s.getOwner());
                        t[0] = t[0] + 1;
                        if (spo == null) break;
                        if (t[0] == 8) {
                            s.setPicnum(143);
                        } else if (t[0] == 16) {
                            s.setPicnum(144);
                            Globals.ps[spo.getYvel()].fist_incs = 1;
                        }
                        if (Globals.ps[spo.getYvel()].fist_incs != 26) break;
                        s.setPicnum(145);
                        break;
                    }
                    case 2590: {
                        spo = Main.boardService.getSprite(s.getOwner());
                        l = s.getXrepeat();
                        if (t[1] > 0) {
                            t[1] = t[1] - 1;
                            if (t[1] == 0) {
                                Main.engine.deletesprite(i);
                                break;
                            }
                        }
                        if (Globals.hittype[s.getOwner()].temp_data[1] == 0) {
                            if (t[0] < 64) {
                                t[0] = t[0] + 1;
                                l += 3;
                            }
                        } else if (t[0] > 64) {
                            t[0] = t[0] - 1;
                            l -= 3;
                        }
                        if (spo != null) {
                            s.setX(spo.getX());
                            s.setY(spo.getY());
                            s.setZ(spo.getZ());
                            s.setAng(s.getAng() + Globals.hittype[s.getOwner()].temp_data[0]);
                        }
                        if (l > 64) {
                            l = 64;
                        } else if (l < 1) {
                            l = 1;
                        }
                        s.setXrepeat((short)l);
                        s.setYrepeat((short)l);
                        s.setShade((byte)((l >> 1) - 48));
                        for (j = t[0]; j > 0; --j) {
                            Actors.ssp(i, 65537);
                        }
                        break;
                    }
                    case 1380: {
                        t[0] = t[0] + 1;
                        if (t[0] == 1) {
                            sec = Main.boardService.getSector(sect);
                            if (sec != null && sec.getLotag() != 1 && sec.getLotag() != 2) {
                                Main.engine.deletesprite(i);
                                break;
                            }
                            if (Globals.Sound[22].getSoundOwnerCount() == 0) {
                                Sounds.spritesound(22, i);
                            }
                        }
                        if (t[0] == 3) {
                            t[0] = 0;
                            t[1] = t[1] + 1;
                        }
                        if (t[1] != 5) break;
                        Main.engine.deletesprite(i);
                        break;
                    }
                    case 4095: {
                        spo = Main.boardService.getSprite(s.getOwner());
                        if (spo == null) break;
                        t[0] = t[0] + 1;
                        if (t[0] > 7) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (t[0] > 4) {
                            s.setCstat(s.getCstat() | 514);
                        } else if (t[0] > 2) {
                            s.setCstat(s.getCstat() | 2);
                        }
                        s.setXoffset(spo.getXoffset());
                        s.setYoffset(spo.getYoffset());
                        break;
                    }
                    case 1860: 
                    case 1861: {
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        if (x < 512) {
                            Globals.ps[p].pals_time = 32;
                            Globals.ps[p].pals[0] = 32;
                            Globals.ps[p].pals[1] = 0;
                            Globals.ps[p].pals[2] = 0;
                            Globals.ps[p].getPlayerSprite().setExtra(Globals.ps[p].getPlayerSprite().getExtra() - 4);
                        }
                    }
                    case 1625: {
                        if (s.getExtra() == 999) ** GOTO lbl154
                        s.setExtra(999);
                        ** GOTO lbl380
lbl154:
                        // 1 sources

                        Main.engine.deletesprite(i);
                        break;
                    }
                    case 1647: {
                        Main.engine.deletesprite(i);
                        break;
                    }
                    case 1234: 
                    case 4411: 
                    case 4461: {
                        z = Main.engine.getflorzofslope(s.getSectnum(), s.getX(), s.getY());
                        s.setZ(z);
                        Globals.hittype[i].floorz = z;
                        ** GOTO lbl380
                    }
                    case 1233: 
                    case 4410: 
                    case 4460: {
                        s.setXvel((short)((Main.engine.krand() & 7) + (EngineUtils.sin(Globals.hittype[i].temp_data[0] & 2047) >> 9)));
                        Globals.hittype[i].temp_data[0] = Globals.hittype[i].temp_data[0] + (Main.engine.krand() & 63);
                        if ((Globals.hittype[i].temp_data[0] & 2047) > 512 && (Globals.hittype[i].temp_data[0] & 2047) < 1596) {
                            sec = Main.boardService.getSector(sect);
                            if (sec != null && sec.getLotag() == 2) {
                                if (s.getZvel() < 64) {
                                    s.setZvel(s.getZvel() + (Globals.currentGame.getCON().gc >> 5) + (Main.engine.krand() & 7));
                                }
                            } else if (s.getZvel() < 144) {
                                s.setZvel(s.getZvel() + (Globals.currentGame.getCON().gc >> 5) + (Main.engine.krand() & 7));
                            }
                        }
                        Actors.ssp(i, 65537);
                        if ((Main.engine.krand() & 3) == 0) {
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                        }
                        if (s.getSectnum() == -1) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        l = Main.engine.getflorzofslope(s.getSectnum(), s.getX(), s.getY());
                        if (s.getZ() <= l) ** GOTO lbl380
                        s.setZ(l);
                        Actors.insertspriteq(i);
                        s.setPicnum(s.getPicnum() + 1);
                        for (node = Main.boardService.getStatNode(5); node != null; node = node.getNext()) {
                            sp = node.get();
                            if (sp.getPicnum() != 1226 || DSector.ldist(s, sp) >= 348) continue;
                            s.setPal(2);
                            ** GOTO lbl380
                        }
                        ** GOTO lbl380
                    }
                    case 1520: 
                    case 1528: 
                    case 1536: 
                    case 1768: 
                    case 1772: 
                    case 1776: 
                    case 2201: 
                    case 2205: 
                    case 2209: 
                    case 2245: 
                    case 2250: 
                    case 2255: 
                    case 2260: 
                    case 2265: 
                    case 2286: {
                        if (s.getXvel() > 0) {
                            s.setXvel(s.getXvel() - 1);
                        } else {
                            s.setXvel(0);
                        }
                        if (t[5] >= 300) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        t[5] = t[5] + 1;
                        if (s.getZvel() > 1024 && s.getZvel() < 1280) {
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            sect = s.getSectnum();
                        }
                        l = Main.engine.getflorzofslope(sect, s.getX(), s.getY());
                        x = Main.engine.getceilzofslope(sect, s.getX(), s.getY());
                        sec = Main.boardService.getSector(sect);
                        if (x == l || sec == null) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (s.getZ() < l - 512) {
                            if (t[1] < 2) {
                                t[1] = t[1] + 1;
                            } else if (sec.getLotag() != 2) {
                                t[1] = 0;
                                t[0] = s.getPicnum() == 1536 || s.getPicnum() == 1520 || s.getPicnum() == 1528 ? (t[0] > 6 ? 0 : t[0] + 1) : (t[0] > 2 ? 0 : t[0] + 1);
                            }
                            if (s.getZvel() < 6144) {
                                if (sec.getLotag() == 2) {
                                    if (s.getZvel() < 1024) {
                                        s.setZvel(s.getZvel() + 48);
                                    } else {
                                        s.setZvel(1024);
                                    }
                                } else {
                                    s.setZvel(s.getZvel() + Globals.currentGame.getCON().gc - 50);
                                }
                            }
                            s.setX(s.getX() + (s.getXvel() * EngineUtils.sin(s.getAng() + 512 & 2047) >> 14));
                            s.setY(s.getY() + (s.getXvel() * EngineUtils.sin(s.getAng() & 2047) >> 14));
                            s.setZ(s.getZ() + s.getZvel());
                            break;
                        }
                        if (t[2] == 0) {
                            if ((sec.getFloorstat() & 2) != 0) {
                                Main.engine.deletesprite(i);
                                break;
                            }
                            t[2] = t[2] + 1;
                        }
                        l = Main.engine.getflorzofslope(s.getSectnum(), s.getX(), s.getY());
                        s.setZ(l - 512);
                        s.setXvel(0);
                        if (s.getPicnum() == 2286) {
                            t[1] = t[1] + 1;
                            if ((t[1] & 3) == 0 && t[0] < 7) {
                                t[0] = t[0] + 1;
                            }
                            if (t[1] <= 20) break;
                            Main.engine.deletesprite(i);
                            break;
                        }
                        s.setPicnum(2286);
                        t[0] = 0;
                        t[1] = 0;
                        break;
                    }
                    case 1226: 
                    case 4389: {
                        sec = Main.boardService.getSector(sect);
                        if (t[0] == 0) {
                            t[0] = 1;
                            if (sec == null || (sec.getFloorstat() & 2) != 0) {
                                Main.engine.deletesprite(i);
                                break;
                            }
                            Actors.insertspriteq(i);
                        }
                        Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        s.setZ(Globals.hittype[i].floorz - 256);
                        if (t[2] < 32) {
                            t[2] = t[2] + 1;
                            if (Globals.hittype[i].picnum == 990) {
                                if (s.getXrepeat() < 64 && s.getYrepeat() < 64) {
                                    s.setXrepeat(s.getXrepeat() + (Main.engine.krand() & 3));
                                    s.setYrepeat(s.getYrepeat() + (Main.engine.krand() & 3));
                                }
                            } else if (s.getXrepeat() < 32 && s.getYrepeat() < 32) {
                                s.setXrepeat(s.getXrepeat() + (Main.engine.krand() & 3));
                                s.setYrepeat(s.getYrepeat() + (Main.engine.krand() & 3));
                            }
                        }
                        if (x < 844 && s.getXrepeat() > 6 && s.getYrepeat() > 6) {
                            if (s.getPal() == 0 && (Main.engine.krand() & 255) < 16 && s.getPicnum() != 4389) {
                                if (Globals.ps[p].boot_amount > 0) {
                                    Globals.ps[p].boot_amount = (short)(Globals.ps[p].boot_amount - 1);
                                } else {
                                    if (Globals.Sound[211].getSoundOwnerCount() < 1) {
                                        Sounds.spritesound(211, Globals.ps[p].i);
                                    }
                                    Globals.ps[p].getPlayerSprite().setExtra(Globals.ps[p].getPlayerSprite().getExtra() - 1);
                                    Globals.ps[p].pals_time = 32;
                                    Globals.ps[p].pals[0] = 16;
                                    Globals.ps[p].pals[1] = 0;
                                    Globals.ps[p].pals[2] = 0;
                                }
                            }
                            if (t[1] == 1) break;
                            t[1] = 1;
                            Globals.ps[p].footprintcount = Globals.hittype[i].picnum == 990 ? (short)10 : (short)3;
                            Globals.ps[p].footprintpal = s.getPal();
                            Globals.ps[p].footprintshade = s.getShade();
                            if (t[2] != 32) break;
                            s.setXrepeat(s.getXrepeat() - 6);
                            s.setYrepeat(s.getYrepeat() - 6);
                            break;
                        }
                        t[1] = 0;
                        break;
                    }
                    case 5152: 
                    case 5173: 
                    case 5207: 
                    case 5268: 
                    case 5304: {
                        if (Globals.currentGame.getCON().type != 20) break;
                    }
                    case 661: 
                    case 1261: 
                    case 1620: 
                    case 1630: 
                    case 1656: 
                    case 1671: 
                    case 1890: 
                    case 2200: 
                    case 2219: 
                    case 2270: 
                    case 2310: 
                    case 2329: 
                    case 2612: {
                        p = DSector.findplayer(s);
                        x = DSector.player_dist;
                        Gamedef.execute(Globals.currentGame.getCON(), i, p, x);
                        break;
                    }
                    case 2533: 
                    case 2535: {
                        Actors.ssp(i, 65537);
                        sec = Main.boardService.getSector(sect);
                        if (sec == null || sec.getFloorz() + 6144 < s.getZ()) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (sec.getLotag() == 2) {
                            t[1] = t[1] + 1;
                            if (t[1] > 8) {
                                t[1] = 0;
                                t[0] = t[0] + 1;
                                t[0] = t[0] & 3;
                            }
                            if (s.getZvel() < 128) {
                                s.setZvel(s.getZvel() + Globals.currentGame.getCON().gc / 13);
                            } else {
                                s.setZvel(s.getZvel() - 64);
                            }
                            if (s.getXvel() > 0) {
                                s.setXvel(s.getXvel() - 4);
                                break;
                            }
                            s.setXvel(0);
                            break;
                        }
                        t[1] = t[1] + 1;
                        if (t[1] > 3) {
                            t[1] = 0;
                            t[0] = t[0] + 1;
                            t[0] = t[0] & 3;
                        }
                        if (s.getZvel() < 512) {
                            s.setZvel(s.getZvel() + Globals.currentGame.getCON().gc / 3);
                        }
                        if (s.getXvel() > 0) {
                            s.setXvel(s.getXvel() - 1);
                            break;
                        }
                        Main.engine.deletesprite(i);
                        break;
                    }
                    case 1031: 
                    case 1032: 
                    case 1033: {
                        Gamedef.makeitfall(Globals.currentGame.getCON(), i);
                        sec = Main.boardService.getSector(sect);
                        if (s.getZvel() > 4096) {
                            s.setZvel(4096);
                        }
                        if (sec == null) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (s.getZ() == Globals.hittype[i].floorz - 256 && t[0] < 3) {
                            s.setZvel((short)(-(3 - t[0] << 8) - (Main.engine.krand() & 511)));
                            if (sec.getLotag() == 2) {
                                s.setZvel(s.getZvel() >> 1);
                            }
                            s.setXrepeat(s.getXrepeat() >> 1);
                            s.setYrepeat(s.getYrepeat() >> 1);
                            if (Gameutils.rnd(96)) {
                                Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            }
                            t[0] = t[0] + 1;
                        } else if (t[0] == 3) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        if (s.getXvel() > 0) {
                            s.setXvel(s.getXvel() - 2);
                            s.setCstat((short)((s.getXvel() & 3) << 2));
                        } else {
                            s.setXvel(0);
                        }
                        Actors.ssp(i, 65537);
                        break;
                    }
lbl380:
                    // 7 sources

                    default: {
                        if (!Gameutils.IFWITHIN(s, 2390, 2419)) break;
                        if (s.getXvel() > 0) {
                            s.setXvel(s.getXvel() - 1);
                        } else {
                            s.setXvel(0);
                        }
                        if (s.getZvel() > 1024 && s.getZvel() < 1280) {
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            sect = s.getSectnum();
                        }
                        if ((sec = Main.boardService.getSector(sect)) != null && s.getZ() < sec.getFloorz() - 512) {
                            if (t[1] < 1) {
                                t[1] = t[1] + 1;
                            } else {
                                t[1] = 0;
                                t[0] = s.getPicnum() < 2398 ? (t[0] > 6 ? 0 : t[0] + 1) : (t[0] > 2 ? 0 : t[0] + 1);
                            }
                            if (s.getZvel() < 4096) {
                                s.setZvel(s.getZvel() + Globals.currentGame.getCON().gc - 50);
                            }
                            s.setX(s.getX() + (s.getXvel() * EngineUtils.sin(s.getAng() + 512 & 2047) >> 14));
                            s.setY(s.getY() + (s.getXvel() * EngineUtils.sin(s.getAng() & 2047) >> 14));
                            s.setZ(s.getZ() + s.getZvel());
                            break;
                        }
                        if (s.getPicnum() == 2400 && s.getYvel() > 0) {
                            j = Spawn.spawn(i, s.getYvel());
                            Main.engine.setsprite(j, s.getX(), s.getY(), s.getZ());
                            Gamedef.getglobalz(j);
                            js = Main.boardService.getSprite(j);
                            if (js != null) {
                                js.setLotag(0);
                                js.setHitag(0);
                            }
                        }
                        Main.engine.deletesprite(i);
                    }
                }
            }
            ni = nexti;
        }
    }

    public static void moveeffectors() {
        Sector sc;
        Globals.fricyv = 0;
        Globals.fricxv = 0;
        ListNode<Sprite> ni = Main.boardService.getStatNode(3);
        while (ni != null) {
            ListNode<Sprite> nexti = ni.getNext();
            Sprite s = ni.get();
            int i = ni.getIndex();
            sc = Main.boardService.getSector(s.getSectnum());
            short st = s.getLotag();
            short sh = s.getHitag();
            int[] t = Globals.hittype[i].temp_data;
            block0 : switch (st) {
                case 0: {
                    int zchange = 0;
                    short j = s.getOwner();
                    Sprite js = Main.boardService.getSprite(j);
                    if (js == null || js.getLotag() == -1) {
                        Main.engine.deletesprite(i);
                        break;
                    }
                    if (sc == null) break;
                    int q = sc.getExtra() >> 3;
                    int l = 0;
                    if (sc.getLotag() == 30) {
                        q >>= 2;
                        if (s.getExtra() == 1) {
                            if (Globals.hittype[i].tempang < 256) {
                                Globals.hittype[i].tempang += 4;
                                if (Globals.hittype[i].tempang >= 256) {
                                    DSector.callsound(s.getSectnum(), i);
                                }
                                l = s.getClipdist() != 0 ? 1 : -1;
                            } else {
                                Globals.hittype[i].tempang = 256;
                            }
                            if (sc.getFloorz() > s.getZ()) {
                                Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                                sc.setFloorz(sc.getFloorz() - 512);
                                zchange = -512;
                                if (sc.getFloorz() < s.getZ()) {
                                    sc.setFloorz(s.getZ());
                                }
                            } else if (sc.getFloorz() < s.getZ()) {
                                Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                                sc.setFloorz(sc.getFloorz() + 512);
                                zchange = 512;
                                if (sc.getFloorz() > s.getZ()) {
                                    sc.setFloorz(s.getZ());
                                }
                            }
                        } else if (s.getExtra() == 3) {
                            if (Globals.hittype[i].tempang > 0) {
                                Globals.hittype[i].tempang -= 4;
                                if (Globals.hittype[i].tempang <= 0) {
                                    DSector.callsound(s.getSectnum(), i);
                                }
                                l = s.getClipdist() != 0 ? -1 : 1;
                            } else {
                                Globals.hittype[i].tempang = 0;
                            }
                            if (sc.getFloorz() > Globals.hittype[i].temp_data[3]) {
                                Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                                sc.setFloorz(sc.getFloorz() - 512);
                                zchange = -512;
                                if (sc.getFloorz() < Globals.hittype[i].temp_data[3]) {
                                    sc.setFloorz(Globals.hittype[i].temp_data[3]);
                                }
                            } else if (sc.getFloorz() < Globals.hittype[i].temp_data[3]) {
                                Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                                sc.setFloorz(sc.getFloorz() + 512);
                                zchange = 512;
                                if (sc.getFloorz() > Globals.hittype[i].temp_data[3]) {
                                    sc.setFloorz(Globals.hittype[i].temp_data[3]);
                                }
                            }
                        }
                    } else {
                        if (Globals.hittype[j].temp_data[0] == 0) break;
                        if (Globals.hittype[j].temp_data[0] == 2) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        l = js.getAng() > 1024 ? -1 : 1;
                        if (t[3] == 0) {
                            t[3] = DSector.ldist(s, js);
                        }
                        s.setXvel((short)t[3]);
                        s.setX(js.getX());
                        s.setY(js.getY());
                    }
                    s.setAng(s.getAng() + l * q);
                    t[2] = t[2] + l * q;
                    if (l != 0 && (sc.getFloorstat() & 0x40) != 0) {
                        short p = Mmulti.connecthead;
                        while (p >= 0) {
                            if (Globals.ps[p].cursectnum == s.getSectnum() && Globals.ps[p].on_ground) {
                                Globals.ps[p].ang += (float)(l * q);
                                Globals.ps[p].ang = ru.m210projects.Build.Gameutils.BClampAngle(Globals.ps[p].ang);
                                Globals.ps[p].posz += zchange;
                                Point rp = EngineUtils.rotatepoint(js.getX(), js.getY(), Globals.ps[p].posx, Globals.ps[p].posy, (short)(q * l));
                                int x = rp.getX();
                                int y = rp.getY();
                                Globals.ps[p].bobposx += x - Globals.ps[p].posx;
                                Globals.ps[p].bobposy += y - Globals.ps[p].posy;
                                Globals.ps[p].posx = x;
                                Globals.ps[p].posy = y;
                                Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
                                if (psp != null && psp.getExtra() <= 0) {
                                    psp.setX(x);
                                    psp.setY(y);
                                }
                            }
                            p = Mmulti.connectpoint2[p];
                        }
                        ListNode<Sprite> node = Main.boardService.getSectNode(s.getSectnum());
                        while (node != null) {
                            int p2 = node.getIndex();
                            Sprite sp = node.get();
                            if (sp.getStatnum() != 3 && sp.getStatnum() != 4 && sp.getPicnum() != 2567) {
                                if (sp.getPicnum() == 1405 && sp.getOwner() >= 0) {
                                    node = node.getNext();
                                    continue;
                                }
                                Main.game.pInt.setsprinterpolate(p2, sp);
                                sp.setAng(sp.getAng() + l * q);
                                sp.setAng(sp.getAng() & 0x7FF);
                                sp.setZ(sp.getZ() + zchange);
                                Point rp = EngineUtils.rotatepoint(js.getX(), js.getY(), sp.getX(), sp.getY(), (short)(q * l));
                                sp.setX(rp.getX());
                                sp.setY(rp.getY());
                            }
                            node = node.getNext();
                        }
                    }
                    Actors.ms(i);
                    break;
                }
                case 1: {
                    if (s.getOwner() != -1) break;
                    s.setOwner(i);
                    for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                        Sprite sp = node.get();
                        if (sp.getLotag() != 19 || sp.getHitag() != sh) continue;
                        t[0] = 0;
                        break block0;
                    }
                    break;
                }
                case 6: {
                    if (sc == null) break;
                    short k = sc.getExtra();
                    if (t[4] > 0) {
                        t[4] = t[4] - 1;
                        if (t[4] >= k - (k >> 3)) {
                            s.setXvel(s.getXvel() - (k >> 5));
                        }
                        if (t[4] > (k >> 1) - 1 && t[4] < k - (k >> 3)) {
                            s.setXvel(0);
                        }
                        if (t[4] < k >> 1) {
                            s.setXvel(s.getXvel() + (k >> 5));
                        }
                        if (t[4] < (k >> 1) - (k >> 3)) {
                            t[4] = 0;
                            s.setXvel(k);
                        }
                    } else {
                        s.setXvel(k);
                    }
                    for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                        Sprite sp = node.get();
                        int j = node.getIndex();
                        if (sp.getLotag() != 14 || sh != sp.getHitag() || Globals.hittype[j].temp_data[0] != t[0]) continue;
                        sp.setXvel(s.getXvel());
                        if (Globals.hittype[j].temp_data[5] == 0) {
                            Globals.hittype[j].temp_data[5] = DSector.dist(sp, s);
                        }
                        int x = Gameutils.sgn(DSector.dist(sp, s) - Globals.hittype[j].temp_data[5]);
                        if (sp.getExtra() != 0) {
                            x = -x;
                        }
                        s.setXvel(s.getXvel() + x);
                        Globals.hittype[j].temp_data[4] = t[4];
                    }
                }
                case 14: {
                    int k;
                    Sprite spo;
                    ListNode<Sprite> node;
                    int j;
                    if (s.getOwner() == -1) {
                        s.setOwner((short)Actors.LocateTheLocator((short)t[3], (short)t[0]));
                    }
                    if (s.getOwner() == -1) {
                        throw new AssertException("Could not find any locators for SE# 6 and 14 with a hitag of " + t[3]);
                    }
                    Sprite so = Main.boardService.getSprite(s.getOwner());
                    int n = j = so != null ? DSector.ldist(so, s) : 0;
                    if (j < 1024) {
                        if (st == 6 && so != null && (so.getHitag() & 1) != 0) {
                            t[4] = sc.getExtra();
                        }
                        t[3] = t[3] + 1;
                        s.setOwner((short)Actors.LocateTheLocator(t[3], t[0]));
                        if (s.getOwner() == -1) {
                            t[3] = 0;
                            s.setOwner((short)Actors.LocateTheLocator(0, t[0]));
                        }
                    }
                    if (sc == null || s.getXvel() == 0) break;
                    so = Main.boardService.getSprite(s.getOwner());
                    int x = so != null ? EngineUtils.getAngle(so.getX() - s.getX(), so.getY() - s.getY()) : s.getAng();
                    int q = Gamedef.getincangle(s.getAng(), x) >> 3;
                    t[2] = t[2] + q;
                    s.setAng(s.getAng() + q);
                    if (s.getXvel() == sc.getExtra()) {
                        if ((sc.getFloorstat() & 1) == 0 && (sc.getCeilingstat() & 1) == 0) {
                            if (Globals.Sound[Globals.hittype[i].lastvx].getSoundOwnerCount() == 0) {
                                Sounds.spritesound(Globals.hittype[i].lastvx, i);
                            }
                        } else if (!Globals.ud.monsters_off && sc.getFloorpal() == 0 && (sc.getFloorstat() & 1) != 0 && Gameutils.rnd(8)) {
                            int p = DSector.findplayer(s);
                            x = DSector.player_dist;
                            if (x < 20480) {
                                short oldAng = s.getAng();
                                s.setAng(EngineUtils.getAngle(s.getX() - Globals.ps[p].posx, s.getY() - Globals.ps[p].posy));
                                Weapons.shoot(i, 2605);
                                s.setAng(oldAng);
                            }
                        }
                    }
                    if (s.getXvel() <= 64 && (sc.getFloorstat() & 1) == 0 && (sc.getCeilingstat() & 1) == 0) {
                        Sounds.stopsound(Globals.hittype[i].lastvx, i);
                    }
                    if (sc.getFloorz() - sc.getCeilingz() < 27648 && !Globals.ud.clipping && s.getXvel() >= 192) {
                        short p = Mmulti.connecthead;
                        while (p >= 0) {
                            Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
                            if (psp != null && psp.getExtra() > 0) {
                                int k2 = Globals.ps[p].cursectnum;
                                if ((k2 = Main.engine.updatesector(Globals.ps[p].posx, Globals.ps[p].posy, k2)) == -1 && !Globals.ud.clipping || k2 == s.getSectnum() && Globals.ps[p].cursectnum != s.getSectnum()) {
                                    Globals.ps[p].posx = s.getX();
                                    Globals.ps[p].posy = s.getY();
                                    Globals.ps[p].cursectnum = s.getSectnum();
                                    System.err.println("aa?");
                                    Main.engine.setsprite(Globals.ps[p].i, s.getX(), s.getY(), s.getZ());
                                    Player.quickkill(Globals.ps[p]);
                                }
                            }
                            p = Mmulti.connectpoint2[p];
                        }
                    }
                    int m = s.getXvel() * EngineUtils.cos(s.getAng() & 0x7FF) >> 14;
                    x = s.getXvel() * EngineUtils.sin(s.getAng() & 0x7FF) >> 14;
                    short p = Mmulti.connecthead;
                    while (p >= 0) {
                        Sector psec = Main.boardService.getSector(Globals.ps[p].cursectnum);
                        if (psec != null && psec.getLotag() != 2) {
                            Sprite psp;
                            if (Globals.po[p].os == s.getSectnum()) {
                                Globals.po[p].ox += m;
                                Globals.po[p].oy += x;
                            }
                            if ((psp = Main.boardService.getSprite(Globals.ps[p].i)) != null && s.getSectnum() == psp.getSectnum()) {
                                Point out = EngineUtils.rotatepoint(s.getX(), s.getY(), Globals.ps[p].posx, Globals.ps[p].posy, (short)q);
                                Globals.ps[p].posx = out.getX();
                                Globals.ps[p].posy = out.getY();
                                Globals.ps[p].posx += m;
                                Globals.ps[p].posy += x;
                                Globals.ps[p].bobposx += m;
                                Globals.ps[p].bobposy += x;
                                Globals.ps[p].ang += (float)q;
                                Globals.ps[p].ang = ru.m210projects.Build.Gameutils.BClampAngle(Globals.ps[p].ang);
                                if (psp.getExtra() <= 0) {
                                    Globals.ps[p].getPlayerSprite().setX(Globals.ps[p].posx);
                                    Globals.ps[p].getPlayerSprite().setY(Globals.ps[p].posy);
                                }
                            }
                        }
                        p = Mmulti.connectpoint2[p];
                    }
                    for (node = Main.boardService.getSectNode(s.getSectnum()); node != null; node = node.getNext()) {
                        Sprite sp = node.get();
                        Sector sec = Main.boardService.getSector(sp.getSectnum());
                        if (sec == null || sp.getStatnum() == 10 || sec.getLotag() == 2 || sp.getPicnum() == 1 || sp.getPicnum() == 6) continue;
                        Point rp = EngineUtils.rotatepoint(s.getX(), s.getY(), sp.getX(), sp.getY(), (short)q);
                        Main.game.pInt.setsprinterpolate(node.getIndex(), sp);
                        sp.setX(rp.getX());
                        sp.setY(rp.getY());
                        sp.setX(sp.getX() + m);
                        sp.setY(sp.getY() + x);
                        sp.setAng(sp.getAng() + q);
                    }
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    if (sc.getFloorz() - sc.getCeilingz() >= 27648) break;
                    if (!Globals.ud.clipping && s.getXvel() >= 192) {
                        short p3 = Mmulti.connecthead;
                        while (p3 >= 0) {
                            Sprite psp = Main.boardService.getSprite(Globals.ps[p3].i);
                            if (psp != null && psp.getExtra() > 0) {
                                int k3 = Globals.ps[p3].cursectnum;
                                if ((k3 = Main.engine.updatesector(Globals.ps[p3].posx, Globals.ps[p3].posy, k3)) == -1 && !Globals.ud.clipping || k3 == s.getSectnum() && Globals.ps[p3].cursectnum != s.getSectnum()) {
                                    Globals.ps[p3].oposx = Globals.ps[p3].posx = s.getX();
                                    Globals.ps[p3].oposy = Globals.ps[p3].posy = s.getY();
                                    Globals.ps[p3].cursectnum = s.getSectnum();
                                    System.err.println("aaa?");
                                    Main.engine.setsprite(Globals.ps[p3].i, s.getX(), s.getY(), s.getZ());
                                    Player.quickkill(Globals.ps[p3]);
                                }
                            }
                            p3 = Mmulti.connectpoint2[p3];
                        }
                    }
                    if ((spo = Main.boardService.getSprite(s.getOwner())) == null) break;
                    node = Main.boardService.getSectNode(spo.getSectnum());
                    while (node != null) {
                        ListNode<Sprite> next = node.getNext();
                        Sprite sp = node.get();
                        if (sp.getStatnum() == 1 && Actors.badguy(sp) && sp.getPicnum() != 1 && sp.getPicnum() != 6) {
                            k = sp.getSectnum();
                            k = Main.engine.updatesector(sp.getX(), sp.getY(), k);
                            if (sp.getExtra() >= 0 && k == s.getSectnum()) {
                                Spawn.gutsdir(sp, 2286, 72, Mmulti.myconnectindex);
                                Sounds.spritesound(69, i);
                                Main.engine.deletesprite(node.getIndex());
                            }
                        }
                        node = next;
                    }
                    break;
                }
                case 30: {
                    ListNode<Sprite> nj;
                    Sprite spo = Main.boardService.getSprite(s.getOwner());
                    if (spo == null) {
                        t[3] = t[3] ^ 1;
                        s.setOwner((short)Actors.LocateTheLocator(t[3], t[0]));
                    } else {
                        if (t[4] == 1) {
                            if (DSector.ldist(spo, s) < 1920) {
                                t[4] = 2;
                            } else {
                                if (s.getXvel() == 0) {
                                    DSector.operateactivators(s.getHitag() + (t[3] == 0 ? (short)1 : 0), -1);
                                }
                                if (s.getXvel() < 256) {
                                    s.setXvel(s.getXvel() + 16);
                                }
                            }
                        }
                        if (t[4] == 2) {
                            int l = Gameutils.FindDistance2D(spo.getX() - s.getX(), spo.getY() - s.getY());
                            if (l <= 128) {
                                s.setXvel(0);
                            }
                            if (s.getXvel() > 0) {
                                s.setXvel(s.getXvel() - 16);
                            } else {
                                s.setXvel(0);
                                DSector.operateactivators(s.getHitag() + (short)t[3], -1);
                                s.setOwner(-1);
                                s.setAng(s.getAng() + 1024);
                                t[4] = 0;
                                DSector.operateforcefields(i, s.getHitag());
                                for (ListNode<Sprite> node = Main.boardService.getSectNode(s.getSectnum()); node != null; node = node.getNext()) {
                                    Sprite sp = node.get();
                                    if (sp.getPicnum() == 1 || sp.getPicnum() == 6) continue;
                                    Main.game.pInt.setsprinterpolate(node.getIndex(), sp);
                                }
                            }
                        }
                    }
                    if (s.getXvel() == 0) break;
                    int l = s.getXvel() * EngineUtils.cos(s.getAng() & 0x7FF) >> 14;
                    int x = s.getXvel() * EngineUtils.sin(s.getAng() & 0x7FF) >> 14;
                    if (sc != null && sc.getFloorz() - sc.getCeilingz() < 27648 && !Globals.ud.clipping) {
                        short p = Mmulti.connecthead;
                        while (p >= 0) {
                            Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
                            if (psp != null && psp.getExtra() > 0) {
                                int k = Globals.ps[p].cursectnum;
                                if ((k = Main.engine.updatesector(Globals.ps[p].posx, Globals.ps[p].posy, k)) == -1 && !Globals.ud.clipping || k == s.getSectnum() && Globals.ps[p].cursectnum != s.getSectnum()) {
                                    Globals.ps[p].posx = s.getX();
                                    Globals.ps[p].posy = s.getY();
                                    Globals.ps[p].cursectnum = s.getSectnum();
                                    System.err.println("aaaa?");
                                    Main.engine.setsprite(Globals.ps[p].i, s.getX(), s.getY(), s.getZ());
                                    Player.quickkill(Globals.ps[p]);
                                }
                            }
                            p = Mmulti.connectpoint2[p];
                        }
                    }
                    short p = Mmulti.connecthead;
                    while (p >= 0) {
                        Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
                        if (psp != null && psp.getSectnum() == s.getSectnum()) {
                            Globals.ps[p].posx += l;
                            Globals.ps[p].posy += x;
                            Globals.ps[p].bobposx += l;
                            Globals.ps[p].bobposy += x;
                        }
                        if (Globals.po[p].os == s.getSectnum()) {
                            Globals.po[p].ox += l;
                            Globals.po[p].oy += x;
                        }
                        p = Mmulti.connectpoint2[p];
                    }
                    for (nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                        Sprite sp = nj.get();
                        if (sp.getPicnum() == 1 || sp.getPicnum() == 6) continue;
                        Main.game.pInt.setsprinterpolate(nj.getIndex(), sp);
                        sp.setX(sp.getX() + l);
                        sp.setY(sp.getY() + x);
                    }
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    if (sc == null || sc.getFloorz() - sc.getCeilingz() >= 27648) break;
                    if (!Globals.ud.clipping) {
                        short p4 = Mmulti.connecthead;
                        while (p4 >= 0) {
                            Sprite psp = Main.boardService.getSprite(Globals.ps[p4].i);
                            if (psp != null && psp.getExtra() > 0) {
                                int k = Globals.ps[p4].cursectnum;
                                if ((k = Main.engine.updatesector(Globals.ps[p4].posx, Globals.ps[p4].posy, k)) == -1 && !Globals.ud.clipping || k == s.getSectnum() && Globals.ps[p4].cursectnum != s.getSectnum()) {
                                    Globals.ps[p4].posx = s.getX();
                                    Globals.ps[p4].posy = s.getY();
                                    Globals.ps[p4].oposx = Globals.ps[p4].posx;
                                    Globals.ps[p4].oposy = Globals.ps[p4].posy;
                                    Globals.ps[p4].cursectnum = s.getSectnum();
                                    System.err.println("aaaaa?");
                                    Main.engine.setsprite(Globals.ps[p4].i, s.getX(), s.getY(), s.getZ());
                                    Player.quickkill(Globals.ps[p4]);
                                }
                            }
                            p4 = Mmulti.connectpoint2[p4];
                        }
                    }
                    if ((spo = Main.boardService.getSprite(s.getOwner())) == null) break;
                    nj = Main.boardService.getSectNode(spo.getSectnum());
                    while (nj != null) {
                        ListNode<Sprite> nl = nj.getNext();
                        Sprite sp = nj.get();
                        if (sp.getStatnum() == 1 && Actors.badguy(sp) && sp.getPicnum() != 1 && sp.getPicnum() != 6) {
                            int k = sp.getSectnum();
                            k = Main.engine.updatesector(sp.getX(), sp.getY(), k);
                            if (sp.getExtra() >= 0 && k == s.getSectnum()) {
                                Spawn.gutsdir(sp, 2286, 24, Mmulti.myconnectindex);
                                Sounds.spritesound(69, nj.getIndex());
                                Main.engine.deletesprite(nj.getIndex());
                            }
                        }
                        nj = nl;
                    }
                    break;
                }
                case 2: {
                    if (t[4] > 0 && t[0] == 0) {
                        if (t[4] < sh) {
                            t[4] = t[4] + 1;
                        } else {
                            t[0] = 1;
                        }
                    }
                    if (t[0] <= 0) break;
                    t[0] = t[0] + 1;
                    s.setXvel(3);
                    if (t[0] > 96) {
                        t[0] = -1;
                        t[4] = -1;
                        Main.engine.deletesprite(i);
                        break;
                    }
                    if ((t[0] & 0x1F) == 8) {
                        Globals.earthquaketime = (short)48;
                        Sounds.spritesound(81, Globals.ps[Globals.screenpeek].i);
                    }
                    if (sc != null) {
                        if (Pragmas.klabs(sc.getFloorheinum() - t[5]) < 8) {
                            sc.setFloorheinum((short)t[5]);
                        } else {
                            sc.setFloorheinum(sc.getFloorheinum() + (Gameutils.sgn(t[5] - sc.getFloorheinum()) << 4));
                        }
                    }
                    int m = s.getXvel() * EngineUtils.sin(s.getAng() + 512 & 0x7FF) >> 14;
                    int x = s.getXvel() * EngineUtils.sin(s.getAng() & 0x7FF) >> 14;
                    short p = Mmulti.connecthead;
                    while (p >= 0) {
                        if (Globals.ps[p].cursectnum == s.getSectnum() && Globals.ps[p].on_ground) {
                            Globals.ps[p].posx += m;
                            Globals.ps[p].posy += x;
                            Globals.ps[p].bobposx += m;
                            Globals.ps[p].bobposy += x;
                        }
                        p = Mmulti.connectpoint2[p];
                    }
                    ListNode<Sprite> nj = Main.boardService.getSectNode(s.getSectnum());
                    while (nj != null) {
                        ListNode<Sprite> nextj = nj.getNext();
                        Sprite sp = nj.get();
                        int j = nj.getIndex();
                        if (sp.getPicnum() != 1) {
                            Main.game.pInt.setsprinterpolate(j, sp);
                            sp.setX(sp.getX() + m);
                            sp.setY(sp.getY() + x);
                            Main.engine.setsprite((short)j, sp.getX(), sp.getY(), sp.getZ());
                        }
                        nj = nextj;
                    }
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    break;
                }
                case 3: {
                    if (sc == null || t[4] == 0) break;
                    if ((Globals.global_random / (sh + 1) & 0x1F) < 4 && t[2] == 0) {
                        sc.setCeilingpal((short)(s.getOwner() >> 8));
                        sc.setFloorpal((short)(s.getOwner() & 0xFF));
                        t[0] = s.getShade() + (Globals.global_random & 0xF);
                    } else {
                        sc.setCeilingpal(s.getPal());
                        sc.setFloorpal(s.getPal());
                        t[0] = t[3];
                    }
                    sc.setCeilingshade((byte)t[0]);
                    sc.setFloorshade((byte)t[0]);
                    for (ListNode<Wall> wn = sc.getWallNode(); wn != null; wn = wn.getNext()) {
                        Wall wal = wn.get();
                        if (wal.getHitag() == 1) continue;
                        wal.setShade(t[0]);
                        Wall nw = Main.boardService.getWall(wal.getNextwall());
                        if ((wal.getCstat() & 2) == 0 || nw == null) continue;
                        nw.setShade(wal.getShade());
                    }
                    break;
                }
                case 4: {
                    if (sc == null) break;
                    boolean j = false;
                    if ((Globals.global_random / (sh + 1) & 0x1F) < 4) {
                        t[1] = s.getShade() + (Globals.global_random & 0xF);
                        t[0] = s.getShade() + (Globals.global_random & 0xF);
                        sc.setCeilingpal((short)(s.getOwner() >> 8));
                        sc.setFloorpal((short)(s.getOwner() & 0xFF));
                        j = true;
                    } else {
                        t[1] = t[2];
                        t[0] = t[3];
                        sc.setCeilingpal(s.getPal());
                        sc.setFloorpal(s.getPal());
                    }
                    sc.setFloorshade((byte)t[1]);
                    sc.setCeilingshade((byte)t[1]);
                    for (ListNode<Wall> wn = sc.getWallNode(); wn != null; wn = wn.getNext()) {
                        Wall wal = wn.get();
                        if (j) {
                            wal.setPal((short)(s.getOwner() & 0xFF));
                        } else {
                            wal.setPal(s.getPal());
                        }
                        if (wal.getHitag() == 1) continue;
                        wal.setShade((byte)t[0]);
                        Wall nw = Main.boardService.getWall(wal.getNextwall());
                        if ((wal.getCstat() & 2) == 0 || nw == null) continue;
                        nw.setShade(wal.getShade());
                    }
                    for (ListNode<Sprite> nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                        Sprite sp = nj.get();
                        if ((sp.getCstat() & 0x10) == 0) continue;
                        if ((sc.getCeilingstat() & 1) != 0) {
                            sp.setShade(sc.getCeilingshade());
                            continue;
                        }
                        sp.setShade(sc.getFloorshade());
                    }
                    if (t[4] == 0) break;
                    Main.engine.deletesprite(i);
                    break;
                }
                case 5: {
                    int p = DSector.findplayer(s);
                    int x = DSector.player_dist;
                    if (x < 8192) {
                        short olda = s.getAng();
                        s.setAng(EngineUtils.getAngle(s.getX() - Globals.ps[p].posx, s.getY() - Globals.ps[p].posy));
                        Weapons.shoot(i, 1625);
                        s.setAng(olda);
                    }
                    if (s.getOwner() == -1) {
                        int q = 0;
                        t[4] = 0;
                        int l = Integer.MAX_VALUE;
                        while (true) {
                            int m;
                            s.setOwner((short)Actors.LocateTheLocator((short)t[4], -1));
                            if (s.getOwner() == -1) break;
                            Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
                            Sprite spo = Main.boardService.getSprite(s.getOwner());
                            if (psp != null && spo != null && l > (m = DSector.ldist(psp, spo))) {
                                q = s.getOwner();
                                l = m;
                            }
                            t[4] = t[4] + 1;
                        }
                        Sprite qs = Main.boardService.getSprite(q);
                        if (qs != null) {
                            s.setOwner(q);
                            s.setZvel(Pragmas.ksgn(qs.getZ() - s.getZ()) << 4);
                        }
                    }
                    if (sc == null) break;
                    Sprite spo = Main.boardService.getSprite(s.getOwner());
                    if (spo != null) {
                        if (DSector.ldist(spo, s) < 1024) {
                            short ta = s.getAng();
                            s.setAng(EngineUtils.getAngle(Globals.ps[p].posx - s.getX(), Globals.ps[p].posy - s.getY()));
                            s.setAng(ta);
                            s.setOwner(-1);
                            break;
                        }
                        s.setXvel(256);
                        x = EngineUtils.getAngle(spo.getX() - s.getX(), spo.getY() - s.getY());
                        int q = Gamedef.getincangle(s.getAng(), x) >> 3;
                        s.setAng(s.getAng() + q);
                        if (Gameutils.rnd(32)) {
                            t[2] = t[2] + q;
                            sc.setCeilingshade(127);
                        } else {
                            t[2] = t[2] + (Gamedef.getincangle(t[2] + 512, EngineUtils.getAngle(Globals.ps[p].posx - s.getX(), Globals.ps[p].posy - s.getY())) >> 2);
                            sc.setCeilingshade(0);
                        }
                    }
                    if (Actors.ifhitbyweapon(i) >= 0) {
                        t[3] = t[3] + 1;
                        if (t[3] == 5) {
                            s.setZvel(s.getZvel() + 1024);
                            View.FTA(7, Globals.ps[Mmulti.myconnectindex]);
                        }
                    }
                    s.setZ(s.getZ() + s.getZvel());
                    Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                    sc.setCeilingz(sc.getCeilingz() + s.getZvel());
                    Sector tsec = Main.boardService.getSector(t[0]);
                    if (tsec != null) {
                        Main.game.pInt.setceilinterpolate(t[0], tsec);
                        tsec.setCeilingz(tsec.getCeilingz() + s.getZvel());
                    }
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    break;
                }
                case 8: 
                case 9: {
                    int j;
                    if (Globals.hittype[i].temp_data[4] != 0) {
                        Globals.hittype[i].temp_data[4] = Globals.hittype[i].temp_data[4] + 1;
                        if (Globals.hittype[i].temp_data[4] > 8) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        j = 1;
                    } else {
                        j = Animate.getanimationgoal(sc, 8);
                    }
                    if (j < 0) break;
                    int x = sc != null && (sc.getLotag() & 0x8000) != 0 || Globals.hittype[i].temp_data[4] != 0 ? -t[3] : t[3];
                    if (st == 9) {
                        x = -x;
                    }
                    for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                        Sprite sp = node.get();
                        j = node.getIndex();
                        if (sp.getLotag() != st || sp.getHitag() != sh) continue;
                        short sn = sp.getSectnum();
                        Sector sec = Main.boardService.getSector(sn);
                        byte m = sp.getShade();
                        if (sec == null) continue;
                        for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                            Wall wal = wn.get();
                            if (wal.getHitag() == 1) continue;
                            wal.setShade(wal.getShade() + x);
                            if (wal.getShade() < m) {
                                wal.setShade(m);
                            } else if (wal.getShade() > Globals.hittype[j].temp_data[2]) {
                                wal.setShade((byte)Globals.hittype[j].temp_data[2]);
                            }
                            Wall nwal = Main.boardService.getWall(wal.getNextwall());
                            if (nwal == null || nwal.getHitag() == 1) continue;
                            nwal.setShade(wal.getShade());
                        }
                        sec.setFloorshade(sec.getFloorshade() + x);
                        sec.setCeilingshade(sec.getCeilingshade() + x);
                        if (sec.getFloorshade() < m) {
                            sec.setFloorshade(m);
                        } else if (sec.getFloorshade() > Globals.hittype[j].temp_data[0]) {
                            sec.setFloorshade((byte)Globals.hittype[j].temp_data[0]);
                        }
                        if (sec.getCeilingshade() < m) {
                            sec.setCeilingshade(m);
                            continue;
                        }
                        if (sec.getCeilingshade() <= Globals.hittype[j].temp_data[1]) continue;
                        sec.setCeilingshade((byte)Globals.hittype[j].temp_data[1]);
                    }
                    break;
                }
                case 10: {
                    if (sc == null) break;
                    if ((sc.getLotag() & 0xFF) == 27 || sc.getFloorz() > sc.getCeilingz() && (sc.getLotag() & 0xFF) != 23 || sc.getLotag() == -32745) {
                        boolean j = true;
                        if ((sc.getLotag() & 0xFF) != 27) {
                            short p = Mmulti.connecthead;
                            while (p >= 0) {
                                Sprite psp;
                                if (sc.getLotag() != 30 && sc.getLotag() != 31 && sc.getLotag() != 0 && (psp = Main.boardService.getSprite(Globals.ps[p].i)) != null && s.getSectnum() == psp.getSectnum()) {
                                    j = false;
                                }
                                p = Mmulti.connectpoint2[p];
                            }
                        }
                        if (!j) break;
                        if (t[0] > sh) {
                            switch (sc.getLotag()) {
                                case 20: 
                                case 21: 
                                case 22: 
                                case 26: {
                                    if (Animate.getanimationgoal(sc, 8) >= 0) break;
                                }
                                default: {
                                    DSector.activatebysector(s.getSectnum(), i);
                                    t[0] = 0;
                                    break;
                                }
                            }
                            break;
                        }
                        t[0] = t[0] + 1;
                        break;
                    }
                    t[0] = 0;
                    break;
                }
                case 11: {
                    if (t[5] > 0) {
                        t[5] = t[5] - 1;
                        break;
                    }
                    if (sc == null || t[4] == 0) break;
                    for (ListNode<Wall> wn = sc.getWallNode(); wn != null; wn = wn.getNext()) {
                        Sprite sp;
                        ListNode<Sprite> node;
                        int j = wn.getIndex();
                        for (node = Main.boardService.getStatNode(1); node != null; node = node.getNext()) {
                            sp = node.get();
                            if (sp.getExtra() > 0 && Actors.badguy(sp) && Main.engine.clipinsidebox(sp.getX(), sp.getY(), j, 256) == 1) break block0;
                        }
                        for (node = Main.boardService.getStatNode(10); node != null; node = node.getNext()) {
                            sp = node.get();
                            if (sp.getOwner() < 0 || Main.engine.clipinsidebox(sp.getX(), sp.getY(), j, 144) != 1) continue;
                            t[5] = 8;
                            short k = (short)((s.getYvel() >> 3) * t[3]);
                            t[2] = t[2] - k;
                            t[4] = t[4] - k;
                            Actors.ms(i);
                            Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                            break block0;
                        }
                    }
                    short k = (short)((s.getYvel() >> 3) * t[3]);
                    t[2] = t[2] + k;
                    t[4] = t[4] + k;
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    if (t[4] > -511 && t[4] < 512) break;
                    t[4] = 0;
                    t[2] = t[2] & 0xFFFFFF00;
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    break;
                }
                case 12: {
                    if (sc == null) break;
                    if (t[0] == 3 || t[3] == 1) {
                        sc.setFloorpal(0);
                        sc.setCeilingpal(0);
                        for (ListNode<Wall> wn = sc.getWallNode(); wn != null; wn = wn.getNext()) {
                            Wall wal = wn.get();
                            if (wal.getHitag() == 1) continue;
                            wal.setShade((byte)t[1]);
                            wal.setPal(0);
                        }
                        sc.setFloorshade((byte)t[1]);
                        sc.setCeilingshade((byte)t[2]);
                        t[0] = 0;
                        for (ListNode<Sprite> node = Main.boardService.getSectNode(s.getSectnum()); node != null; node = node.getNext()) {
                            Sprite sp = node.get();
                            if ((sp.getCstat() & 0x10) == 0) continue;
                            if ((sc.getCeilingstat() & 1) != 0) {
                                sp.setShade(sc.getCeilingshade());
                                continue;
                            }
                            sp.setShade(sc.getFloorshade());
                        }
                        if (t[3] == 1) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                    }
                    if (t[0] != 1) break;
                    if (sc.getFloorshade() > s.getShade()) {
                        sc.setFloorpal(s.getPal());
                        sc.setCeilingpal(s.getPal());
                        sc.setFloorshade(sc.getFloorshade() - 2);
                        sc.setCeilingshade(sc.getCeilingshade() - 2);
                        for (ListNode<Wall> wn = sc.getWallNode(); wn != null; wn = wn.getNext()) {
                            Wall wal = wn.get();
                            if (wal.getHitag() == 1) continue;
                            wal.setPal(s.getPal());
                            wal.setShade(wal.getShade() - 2);
                        }
                    } else {
                        t[0] = 2;
                    }
                    for (ListNode<Sprite> node = Main.boardService.getSectNode(s.getSectnum()); node != null; node = node.getNext()) {
                        Sprite sp = node.get();
                        if ((sp.getCstat() & 0x10) == 0) continue;
                        if ((sc.getCeilingstat() & 1) != 0) {
                            sp.setShade(sc.getCeilingshade());
                            continue;
                        }
                        sp.setShade(sc.getFloorshade());
                    }
                    break;
                }
                case 13: {
                    if (sc != null && t[2] != 0) {
                        int j = s.getYvel() << 5 | 1;
                        if (s.getAng() == 512) {
                            if (s.getOwner() != 0) {
                                Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                                if (Pragmas.klabs(t[0] - sc.getCeilingz()) >= j) {
                                    sc.setCeilingz(sc.getCeilingz() + Gameutils.sgn(t[0] - sc.getCeilingz()) * j);
                                } else {
                                    sc.setCeilingz(t[0]);
                                }
                            } else {
                                Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                                if (Pragmas.klabs(t[1] - sc.getFloorz()) >= j) {
                                    sc.setFloorz(sc.getFloorz() + Gameutils.sgn(t[1] - sc.getFloorz()) * j);
                                } else {
                                    sc.setFloorz(t[1]);
                                }
                            }
                        } else {
                            Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                            Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                            if (Pragmas.klabs(t[1] - sc.getFloorz()) >= j) {
                                sc.setFloorz(sc.getFloorz() + Gameutils.sgn(t[1] - sc.getFloorz()) * j);
                            } else {
                                sc.setFloorz(t[1]);
                            }
                            if (Pragmas.klabs(t[0] - sc.getCeilingz()) >= j) {
                                sc.setCeilingz(sc.getCeilingz() + Gameutils.sgn(t[0] - sc.getCeilingz()) * j);
                            }
                            sc.setCeilingz(t[0]);
                        }
                        if (t[3] == 1) {
                            t[3] = t[3] + 1;
                            sc.setCeilingstat(sc.getCeilingstat() ^ 1);
                            if (s.getAng() == 512) {
                                for (ListNode<Wall> wn = sc.getWallNode(); wn != null; wn = wn.getNext()) {
                                    Wall wal = wn.get();
                                    wal.setShade(s.getShade());
                                }
                                sc.setFloorshade(s.getShade());
                                Sector sec = Main.boardService.getSector(Globals.ps[Mmulti.connecthead].one_parallax_sectnum);
                                if (sec != null) {
                                    sc.setCeilingpicnum(sec.getCeilingpicnum());
                                    sc.setCeilingshade(sec.getCeilingshade());
                                }
                            }
                        }
                        t[2] = t[2] + 1;
                        if (t[2] > 256) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                    }
                    if (t[2] != 4 || s.getAng() == 512) break;
                    for (int x = 0; x < 7; ++x) {
                        Gameutils.RANDOMSCRAP(s, i);
                    }
                    break;
                }
                case 15: {
                    if (t[4] == 0) break;
                    s.setXvel(16);
                    if (t[4] == 1) {
                        if (t[3] >= s.getYvel() >> 3) {
                            t[4] = 0;
                            DSector.callsound(s.getSectnum(), i);
                            break;
                        }
                        t[3] = t[3] + 1;
                    } else if (t[4] == 2) {
                        if (t[3] < 1) {
                            t[4] = 0;
                            DSector.callsound(s.getSectnum(), i);
                            break;
                        }
                        t[3] = t[3] - 1;
                    }
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    break;
                }
                case 16: {
                    if (sc == null) break;
                    t[2] = t[2] + 32;
                    if (sc.getFloorz() < sc.getCeilingz()) {
                        s.setShade(0);
                    } else if (sc.getCeilingz() < t[3]) {
                        Sprite sp;
                        ListNode<Sprite> nj;
                        for (nj = Main.boardService.getSectNode(s.getSectnum()); nj != null && (sp = nj.get()).getPicnum() != 1088 && sp.getPicnum() != 578; nj = nj.getNext()) {
                        }
                        if (nj == null) {
                            Main.engine.deletesprite(i);
                            break;
                        }
                        s.setShade(1);
                    }
                    Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                    if (s.getShade() != 0) {
                        sc.setCeilingz(sc.getCeilingz() + 1024);
                    } else {
                        sc.setCeilingz(sc.getCeilingz() - 512);
                    }
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    break;
                }
                case 17: {
                    Sector jsec;
                    Sprite sprite;
                    ListNode<Sprite> node;
                    int k;
                    if (sc == null) break;
                    int q = t[0] * (s.getYvel() << 2);
                    Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                    Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                    sc.setCeilingz(sc.getCeilingz() + q);
                    sc.setFloorz(sc.getFloorz() + q);
                    for (ListNode<Sprite> nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                        Sprite sp = nj.get();
                        int j = nj.getIndex();
                        if (sp.getStatnum() == 10 && sp.getOwner() >= 0) {
                            short p = sp.getYvel();
                            Globals.ps[p].posz += q;
                            Globals.ps[p].truefz += q;
                            Globals.ps[p].truecz += q;
                            if (Mmulti.numplayers > 1 || Globals.mFakeMultiplayer) {
                                Globals.ps[p].oposz = Globals.ps[p].posz;
                            }
                        }
                        if (sp.getStatnum() != 3) {
                            Main.game.pInt.setsprinterpolate(j, sp);
                            sp.setZ(sp.getZ() + q);
                        }
                        Globals.hittype[j].floorz = sc.getFloorz();
                        Globals.hittype[j].ceilingz = sc.getCeilingz();
                    }
                    if (t[0] == 0) break;
                    if (Pragmas.klabs(sc.getFloorz() - t[2]) <= s.getYvel()) {
                        DSector.activatewarpelevators(i, 0);
                        break;
                    }
                    if ((t[0] != -1 ? sc.getCeilingz() < t[4] : sc.getFloorz() > t[3]) || t[1] == 0) break;
                    t[1] = 0;
                    int j = -1;
                    for (node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                        Sector sec;
                        Sprite sp = node.get();
                        j = node.getIndex();
                        if (i != j && sp.getLotag() == 17 && (sec = Main.boardService.getSector(sp.getSectnum())) != null && sc.getHitag() - t[0] == sec.getHitag() && sh == sp.getHitag()) break;
                    }
                    if (node == null || (sprite = Main.boardService.getSprite(j)) == null || (jsec = Main.boardService.getSector(sprite.getSectnum())) == null) break;
                    ListNode<Sprite> nk = Main.boardService.getSectNode(s.getSectnum());
                    while (nk != null) {
                        Sprite sp = nk.get();
                        ListNode<Sprite> nextk = nk.getNext();
                        k = nk.getIndex();
                        if (sp.getStatnum() == 10 && sp.getOwner() >= 0) {
                            short p = sp.getYvel();
                            Globals.ps[p].posx += sprite.getX() - s.getX();
                            Globals.ps[p].posy += sprite.getY() - s.getY();
                            Globals.ps[p].posz = jsec.getFloorz() - (sc.getFloorz() - Globals.ps[p].posz);
                            Globals.hittype[k].floorz = jsec.getFloorz();
                            Globals.hittype[k].ceilingz = jsec.getCeilingz();
                            Globals.ps[p].bobposx = Globals.ps[p].oposx = Globals.ps[p].posx;
                            Globals.ps[p].bobposy = Globals.ps[p].oposy = Globals.ps[p].posy;
                            Globals.ps[p].oposz = Globals.ps[p].posz;
                            Globals.ps[p].truefz = Globals.hittype[k].floorz;
                            Globals.ps[p].truecz = Globals.hittype[k].ceilingz;
                            Globals.ps[p].bobcounter = 0;
                            Main.game.pInt.setsprinterpolate(Globals.ps[p].i, Main.boardService.getSprite(Globals.ps[p].i));
                            Main.engine.changespritesect(k, sprite.getSectnum());
                            Globals.ps[p].cursectnum = sprite.getSectnum();
                            Globals.ps[p].UpdatePlayerLoc();
                        } else if (sp.getStatnum() != 3) {
                            Main.game.pInt.setsprinterpolate(k, sp);
                            sp.setX(sp.getX() + sprite.getX() - s.getX());
                            sp.setY(sp.getY() + sprite.getY() - s.getY());
                            sp.setZ(jsec.getFloorz() - (sc.getFloorz() - sp.getZ()));
                            Main.engine.changespritesect(k, sprite.getSectnum());
                            Main.engine.setsprite(k, sp.getX(), sp.getY(), sp.getZ());
                            Globals.hittype[k].floorz = jsec.getFloorz();
                            Globals.hittype[k].ceilingz = jsec.getCeilingz();
                        }
                        nk = nextk;
                    }
                    break;
                }
                case 18: {
                    if (sc == null || t[0] == 0) break;
                    if (s.getPal() != 0) {
                        if (s.getAng() == 512) {
                            Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                            sc.setCeilingz(sc.getCeilingz() - sc.getExtra());
                            if (sc.getCeilingz() <= t[1]) {
                                sc.setCeilingz(t[1]);
                                Main.engine.deletesprite(i);
                                break;
                            }
                        } else {
                            Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                            sc.setFloorz(sc.getFloorz() + sc.getExtra());
                            for (ListNode<Sprite> nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                                Sprite sp = nj.get();
                                int j = nj.getIndex();
                                if (sp.getPicnum() == 1405 && sp.getOwner() >= 0 && Globals.ps[sp.getYvel()].on_ground) {
                                    Globals.ps[sp.getYvel()].posz += sc.getExtra();
                                }
                                if (sp.getZvel() != 0 || sp.getStatnum() == 3 || sp.getStatnum() == 4) continue;
                                Main.game.pInt.setsprinterpolate(j, sp);
                                sp.setZ(sp.getZ() + sc.getExtra());
                                Globals.hittype[j].floorz = sc.getFloorz();
                            }
                            if (sc.getFloorz() >= t[1]) {
                                sc.setFloorz(t[1]);
                                Main.engine.deletesprite(i);
                                break;
                            }
                        }
                    } else if (s.getAng() == 512) {
                        Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                        sc.setCeilingz(sc.getCeilingz() + sc.getExtra());
                        if (sc.getCeilingz() >= s.getZ()) {
                            sc.setCeilingz(s.getZ());
                            Main.engine.deletesprite(i);
                            break;
                        }
                    } else {
                        Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                        sc.setFloorz(sc.getFloorz() - sc.getExtra());
                        for (ListNode<Sprite> nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                            Sprite sp = nj.get();
                            int j = nj.getIndex();
                            if (sp.getPicnum() == 1405 && sp.getOwner() >= 0 && Globals.ps[sp.getYvel()].on_ground) {
                                Globals.ps[sp.getYvel()].posz -= sc.getExtra();
                            }
                            if (sp.getZvel() != 0 || sp.getStatnum() == 3 || sp.getStatnum() == 4) continue;
                            Main.game.pInt.setsprinterpolate(j, sp);
                            sp.setZ(sp.getZ() - sc.getExtra());
                            Globals.hittype[j].floorz = sc.getFloorz();
                        }
                        if (sc.getFloorz() <= s.getZ()) {
                            sc.setFloorz(s.getZ());
                            Main.engine.deletesprite(i);
                            break;
                        }
                    }
                    t[2] = t[2] + 1;
                    if (t[2] < s.getHitag()) break;
                    t[2] = 0;
                    t[0] = 0;
                    break;
                }
                case 19: {
                    if (sc != null && t[0] != 0) {
                        if (t[0] == 1) {
                            t[0] = t[0] + 1;
                            for (ListNode<Wall> wn = sc.getWallNode(); wn != null; wn = wn.getNext()) {
                                Wall wal = wn.get();
                                if (wal.getOverpicnum() != 230) continue;
                                wal.setCstat(wal.getCstat() & 0xAE);
                                wal.setOverpicnum(0);
                                Wall nwal = Main.boardService.getWall(wal.getNextwall());
                                if (nwal == null) continue;
                                nwal.setOverpicnum(0);
                                nwal.setCstat(nwal.getCstat() & 0xAE);
                            }
                        }
                        Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                        if (sc.getCeilingz() < sc.getFloorz()) {
                            sc.setCeilingz(sc.getCeilingz() + s.getYvel());
                            break;
                        }
                        sc.setCeilingz(sc.getFloorz());
                        for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                            Sprite spo;
                            Sprite sp = node.get();
                            if (sp.getLotag() != 0 || sp.getHitag() != sh || (spo = Main.boardService.getSprite(sp.getOwner())) == null) continue;
                            short q = spo.getSectnum();
                            Sector qsec = Main.boardService.getSector(q);
                            Sector sec = Main.boardService.getSector(sp.getSectnum());
                            if (sec == null || qsec == null) continue;
                            short pal = qsec.getFloorpal();
                            sec.setCeilingpal(pal);
                            sec.setFloorpal(pal);
                            byte shade = qsec.getFloorshade();
                            sec.setCeilingshade(shade);
                            sec.setFloorshade(shade);
                            Globals.hittype[sp.getOwner()].temp_data[0] = 2;
                        }
                        Main.engine.deletesprite(i);
                        break;
                    }
                    if (Actors.ifhitsectors(s.getSectnum()) < 0) break;
                    View.FTA(8, Globals.ps[Mmulti.myconnectindex]);
                    block100: for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                        int l = node.getIndex();
                        Sprite sp = node.get();
                        int x = sp.getLotag() & Short.MAX_VALUE;
                        switch (x) {
                            case 0: {
                                if (sp.getHitag() != sh) continue block100;
                                short q = sp.getSectnum();
                                Sector sec = Main.boardService.getSector(q);
                                Sprite spo = Main.boardService.getSprite(sp.getOwner());
                                if (sec == null || spo == null) continue block100;
                                short pal = spo.getPal();
                                sec.setCeilingpal(pal);
                                sec.setFloorpal(pal);
                                byte shade = spo.getShade();
                                sec.setCeilingshade(shade);
                                sec.setFloorshade(shade);
                                continue block100;
                            }
                            case 1: 
                            case 12: 
                            case 19: {
                                if (sh != sp.getHitag() || Globals.hittype[l].temp_data[0] != 0) continue block100;
                                Globals.hittype[l].temp_data[0] = 1;
                                sp.setOwner(i);
                            }
                        }
                    }
                    break;
                }
                case 20: {
                    if (t[0] == 0) break;
                    if (t[0] == 1) {
                        s.setXvel(8);
                    } else {
                        s.setXvel(-8);
                    }
                    if (s.getXvel() == 0) break;
                    int x = s.getXvel() * EngineUtils.cos(s.getAng() & 0x7FF) >> 14;
                    int l = s.getXvel() * EngineUtils.sin(s.getAng() & 0x7FF) >> 14;
                    t[3] = t[3] + s.getXvel();
                    s.setX(s.getX() + x);
                    s.setY(s.getY() + l);
                    if (t[3] <= 0 || t[3] >> 6 >= s.getYvel() >> 6) {
                        s.setX(s.getX() - x);
                        s.setY(s.getY() - l);
                        t[0] = 0;
                        DSector.callsound(s.getSectnum(), i);
                        break;
                    }
                    ListNode<Sprite> nj = Main.boardService.getSectNode(s.getSectnum());
                    while (nj != null) {
                        Sprite sp = nj.get();
                        ListNode<Sprite> nextj = nj.getNext();
                        int j = nj.getIndex();
                        if (sp.getStatnum() != 3 && sp.getZvel() == 0) {
                            Main.game.pInt.setsprinterpolate(j, sp);
                            sp.setX(sp.getX() + x);
                            sp.setY(sp.getY() + l);
                            Main.engine.setsprite(j, sp.getX(), sp.getY(), sp.getZ());
                            Sector sec = Main.boardService.getSector(sp.getSectnum());
                            if (sec != null && (sec.getFloorstat() & 2) != 0 && sp.getStatnum() == 2) {
                                Gamedef.makeitfall(Globals.currentGame.getCON(), j);
                            }
                        }
                        nj = nextj;
                    }
                    Wall w1 = Main.boardService.getWall(t[1]);
                    Wall w2 = Main.boardService.getWall(t[2]);
                    if (w1 != null) {
                        Main.engine.dragpoint(t[1], w1.getX() + x, w1.getY() + l);
                    }
                    if (w2 != null) {
                        Main.engine.dragpoint(t[2], w2.getX() + x, w2.getY() + l);
                    }
                    short p = Mmulti.connecthead;
                    while (p >= 0) {
                        if (Globals.ps[p].cursectnum == s.getSectnum() && Globals.ps[p].on_ground) {
                            Globals.ps[p].posx += x;
                            Globals.ps[p].posy += l;
                            Main.engine.setsprite(Globals.ps[p].i, Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].posz + 9728);
                        }
                        p = Mmulti.connectpoint2[p];
                    }
                    if (sc == null) break;
                    sc.setFloorxpanning(sc.getFloorxpanning() - (x >> 3));
                    sc.setFloorypanning(sc.getFloorypanning() - (l >> 3));
                    sc.setCeilingxpanning(sc.getCeilingxpanning() - (x >> 3));
                    sc.setCeilingypanning(sc.getCeilingypanning() - (l >> 3));
                    break;
                }
                case 21: {
                    if (sc == null || t[0] == 0) break;
                    int l = sc.getFloorz();
                    if (s.getAng() == 1536) {
                        l = sc.getCeilingz();
                    }
                    if (t[0] == 1) {
                        s.setZvel(Pragmas.ksgn(s.getZ() - l) * (s.getYvel() << 4));
                        t[0] = t[0] + 1;
                    }
                    if (sc.getExtra() == 0) {
                        l += s.getZvel();
                        if (s.getAng() == 1536) {
                            Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                            sc.setCeilingz(l);
                        } else {
                            Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                            sc.setFloorz(l);
                        }
                        if (Pragmas.klabs(l - s.getZ()) >= 1024) break;
                        l = s.getZ();
                        if (s.getAng() == 1536) {
                            sc.setCeilingz(l);
                        } else {
                            sc.setFloorz(l);
                        }
                        Main.engine.deletesprite(i);
                        break;
                    }
                    sc.setExtra(sc.getExtra() - 1);
                    break;
                }
                case 22: {
                    if (t[1] == 0) break;
                    if (sc != null && Animate.getanimationgoal(Main.boardService.getSector(t[0]), 8) >= 0) {
                        Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                        sc.setCeilingz(sc.getCeilingz() + sc.getExtra() * 9);
                        break;
                    }
                    t[1] = 0;
                    break;
                }
                case 24: 
                case 34: {
                    if (t[4] != 0) break;
                    int x = s.getYvel() * EngineUtils.sin(s.getAng() + 512 & 0x7FF) >> 18;
                    int l = s.getYvel() * EngineUtils.sin(s.getAng() & 0x7FF) >> 18;
                    ListNode<Sprite> nj = Main.boardService.getSectNode(s.getSectnum());
                    block103: while (nj != null) {
                        Sprite sp = nj.get();
                        ListNode<Sprite> nextj = nj.getNext();
                        int j = nj.getIndex();
                        if (sp.getZvel() >= 0) {
                            switch (sp.getStatnum()) {
                                case 5: {
                                    switch (sp.getPicnum()) {
                                        case 550: 
                                        case 672: 
                                        case 673: 
                                        case 674: 
                                        case 952: 
                                        case 1226: 
                                        case 2296: 
                                        case 2297: 
                                        case 2298: 
                                        case 2299: 
                                        case 4389: {
                                            sp.setXrepeat(0);
                                            sp.setYrepeat(0);
                                            nj = nextj;
                                            continue block103;
                                        }
                                        case 2567: {
                                            nj = nextj;
                                            continue block103;
                                        }
                                    }
                                }
                                case 6: {
                                    if (sp.getPicnum() == 2566) break;
                                }
                                case 0: 
                                case 1: {
                                    if (sp.getPicnum() == 634 || sp.getPicnum() == 635 || sp.getPicnum() == 636 || sp.getPicnum() == 637 || sp.getPicnum() == 4525 || sp.getPicnum() == 4526 || sp.getPicnum() == 4527 || sp.getPicnum() == 4528 || DSector.wallswitchcheck(j) || sp.getPicnum() >= 1222 && sp.getPicnum() <= 1225 || sp.getZ() <= Globals.hittype[j].floorz - 4096) break;
                                    Main.game.pInt.setsprinterpolate(j, sp);
                                    sp.setX(sp.getX() + (x >> 2));
                                    sp.setY(sp.getY() + (l >> 2));
                                    Main.engine.setsprite(j, sp.getX(), sp.getY(), sp.getZ());
                                    Sector sec = Main.boardService.getSector(sp.getSectnum());
                                    if (sec == null || (sec.getFloorstat() & 2) == 0 || sp.getStatnum() != 2) break;
                                    Gamedef.makeitfall(Globals.currentGame.getCON(), j);
                                }
                            }
                        }
                        nj = nextj;
                    }
                    short p = Mmulti.myconnectindex;
                    if (Globals.ps[p].cursectnum == s.getSectnum() && Globals.ps[p].on_ground && Pragmas.klabs(Globals.ps[p].posz - Globals.ps[p].truefz) < 12032) {
                        Globals.fricxv += x << 3;
                        Globals.fricyv += l << 3;
                    }
                    if (sc == null) break;
                    sc.setFloorxpanning(sc.getFloorxpanning() + (s.getYvel() >> 7));
                    break;
                }
                case 35: {
                    if (sc == null) break;
                    if (sc.getCeilingz() > s.getZ()) {
                        for (int j = 0; j < 8; ++j) {
                            s.setAng(s.getAng() + (Main.engine.krand() & 0x1FF));
                            int k = Spawn.spawn(i, 2329);
                            Sprite sp = Main.boardService.getSprite(k);
                            if (sp == null) continue;
                            sp.setXvel(96 + (Main.engine.krand() & 0x7F));
                            Actors.ssp(k, 65537);
                            Main.engine.setsprite(k, sp.getX(), sp.getY(), sp.getZ());
                            if (!Gameutils.rnd(16)) continue;
                            Spawn.spawn(i, 1890);
                        }
                    }
                    switch (t[0]) {
                        case 0: {
                            Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                            Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                            sc.setCeilingz(sc.getCeilingz() + s.getYvel());
                            if (sc.getCeilingz() > sc.getFloorz()) {
                                sc.setFloorz(sc.getCeilingz());
                            }
                            if (sc.getCeilingz() <= s.getZ() + 8192) break;
                            t[0] = t[0] + 1;
                            break;
                        }
                        case 1: {
                            Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                            sc.setCeilingz(sc.getCeilingz() - (s.getYvel() << 2));
                            if (sc.getCeilingz() >= t[4]) break;
                            sc.setCeilingz(t[4]);
                            t[0] = 0;
                        }
                    }
                    break;
                }
                case 25: {
                    if (sc == null || t[4] == 0) break;
                    if (sc.getFloorz() <= sc.getCeilingz()) {
                        s.setShade(0);
                    } else if (sc.getCeilingz() <= t[3]) {
                        s.setShade(1);
                    }
                    Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                    if (s.getShade() != 0) {
                        sc.setCeilingz(sc.getCeilingz() + (s.getYvel() << 4));
                        if (sc.getCeilingz() <= sc.getFloorz()) break;
                        sc.setCeilingz(sc.getFloorz());
                        break;
                    }
                    sc.setCeilingz(sc.getCeilingz() - (s.getYvel() << 4));
                    if (sc.getCeilingz() >= t[3]) break;
                    sc.setCeilingz(t[3]);
                    break;
                }
                case 26: {
                    if (sc == null) break;
                    s.setXvel(32);
                    int l = s.getXvel() * EngineUtils.cos(s.getAng() & 0x7FF) >> 14;
                    int x = s.getXvel() * EngineUtils.sin(s.getAng() & 0x7FF) >> 14;
                    s.setShade(s.getShade() + 1);
                    Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                    if (s.getShade() > 7) {
                        s.setX(t[3]);
                        s.setY(t[4]);
                        sc.setFloorz(sc.getFloorz() - (s.getZvel() * s.getShade() - s.getZvel()));
                        s.setShade(0);
                    } else {
                        sc.setFloorz(sc.getFloorz() + s.getZvel());
                    }
                    ListNode<Sprite> nj = Main.boardService.getSectNode(s.getSectnum());
                    while (nj != null) {
                        Sprite sp = nj.get();
                        ListNode<Sprite> nextj = nj.getNext();
                        int j = nj.getIndex();
                        if (sp.getStatnum() != 3 && sp.getStatnum() != 10) {
                            Main.game.pInt.setsprinterpolate(j, sp);
                            sp.setX(sp.getX() + l);
                            sp.setY(sp.getY() + x);
                            sp.setZ(sp.getZ() + s.getZvel());
                            Main.engine.setsprite(j, sp.getX(), sp.getY(), sp.getZ());
                        }
                        nj = nextj;
                    }
                    if (Globals.ps[Mmulti.myconnectindex].getPlayerSprite().getSectnum() == s.getSectnum() && Globals.ps[Mmulti.myconnectindex].on_ground) {
                        Globals.fricxv += l << 5;
                        Globals.fricyv += x << 5;
                    }
                    short p = Mmulti.connecthead;
                    while (p >= 0) {
                        if (Globals.ps[p].getPlayerSprite().getSectnum() == s.getSectnum() && Globals.ps[p].on_ground) {
                            Globals.ps[p].posz += s.getZvel();
                        }
                        p = Mmulti.connectpoint2[p];
                    }
                    Actors.ms(i);
                    Main.engine.setsprite(i, s.getX(), s.getY(), s.getZ());
                    break;
                }
                case 27: {
                    if (Globals.ud.recstat == 0) break;
                    Globals.hittype[i].tempang = s.getAng();
                    short p = (short)DSector.findplayer(s);
                    int x = DSector.player_dist;
                    Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
                    if (psp == null || psp.getExtra() <= 0 || Mmulti.myconnectindex != Globals.screenpeek) break;
                    if (t[0] < 0) {
                        Globals.ud.camerasprite = i;
                        t[0] = t[0] + 1;
                        break;
                    }
                    if (!DemoScreen.isDemoPlaying() || Globals.ps[p].newowner != -1) break;
                    if (Main.engine.cansee(s.getX(), s.getY(), s.getZ(), s.getSectnum(), Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].posz, Globals.ps[p].cursectnum)) {
                        if (x < (sh & 0xFFFF)) {
                            Globals.ud.camerasprite = i;
                            t[0] = 999;
                            s.setAng(s.getAng() + (Gamedef.getincangle(s.getAng(), EngineUtils.getAngle(Globals.ps[p].posx - s.getX(), Globals.ps[p].posy - s.getY())) >> 3));
                            s.setYvel((short)(100 + (s.getZ() - Globals.ps[p].posz) / 257));
                            break;
                        }
                        if (t[0] != 999) break;
                        t[0] = Globals.ud.camerasprite == i ? 0 : -10;
                        Globals.ud.camerasprite = i;
                        break;
                    }
                    s.setAng(EngineUtils.getAngle(Globals.ps[p].posx - s.getX(), Globals.ps[p].posy - s.getY()));
                    if (t[0] != 999) break;
                    t[0] = Globals.ud.camerasprite == i ? 0 : -20;
                    Globals.ud.camerasprite = i;
                    break;
                }
                case 28: {
                    if (t[5] > 0) {
                        t[5] = t[5] - 1;
                        break;
                    }
                    if (Globals.hittype[i].temp_data[0] == 0) {
                        DSector.findplayer(s);
                        int x = DSector.player_dist;
                        if (x > 15500) break;
                        Globals.hittype[i].temp_data[0] = 1;
                        Globals.hittype[i].temp_data[1] = 64 + (Main.engine.krand() & 0x1FF);
                        Globals.hittype[i].temp_data[2] = 0;
                        break;
                    }
                    Globals.hittype[i].temp_data[2] = Globals.hittype[i].temp_data[2] + 1;
                    if (Globals.hittype[i].temp_data[2] > Globals.hittype[i].temp_data[1]) {
                        Globals.hittype[i].temp_data[0] = 0;
                        Engine.visibility = Globals.currentGame.getCON().const_visibility;
                        break;
                    }
                    if (Globals.hittype[i].temp_data[2] == Globals.hittype[i].temp_data[1] >> 1) {
                        Sounds.spritesound(352, i);
                        break;
                    }
                    if (Globals.hittype[i].temp_data[2] == Globals.hittype[i].temp_data[1] >> 3) {
                        Sounds.spritesound(351, i);
                        break;
                    }
                    if (Globals.hittype[i].temp_data[2] == Globals.hittype[i].temp_data[1] >> 2) {
                        for (ListNode<Sprite> node = Main.boardService.getStatNode(0); node != null; node = node.getNext()) {
                            Sprite sp = node.get();
                            if (sp.getPicnum() != 4890 || sp.getHitag() != s.getHitag()) continue;
                            sp.setCstat(sp.getCstat() | 0x8000);
                        }
                    } else {
                        if (Globals.hittype[i].temp_data[2] <= Globals.hittype[i].temp_data[1] >> 3 || Globals.hittype[i].temp_data[2] >= Globals.hittype[i].temp_data[1] >> 2) break;
                        int j = Main.engine.cansee(s.getX(), s.getY(), s.getZ(), s.getSectnum(), Globals.ps[Globals.screenpeek].posx, Globals.ps[Globals.screenpeek].posy, Globals.ps[Globals.screenpeek].posz, Globals.ps[Globals.screenpeek].cursectnum) ? 1 : 0;
                        if (Gameutils.rnd(192) && (Globals.hittype[i].temp_data[2] & 1) != 0) {
                            if (j != 0) {
                                Globals.gVisibility = 0;
                            }
                        } else if (j != 0) {
                            Globals.gVisibility = Globals.currentGame.getCON().const_visibility;
                        }
                        for (ListNode<Sprite> node = Main.boardService.getStatNode(0); node != null; node = node.getNext()) {
                            Sprite sp = node.get();
                            j = node.getIndex();
                            if (sp.getPicnum() != 4890 || sp.getHitag() != s.getHitag()) continue;
                            if (Gameutils.rnd(32) && (Globals.hittype[i].temp_data[2] & 1) != 0) {
                                int x;
                                sp.setCstat(sp.getCstat() & Short.MAX_VALUE);
                                Spawn.spawn(j, 2329);
                                int p = DSector.findplayer(s);
                                Sprite psp = Main.boardService.getSprite(Globals.ps[p].i);
                                if (psp == null || (x = DSector.ldist(psp, sp)) >= 768) break block0;
                                if (Globals.Sound[211].getSoundOwnerCount() < 1) {
                                    Sounds.spritesound(211, Globals.ps[p].i);
                                }
                                Sounds.spritesound(21, Globals.ps[p].i);
                                Globals.ps[p].getPlayerSprite().setExtra(Globals.ps[p].getPlayerSprite().getExtra() - (8 + (Main.engine.krand() & 7)));
                                Globals.ps[p].pals_time = 32;
                                Globals.ps[p].pals[0] = 16;
                                Globals.ps[p].pals[1] = 0;
                                Globals.ps[p].pals[2] = 0;
                                break block0;
                            }
                            sp.setCstat(sp.getCstat() | 0x8000);
                        }
                    }
                    break;
                }
                case 29: {
                    s.setHitag(s.getHitag() + 64);
                    int l = Pragmas.mulscale(s.getYvel(), EngineUtils.sin(s.getHitag() & 0x7FF), 12);
                    if (sc == null) break;
                    sc.setFloorz(s.getZ() + l);
                    break;
                }
                case 31: {
                    ListNode<Sprite> nj;
                    if (t[0] != 1) break;
                    if (t[3] > 0) {
                        t[3] = t[3] - 1;
                        break;
                    }
                    Main.game.pInt.setfloorinterpolate(s.getSectnum(), sc);
                    for (nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                        Sprite sp = nj.get();
                        Main.game.pInt.setsprinterpolate(nj.getIndex(), sp);
                    }
                    if (sc == null) break;
                    if (t[2] == 1) {
                        if (s.getAng() != 1536) {
                            if (Pragmas.klabs(sc.getFloorz() - s.getZ()) < s.getYvel()) {
                                sc.setFloorz(s.getZ());
                                t[2] = 0;
                                t[0] = 0;
                                t[3] = s.getHitag();
                                DSector.callsound(s.getSectnum(), i);
                                break;
                            }
                            int l = Gameutils.sgn(s.getZ() - sc.getFloorz()) * s.getYvel();
                            sc.setFloorz(sc.getFloorz() + l);
                            for (nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                                Sprite sp = nj.get();
                                if (sp.getPicnum() == 1405 && sp.getOwner() >= 0 && Globals.ps[sp.getYvel()].on_ground) {
                                    Globals.ps[sp.getYvel()].posz += l;
                                }
                                if (sp.getZvel() != 0 || sp.getStatnum() == 3 || sp.getStatnum() == 4) continue;
                                sp.setZ(sp.getZ() + l);
                                Globals.hittype[nj.getIndex()].floorz = sc.getFloorz();
                            }
                        } else {
                            if (Pragmas.klabs(sc.getFloorz() - t[1]) < s.getYvel()) {
                                sc.setFloorz(t[1]);
                                DSector.callsound(s.getSectnum(), i);
                                t[2] = 0;
                                t[0] = 0;
                                t[3] = s.getHitag();
                                break;
                            }
                            int l = Gameutils.sgn(t[1] - sc.getFloorz()) * s.getYvel();
                            sc.setFloorz(sc.getFloorz() + l);
                            for (nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                                Sprite sp = nj.get();
                                if (sp.getPicnum() == 1405 && sp.getOwner() >= 0 && Globals.ps[sp.getYvel()].on_ground) {
                                    Globals.ps[sp.getYvel()].posz += l;
                                }
                                if (sp.getZvel() != 0 || sp.getStatnum() == 3 || sp.getStatnum() == 4) continue;
                                sp.setZ(sp.getZ() + l);
                                Globals.hittype[nj.getIndex()].floorz = sc.getFloorz();
                            }
                        }
                    } else if ((s.getAng() & 0x7FF) == 1536) {
                        if (Pragmas.klabs(s.getZ() - sc.getFloorz()) < s.getYvel()) {
                            DSector.callsound(s.getSectnum(), i);
                            t[0] = 0;
                            t[2] = 1;
                            t[3] = s.getHitag();
                            break;
                        }
                        int l = Gameutils.sgn(s.getZ() - sc.getFloorz()) * s.getYvel();
                        sc.setFloorz(sc.getFloorz() + l);
                        for (nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                            Sprite sp = nj.get();
                            if (sp.getPicnum() == 1405 && sp.getOwner() >= 0 && Globals.ps[sp.getYvel()].on_ground) {
                                Globals.ps[sp.getYvel()].posz += l;
                            }
                            if (sp.getZvel() != 0 || sp.getStatnum() == 3 || sp.getStatnum() == 4) continue;
                            sp.setZ(sp.getZ() + l);
                            Globals.hittype[nj.getIndex()].floorz = sc.getFloorz();
                        }
                    } else {
                        if (Pragmas.klabs(sc.getFloorz() - t[1]) < s.getYvel()) {
                            t[0] = 0;
                            DSector.callsound(s.getSectnum(), i);
                            t[2] = 1;
                            t[3] = s.getHitag();
                            break;
                        }
                        int l = Gameutils.sgn(s.getZ() - t[1]) * s.getYvel();
                        sc.setFloorz(sc.getFloorz() - l);
                        for (nj = Main.boardService.getSectNode(s.getSectnum()); nj != null; nj = nj.getNext()) {
                            Sprite sp = nj.get();
                            if (sp.getPicnum() == 1405 && sp.getOwner() >= 0 && Globals.ps[sp.getYvel()].on_ground) {
                                Globals.ps[sp.getYvel()].posz -= l;
                            }
                            if (sp.getZvel() != 0 || sp.getStatnum() == 3 || sp.getStatnum() == 4) continue;
                            sp.setZ(sp.getZ() - l);
                            Globals.hittype[nj.getIndex()].floorz = sc.getFloorz();
                        }
                    }
                    break;
                }
                case 32: {
                    if (sc == null || t[0] != 1) break;
                    Main.game.pInt.setceilinterpolate(s.getSectnum(), sc);
                    if (t[2] == 1) {
                        if (s.getAng() != 1536) {
                            if (Pragmas.klabs(sc.getCeilingz() - s.getZ()) < s.getYvel() << 1) {
                                sc.setCeilingz(s.getZ());
                                DSector.callsound(s.getSectnum(), i);
                                t[2] = 0;
                                t[0] = 0;
                                break;
                            }
                            sc.setCeilingz(sc.getCeilingz() + Gameutils.sgn(s.getZ() - sc.getCeilingz()) * s.getYvel());
                            break;
                        }
                        if (Pragmas.klabs(sc.getCeilingz() - t[1]) < s.getYvel() << 1) {
                            sc.setCeilingz(t[1]);
                            DSector.callsound(s.getSectnum(), i);
                            t[2] = 0;
                            t[0] = 0;
                            break;
                        }
                        sc.setCeilingz(sc.getCeilingz() + Gameutils.sgn(t[1] - sc.getCeilingz()) * s.getYvel());
                        break;
                    }
                    if ((s.getAng() & 0x7FF) == 1536) {
                        if (Pragmas.klabs(sc.getCeilingz() - s.getZ()) < s.getYvel() << 1) {
                            t[0] = 0;
                            t[2] = t[2] ^ 1;
                            DSector.callsound(s.getSectnum(), i);
                            sc.setCeilingz(s.getZ());
                            break;
                        }
                        sc.setCeilingz(sc.getCeilingz() + Gameutils.sgn(s.getZ() - sc.getCeilingz()) * s.getYvel());
                        break;
                    }
                    if (Pragmas.klabs(sc.getCeilingz() - t[1]) < s.getYvel() << 1) {
                        t[0] = 0;
                        t[2] = t[2] ^ 1;
                        DSector.callsound(s.getSectnum(), i);
                        break;
                    }
                    sc.setCeilingz(sc.getCeilingz() - Gameutils.sgn(s.getZ() - t[1]) * s.getYvel());
                    break;
                }
                case 33: {
                    if (Globals.earthquaketime <= 0 || (Main.engine.krand() & 7) != 0) break;
                    Gameutils.RANDOMSCRAP(s, i);
                    break;
                }
                case 36: {
                    if (t[0] == 0) break;
                    if (sc != null && t[0] == 1) {
                        Weapons.shoot(i, sc.getExtra());
                    } else if (t[0] == 130) {
                        t[0] = 0;
                    }
                    t[0] = t[0] + 1;
                    break;
                }
                case 128: {
                    Wall wal = Main.boardService.getWall(t[2]);
                    if (wal == null) break;
                    wal.setCstat(wal.getCstat() & 0xDF);
                    wal.setCstat(wal.getCstat() | 0x10);
                    Wall nwal = Main.boardService.getWall(wal.getNextwall());
                    if (nwal != null) {
                        nwal.setCstat(nwal.getCstat() & 0xDF);
                        nwal.setCstat(nwal.getCstat() | 0x10);
                    }
                    wal.setOverpicnum(wal.getOverpicnum() + 1);
                    nwal = Main.boardService.getWall(wal.getNextwall());
                    if (nwal != null) {
                        nwal.setOverpicnum(nwal.getOverpicnum() + 1);
                    }
                    if (t[0] < t[1]) {
                        t[0] = t[0] + 1;
                        break;
                    }
                    wal.setCstat(wal.getCstat() & 0xAE);
                    if (nwal != null) {
                        nwal.setCstat(nwal.getCstat() & 0xAE);
                    }
                    Main.engine.deletesprite(i);
                    break;
                }
                case 130: {
                    if (t[0] > 80) {
                        Main.engine.deletesprite(i);
                        break;
                    }
                    t[0] = t[0] + 1;
                    if (sc == null) break;
                    int x = sc.getFloorz() - sc.getCeilingz();
                    if (!Gameutils.rnd(64)) break;
                    int k = Spawn.spawn(i, 1890);
                    int size = 2 + (Main.engine.krand() & 7);
                    Sprite ks = Main.boardService.getSprite(k);
                    if (ks == null) break;
                    ks.setXrepeat(size);
                    ks.setYrepeat(size);
                    ks.setZ(sc.getFloorz() - Main.engine.krand() % x);
                    ks.setAng(ks.getAng() + 256 - Main.engine.krand() % 511);
                    ks.setXvel((short)(Main.engine.krand() & 0x7F));
                    Actors.ssp(k, 65537);
                    break;
                }
                case 131: {
                    if (t[0] > 40) {
                        Main.engine.deletesprite(i);
                        break;
                    }
                    t[0] = t[0] + 1;
                    if (sc == null) break;
                    int x = sc.getFloorz() - sc.getCeilingz();
                    if (!Gameutils.rnd(32)) break;
                    short k = (short)Spawn.spawn(i, 1890);
                    int size = 2 + (Main.engine.krand() & 3);
                    Sprite ks = Main.boardService.getSprite(k);
                    if (ks == null) break;
                    ks.setXrepeat(size);
                    ks.setYrepeat(size);
                    ks.setZ(sc.getFloorz() - Main.engine.krand() % x);
                    ks.setAng(ks.getAng() + 256 - Main.engine.krand() % 511);
                    ks.setXvel((short)(Main.engine.krand() & 0x7F));
                    Actors.ssp(k, 65537);
                }
            }
            ni = nexti;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
            Sector sec;
            Wall wal;
            Sprite s = node.get();
            if (s.getLotag() != 29 || (sc = Main.boardService.getSector(s.getSectnum())) == null || sc.getWallnum() != 4 || (wal = Main.boardService.getWall(sc.getWallptr() + 2)) == null || (sec = Main.boardService.getSector(wal.getNextsector())) == null) continue;
            Main.engine.alignflorslope(s.getSectnum(), wal.getX(), wal.getY(), sec.getFloorz());
        }
    }
}

