/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.stream.IntStream;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Build.settings.InputContext;
import ru.m210projects.Build.settings.Properties;
import ru.m210projects.Duke3D.Globals;

public class Config
extends GameConfig {
    public int weaponIndex = -1;
    public static final int[] defkeys = new int[]{51, 47, 21, 22, 67, 57, 29, 32, 62, 129, 59, 33, 130, 75, 74, 92, 93, 61, 70, 69, 48, 49, 111, 68, 115, 45, 3, 123, 149, 124, 112, 8, 9, 10, 11, 12, 13, 14, 15, 16, 7, 66, 71, 72, 34, 39, 137, 37, 73, 53, 42, 36, 38, 41, 46, 131, 132, 133, 134, 135, 136, 0, 139, 140, 141, 142, 0, 0};
    public static final int[] defclassickeys = new int[]{19, 20, 21, 22, 67, 57, 55, 56, 29, 54, 59, 62, 129, 75, 74, 92, 93, 61, 70, 69, 48, 49, 111, 68, 115, 45, 3, 123, 149, 124, 112, 8, 9, 10, 11, 12, 13, 14, 15, 16, 7, 66, 71, 72, 34, 39, 137, 37, 116, 51, 42, 36, 38, 41, 46, 131, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 0, 0};
    public int gStatSize = 65536;
    public int gCrossSize = 65536;
    public int gShowStat = 1;
    public int showMapInfo = 1;
    public final boolean AmbienceToggle = true;
    public final boolean VoiceToggle = true;
    public int gDemoSeq = 1;
    public boolean gAutoAim = true;
    public int screen_size = 2;
    public int crosshair = 1;
    public int screen_tilting = 1;
    public int auto_run = 1;
    public int fta_on = 1;
    public boolean bDevCommentry = true;
    public boolean bLegacyDukeTalk = false;

    public Config(Path path) {
        super(path);
        this.setpName("Duke");
    }

    @Override
    protected InputContext createDefaultInputContext() {
        return new InputContext(this.getKeyMap(), defkeys, defclassickeys){

            @Override
            protected void clearInput() {
                super.clearInput();
                Config.this.weaponIndex = IntStream.range(0, this.keymap.length).filter(i -> this.keymap[i].equals(DukeKeys.Weapon_1)).findFirst().orElse(-1);
            }

            @Override
            public void resetInput(boolean classicKeys) {
                super.resetInput(classicKeys);
                this.bindMouse(DukeKeys.Last_Weap_Switch, 227);
            }
        };
    }

    @Override
    protected ConfigContext createDefaultGameContext() {
        return new ConfigContext(){

            @Override
            public void load(Properties prop) {
                if (prop.setContext("Options")) {
                    Config.this.screen_size = prop.getIntValue("Size", Config.this.screen_size);
                    Config.this.crosshair = prop.getIntValue("Crosshair", Config.this.crosshair);
                    Config.this.fta_on = prop.getIntValue("MessageState", Config.this.fta_on);
                    Config.this.gAutoAim = prop.getBooleanValue("Autoaim", Config.this.gAutoAim);
                    Config.this.screen_tilting = prop.getIntValue("Tilt", Config.this.screen_tilting);
                    Config.this.auto_run = prop.getIntValue("AutoRun", Config.this.auto_run);
                    Config.this.gStatSize = Math.max(prop.getIntValue("StatSize", Config.this.gStatSize), 16384);
                    Config.this.gCrossSize = Math.max(prop.getIntValue("CrossSize", Config.this.gCrossSize), 16384);
                    Config.this.gShowStat = prop.getIntValue("ShowStat", Config.this.gShowStat);
                    Config.this.showMapInfo = prop.getIntValue("showMapInfo", Config.this.showMapInfo);
                    Config.this.gDemoSeq = prop.getIntValue("DemoSequence", Config.this.gDemoSeq);
                    Config.this.bDevCommentry = prop.getBooleanValue("DeveloperCommentary", Config.this.bDevCommentry);
                    Config.this.bLegacyDukeTalk = prop.getBooleanValue("LegacyDukeTalk", Config.this.bLegacyDukeTalk);
                }
            }

            @Override
            public void save(OutputStream os) throws IOException {
                this.putString(os, "[Options]\r\n");
                this.putInteger(os, "Size", Globals.ud.screen_size);
                this.putInteger(os, "Crosshair", Globals.ud.crosshair);
                this.putInteger(os, "MessageState", Globals.ud.fta_on);
                this.putBoolean(os, "Autoaim", Config.this.gAutoAim);
                this.putInteger(os, "Tilt", Globals.ud.screen_tilting);
                this.putInteger(os, "AutoRun", Globals.ud.auto_run);
                this.putInteger(os, "MessageState", Globals.ud.fta_on);
                this.putInteger(os, "StatSize", Config.this.gStatSize);
                this.putInteger(os, "CrossSize", Config.this.gCrossSize);
                this.putInteger(os, "ShowStat", Config.this.gShowStat);
                this.putInteger(os, "showMapInfo", Config.this.showMapInfo);
                this.putInteger(os, "DemoSequence", Config.this.gDemoSeq);
                this.putString(os, "//Twentieth Anniversary World Tour options\r\n");
                this.putBoolean(os, "DeveloperCommentary", Config.this.bDevCommentry);
                this.putBoolean(os, "LegacyDukeTalk", Config.this.bLegacyDukeTalk);
            }
        };
    }

    public GameKey[] getKeyMap() {
        return new GameKey[]{GameKeys.Move_Forward, GameKeys.Move_Backward, GameKeys.Turn_Left, GameKeys.Turn_Right, GameKeys.Turn_Around, GameKeys.Strafe, GameKeys.Strafe_Left, GameKeys.Strafe_Right, GameKeys.Jump, GameKeys.Crouch, GameKeys.Run, DukeKeys.AutoRun, GameKeys.Open, GameKeys.Weapon_Fire, DukeKeys.Quick_Kick, DukeKeys.Aim_Up, DukeKeys.Aim_Down, DukeKeys.Aim_Center, GameKeys.Look_Up, GameKeys.Look_Down, DukeKeys.Tilt_Left, DukeKeys.Tilt_Right, DukeKeys.Weapon_1, DukeKeys.Weapon_2, DukeKeys.Weapon_3, DukeKeys.Weapon_4, DukeKeys.Weapon_5, DukeKeys.Weapon_6, DukeKeys.Weapon_7, DukeKeys.Weapon_8, DukeKeys.Weapon_9, DukeKeys.Weapon_10, DukeKeys.Inventory_Use, DukeKeys.Inventory_Left, DukeKeys.Inventory_Right, GameKeys.Map_Toggle, DukeKeys.Map_Follow_Mode, GameKeys.Shrink_Screen, GameKeys.Enlarge_Screen, GameKeys.Send_Message, DukeKeys.See_Coop_View, DukeKeys.See_Chase_View, GameKeys.Mouse_Aiming, DukeKeys.Toggle_Crosshair, GameKeys.Next_Weapon, GameKeys.Previous_Weapon, DukeKeys.Holster_Weapon, DukeKeys.Show_Opp_Weapon, DukeKeys.NightVision, DukeKeys.Holo_Duke, DukeKeys.Jetpack, DukeKeys.MedKit, DukeKeys.Steroids, GameKeys.Menu_Toggle, GameKeys.Show_Console, DukeKeys.Show_Help, DukeKeys.Show_Savemenu, DukeKeys.Show_Loadmenu, DukeKeys.Show_Sounds, DukeKeys.Show_Options, DukeKeys.Quicksave, DukeKeys.Messages, DukeKeys.Quickload, DukeKeys.Quit, DukeKeys.Gamma, DukeKeys.Screenshot, DukeKeys.Last_Weap_Switch, DukeKeys.Crouch_toggle};
    }

    public static enum DukeKeys implements GameKey
    {
        AutoRun,
        Quick_Kick,
        Aim_Up,
        Aim_Down,
        Aim_Center,
        Tilt_Left,
        Tilt_Right,
        Weapon_1,
        Weapon_2,
        Weapon_3,
        Weapon_4,
        Weapon_5,
        Weapon_6,
        Weapon_7,
        Weapon_8,
        Weapon_9,
        Weapon_10,
        Inventory_Use,
        Inventory_Left,
        Inventory_Right,
        Map_Follow_Mode,
        See_Coop_View,
        See_Chase_View,
        Toggle_Crosshair,
        Holster_Weapon,
        Show_Opp_Weapon,
        NightVision,
        Holo_Duke,
        Jetpack,
        MedKit,
        Steroids,
        Show_Help,
        Show_Savemenu,
        Show_Loadmenu,
        Show_Sounds,
        Show_Options,
        Quicksave,
        Messages,
        Quickload,
        Quit,
        Gamma,
        Screenshot,
        Last_Weap_Switch,
        Crouch_toggle;


        @Override
        public int getNum() {
            return GameKeys.values().length + this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

