/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Menus;

import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuAudio;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Menus.DukeTitle;
import ru.m210projects.Duke3D.Sounds;

public class SoundMenu
extends MenuAudio {
    public SoundMenu(Main app) {
        super(app, 20, 30, 280, 10, 10, app.getFont(1));
        MenuAudio.AudioListener listener = new MenuAudio.AudioListener(){

            @Override
            public void PreDrvChange() {
                this.SoundOff();
                this.MusicOff();
            }

            @Override
            public void PostDrvChange() {
                Sounds.SoundStartup();
                this.MusicOn();
            }

            @Override
            public void SoundVolumeChange() {
                Sounds.CommentaryVolume(Sounds.pCommentary, Main.cfg.getSoundVolume());
            }

            @Override
            public void SoundOff() {
                Sounds.StopAllSounds();
            }

            @Override
            public void MusicOn() {
                if (Main.game.isCurrentScreen(Main.gGameScreen) || Main.game.isCurrentScreen(Main.gDemoScreen) || Main.game.isCurrentScreen(Main.gMenuScreen)) {
                    if (!Main.game.isCurrentScreen(Main.gGameScreen)) {
                        Sounds.sndPlayMusic(Globals.currentGame.getCON().env_music_fn[0]);
                    } else {
                        Sounds.sndPlayMusic(Globals.currentGame.getCON().music_fn[Globals.ud.volume_number][Globals.ud.level_number]);
                    }
                }
            }

            @Override
            public void MusicOff() {
                Sounds.sndStopMusic();
            }
        };
        this.setListener(listener);
        this.sSoundDrv.listFont = app.getFont(0);
        this.sMusicDrv.listFont = app.getFont(0);
        this.sResampler.listFont = app.getFont(0);
        this.mApplyChanges.font = app.getFont(2);
        this.mApplyChanges.y += 10;
    }

    @Override
    public MenuTitle getTitle(BuildGame app, String text) {
        return new DukeTitle(text);
    }
}

