/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Sounds;

public class EndScreen
extends ScreenAdapter
implements InputListener {
    private final Main app;
    private final int[] bossmove = new int[]{0, 120, 3263, 86, 59, 220, 260, 3264, 86, 59, 260, 290, 3265, 86, 59, 290, 320, 3266, 86, 59, 320, 350, 3267, 86, 59, 350, 380, 3268, 86, 59};
    private final int[] breathe = new int[]{0, 30, 3261, 176, 59, 30, 60, 3262, 176, 59, 60, 90, 3261, 176, 59, 90, 120, 0, 176, 59};
    protected int gCutsClock;
    private int bonuscnt = 0;

    public EndScreen(Main app) {
        this.app = app;
    }

    @Override
    public void show() {
        if (Globals.ud.volume_number == 0) {
            Main.engine.setbrightness(Globals.ud.brightness >> 2, Player.endingpal);
        } else {
            Main.engine.setbrightness(Globals.ud.brightness >> 2, Main.engine.getPaletteManager().getBasePalette());
        }
        this.bonuscnt = 0;
        this.gCutsClock = 0;
        Main.engine.getTimer().reset();
        Main.game.getProcessor().resetPollingStates();
    }

    @Override
    public void render(float delta) {
        Renderer renderer = Main.game.getRenderer();
        renderer.clearview(0);
        if (Main.game.getProcessor().isKeyPressed(-1)) {
            this.anyKeyPressed();
        }
        switch (Globals.ud.volume_number) {
            case 0: {
                if (this.bonuscnt < 4) {
                    int t;
                    renderer.rotatesprite(0, 0x320000, 65536, 0, 3260, 0, 0, 218);
                    if (Main.engine.getTotalClock() > 390 && Main.engine.getTotalClock() < 780) {
                        for (t = 0; t < this.bossmove.length; t += 5) {
                            if (this.bossmove[t + 2] == 0 || Main.engine.getTotalClock() % 390 <= this.bossmove[t] || Main.engine.getTotalClock() % 390 > this.bossmove[t + 1]) continue;
                            if (t == 10 && this.bonuscnt == 1) {
                                Sounds.sound(109);
                                Sounds.sound(69);
                                ++this.bonuscnt;
                            }
                            renderer.rotatesprite(this.bossmove[t + 3] << 16, this.bossmove[t + 4] << 16, 65536, 0, this.bossmove[t + 2], 0, 0, 218);
                        }
                    }
                    if (Main.engine.getTotalClock() >= 450 && Main.engine.getTotalClock() < 750) break;
                    if (Main.engine.getTotalClock() >= 750) {
                        renderer.rotatesprite(0x560000, 0x3B0000, 65536, 0, 3268, 0, 0, 218);
                        if (Main.engine.getTotalClock() >= 750 && this.bonuscnt == 2) {
                            Sounds.sound(56);
                            ++this.bonuscnt;
                        }
                    }
                    for (t = 0; t < this.breathe.length; t += 5) {
                        if (this.breathe[t + 2] == 0 || Main.engine.getTotalClock() % 120 <= this.breathe[t] || Main.engine.getTotalClock() % 120 > this.breathe[t + 1]) continue;
                        if (t == 5 && this.bonuscnt == 0) {
                            Sounds.sound(230);
                            ++this.bonuscnt;
                        }
                        renderer.rotatesprite(this.breathe[t + 3] << 16, this.breathe[t + 4] << 16, 65536, 0, this.breathe[t + 2], 0, 0, 218);
                    }
                    break;
                }
                renderer.rotatesprite(0, 655360, 63000, 0, 3292, 0, 0, 90);
                break;
            }
            case 1: {
                renderer.rotatesprite(0, 0, 65536, 0, 3293, 0, 0, 90);
                break;
            }
            case 3: {
                this.app.getFont(2).drawTextScaled(renderer, 160, 60, "THANKS TO ALL OUR", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                this.app.getFont(2).drawTextScaled(renderer, 160, 76, "FANS FOR GIVING", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                this.app.getFont(2).drawTextScaled(renderer, 160, 92, "US BIG HEADS.", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                this.app.getFont(2).drawTextScaled(renderer, 160, 118, "LOOK FOR A DUKE NUKEM 3D", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                this.app.getFont(2).drawTextScaled(renderer, 160, 134, "SEQUEL SOON.", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                break;
            }
            case 4: {
                renderer.rotatesprite(0, 0, 65536, 0, 5367, 0, 0, 90);
            }
        }
        if (Main.engine.getTotalClock() - this.gCutsClock < 200) {
            this.DrawEscText(Main.game.getFont(0));
        }
        Main.engine.nextpage(delta);
    }

    protected void DrawEscText(Font font) {
        Renderer renderer = Main.game.getRenderer();
        int shade = 16 + Pragmas.mulscale(16L, EngineUtils.sin(20 * Main.engine.getTotalClock() & 0x7FF), 16);
        font.drawTextScaled(renderer, 160, 5, "Press ESC to skip", 1.0f, shade, 251, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
    }

    public void episode1() {
        Gdx.app.postRunnable(() -> {
            Globals.ud.volume_number = 0;
            Main.game.changeScreen(Main.gEndScreen);
        });
    }

    public void episode2() {
        Gdx.app.postRunnable(() -> {
            Globals.ud.volume_number = 1;
            Sounds.sndStopMusic();
            Main.gAnmScreen.init("cineov2.anm", 1);
            Main.gAnmScreen.setCallback(() -> Main.game.changeScreen(Main.gEndScreen));
            Main.game.changeScreen(Main.gAnmScreen.escSkipping(true));
        });
    }

    public void episode3() {
        Gdx.app.postRunnable(() -> {
            Globals.ud.volume_number = 2;
            Sounds.sndStopMusic();
            Main.gAnmScreen.init("cineov3.anm", 2);
            Main.gAnmScreen.setCallback(() -> {
                Main.gAnmScreen.init("radlogo.anm", 3);
                Main.gAnmScreen.setCallback(() -> Main.game.changeScreen(Main.gStatisticScreen));
                Main.gAnmScreen.escSkipping(true);
            });
            Main.game.changeScreen(Main.gAnmScreen.escSkipping(true));
        });
    }

    public void episode4() {
        Gdx.app.postRunnable(() -> {
            Globals.ud.volume_number = 3;
            Sounds.sndStopMusic();
            Main.gAnmScreen.init("vol4e1.anm", 8);
            Main.gAnmScreen.setCallback(() -> {
                Sounds.sound(288);
                Main.game.changeScreen(Main.gEndScreen);
            });
            Main.game.changeScreen(Main.gAnmScreen.escSkipping(true));
        });
    }

    public void episode5() {
        Gdx.app.postRunnable(() -> {
            Globals.ud.volume_number = 4;
            Sounds.sndStopMusic();
            Sounds.sound(401);
            Main.game.changeScreen(Main.gEndScreen);
        });
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            this.onSkip();
            return true;
        }
        return false;
    }

    public void onSkip() {
        switch (Globals.ud.volume_number) {
            case 0: {
                if (this.bonuscnt < 4) {
                    this.bonuscnt = 4;
                    Main.engine.setbrightness(Globals.ud.brightness >> 2, Main.engine.getPaletteManager().getBasePalette());
                    Sounds.StopAllSounds();
                    break;
                }
                Main.engine.setbrightness(Globals.ud.brightness >> 2, Main.engine.getPaletteManager().getBasePalette());
                Sounds.sound(14);
                Main.game.changeScreen(Main.gStatisticScreen);
                break;
            }
            case 1: 
            case 4: {
                Main.engine.setbrightness(Globals.ud.brightness >> 2, Main.engine.getPaletteManager().getBasePalette());
                Sounds.sound(14);
                Main.game.changeScreen(Main.gStatisticScreen);
                break;
            }
            case 3: {
                Main.gAnmScreen.setCallback(() -> Main.game.changeScreen(Main.gStatisticScreen));
                Main.gAnmScreen.init("duketeam.anm", 4);
                Main.game.changeScreen(Main.gAnmScreen.escSkipping(false));
            }
        }
    }

    public void anyKeyPressed() {
        Main.game.getProcessor().prepareNext();
        this.gCutsClock = Main.engine.getTotalClock();
    }

    @Override
    public InputListener getInputListener() {
        return this;
    }

    @Override
    public void processInput(GameProcessor processor) {
        processor.prepareNext();
    }
}

