/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Premap;

public class PrecacheScreen
extends DefaultPrecacheScreen {
    public PrecacheScreen(Runnable toLoad, PrecacheListener listener) {
        super(Main.game, toLoad, listener);
        this.addQueue("Preload sounds...", this::precachenecessarysounds);
        this.addQueue("Preload floor and ceiling tiles...", () -> {
            Sector[] sectors;
            for (Sector sec : sectors = Main.boardService.getBoard().getSectors()) {
                this.addTile(sec.getFloorpicnum());
                this.addTile(sec.getCeilingpicnum());
            }
            this.doprecache(0);
            for (Sector sec : sectors) {
                if ((sec.getCeilingstat() & 1) == 0) continue;
                if (sec.getCeilingpicnum() == 89) {
                    for (int j = 0; j < 5; ++j) {
                        this.addTile(sec.getCeilingpicnum() + j);
                    }
                    continue;
                }
                this.addTile(sec.getCeilingpicnum());
            }
            this.doprecache(1);
        });
        this.addQueue("Preload wall tiles...", () -> {
            for (Wall wall : Main.boardService.getBoard().getWalls()) {
                int j;
                this.addTile(wall.getPicnum());
                switch (wall.getPicnum()) {
                    case 336: {
                        for (j = 0; j < 3; ++j) {
                            this.addTile(wall.getPicnum() + j);
                        }
                        break;
                    }
                    case 120: 
                    case 122: {
                        this.addTile(wall.getPicnum());
                        break;
                    }
                    case 268: 
                    case 269: 
                    case 270: {
                        for (int k = 268; k < 271; ++k) {
                            this.addTile(k);
                        }
                        break;
                    }
                }
                if (wall.getOverpicnum() < 0) continue;
                this.addTile(wall.getOverpicnum());
                if (wall.getOverpicnum() != 663) continue;
                for (j = 0; j < 3; ++j) {
                    this.addTile(663 + j);
                }
            }
            this.doprecache(0);
        });
        this.addQueue("Preload sprite tiles...", () -> {
            this.cachegoodsprites();
            for (int i = 0; i < Main.boardService.getSectorCount(); ++i) {
                for (ListNode<Sprite> j = Main.boardService.getSectNode(i); j != null; j = j.getNext()) {
                    Sprite spr = j.get();
                    if (spr.getXrepeat() == 0 || spr.getYrepeat() == 0 || (spr.getCstat() & 0x8000) != 0) continue;
                    this.cachespritenum(spr);
                }
            }
            this.doprecache(1);
        });
    }

    @Override
    public void draw(String title, int i) {
        Renderer renderer = this.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 3281, 0, 0, 74);
        if (Main.mUserFlag != Main.UserFlag.UserMap || Globals.boardfilename == null) {
            this.game.getFont(2).drawTextScaled(renderer, 160, 90, "Entering ", 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            if (Globals.currentGame.episodes[Globals.ud.volume_number] != null) {
                this.game.getFont(2).drawTextScaled(renderer, 160, 114, Globals.currentGame.episodes[Globals.ud.volume_number].getMapTitle(Globals.ud.level_number), 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            }
        } else {
            this.game.getFont(2).drawTextScaled(renderer, 160, 90, "Entering usermap", 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            this.game.getFont(2).drawTextScaled(renderer, 160, 114, Globals.boardfilename.getName(), 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        }
        this.game.getFont(1).drawTextScaled(renderer, 160, 146, title, 1.0f, -128, 10, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
    }

    private void precachenecessarysounds() {
        for (int i = 0; i < 500; ++i) {
            if (Globals.Sound[i].ptr != null) continue;
            Premap.getsound(i);
        }
    }

    private void cachespritenum(Sprite sp) {
        int j;
        if (Globals.ud.monsters_off && Actors.badguy(sp)) {
            return;
        }
        int maxc = 1;
        switch (sp.getPicnum()) {
            case 981: {
                this.addTile(950);
                for (j = 921; j < 925; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 569: {
                this.addTile(615);
                for (j = 921; j < 925; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 571: {
                this.addTile(573);
                for (j = 921; j < 925; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 1062: {
                maxc = 2;
                break;
            }
            case 921: {
                maxc = 4;
                break;
            }
            case 1280: {
                maxc = 44;
                break;
            }
            case 1680: 
            case 1681: 
            case 1715: 
            case 1725: 
            case 1741: 
            case 1744: {
                for (j = 1680; j < 1752; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 1768; j < 1779; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 904: {
                maxc = 5;
                for (j = 1026; j < 1030; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 4610: 
            case 4611: {
                maxc = 90;
                break;
            }
            case 1550: 
            case 2630: 
            case 2710: 
            case 2760: {
                maxc = 30;
                break;
            }
            case 1820: 
            case 1821: 
            case 1920: 
            case 1921: {
                maxc = 38;
                break;
            }
            case 1960: {
                maxc = 13;
                break;
            }
            case 2000: 
            case 2045: {
                maxc = 61;
                break;
            }
            case 2120: 
            case 2150: 
            case 2160: 
            case 2165: {
                for (j = 2201; j < 2212; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 80;
                break;
            }
            case 1405: {
                maxc = 0;
                if (Globals.ud.multimode <= 1) break;
                maxc = 5;
                for (j = 1420; j < 1526; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 100: {
                maxc = 14;
                break;
            }
            case 1880: {
                maxc = 10;
                break;
            }
            case 1079: 
            case 1238: 
            case 1247: {
                maxc = 3;
                break;
            }
            case 621: 
            case 1227: {
                maxc = 5;
            }
        }
        for (j = (int)sp.getPicnum(); j < sp.getPicnum() + maxc; j = (int)((short)(j + 1))) {
            this.addTile(j);
        }
    }

    private void cachegoodsprites() {
        int i;
        if (Globals.ud.screen_size >= 2) {
            this.addTile(2462);
            if (Globals.ud.multimode > 1) {
                this.addTile(2465);
                for (i = 3072; i < 3135; i = (int)((short)(i + 1))) {
                    this.addTile(i);
                }
            }
        }
        this.addTile(502);
        for (i = 2822; i < 2916; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 550; i < 553; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2940; i < 3022; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2270; i < 2284; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2310; i < 2324; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2324; i < 2328; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2524; i < 2527; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1890; i < 1911; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        this.addTile(952);
        for (i = 2528; i < 2536; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        this.addTile(550);
        for (i = 2245; i < 2270; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2400; i < 2419; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2329; i < 2333; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
    }
}

