/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import com.badlogic.gdx.audio.Music;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Architecture.common.audio.SourceListener;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Gameutils;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.SoundDefs;
import ru.m210projects.Duke3D.Types.Sample;
import ru.m210projects.Duke3D.Types.SoundOwner;
import ru.m210projects.Duke3D.filehandle.VOCDecoder;

public class Sounds {
    public static final int LOUDESTVOLUME = 150;
    public static final int NUM_SOUNDS = 500;
    private static final int[][] PitchTable = new int[][]{{65536, 65687, 65839, 65991, 66144, 66297, 66450, 66604, 66758, 66913, 67067, 67222, 67378, 67534, 67690, 67847, 68004, 68161, 68319, 68477, 68635, 68794, 68953, 69112, 69272}, {69432, 69593, 69754, 69915, 70077, 70239, 70402, 70565, 70728, 70891, 71055, 71220, 71384, 71550, 71715, 71881, 72047, 72214, 72381, 72548, 72716, 72884, 73053, 73222, 73391}, {73561, 73731, 73902, 74073, 74244, 74416, 74588, 74761, 74934, 75107, 75281, 75455, 75629, 75804, 75980, 76155, 76331, 76508, 76685, 76862, 77040, 77218, 77397, 77576, 77756}, {77935, 78116, 78296, 78477, 78659, 78841, 79023, 79206, 79389, 79573, 79757, 79942, 80126, 80312, 80498, 80684, 80870, 81057, 81245, 81433, 81621, 81810, 81999, 82189, 82379}, {82570, 82761, 82952, 83144, 83336, 83529, 83722, 83916, 84110, 84305, 84500, 84695, 84891, 85087, 85284, 85482, 85679, 85877, 86076, 86275, 86475, 86675, 86875, 87076, 87278}, {87480, 87682, 87885, 88088, 88292, 88496, 88701, 88906, 89112, 89318, 89524, 89731, 89939, 90147, 90356, 90565, 90774, 90984, 91194, 91405, 91617, 91829, 92041, 92254, 92468}, {92681, 92896, 93111, 93326, 93542, 93758, 93975, 94193, 94410, 94629, 94848, 95067, 95287, 95507, 95728, 95950, 96172, 96394, 96617, 96841, 97065, 97289, 97514, 97740, 97966}, {98193, 98420, 98647, 98876, 99104, 99334, 99563, 99794, 100024, 100256, 100488, 100720, 100953, 101187, 101421, 101655, 101890, 102126, 102362, 102599, 102837, 103074, 103313, 103552, 103791}, {104031, 104272, 104513, 104755, 104997, 105240, 105484, 105728, 105972, 106217, 106463, 106709, 106956, 107204, 107452, 107700, 107949, 108199, 108449, 108700, 108952, 109204, 109456, 109709, 109963}, {110217, 110472, 110728, 110984, 111241, 111498, 111756, 112015, 112274, 112533, 112794, 113055, 113316, 113578, 113841, 114104, 114368, 114633, 114898, 115164, 115430, 115697, 115965, 116233, 116502}, {116771, 117041, 117312, 117584, 117856, 118128, 118401, 118675, 118950, 119225, 119501, 119777, 120054, 120332, 120610, 120889, 121169, 121449, 121730, 122012, 122294, 122577, 122860, 123145, 123429}, {123715, 124001, 124288, 124576, 124864, 125152, 125442, 125732, 126023, 126315, 126607, 126900, 127193, 127487, 127782, 128078, 128374, 128671, 128969, 129267, 129566, 129866, 130166, 130467, 130769}};
    private static final int MAXDETUNE = 25;
    public static char rtsplaying;
    public static int numenvsnds;
    public static Entry userMusicEntry;
    public static Music currMusic;
    public static Entry currSongEntry;
    public static Directory pDukeLegacyDir;
    public static Commentary pCommentary;
    public static BuildAudio audio;
    private static float lastMusicVolume;

    public static void check_fta_sounds(int i) {
        Sprite sp = Main.boardService.getSprite(i);
        if (sp == null) {
            return;
        }
        if (sp.getExtra() > 0) {
            switch (sp.getPicnum()) {
                case 1680: 
                case 1681: 
                case 1715: 
                case 1725: 
                case 1741: 
                case 1742: 
                case 1744: {
                    Sounds.spritesound(111, i);
                    break;
                }
                case 2120: 
                case 2150: 
                case 2160: 
                case 2165: {
                    Sounds.spritesound(117, i);
                    break;
                }
                case 2000: 
                case 2045: {
                    Sounds.spritesound(121, i);
                    break;
                }
                case 1960: {
                    Sounds.spritesound(126, i);
                    break;
                }
                case 1880: {
                    Sounds.spritesound(131, i);
                    break;
                }
                case 1920: 
                case 1921: {
                    Sounds.spritesound(136, i);
                    break;
                }
                case 2420: {
                    Sounds.spritesound(146, i);
                    break;
                }
                case 1820: 
                case 1821: {
                    Sounds.spritesound(141, i);
                    break;
                }
                case 2630: {
                    Sounds.sound(97);
                    break;
                }
                case 2710: {
                    if (sp.getPal() == 1) {
                        Sounds.sound(102);
                        break;
                    }
                    Sounds.sound(294);
                    break;
                }
                case 2760: {
                    if (sp.getPal() == 1) {
                        Sounds.sound(151);
                        break;
                    }
                    Sounds.sound(284);
                    break;
                }
                case 4740: 
                case 4741: {
                    if (sp.getPal() == 1) {
                        Sounds.sound(342);
                    }
                    Sounds.sound(371);
                    break;
                }
                case 2370: {
                    Sounds.spritesound(26, i);
                }
            }
        }
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (currMusic != null) {
                currMusic.pause();
            }
            Sounds.StopAllSounds();
            Sounds.clearsoundlocks();
        } else if (!Main.cfg.isMuteMusic() && currMusic != null) {
            currMusic.play();
        }
    }

    public static void sndStopMusic() {
        if (currMusic != null) {
            currMusic.stop();
        }
        currMusic = null;
        currSongEntry = null;
    }

    public static void sndCheckMusic(Entry map) {
        if (map != null && map.exists()) {
            String mMapName = map.getName();
            userMusicEntry = map.getParent().getEntry(mMapName.substring(0, mMapName.lastIndexOf(46)) + ".ogg");
        }
    }

    public static void sndPlayMusic(String name) {
        String himus;
        if (Main.cfg.isMuteMusic()) {
            return;
        }
        lastMusicVolume = Sounds.calcMusicVolume();
        if (Main.cfg.getMusicType() != 0 && userMusicEntry != null) {
            if (currMusic != null && currMusic.isPlaying() && userMusicEntry.equals(currSongEntry)) {
                return;
            }
            Sounds.sndStopMusic();
            currMusic = Sounds.newMusic(userMusicEntry);
            if (currMusic != null) {
                currSongEntry = userMusicEntry;
                currMusic.setLooping(true);
                currMusic.setVolume(lastMusicVolume);
                currMusic.play();
                return;
            }
        }
        if (Main.cfg.getMusicType() == 1 && Main.game.currentDef != null && (himus = Main.game.currentDef.audInfo.getDigitalInfo(name)) != null) {
            Entry entry = Main.game.getCache().getEntry(himus, true);
            if (!entry.exists()) {
                return;
            }
            if (currMusic != null && currMusic.isPlaying() && entry.equals(currSongEntry)) {
                return;
            }
            Sounds.sndStopMusic();
            currMusic = Sounds.newMusic(entry);
            if (currMusic != null) {
                currSongEntry = entry;
                currMusic.setLooping(true);
                currMusic.setVolume(lastMusicVolume);
                currMusic.play();
                return;
            }
        }
        Sounds.playmusic(name);
    }

    public static void playmusic(String fn) {
        if (fn == null) {
            return;
        }
        Entry entry = Main.game.getCache().getEntry(fn, true);
        if (!entry.exists()) {
            entry = new FileEntry(Paths.get(fn, new String[0]), fn, 0L);
        }
        if (currMusic != null && currMusic.isPlaying() && entry.equals(currSongEntry)) {
            return;
        }
        if (entry.isExtension("ogg")) {
            Entry digitEntry;
            boolean midExist = false;
            if (Main.cfg.getMusicType() == 0) {
                String musName = entry.getName();
                Entry midEntry = Main.game.getCache().getEntry(musName.substring(0, musName.lastIndexOf(46)) + ".mid", true);
                if (midEntry.exists()) {
                    entry = midEntry;
                    midExist = true;
                }
            }
            if ((Main.cfg.getMusicType() != 0 || !midExist) && Globals.currentGame.getCON().type == 20 && (digitEntry = Main.game.getCache().getEntry(FileUtils.getPath("music", fn), true)).exists()) {
                entry = digitEntry;
            }
        }
        if (!entry.exists()) {
            return;
        }
        Sounds.sndStopMusic();
        currMusic = Sounds.newMusic(entry);
        if (currMusic != null) {
            currMusic.setLooping(true);
            currMusic.play();
            currMusic.setVolume(lastMusicVolume);
            currSongEntry = entry;
        }
    }

    public static void SoundStartup() {
        Main.cfg.setAudioDriver(Main.cfg.getAudioDriver());
        Main.cfg.setMidiDevice(Main.cfg.getMidiDevice());
        audio = Main.cfg.getAudio();
        audio.registerDecoder("VOC", new VOCDecoder());
        Directory gameDir = Main.game.getCache().getGameDirectory();
        pDukeLegacyDir = gameDir.getDirectory(gameDir.getEntry(FileUtils.getPath("sound", "Legacy_DukeTalk_OGG")));
        for (int i = 0; i < 500; ++i) {
            Globals.Sound[i] = new Sample();
            Globals.Sound[i].setGlobalSound((Globals.currentGame.getCON().soundm[i] & 0x10) != 0);
        }
    }

    public static void MusicStartup() {
    }

    public static float calcMusicVolume() {
        float vol = Main.cfg.getMusicVolume();
        if (Main.cfg.isMuteMusic()) {
            vol = 0.0f;
        }
        if (pCommentary != null && Sounds.pCommentary.handle != null && Sounds.pCommentary.handle.isActive()) {
            vol /= 4.0f;
        }
        return vol;
    }

    public static void MusicUpdate() {
        float vol = Sounds.calcMusicVolume();
        if (vol != lastMusicVolume) {
            if (currMusic != null) {
                currMusic.setVolume(vol);
            }
            lastMusicVolume = vol;
        }
    }

    public static int loadsound(int num) {
        if (Main.cfg.isNoSound()) {
            return 0;
        }
        Entry entry = Sounds.getSampleEntry(num);
        if (!entry.exists()) {
            Console.out.println("Sound (" + num + ") not found.");
            return 0;
        }
        Globals.soundsiz[num] = (int)entry.getSize();
        Globals.Sound[num].lock = 2;
        Sounds.loadSample(entry, num);
        return 1;
    }

    public static Entry getSampleEntry(int num) {
        FileEntry fil;
        if (num < 0 || num >= 500 || Globals.currentGame.getCON().sounds[num] == null) {
            return Directory.DUMMY_ENTRY;
        }
        Path filename = FileUtils.getPath(Globals.currentGame.getCON().sounds[num], new String[0]);
        if (Main.cfg.bLegacyDukeTalk && pDukeLegacyDir != null && (Globals.currentGame.getCON().soundm[num] & 4) != 0 && (fil = pDukeLegacyDir.getEntry(filename.getFileName())).exists()) {
            filename = fil.getRelativePath();
        }
        return Main.game.getCache().getEntry(filename, !Globals.loadfromgrouponly);
    }

    public static Source xyzsound(int num, int i, int x, int y, int z) {
        Source voice;
        int pitchs;
        short pitche;
        if (num < 0 || num >= 500 || (Globals.currentGame.getCON().soundm[num] & 8) != 0 && Globals.ud.lockout != 0 || Main.cfg.isNoSound() || Globals.Sound[num].getSoundOwnerCount() > 3 || !Sounds.isAvailable(Globals.currentGame.getCON().soundpr[num]) || Globals.ps[Mmulti.myconnectindex].timebeforeexit > 0 && Globals.ps[Mmulti.myconnectindex].timebeforeexit <= 78 || Main.game.menu.gShowMenu) {
            return null;
        }
        if ((Globals.currentGame.getCON().soundm[num] & 0x80) != 0) {
            Sounds.sound(num);
            return null;
        }
        Sprite sp = Main.boardService.getSprite(i);
        if (sp == null) {
            return null;
        }
        if ((Globals.currentGame.getCON().soundm[num] & 4) != 0) {
            Objects.requireNonNull(Main.cfg);
            if (Globals.ud.multimode > 1 && sp.getPicnum() == 1405 && sp.getYvel() != Globals.screenpeek && Globals.ud.coop != 1) {
                return null;
            }
            for (int j = 0; j < 500; ++j) {
                for (int k = 0; k < Globals.Sound[j].getSoundOwnerCount(); ++k) {
                    if (Globals.Sound[j].getSoundOwnerCount() <= 0 || (Globals.currentGame.getCON().soundm[j] & 4) == 0) continue;
                    return null;
                }
            }
        }
        int cx = Globals.ps[Globals.screenpeek].oposx;
        int cy = Globals.ps[Globals.screenpeek].oposy;
        int cz = Globals.ps[Globals.screenpeek].oposz;
        int cs = Globals.ps[Globals.screenpeek].cursectnum;
        int sndist = Gameutils.FindDistance3D(cx - x, cy - y, cz - z >> 4);
        Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (i >= 0 && sec != null && (Globals.currentGame.getCON().soundm[num] & 0x10) == 0 && sp.getPicnum() == 5 && sp.getLotag() < 999 && sec.getLotag() < 9) {
            sndist = Pragmas.divscale(sndist, sp.getHitag() + 1, 14);
        }
        int pitch = (cx = Pragmas.klabs((pitche = Globals.currentGame.getCON().soundpe[num]) - (pitchs = Globals.currentGame.getCON().soundps[num]))) != 0 ? (pitchs < pitche ? pitchs + Main.engine.rand() % cx : pitche + Main.engine.rand() % cx) : pitchs;
        if ((sndist += Globals.currentGame.getCON().soundvo[num]) < 0) {
            sndist = 0;
        }
        if (sndist != 0 && sp.getPicnum() != 5 && !Main.engine.cansee(cx, cy, cz - 6144, cs, sp.getX(), sp.getY(), sp.getZ() - 6144, sp.getSectnum())) {
            sndist += sndist >> 2;
        }
        Sector csec = Main.boardService.getSector(cs);
        switch (num) {
            case 9: 
            case 14: 
            case 17: {
                if (sndist > 6144) {
                    sndist = 6144;
                }
                if (csec == null || csec.getLotag() != 2) break;
                pitch -= 1024;
                break;
            }
            default: {
                if (csec != null && csec.getLotag() == 2 && (Globals.currentGame.getCON().soundm[num] & 4) == 0) {
                    pitch = -768;
                }
                if (sndist <= 31444 || sp.getPicnum() == 5) break;
                return null;
            }
        }
        if (Globals.Sound[num].getSoundOwnerCount() > 0 && sp.getPicnum() != 5) {
            if (Globals.Sound[num].getSoundOwner((int)0).i == i) {
                Sounds.stopsound(num);
            } else if (Globals.Sound[num].getSoundOwnerCount() > 1) {
                Sounds.stopsound(num);
            } else if (Actors.badguy(sp) && sp.getExtra() <= 0) {
                Sounds.stopsound(num);
            }
        }
        if (sp.getPicnum() == 1405 && sp.getYvel() == Globals.screenpeek) {
            sndist = 0;
        }
        if (Globals.Sound[num].ptr == null) {
            if (Sounds.loadsound(num) == 0) {
                return null;
            }
        } else {
            Globals.Sound[num].lock = Globals.Sound[num].lock < 200 ? 200 : ++Globals.Sound[num].lock;
            Globals.Sound[num].ptr.rewind();
        }
        if ((Globals.currentGame.getCON().soundm[num] & 0x10) != 0) {
            sndist = 0;
        }
        if (sndist < 6720) {
            sndist = 6720;
        }
        boolean looping = false;
        float volume = Sounds.calcVolume(sndist);
        if ((Globals.currentGame.getCON().soundm[num] & 1) != 0) {
            if (Globals.Sound[num].getSoundOwnerCount() > 0) {
                return null;
            }
            looping = true;
        }
        if ((voice = Sounds.newSound(Globals.Sound[num].ptr, Globals.Sound[num].rate, Globals.Sound[num].bits, Globals.currentGame.getCON().soundpr[num])) != null) {
            Globals.Sound[num].addSoundOwner(voice, i);
            voice.setListener(Globals.Sound[num]);
            voice.setPosition(x, z >> 4, y);
            voice.setPitch(Sounds.PITCH_GetScale(pitch));
            if (looping) {
                voice.loop(volume);
            } else {
                voice.play(volume);
            }
        } else {
            --Globals.Sound[num].lock;
        }
        return voice;
    }

    public static Source sound(int num) {
        Source voice;
        if (Main.cfg.isNoSound()) {
            return null;
        }
        if (num < 0 || num >= 500) {
            return null;
        }
        Objects.requireNonNull(Main.cfg);
        if ((Globals.currentGame.getCON().soundm[num] & 8) != 0 && Globals.ud.lockout != 0) {
            return null;
        }
        if (!Sounds.isAvailable(Globals.currentGame.getCON().soundpr[num])) {
            return null;
        }
        short pitche = Globals.currentGame.getCON().soundpe[num];
        int pitchs = Globals.currentGame.getCON().soundps[num];
        int cx = Pragmas.klabs(pitche - pitchs);
        int pitch = cx != 0 ? (pitchs < pitche ? pitchs + Main.engine.rand() % cx : pitche + Main.engine.rand() % cx) : pitchs;
        if (Globals.Sound[num].ptr == null) {
            if (Sounds.loadsound(num) == 0) {
                return null;
            }
        } else {
            Globals.Sound[num].lock = Globals.Sound[num].lock < 200 ? 200 : ++Globals.Sound[num].lock;
            Globals.Sound[num].ptr.rewind();
        }
        if ((voice = Sounds.newSound(Globals.Sound[num].ptr, Globals.Sound[num].rate, Globals.Sound[num].bits, Globals.currentGame.getCON().soundpr[num])) != null) {
            voice.setPitch(Sounds.PITCH_GetScale(pitch));
            voice.setListener(Globals.Sound[num]);
            if ((Globals.currentGame.getCON().soundm[num] & 1) != 0) {
                voice.loop(Sounds.calcVolume(150));
            } else {
                voice.play(Sounds.calcVolume(105));
            }
            return voice;
        }
        --Globals.Sound[num].lock;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void loadSample(Entry entry, int num) {
        extension = entry.getExtension();
        try {
            is = entry.getInputStream();
            try {
                var4_5 = StreamUtils.readString(is, 3);
                var5_7 = -1;
                switch (var4_5.hashCode()) {
                    case 81135: {
                        if (!var4_5.equals("RIF")) break;
                        var5_7 = 0;
                        break;
                    }
                    case 79215: {
                        if (!var4_5.equals("Ogg")) break;
                        var5_7 = 1;
                    }
                }
                switch (var5_7) {
                    case 0: {
                        extension = "WAV";
                        ** break;
lbl19:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        extension = "OGG";
                        break;
                    }
                    ** default:
lbl24:
                    // 1 sources

                    break;
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        soundData = Sounds.audio.getSoundDecoder(extension).decode(entry);
        if (soundData != null) {
            Globals.Sound[num].bits = soundData.getBits();
            Globals.Sound[num].rate = soundData.getRate();
            Globals.Sound[num].ptr = soundData.getData();
            return;
        }
        Console.out.println("Can't load sound[" + num + "]", OsdColor.RED);
        Globals.Sound[num].ptr = ByteBuffer.allocateDirect(0);
        Globals.Sound[num].rate = 0;
        Globals.Sound[num].bits = 8;
    }

    public static Source spritesound(int num, int i) {
        if (num < 0 || num >= 500) {
            return null;
        }
        Sprite sp = Main.boardService.getSprite(i);
        if (sp == null) {
            return null;
        }
        return Sounds.xyzsound(num, i, sp.getX(), sp.getY(), sp.getZ());
    }

    public static void stopsound(int num) {
        if (num < 0 || num >= 500) {
            return;
        }
        Globals.Sound[num].stopSound(-1);
    }

    public static void stopsound(int num, int i) {
        if (num < 0 || num >= 500) {
            return;
        }
        Globals.Sound[num].stopSound(i);
    }

    public static void StopAllSounds() {
        for (int i = 0; i < 500; ++i) {
            Sounds.stopsound(i);
        }
        Sounds.StopCommentary(pCommentary);
        Sounds.stopAllSounds();
    }

    public static void stopenvsound(int num, int i) {
        if (num < 0 || num >= 500) {
            return;
        }
        Globals.Sound[num].stopenvsound(i);
    }

    public static void pan3dsound() {
        short ca;
        int cs;
        int cz;
        int cy;
        int cx;
        numenvsnds = 0;
        Sprite cam = Main.boardService.getSprite(Globals.ud.camerasprite);
        if (cam == null) {
            cx = Globals.ps[Globals.screenpeek].oposx;
            cy = Globals.ps[Globals.screenpeek].oposy;
            cz = Globals.ps[Globals.screenpeek].oposz;
            cs = Globals.ps[Globals.screenpeek].cursectnum;
            ca = (short)(Globals.ps[Globals.screenpeek].ang + (float)Globals.ps[Globals.screenpeek].look_ang);
        } else {
            cx = cam.getX();
            cy = cam.getY();
            cz = cam.getZ();
            cs = cam.getSectnum();
            ca = cam.getAng();
        }
        audio.setListener(cx, cz >> 4, cy, ca);
        for (int j = 0; j < 500; ++j) {
            block4: for (int k = 0; k < Globals.Sound[j].getSoundOwnerCount(); ++k) {
                int sndist;
                SoundOwner soundOwner = Globals.Sound[j].getSoundOwner(k);
                Sprite sprite = Main.boardService.getSprite(soundOwner.i);
                if (sprite == null) continue;
                int sx = sprite.getX();
                int sy = sprite.getY();
                int sz = sprite.getZ();
                if (soundOwner.voice.isGlobal() || sprite.getPicnum() == 1405 && sprite.getYvel() == Globals.screenpeek) {
                    sndist = 0;
                } else {
                    sndist = Gameutils.FindDistance3D(cx - sx, cy - sy, cz - sz >> 4);
                    Sector sec = Main.boardService.getSector(sprite.getSectnum());
                    if (sec != null && soundOwner.i >= 0 && (Globals.currentGame.getCON().soundm[j] & 0x10) == 0 && sprite.getPicnum() == 5 && sprite.getLotag() < 999 && (sec.getLotag() & 0xFF) < 9) {
                        sndist = Pragmas.divscale(sndist, sprite.getHitag() + 1, 14);
                    }
                }
                if ((sndist += Globals.currentGame.getCON().soundvo[j]) < 0) {
                    sndist = 0;
                }
                if (sndist != 0 && sprite.getPicnum() != 5 && !Main.engine.cansee(cx, cy, cz - 6144, cs, sx, sy, sz - 6144, sprite.getSectnum())) {
                    sndist += sndist >> 5;
                }
                if (sprite.getPicnum() == 5 && sprite.getLotag() < 999) {
                    ++numenvsnds;
                }
                switch (j) {
                    case 9: 
                    case 14: 
                    case 17: {
                        if (sndist <= 6144) break;
                        sndist = 6144;
                        break;
                    }
                    default: {
                        if (sndist <= 31444 || sprite.getPicnum() == 5) break;
                        Sounds.stopsound(j);
                        continue block4;
                    }
                }
                if (Globals.Sound[j].ptr == null && Sounds.loadsound(j) == 0) continue;
                if ((Globals.currentGame.getCON().soundm[j] & 0x10) != 0) {
                    sndist = 0;
                }
                if (sndist < 6720) {
                    sndist = 6720;
                }
                soundOwner.voice.setPosition(sx, sz >> 4, sy);
                soundOwner.voice.setVolume(Sounds.calcVolume(sndist));
            }
        }
    }

    private static float calcVolume(int dist) {
        float vol = (float)(dist >> 6) / 255.0f;
        vol = Math.min(Math.max(vol, 0.0f), 1.0f);
        if (!Main.game.menu.gShowMenu && pCommentary != null && Sounds.pCommentary.handle != null && Sounds.pCommentary.handle.isActive()) {
            vol = 0.93f;
        }
        return 1.0f - vol;
    }

    public static void clearsoundlocks() {
        for (int i = 0; i < 500; ++i) {
            if (Globals.Sound[i].lock < 200) continue;
            Globals.Sound[i].lock = 199;
        }
    }

    private static float PITCH_GetScale(int pitchoffset) {
        if (pitchoffset == 0) {
            return (float)PitchTable[0][0] / 65536.0f;
        }
        int noteshift = pitchoffset % 1200;
        if (noteshift < 0) {
            noteshift += 1200;
        }
        int note = noteshift / 100;
        int detune = noteshift % 100 / 4;
        int octaveshift = (pitchoffset - noteshift) / 1200;
        int scale = PitchTable[note][detune];
        scale = octaveshift < 0 ? (scale >>= -octaveshift) : (scale <<= octaveshift);
        return (float)scale / 65536.0f;
    }

    public static boolean StartCommentary(int num, int spr) {
        SoundData snd;
        Sprite sp = Main.boardService.getSprite(spr);
        if (sp == null) {
            return false;
        }
        if (pCommentary != null && Main.cfg.bDevCommentry && (snd = Sounds.LoadCommentary(num)) != null) {
            Sounds.StopCommentary(pCommentary);
            Source voice = Sounds.newSound(snd.getData(), snd.getRate(), snd.getBits(), 255);
            if (voice != null) {
                for (int i = 0; i < 500; ++i) {
                    for (int j = 0; j < Globals.Sound[i].getSoundOwnerCount(); ++j) {
                        SoundOwner owner = Globals.Sound[i].getSoundOwner(j);
                        owner.voice.setVolume(0.3f);
                    }
                }
                voice.setListener(pCommentary);
                voice.play(Main.cfg.getSoundVolume());
                Sounds.pCommentary.handle = voice;
                Sounds.pCommentary.spr = sp;
                Sounds.pCommentary.picnum = sp.getPicnum();
                return true;
            }
        }
        return false;
    }

    public static void StopCommentary(Commentary commentary) {
        if (commentary != null && commentary.handle != null) {
            commentary.spr.setPicnum(commentary.picnum);
            commentary.handle.stop();
            commentary.handle = null;
            commentary.spr = null;
        }
    }

    public static void CommentaryVolume(Commentary commentary, float volume) {
        if (commentary != null && commentary.handle != null) {
            commentary.handle.setVolume(volume);
        }
    }

    public static SoundData LoadCommentary(int num) {
        if (SoundDefs.commentaries == null || Main.cfg.isNoSound()) {
            return null;
        }
        Entry fp = Main.game.getCache().getEntry(SoundDefs.commentaries.get(num), true);
        if (!fp.exists()) {
            Console.out.println("Commentary (" + num + ") not found.");
            return null;
        }
        return audio.getSoundDecoder(fp.getExtension()).decode(fp);
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, priority);
    }

    public static Music newMusic(Entry entry) {
        return audio.newMusic(entry);
    }

    public static boolean isAvailable(int priority) {
        return audio.canPlay(priority);
    }

    public static void stopAllSounds() {
        audio.stopAllSounds();
    }

    public static void setReverb(boolean enable, float delay) {
        audio.setReverb(enable, delay);
    }

    static {
        lastMusicVolume = 0.0f;
    }

    public static class Commentary
    implements SourceListener {
        public Source handle;
        public Sprite spr;
        public short picnum;

        @Override
        public void onStop() {
            Sounds.StopCommentary(this);
        }
    }
}

