/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Types;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Duke3D.Gamedef;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Types.GameInfo;
import ru.m210projects.Duke3D.filehandle.EpisodeEntry;

public class EpisodeManager {
    private final Map<String, GameInfo> episodeCache = new HashMap<String, GameInfo>();

    public List<EpisodeEntry> getEpisodeEntries(FileEntry file) {
        ArrayList<EpisodeEntry> list = new ArrayList<EpisodeEntry>();
        if (!file.exists()) {
            return list;
        }
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        Group group = file.getDirectory();
        if (!file.isDirectory()) {
            if (file.isExtension("con")) {
                group = file.getParent();
            } else {
                group = Main.game.getCache().getGroup(file.getRelativePath().toString());
                if (group.isEmpty()) {
                    group = Main.game.getCache().newGroup(file);
                }
            }
        }
        for (Entry entry : group) {
            List<Entry> includes;
            if (!entry.isExtension("con") || (includes = this.checkIncludes(entry)).isEmpty()) continue;
            if (file.isDirectory() || file.isExtension("con")) {
                entries.add(new EpisodeEntry.File((FileEntry)entry, includes));
                continue;
            }
            entries.add(new EpisodeEntry.Pack(file, entry, includes));
        }
        for (EpisodeEntry episodeEntry : entries) {
            GameInfo gameInfo = this.episodeCache.computeIfAbsent(episodeEntry.getHashKey(), e -> this.buildEpisode(entry));
            if (gameInfo == null) continue;
            list.add(episodeEntry);
        }
        return list;
    }

    public GameInfo getEpisode(EpisodeEntry entry) {
        if (entry != null) {
            return this.episodeCache.get(entry.getHashKey());
        }
        return null;
    }

    private GameInfo buildEpisode(EpisodeEntry file) {
        try {
            return new GameInfo(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Entry> checkIncludes(Entry confile) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        if (!confile.exists()) {
            return list;
        }
        Group parent = confile.getParent();
        byte[] buf = Gamedef.preparescript(confile.getBytes());
        int index = -1;
        while ((index = Strhandler.indexOf("include ", buf, index + 1)) != -1) {
            int textptr = index + 7;
            while (!Gamedef.isaltok(buf[textptr]) && buf[++textptr] != 0) {
            }
            int i = 0;
            while (textptr + i < buf.length && Gamedef.isaltok(buf[textptr + i])) {
                ++i;
            }
            Path path = FileUtils.getPath(new String(buf, textptr, i), new String[0]);
            Entry includedEntry = parent.getEntry(path);
            if (!includedEntry.exists()) {
                includedEntry = Main.game.getCache().getGroup(Main.game.mainGrp).getEntry(path);
            }
            if (includedEntry.exists()) {
                list.add(includedEntry);
                continue;
            }
            return new ArrayList<Entry>();
        }
        return list;
    }
}

