/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Types;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Types.ANIMATION;
import ru.m210projects.Duke3D.Types.Animwalltype;
import ru.m210projects.Duke3D.Types.GameInfo;
import ru.m210projects.Duke3D.Types.PlayerOrig;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.Types.Weaponhit;

public class SafeLoader {
    public Entry boardfilename;
    public GameInfo addon;
    public String addonFileName;
    public String addonPackedConName;
    public byte warp_on;
    public int gAnimationCount = 0;
    public final ANIMATION[] gAnimationData = new ANIMATION[512];
    public final short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public short connecthead;
    public final short[] connectpoint2 = new short[16];
    public int randomseed;
    public final BitMap show2dsector = new BitMap(1024);
    public Sector[] sector;
    public Wall[] wall;
    public List<Sprite> sprite;
    public final PlayerStruct[] ps = new PlayerStruct[16];
    public final PlayerOrig[] po = new PlayerOrig[16];
    public final Array<Weaponhit> hittype = new Array(true, Engine.MAXSPRITES, Weaponhit.class);
    public int multimode;
    public int volume_number;
    public int level_number;
    public int player_skill;
    public int from_bonus;
    public int secretlevel;
    public boolean respawn_monsters;
    public boolean respawn_items;
    public boolean respawn_inventory;
    public boolean god;
    public boolean monsters_off;
    public int auto_run;
    public int crosshair;
    public int last_level;
    public int eog;
    public int coop;
    public int marker;
    public int ffire;
    public short numplayersprites;
    public short global_random;
    public short earthquaketime;
    public short camsprite;
    public final short[][] frags = new short[16][16];
    public final int[] msx = new int[2048];
    public final int[] msy = new int[2048];
    public final Animwalltype[] animwall = new Animwalltype[512];
    public final short[][] cyclers = new short[256][6];
    public short numcyclers;
    public short numanimwalls;
    public final short[] spriteq = new short[1024];
    public short spriteqloc;
    public short spriteqamount;
    public final short[] mirrorwall = new short[64];
    public final short[] mirrorsector = new short[64];
    public short mirrorcnt;
    public short numclouds;
    public final short[] clouds = new short[128];
    public final short[] cloudx = new short[128];
    public final short[] cloudy = new short[128];
    public final IntArray actorscrptr = new IntArray(Engine.MAXTILES);
    public final ShortArray actortype = new ShortArray(Engine.MAXTILES);
    public final int[] script = new int[20460];
    private String message;

    public SafeLoader() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.ps[i] = new PlayerStruct();
            this.po[i] = new PlayerOrig();
        }
        for (i = 0; i < 512; ++i) {
            this.animwall[i] = new Animwalltype();
        }
        for (i = 0; i < 512; ++i) {
            this.gAnimationData[i] = new ANIMATION();
        }
    }

    public void LoadGDXBlock(InputStream is) throws IOException {
        this.warp_on = StreamUtils.readByte(is);
        if (this.warp_on == 1) {
            boolean isPacked = StreamUtils.readBoolean(is);
            this.addonFileName = StreamUtils.readDataString(is).toLowerCase();
            if (isPacked) {
                this.addonPackedConName = StreamUtils.readDataString(is).toLowerCase();
            }
        }
    }

    public void MapLoad(InputStream is) throws IOException {
        int i;
        this.boardfilename = Directory.DUMMY_ENTRY;
        String name = StreamUtils.readString(is, 144);
        if (!name.isEmpty()) {
            this.boardfilename = Main.game.getCache().getEntry(name, true);
        }
        this.sector = new Sector[StreamUtils.readInt(is)];
        for (i = 0; i < this.sector.length; ++i) {
            this.sector[i] = new Sector().readObject(is);
        }
        this.wall = new Wall[StreamUtils.readInt(is)];
        for (i = 0; i < this.wall.length; ++i) {
            this.wall[i] = new Wall().readObject(is);
        }
        int numSprites = StreamUtils.readInt(is);
        this.sprite = new ArrayList<Sprite>(numSprites * 2);
        for (int i2 = 0; i2 < numSprites; ++i2) {
            this.sprite.add(new Sprite().readObject(is));
        }
    }

    public void AnimationLoad(InputStream is) throws IOException {
        for (int i = 0; i < 512; ++i) {
            short index = StreamUtils.readShort(is);
            byte type = StreamUtils.readByte(is);
            this.gAnimationData[i].id = index;
            this.gAnimationData[i].type = type;
            this.gAnimationData[i].ptr = null;
            this.gAnimationData[i].goal = StreamUtils.readInt(is);
            this.gAnimationData[i].vel = StreamUtils.readInt(is);
            this.gAnimationData[i].sect = StreamUtils.readShort(is);
        }
        this.gAnimationCount = StreamUtils.readInt(is);
    }

    public void GameInfoLoad(InputStream is) throws IOException {
        int i;
        this.pskybits = StreamUtils.readShort(is);
        this.parallaxyscale = StreamUtils.readInt(is);
        for (i = 0; i < 256; ++i) {
            this.pskyoff[i] = StreamUtils.readShort(is);
        }
        this.earthquaketime = StreamUtils.readShort(is);
        this.from_bonus = StreamUtils.readShort(is);
        this.secretlevel = StreamUtils.readShort(is);
        this.respawn_monsters = StreamUtils.readBoolean(is);
        this.respawn_items = StreamUtils.readBoolean(is);
        this.respawn_inventory = StreamUtils.readBoolean(is);
        this.god = StreamUtils.readBoolean(is);
        this.auto_run = StreamUtils.readInt(is) == 1 ? 1 : 0;
        this.crosshair = StreamUtils.readInt(is) == 1 ? 1 : 0;
        this.monsters_off = StreamUtils.readBoolean(is);
        this.last_level = StreamUtils.readInt(is);
        this.eog = StreamUtils.readInt(is);
        this.coop = StreamUtils.readInt(is);
        this.marker = StreamUtils.readInt(is);
        this.ffire = StreamUtils.readInt(is);
        this.camsprite = StreamUtils.readShort(is);
        this.connecthead = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.connectpoint2[i] = StreamUtils.readShort(is);
        }
        this.numplayersprites = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.frags[i][j] = StreamUtils.readShort(is);
            }
        }
        this.randomseed = StreamUtils.readInt(is);
        this.global_random = StreamUtils.readShort(is);
    }

    public void StuffLoad(InputStream is) throws IOException {
        int i;
        this.numcyclers = StreamUtils.readShort(is);
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.cyclers[i][j] = StreamUtils.readShort(is);
            }
        }
        for (i = 0; i < 16; ++i) {
            this.ps[i].readObject(is);
        }
        for (i = 0; i < 16; ++i) {
            this.po[i].readObject(is);
        }
        this.numanimwalls = StreamUtils.readShort(is);
        for (i = 0; i < 512; ++i) {
            this.animwall[i].wallnum = StreamUtils.readShort(is);
            this.animwall[i].tag = StreamUtils.readInt(is);
        }
        for (i = 0; i < 2048; ++i) {
            this.msx[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 2048; ++i) {
            this.msy[i] = StreamUtils.readInt(is);
        }
        this.spriteqloc = StreamUtils.readShort(is);
        this.spriteqamount = StreamUtils.readShort(is);
        for (i = 0; i < 1024; ++i) {
            this.spriteq[i] = StreamUtils.readShort(is);
        }
        this.mirrorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 64; ++i) {
            this.mirrorwall[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 64; ++i) {
            this.mirrorsector[i] = StreamUtils.readShort(is);
        }
        this.show2dsector.readObject(is);
        this.numclouds = StreamUtils.readShort(is);
        for (i = 0; i < 128; ++i) {
            this.clouds[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 128; ++i) {
            this.cloudx[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 128; ++i) {
            this.cloudy[i] = StreamUtils.readShort(is);
        }
    }

    public void ConLoad(InputStream is) throws IOException {
        int i;
        int len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.actortype.add((short)StreamUtils.readUnsignedByte(is));
        }
        len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.script[i] = StreamUtils.readInt(is);
        }
        len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.actorscrptr.add(StreamUtils.readInt(is));
        }
        len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            Weaponhit weaponhit = new Weaponhit();
            weaponhit.readObject(is);
            this.hittype.add(weaponhit);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public GameInfo LoadGDXHeader(InputStream is) throws IOException {
        this.volume_number = -1;
        this.level_number = -1;
        this.player_skill = -1;
        this.warp_on = 0;
        this.addon = null;
        this.addonFileName = null;
        this.addonPackedConName = null;
        StreamUtils.skip(is, 40);
        this.multimode = StreamUtils.readInt(is);
        this.volume_number = StreamUtils.readInt(is);
        this.level_number = StreamUtils.readInt(is);
        this.player_skill = StreamUtils.readInt(is);
        StreamUtils.skip(is, 16000);
        this.LoadGDXBlock(is);
        if (this.warp_on == 1) {
            this.addon = SafeLoader.findAddon(this.addonFileName, this.addonPackedConName);
        }
        return this.addon;
    }

    public boolean load(InputStream is) {
        this.message = null;
        this.hittype.clear();
        this.actorscrptr.clear();
        this.actortype.clear();
        try {
            this.addon = this.LoadGDXHeader(is);
            this.MapLoad(is);
            this.StuffLoad(is);
            this.ConLoad(is);
            this.AnimationLoad(is);
            this.GameInfoLoad(is);
            if (this.warp_on == 1 && this.addon == null) {
                this.message = "Can't find user episode file: " + this.addonFileName;
                this.warp_on = (byte)2;
                this.volume_number = 0;
                this.level_number = 7;
            }
            System.out.println(is.available());
            if (is.available() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static GameInfo findAddon(String addonFileName, String conName) {
        try {
            FileEntry addonEntry = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(addonFileName, new String[0]));
            if (addonEntry.exists()) {
                if (conName == null) {
                    conName = addonEntry.getName();
                }
                String finalIniName = conName;
                return ResourceHandler.episodeManager.getEpisodeEntries(addonEntry).stream().filter(e -> e.getConFile().getName().equalsIgnoreCase(finalIniName)).map(ResourceHandler.episodeManager::getEpisode).findAny().orElse(null);
            }
        }
        catch (Exception e2) {
            Console.out.println(e2.toString(), OsdColor.RED);
        }
        return null;
    }
}

