/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.filehandle;

import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Duke3D.Main;

public interface EpisodeEntry {
    public String getHashKey();

    public FileEntry getFileEntry();

    public Entry getConFile();

    public Group getGroup();

    public boolean isPackageEpisode();

    public List<Entry> getIncludes();

    public String getName();

    public static class File
    extends FileEntry
    implements EpisodeEntry {
        private final List<Entry> includes;

        public File(FileEntry fileEntry, List<Entry> includes) {
            super(fileEntry);
            this.includes = includes;
        }

        @Override
        public String getHashKey() {
            return this.getRelativePath().toString().toUpperCase(Locale.ROOT);
        }

        @Override
        public FileEntry getFileEntry() {
            return this;
        }

        @Override
        public Entry getConFile() {
            return this;
        }

        @Override
        public Group getGroup() {
            return this.getParent();
        }

        @Override
        public boolean isPackageEpisode() {
            return false;
        }

        @Override
        public List<Entry> getIncludes() {
            return this.includes;
        }
    }

    public static class Pack
    extends FileEntry
    implements EpisodeEntry {
        private final Entry conFile;
        private final FileEntry groupFile;
        private final List<Entry> includes;

        public Pack(FileEntry group, Entry conFile, List<Entry> includes) {
            super(group.getPath(), String.format("%s:%s", group.getName(), conFile.getName()), group.getSize());
            this.conFile = conFile;
            this.groupFile = group;
            this.setParent(group.getParent());
            this.includes = includes;
        }

        @Override
        public String getHashKey() {
            return String.format("%s:%s", this.groupFile.getRelativePath().toString().toUpperCase(Locale.ROOT), this.conFile.getName().toUpperCase(Locale.ROOT));
        }

        @Override
        public FileEntry getFileEntry() {
            return this.groupFile;
        }

        @Override
        public Entry getConFile() {
            return this.conFile;
        }

        @Override
        public Group getGroup() {
            return Main.game.getCache().newGroup(this.groupFile);
        }

        @Override
        public boolean isPackageEpisode() {
            return true;
        }

        @Override
        public List<Entry> getIncludes() {
            return this.includes;
        }

        @Override
        public String getExtension() {
            return this.groupFile.getExtension();
        }
    }
}

