/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.filehandle;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.filehandle.StreamUtils;

public class LZWInputStream
extends InputStream {
    private static final int LZWSIZE = 16385;
    private final byte[] lzwbuf1;
    private final byte[] lzwbuf4;
    private final byte[] lzwbuf5;
    private final short[] lzwbuf2;
    private final short[] lzwbuf3;
    private final byte[] blockBuffer;
    private int blockPos;
    private final InputStream in;
    private int pos;
    private int count;

    public LZWInputStream(InputStream in, int blockSize) {
        this.in = in;
        this.blockBuffer = new byte[blockSize];
        this.blockPos = 0;
        this.lzwbuf1 = new byte[17409];
        this.lzwbuf2 = new short[17409];
        this.lzwbuf3 = new short[17409];
        this.lzwbuf4 = new byte[16385];
        this.lzwbuf5 = new byte[17409];
    }

    protected void fill() throws IOException {
        short len = StreamUtils.readShort(this.in);
        StreamUtils.readBytes(this.in, this.lzwbuf5, len);
        if (this.pos <= 16385 - this.blockBuffer.length) {
            this.flush();
        }
        this.count = this.lzwuncompress(this.lzwbuf5, len, this.lzwbuf4);
        this.pos = 0;
    }

    public void flush() {
        Arrays.fill(this.blockBuffer, (byte)0);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        int n = this.blockPos;
        this.blockBuffer[n] = (byte)(this.blockBuffer[n] + this.lzwbuf4[this.blockPos + this.pos]);
        int result = this.blockBuffer[this.blockPos++] & 0xFF;
        if (this.blockPos >= this.blockBuffer.length) {
            this.pos += this.blockBuffer.length;
            this.blockPos = 0;
        }
        return result;
    }

    private int lzwuncompress(byte[] lzwinbuf, int compleng, byte[] lzwoutbuf) {
        ByteBuffer inbuf = ByteBuffer.wrap(lzwinbuf);
        inbuf.order(ByteOrder.LITTLE_ENDIAN);
        short strtot = inbuf.getShort(2);
        inbuf.position(4);
        if (strtot == 0) {
            inbuf.get(lzwoutbuf, 0, compleng - 4 + 3);
            return inbuf.getShort(0);
        }
        for (int i = 255; i >= 0; --i) {
            this.lzwbuf2[i] = (short)i;
            this.lzwbuf3[i] = (short)i;
        }
        short currstr = 256;
        int bitcnt = 32;
        int outbytecnt = 0;
        int numbits = 8;
        int oneupnumbits = 256;
        do {
            int intptr = inbuf.getInt(bitcnt >> 3);
            int dat = intptr >> (bitcnt & 7) & oneupnumbits - 1;
            bitcnt += numbits;
            if ((dat & (oneupnumbits >> 1) - 1) > (currstr - 1 & (oneupnumbits >> 1) - 1)) {
                dat &= (oneupnumbits >> 1) - 1;
                --bitcnt;
            }
            this.lzwbuf3[currstr] = (short)dat;
            int leng = 0;
            while (dat >= 256) {
                this.lzwbuf1[leng] = (byte)this.lzwbuf2[dat];
                ++leng;
                dat = this.lzwbuf3[dat];
            }
            lzwoutbuf[outbytecnt++] = (byte)dat;
            for (int i = leng - 1; i >= 0; --i) {
                lzwoutbuf[outbytecnt++] = this.lzwbuf1[i];
            }
            this.lzwbuf2[currstr - 1] = (short)dat;
            this.lzwbuf2[currstr] = (short)dat;
            if (++currstr <= oneupnumbits) continue;
            ++numbits;
            oneupnumbits <<= 1;
        } while (currstr < strtot);
        return inbuf.getShort(0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

