/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.filehandle.rts;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Duke3D.filehandle.rts.LumpInfo;

public class RTSFile
implements Group {
    protected final List<LumpInfo> entries;
    private final String name;

    public RTSFile(String filename, InputStreamProvider provider) throws IOException {
        this.name = filename.toUpperCase();
        Console.out.println("    Adding " + filename);
        try (BufferedInputStream is = new BufferedInputStream(provider.newInputStream());){
            String identification = StreamUtils.readString(is, 4);
            if (!identification.equalsIgnoreCase("IWAD")) {
                throw new RuntimeException("RTS file " + filename + " doesn't have IWAD id");
            }
            int infonumlumps = StreamUtils.readInt(is);
            int infotableofs = StreamUtils.readInt(is);
            this.entries = new ArrayList<LumpInfo>(infonumlumps);
            int skipBytes = infotableofs - 12;
            StreamUtils.skip(is, skipBytes);
            for (int i = 0; i < infonumlumps; ++i) {
                int offset = StreamUtils.readInt(is);
                int size = StreamUtils.readInt(is);
                String name = StreamUtils.readString(is, 8);
                LumpInfo entry = new LumpInfo(provider, name, offset, size);
                entry.parent = this;
                if (size <= 0) continue;
                this.entries.add(entry);
            }
        }
    }

    @Override
    public synchronized int getSize() {
        return this.entries.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries);
    }

    @Override
    public Entry getEntry(String name) {
        return Directory.DUMMY_ENTRY;
    }

    public Entry getEntry(int lump) {
        if (lump < 0 || lump >= this.entries.size()) {
            return Directory.DUMMY_ENTRY;
        }
        return this.entries.get(lump);
    }
}

