/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Screens.GameScreen;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Sprites;
import ru.m210projects.LSP.Types.PlayerStruct;

public class Enemies {
    public static final int[] gEnemyClock = new int[Engine.MAXSPRITES];
    public static final short[] gMoveStatus = new short[Engine.MAXSPRITES];
    public static final short[] nKills = new short[6];
    public static final short[] nTotalKills = new short[6];
    public static int nEnemyKills;
    public static int nEnemyMax;
    private static final Object[] attackFrames;
    private static final short[] timeCounter;
    private static final short[] frameIndex;
    private static final Frame[] blueattack;
    private static final Callback greencallback;
    private static final Frame[] greenattack;
    private static final Callback redcallback;
    private static final Frame[] redattack;
    private static final Callback purpcallback;
    private static final Frame[] purpattack;
    private static final Callback yellowcallback;
    private static final Frame[] yellattack;
    private static int ocount;
    private static BuildPos out;

    private static void setframes(int i, Frame[] frms) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr != null) {
            spr.setExtra(spr.getPicnum());
            Enemies.frameIndex[i] = 0;
            Enemies.attackFrames[i] = frms;
            spr.setPicnum(frms[0].tile);
            Enemies.timeCounter[i] = frms[0].ticksPerFrame;
        }
    }

    private static boolean frameprocess(Frame[] frms, int sn) {
        int n = sn;
        timeCounter[n] = (short)(timeCounter[n] - 4);
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return false;
        }
        if (Main.cfg.bOriginal) {
            switch (spr.getExtra()) {
                case 1792: {
                    greencallback.invoke(sn);
                    break;
                }
                case 2048: {
                    redcallback.invoke(sn);
                    break;
                }
                case 2304: {
                    purpcallback.invoke(sn);
                    break;
                }
                case 2560: {
                    yellowcallback.invoke(sn);
                }
            }
        }
        if (timeCounter[sn] < 0) {
            int n2 = sn;
            frameIndex[n2] = (short)(frameIndex[n2] + 1);
            if (frameIndex[n2] >= frms.length) {
                spr.setPicnum(spr.getExtra());
                Main.engine.changespritestat(sn, 1);
                Enemies.attackFrames[sn] = null;
                return true;
            }
            Frame frm = frms[frameIndex[sn]];
            int n3 = sn;
            timeCounter[n3] = (short)(timeCounter[n3] + frm.ticksPerFrame);
            if (frm.trigger != null) {
                frm.trigger.invoke(sn);
            }
            spr.setPicnum(frm.tile);
        }
        return false;
    }

    @Nullable
    private static Sprite buildProjectile(int i, int target, int dang) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return null;
        }
        int j = Main.engine.insertsprite(spr.getSectnum(), 6);
        if (j == -1) {
            return null;
        }
        Sprite nspr = Main.boardService.getSprite(j);
        if (nspr == null) {
            return null;
        }
        nspr.setX(spr.getX());
        nspr.setY(spr.getY());
        nspr.setZ(spr.getZ());
        nspr.setCstat(128);
        nspr.setXrepeat(64);
        nspr.setYrepeat(64);
        int dx = Globals.gPlayer[target].x - spr.getX();
        int dy = Globals.gPlayer[target].y - spr.getY();
        nspr.setAng((short)(EngineUtils.getAngle(dx, dy) + dang & 0x7FF));
        nspr.setXvel((short)(EngineUtils.sin(nspr.getAng() + 2560 & 0x7FF) >> 6));
        nspr.setYvel((short)(EngineUtils.sin(nspr.getAng() + 2048 & 0x7FF) >> 6));
        nspr.setZvel((short)((Globals.gPlayer[target].z + 8192 - nspr.getZ() << 8) / EngineUtils.sqrt(dx * dx + dy * dy)));
        nspr.setOwner((short)i);
        nspr.setHitag((short)target);
        return nspr;
    }

    public static void inienemies() {
        Arrays.fill(gEnemyClock, 0);
        Arrays.fill(attackFrames, null);
        Arrays.fill(timeCounter, (short)0);
        Arrays.fill(frameIndex, (short)0);
        Arrays.fill(gMoveStatus, (short)1);
        Arrays.fill(nKills, (short)0);
        Arrays.fill(nTotalKills, (short)0);
        nEnemyKills = 0;
        nEnemyMax = 0;
        Main.engine.getTile(1556).disableAnimation();
        Main.engine.getTile(1812).disableAnimation();
        Main.engine.getTile(2068).disableAnimation();
        Main.engine.getTile(2324).disableAnimation();
        Main.engine.getTile(2580).disableAnimation();
        block14: for (int i = 0; i < Engine.MAXSPRITES; i = (int)((short)(i + 1))) {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                return;
            }
            if (spr.getStatnum() >= 32) continue;
            switch (spr.getPicnum()) {
                case 232: 
                case 1410: {
                    Main.engine.changespritestat(i, 2);
                    spr.setLotag(9999);
                    break;
                }
                case 1536: {
                    Main.engine.changespritestat(i, 2);
                    spr.setLotag(24);
                    nTotalKills[1] = (short)(nTotalKills[1] + 1);
                    ++nEnemyMax;
                    break;
                }
                case 1792: {
                    Main.engine.changespritestat(i, 2);
                    spr.setLotag(48);
                    nTotalKills[2] = (short)(nTotalKills[2] + 1);
                    ++nEnemyMax;
                    break;
                }
                case 2048: {
                    Main.engine.changespritestat(i, 2);
                    spr.setLotag(72);
                    nTotalKills[3] = (short)(nTotalKills[3] + 1);
                    ++nEnemyMax;
                    break;
                }
                case 2304: {
                    Main.engine.changespritestat(i, 2);
                    spr.setLotag(240);
                    nTotalKills[4] = (short)(nTotalKills[4] + 1);
                    ++nEnemyMax;
                    break;
                }
                case 2560: {
                    Main.engine.changespritestat(i, 2);
                    spr.setLotag(480);
                    nTotalKills[5] = (short)(nTotalKills[5] + 1);
                    ++nEnemyMax;
                }
            }
            switch (spr.getPicnum()) {
                case 50: 
                case 232: 
                case 1410: 
                case 1536: 
                case 1600: 
                case 1700: 
                case 1792: 
                case 2048: 
                case 2304: 
                case 2560: {
                    spr.setCstat(spr.getCstat() | 0x101);
                }
            }
            if (Globals.nNextMap != 6) continue;
            switch (spr.getPicnum()) {
                case 249: 
                case 1116: 
                case 1126: 
                case 1136: 
                case 1146: 
                case 1156: 
                case 1166: 
                case 1179: 
                case 1192: 
                case 1203: 
                case 1214: 
                case 1225: 
                case 1259: 
                case 1328: 
                case 1335: 
                case 1341: 
                case 1345: 
                case 1354: 
                case 1358: 
                case 1364: 
                case 1369: 
                case 1374: 
                case 1840: 
                case 1844: 
                case 2096: 
                case 2352: 
                case 2356: 
                case 2608: {
                    Main.engine.deletesprite(i);
                    continue block14;
                }
            }
        }
    }

    public static void enemydie(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null || spr.getStatnum() == 20) {
            return;
        }
        switch (spr.getPicnum()) {
            case 1536: {
                nKills[1] = (short)(nKills[1] + 1);
                ++nEnemyKills;
                break;
            }
            case 1792: {
                nKills[2] = (short)(nKills[2] + 1);
                ++nEnemyKills;
                break;
            }
            case 2048: {
                nKills[3] = (short)(nKills[3] + 1);
                ++nEnemyKills;
                break;
            }
            case 2304: {
                nKills[4] = (short)(nKills[4] + 1);
                ++nEnemyKills;
                break;
            }
            case 2560: {
                nKills[5] = (short)(nKills[5] + 1);
                ++nEnemyKills;
            }
        }
        for (int sec = 0; sec < Main.boardService.getSectorCount(); sec = (int)((short)(sec + 1))) {
            block11: for (ListNode<Sprite> node = Main.boardService.getSectNode(sec); node != null; node = node.getNext()) {
                int j = node.getIndex();
                Sprite pspr = node.get();
                switch (pspr.getPicnum()) {
                    case 1536: 
                    case 1792: 
                    case 2048: 
                    case 2304: 
                    case 2560: {
                        if (!Main.engine.cansee(spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum(), pspr.getX(), pspr.getY(), pspr.getZ() - (Main.engine.getTile(pspr.getPicnum()).getHeight() << 7), pspr.getSectnum()) || pspr.getStatnum() != 2) continue block11;
                        Main.engine.changespritestat(j, 1);
                    }
                }
            }
        }
        if (spr.getPicnum() != 2304 && spr.getPicnum() != 2560) {
            spr.setPicnum(spr.getPicnum() + 4 * (Main.engine.krand() & 1) + 28);
        } else {
            spr.setPicnum(spr.getPicnum() + 28);
        }
        spr.setCstat(0);
        spr.setLotag(240);
        spr.setOwner(spr.getPicnum());
        Main.engine.changespritestat((short)i, 20);
    }

    private static int findplayer(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return -1;
        }
        int mindist = Integer.MAX_VALUE;
        short target = Mmulti.connecthead;
        short p = Mmulti.connecthead;
        while (p >= 0) {
            int dist = Pragmas.klabs(spr.getX() - Globals.gPlayer[p].x) + Pragmas.klabs(spr.getY() - Globals.gPlayer[p].y);
            if (dist < mindist) {
                mindist = dist;
                target = p;
            }
            p = Mmulti.connectpoint2[p];
        }
        return target;
    }

    public static void moveenemies() {
        ListNode<Sprite> next;
        int count = 0;
        ListNode<Sprite> node = Main.boardService.getStatNode(21);
        while (node != null) {
            next = node.getNext();
            int i = node.getIndex();
            Sprite spr = node.get();
            switch (spr.getExtra()) {
                case 1536: 
                case 1792: 
                case 2048: 
                case 2304: 
                case 2560: {
                    if (Enemies.frameprocess((Frame[])attackFrames[i], i)) break;
                    ++count;
                }
            }
            node = next;
        }
        node = Main.boardService.getStatNode(1);
        while (node != null) {
            next = node.getNext();
            int target = Enemies.findplayer(node.getIndex());
            int v56 = Main.engine.krand();
            Sprite spr = node.get();
            int i = node.getIndex();
            switch (spr.getPicnum()) {
                case 232: {
                    int j;
                    Sprite spr2;
                    if (!Main.cfg.bOriginal && Globals.totalmoves % 4 != 0 || !Main.engine.cansee(Globals.gPlayer[target].x, Globals.gPlayer[target].y, Globals.gPlayer[target].z, Globals.gPlayer[target].sectnum, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(232).getHeight() << 7), spr.getSectnum()) || (Main.engine.krand() & 3) != 0 || (spr2 = Main.boardService.getSprite(j = Main.engine.insertsprite(spr.getSectnum(), 6))) == null) break;
                    spr2.setX(spr.getX());
                    spr2.setY(spr.getY());
                    spr2.setZ(spr.getZ() - 2560);
                    spr2.setCstat(128);
                    spr2.setPicnum(1179);
                    spr2.setShade(-20);
                    spr2.setXrepeat(32);
                    spr2.setYrepeat(32);
                    spr2.setAng((short)(Main.engine.krand() & 0x7FF));
                    spr2.setXvel((short)(EngineUtils.sin(spr2.getAng() + 2560 & 0x7FF) >> 6));
                    spr2.setYvel((short)(EngineUtils.sin(spr2.getAng() + 2048 & 0x7FF) >> 6));
                    int dx = Globals.gPlayer[target].x - spr2.getY();
                    int dy = Globals.gPlayer[target].y - spr2.getX();
                    spr2.setZvel((short)((Globals.gPlayer[target].z + 2048 - spr2.getZ() << 8) / EngineUtils.sqrt(dx * dx + dy * dy)));
                    spr2.setOwner(i);
                    spr2.setLotag(-8);
                    break;
                }
                case 1410: {
                    int j;
                    Sprite spr2;
                    if (!Main.cfg.bOriginal && Globals.totalmoves % 4 != 0 || !Main.engine.cansee(spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum(), Globals.gPlayer[target].x, Globals.gPlayer[target].y, Globals.gPlayer[target].z, Globals.gPlayer[target].sectnum) || (Main.engine.krand() & 7) != 0 || (spr2 = Main.boardService.getSprite(j = Main.engine.insertsprite(spr.getSectnum(), 6))) == null) break;
                    spr2.setX(spr.getX());
                    spr2.setY(spr.getY());
                    spr2.setZ(spr.getZ() - 2560);
                    spr2.setCstat(128);
                    spr2.setPicnum(1322);
                    spr2.setShade(-20);
                    spr2.setXrepeat(32);
                    spr2.setYrepeat(32);
                    int dx = Globals.gPlayer[target].x - spr.getX();
                    int dy = Globals.gPlayer[target].y - spr.getY();
                    spr2.setAng((short)((Main.engine.krand() & 1) + EngineUtils.getAngle(dx, dy) + 2040 & 0x7FF));
                    spr2.setXvel((short)(EngineUtils.sin(spr2.getAng() + 2560 & 0x7FF) >> 6));
                    spr2.setYvel((short)(EngineUtils.sin(spr2.getAng() + 2048 & 0x7FF) >> 6));
                    spr2.setZvel((short)((Globals.gPlayer[target].z + 2048 - spr2.getZ() << 8) / EngineUtils.sqrt(dx * dx + dy * dy)));
                    spr2.setOwner(i);
                    spr2.setLotag(-16);
                    Sounds.playsound(0, i);
                    break;
                }
                case 1536: 
                case 1792: 
                case 2048: 
                case 2304: 
                case 2560: {
                    boolean canAttack;
                    Sector sec = Main.boardService.getSector(spr.getSectnum());
                    if (sec == null) break;
                    ++count;
                    if (Globals.lockclock - gEnemyClock[i] < 0) {
                        Enemies.gEnemyClock[i] = Globals.lockclock;
                    }
                    Main.game.pInt.setsprinterpolate(i, spr);
                    if (spr.getZ() < sec.getFloorz()) {
                        spr.setZ(spr.getZ() + 1152);
                    }
                    int h = Main.engine.getTile(spr.getPicnum()).getHeight() * spr.getYrepeat() << 2;
                    int zTop = spr.getZ() - h;
                    if (spr.getZ() >= sec.getFloorz() && zTop < sec.getFloorz()) {
                        spr.setZ(sec.getFloorz());
                    }
                    if (sec.getLotag() == 4 || sec.getLotag() == 5) {
                        spr.setZ(sec.getFloorz() + h / 2);
                    }
                    int dx = Globals.gPlayer[target].x - spr.getX();
                    int dy = Globals.gPlayer[target].y - spr.getY();
                    int dz = Globals.gPlayer[target].z + 8192 - spr.getZ();
                    int ang = EngineUtils.getAngle(dx, dy);
                    int dang = (1024 + ang - spr.getAng() & 0x7FF) - 1024;
                    boolean cansee = Main.engine.cansee(Globals.gPlayer[target].x, Globals.gPlayer[target].y, Globals.gPlayer[target].z, Globals.gPlayer[target].sectnum, spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum());
                    if (spr.getPicnum() == 1536) {
                        canAttack = false;
                        if (cansee && Pragmas.klabs(dx) + Pragmas.klabs(dy) < 1024 && Pragmas.klabs(dz) < 8192) {
                            spr.setAng(ang);
                            canAttack = true;
                        }
                    } else {
                        canAttack = cansee;
                    }
                    if (v56 % 10 == 9 && gMoveStatus[i] != 1) {
                        if (gMoveStatus[i] == 2 && Globals.lockclock - gEnemyClock[i] > 180 || gMoveStatus[i] == 0) {
                            Enemies.gMoveStatus[i] = 1;
                            Enemies.gEnemyClock[i] = Globals.lockclock;
                        }
                    } else if (v56 % 10 == 0 && Pragmas.klabs(dang) < 256) {
                        if (Globals.lockclock - gEnemyClock[i] > 60) {
                            if (canAttack && Globals.gPlayer[target].nHealth > 0) {
                                spr.setHitag(target);
                                switch (spr.getPicnum()) {
                                    case 1792: {
                                        Enemies.setframes(i, greenattack);
                                        break;
                                    }
                                    case 2048: {
                                        Enemies.setframes(i, redattack);
                                        break;
                                    }
                                    case 2304: {
                                        Enemies.setframes(i, purpattack);
                                        break;
                                    }
                                    case 2560: {
                                        Enemies.setframes(i, yellattack);
                                        break;
                                    }
                                    case 1536: {
                                        Enemies.setframes(i, blueattack);
                                    }
                                }
                                Main.engine.changespritestat(i, 21);
                                Enemies.gMoveStatus[i] = 0;
                                break;
                            }
                            Enemies.gEnemyClock[i] = Globals.lockclock;
                        }
                    } else if (Globals.lockclock - gEnemyClock[i] > 120) {
                        spr.setAng(ang);
                        int v30 = (Main.engine.krand() & 0x100) - 128;
                        spr.setAng((short)(v30 + spr.getAng() & 0x7FF));
                        Enemies.gEnemyClock[i] = Globals.lockclock;
                    }
                    if (gMoveStatus[i] == 0) break;
                    Enemies.out.x = EngineUtils.cos(spr.getAng() & 0x7FF) >> 9;
                    Enemies.out.y = EngineUtils.sin(spr.getAng() & 0x7FF) >> 9;
                    if (Pragmas.klabs(dang) < 256) {
                        out = Enemies.sub_16849(target, i, Enemies.out.x, Enemies.out.y);
                    }
                    short sect = spr.getSectnum();
                    int move = Main.engine.movesprite(i, Enemies.out.x, Enemies.out.y, 0, spr.getClipdist() << 2, 1024, 1024, 65537, 4);
                    Main.engine.pushmove(spr.getX(), spr.getY(), spr.getZ() - h / 2, sect, spr.getClipdist() << 2, 1024, 1024, 65537);
                    spr.setX(Engine.pushmove_x);
                    spr.setY(Engine.pushmove_y);
                    spr.setZ(Engine.pushmove_z + h / 2);
                    if (sect != Engine.pushmove_sectnum) {
                        Main.engine.changespritesect(i, Engine.pushmove_sectnum);
                    }
                    if (move == 0) break;
                    if (spr.getPicnum() == 1536) {
                        if ((Main.engine.krand() & 3) != 0) break;
                        spr.setAng(EngineUtils.getAngle(dx, dy));
                        break;
                    }
                    if ((spr.getAng() + 2048 - ang & 0x7FF) >= 1024) {
                        spr.setAng((short)(spr.getAng() + 8));
                    } else {
                        spr.setAng((short)(spr.getAng() + 2048 - 8));
                    }
                    spr.setAng(spr.getAng() & 0x7FF);
                }
            }
            node = next;
        }
        if (count < 1 && ocount != count) {
            Globals.nMusicClock = Globals.lockclock;
        }
        if (count < 1 && GameScreen.getMap((int)Globals.mapnum).music - 1 != Sounds.currSong) {
            if (Globals.lockclock - Globals.nMusicClock > 780) {
                Sounds.startmusic(GameScreen.getMap((int)Globals.mapnum).music - 1);
            }
        } else if (count > 1 && Sounds.currSong != 7) {
            Sounds.startmusic(7);
        }
        ocount = count;
        ListNode<Sprite> i = Main.boardService.getStatNode(20);
        while (i != null) {
            ListNode<Sprite> nexti = i.getNext();
            Sprite spr = i.get();
            spr.setLotag(spr.getLotag() - 4);
            if (spr.getLotag() < 210 && spr.getLotag() > 175) {
                spr.setPicnum((short)(spr.getOwner() + 1));
            } else if (spr.getLotag() < 155 && spr.getLotag() > 120) {
                spr.setPicnum((short)(spr.getOwner() + 2));
            } else if (spr.getLotag() < 75 && spr.getLotag() > 45) {
                spr.setPicnum((short)(spr.getOwner() + 3));
            } else if (spr.getLotag() < 0) {
                spr.setPicnum((short)(spr.getOwner() + 8));
                Main.engine.changespritestat(i.getIndex(), 0);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(2);
        while (i != null) {
            ListNode<Sprite> nexti = i.getNext();
            short p = Mmulti.connecthead;
            while (p >= 0) {
                int k = i.getIndex();
                if (Enemies.isvisible(k, p)) {
                    Main.engine.changespritestat(k, 1);
                    switch (i.get().getPicnum()) {
                        case 1536: {
                            Sounds.playsound(28, k);
                            break;
                        }
                        case 1792: {
                            Sounds.playsound(34, k);
                            break;
                        }
                        case 2048: {
                            Sounds.playsound(53, k);
                            break;
                        }
                        case 2304: {
                            Sounds.playsound(52, k);
                            break;
                        }
                        case 2560: {
                            Sounds.playsound(63, k);
                        }
                    }
                }
                p = Mmulti.connectpoint2[p];
            }
            i = nexti;
        }
    }

    public static boolean isvisible(int i, int target) {
        PlayerStruct plr = Globals.gPlayer[target];
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return false;
        }
        int sin = EngineUtils.sin(spr.getAng() & 0x7FF);
        int cos = EngineUtils.sin(spr.getAng() + 512 & 0x7FF);
        if (plr.sectnum >= 0 && cos * (plr.x - spr.getX()) + sin * (plr.y - spr.getY()) >= 0) {
            return Main.engine.cansee(plr.x, plr.y, plr.z, plr.sectnum, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum());
        }
        return false;
    }

    private static BuildPos sub_16849(int nTarget, int nSprite, int xvel, int yvel) {
        int vel;
        Enemies.out.x = xvel;
        Enemies.out.y = yvel;
        Sprite spr = Main.boardService.getSprite(nSprite);
        if (spr == null) {
            return out;
        }
        int dx = Globals.gPlayer[nTarget].x - spr.getX();
        int dy = Globals.gPlayer[nTarget].y - spr.getY();
        boolean v19 = false;
        boolean v18 = false;
        if (xvel < 0 && dx - xvel < -350 || xvel > 0 && dx - xvel > 350) {
            v19 = true;
        }
        if (yvel < 0 && dy - yvel < -350 || yvel > 0 && dy - yvel > 350) {
            v18 = true;
        }
        if (!v19) {
            vel = dx < 0 ? dx + 350 : dx - 350;
            Enemies.out.x = Pragmas.klabs(vel) == vel == (Pragmas.klabs(xvel) == xvel) ? vel : 0;
        }
        if (!v18) {
            vel = dy < 0 ? dy + 350 : dy - 350;
            Enemies.out.y = Pragmas.klabs(vel) == vel == (Pragmas.klabs(yvel) == yvel) ? vel : 0;
        }
        return out;
    }

    static {
        attackFrames = new Object[Engine.MAXSPRITES];
        timeCounter = new short[Engine.MAXSPRITES];
        frameIndex = new short[Engine.MAXSPRITES];
        blueattack = new Frame[]{new Frame(1556, 20, null), new Frame(1557, 12, i -> {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                return;
            }
            short target = spr.getHitag();
            if (target != -1) {
                int dx = Globals.gPlayer[target].x - spr.getX();
                int dy = Globals.gPlayer[target].y - spr.getY();
                if (Pragmas.klabs(dx) + Pragmas.klabs(dy) < 1024) {
                    Sprites.changehealth(target, -((Main.engine.krand() & 3) + Globals.nDifficult));
                    Sounds.playsound(31, i);
                }
            }
        }), new Frame(1558, 12, null)};
        greencallback = i -> {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                return;
            }
            Sprite nspr = Enemies.buildProjectile(i, spr.getHitag(), (Main.engine.krand() & 3) + 2032);
            if (nspr != null) {
                nspr.setZ(nspr.getZ() - 7168);
                nspr.setPicnum(1840);
                nspr.setShade(-20);
                nspr.setXrepeat(32);
                nspr.setYrepeat(32);
                nspr.setLotag((short)(-4 - Globals.nDifficult));
                Sounds.playsound(6, i);
            }
        };
        greenattack = new Frame[]{new Frame(1812, 12, null), new Frame(1813, 12, greencallback), new Frame(1814, 12, null)};
        redcallback = i -> {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                return;
            }
            Sprite nspr = Enemies.buildProjectile(i, spr.getHitag(), (Main.engine.krand() & 1) + 2032);
            if (nspr != null) {
                nspr.setZ(nspr.getZ() - 5120);
                nspr.setPicnum(2096);
                nspr.setShade(-20);
                nspr.setLotag((short)(-8 - Globals.nDifficult));
                Sounds.playsound(8, i);
            }
        };
        redattack = new Frame[]{new Frame(2068, 8, null), new Frame(2069, 8, null), new Frame(2070, 8, null), new Frame(2071, 8, null), new Frame(2072, 8, null), new Frame(2073, 12, redcallback)};
        purpcallback = i -> {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                return;
            }
            Sprite nspr = Enemies.buildProjectile(i, spr.getHitag(), (Main.engine.krand() & 1) + 2040);
            if (nspr != null) {
                nspr.setZ(nspr.getZ() - 5120);
                nspr.setPicnum(2352);
                nspr.setShade(-20);
                nspr.setLotag((short)(-16 - Globals.nDifficult));
                Sounds.playsound(0, i);
            }
        };
        purpattack = new Frame[]{new Frame(2324, 8, null), new Frame(2325, 8, null), new Frame(2326, 8, null), new Frame(2327, 16, purpcallback)};
        yellowcallback = i -> {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                return;
            }
            Sprite nspr = Enemies.buildProjectile(i, spr.getHitag(), (Main.engine.krand() & 1) + 2040);
            if (nspr != null) {
                nspr.setZ(nspr.getZ() - 5120);
                nspr.setPicnum(2608);
                nspr.setShade(-25);
                nspr.setLotag((short)(-32 - Globals.nDifficult));
                Sounds.playsound(2, i);
            }
        };
        yellattack = new Frame[]{new Frame(2580, 20, null), new Frame(2581, 12, null), new Frame(2582, 12, yellowcallback), new Frame(2583, 12, null)};
        out = new BuildPos();
    }

    private static class Frame {
        public final short tile;
        public final Callback trigger;
        public final short ticksPerFrame;

        public Frame(int tile, int ticksPerFrame, Callback trigger) {
            this.tile = (short)tile;
            this.ticksPerFrame = (short)ticksPerFrame;
            this.trigger = trigger;
        }
    }

    private static interface Callback {
        public void invoke(int var1);
    }
}

