/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import com.badlogic.gdx.math.Vector2;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.LSP.Config;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.Input;

public class LSPInput
extends GameProcessor {
    private boolean crouch;
    private int lPlayerXVel;
    private int lPlayerYVel;

    public LSPInput(Main main) {
        super(main);
    }

    public void reset() {
        this.lPlayerYVel = 0;
        this.lPlayerXVel = 0;
    }

    @Override
    public void fillInput(BuildNet.NetInput input) {
        double yvel;
        float k;
        boolean running;
        this.mouseDelta.x /= 4.0f;
        this.mouseDelta.y /= 16.0f;
        Input gInput = (Input)input;
        if (this.game.pMenu.gShowMenu || Console.out.isShowing()) {
            return;
        }
        gInput.reset();
        int vel = 0;
        int svel = 0;
        float angvel = 0.0f;
        float horiz = 0.0f;
        gInput.bits = gInput.bits | (this.isGameKeyJustPressed(GameKeys.Jump) ? 1 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyPressed(GameKeys.Crouch) ? 2 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyPressed(GameKeys.Look_Up) ? 4 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyPressed(GameKeys.Look_Down) ? 8 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyPressed(GameKeys.Run) ? 256 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyJustPressed(GameKeys.Open) ? 1024 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyPressed(GameKeys.Weapon_Fire) ? 2048 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyJustPressed(Config.LSPKeys.Weapon_1) ? 16384 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyJustPressed(Config.LSPKeys.Weapon_2) ? 32768 : 0);
        gInput.bits = gInput.bits | (this.isGameKeyJustPressed(Config.LSPKeys.Weapon_3) ? 49152 : 0);
        if (this.isGameKeyJustPressed(GameKeys.Previous_Weapon)) {
            gInput.bits |= 0x10000;
        }
        if (this.isGameKeyJustPressed(GameKeys.Next_Weapon)) {
            gInput.bits |= 0x14000;
        }
        if (this.isGameKeyJustPressed(Config.LSPKeys.Last_Used_Weapon)) {
            gInput.bits |= 0x18000;
        }
        gInput.bits = gInput.bits | (this.isKeyJustPressed(121) ? 131072 : 0);
        if (this.isGameKeyJustPressed(Config.LSPKeys.Crouch_toggle)) {
            boolean bl = this.crouch = !this.crouch;
        }
        if (this.crouch) {
            gInput.bits |= 2;
        }
        int keymove = 80;
        int keyturn = 128;
        boolean bl = running = !Main.cfg.gAutoRun && (gInput.bits & 0x100) != 0 || (gInput.bits & 0x100) == 0 && Main.cfg.gAutoRun;
        if (running) {
            keymove = 128;
            keyturn = 192;
        }
        if (this.isGameKeyPressed(GameKeys.Strafe)) {
            if (this.isGameKeyPressed(GameKeys.Turn_Left)) {
                svel -= -keymove;
            }
            if (this.isGameKeyPressed(GameKeys.Turn_Right)) {
                svel -= keymove;
            }
            svel = (short)Gameutils.BClipRange((float)svel - 20.0f * this.ctrlGetMouseStrafe(), (float)(-keymove), (float)keymove);
        } else {
            if (this.isGameKeyPressed(GameKeys.Turn_Left)) {
                angvel -= (float)keyturn;
            } else if (this.isGameKeyPressed(GameKeys.Turn_Right)) {
                angvel += (float)keyturn;
            }
            angvel = Gameutils.BClipRange(angvel + this.ctrlGetMouseTurn(), -1024.0f, 1024.0f);
        }
        if (this.isGameKeyPressed(GameKeys.Strafe_Left)) {
            svel += keymove;
        }
        if (this.isGameKeyPressed(GameKeys.Strafe_Right)) {
            svel -= keymove;
        }
        if (this.isGameKeyPressed(GameKeys.Move_Forward)) {
            vel += keymove;
        }
        if (this.isGameKeyPressed(GameKeys.Move_Backward)) {
            vel -= keymove;
        }
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        if (Main.cfg.isgMouseAim()) {
            horiz = Gameutils.BClipRange(this.ctrlGetMouseLook(!Main.cfg.isgInvertmouse()), (float)(-(ydim >> 1)), (float)(100 + (ydim >> 1)));
        } else {
            vel = (short)Gameutils.BClipRange((float)vel - this.ctrlGetMouseMove(), (float)(-4 * keymove), (float)(4 * keymove));
        }
        Vector2 stick1 = this.ctrlGetStick(GameProcessor.JoyStick.LOOKING);
        Vector2 stick2 = this.ctrlGetStick(GameProcessor.JoyStick.MOVING);
        float lookx = stick1.x;
        float looky = -stick1.y;
        if (looky != 0.0f) {
            k = 4.0f;
            horiz = Gameutils.BClipRange(horiz + k * looky * Main.cfg.getJoyLookSpeed(), (float)(-(ydim >> 1)), (float)(100 + (ydim >> 1)));
        }
        if (lookx != 0.0f) {
            k = 80.0f;
            angvel = (short)Gameutils.BClipRange(angvel + k * lookx * Main.cfg.getJoyTurnSpeed(), -1024.0f, 1024.0f);
        }
        if (stick2.y != 0.0f) {
            k = 320.0f;
            vel = (short)Gameutils.BClipRange((float)vel - k * stick2.y, -128.0f, 127.0f);
        }
        if (stick2.x != 0.0f) {
            k = 320.0f;
            svel = (short)Gameutils.BClipRange((float)svel - k * stick2.x, -128.0f, 127.0f);
        }
        if (svel < 0) {
            svel = Math.min(svel + 8, 0);
        }
        if (svel > 0) {
            svel = Math.max(svel - 8, 0);
        }
        if (vel < 0) {
            vel = Math.min(vel + 8, 0);
        }
        if (vel > 0) {
            vel = Math.max(vel - 8, 0);
        }
        if (Globals.followmode && Globals.gPlayer[Mmulti.myconnectindex].gViewMode != 3) {
            Globals.followvel = vel;
            Globals.followsvel = svel;
            Globals.followang = angvel;
            return;
        }
        k = 0.17f;
        float angle = Gameutils.BClampAngle(Globals.gPlayer[Mmulti.myconnectindex].ang);
        double xvel = (double)vel * Gameutils.BCosAngle(angle) + (double)svel * Gameutils.BSinAngle(angle);
        double len = Math.sqrt(xvel * xvel + (yvel = (double)vel * Gameutils.BSinAngle(angle) - (double)svel * Gameutils.BCosAngle(angle)) * yvel);
        if (len > (double)(keymove << 14)) {
            xvel = xvel / len * (double)(keymove << 14);
            yvel = yvel / len * (double)(keymove << 14);
        }
        this.lPlayerXVel += (int)(xvel * (double)k);
        this.lPlayerYVel += (int)(yvel * (double)k);
        this.lPlayerXVel = Pragmas.mulscale(this.lPlayerXVel, 53248L, 16);
        this.lPlayerYVel = Pragmas.mulscale(this.lPlayerYVel, 53248L, 16);
        if (Pragmas.klabs(this.lPlayerXVel) < 2048 && Pragmas.klabs(this.lPlayerYVel) < 2048) {
            this.lPlayerYVel = 0;
            this.lPlayerXVel = 0;
        }
        gInput.xvel = this.lPlayerXVel;
        gInput.yvel = this.lPlayerYVel;
        gInput.angvel = angvel;
        gInput.horiz = horiz;
    }
}

