/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Tables;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class LSPTables
extends Tables {
    public LSPTables(Entry entry) throws IOException {
        super(entry);
    }

    @Override
    protected void read(Entry entry) throws IOException {
        if (!entry.exists()) {
            throw new FileNotFoundException("Failed to load \"tables.dat\"!");
        }
        try (InputStream is = entry.getInputStream();){
            ByteBuffer.wrap(StreamUtils.readBytes(is, this.sintable.length * 2)).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.sintable);
            StreamUtils.skip(is, 4096);
            ByteBuffer.wrap(StreamUtils.readBytes(is, 640)).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.radarang, 0, 320);
            this.radarang[320] = 16384;
            StreamUtils.readBytes(is, this.textfont, 1024);
            StreamUtils.readBytes(is, this.smalltextfont, 1024);
        }
    }

    @Override
    public int getAngle(int xvect, int yvect) {
        if ((xvect | yvect) == 0) {
            return 0;
        }
        if (xvect == 0) {
            return (short)(512 + ((yvect < 0 ? 1 : 0) << 10));
        }
        if (yvect == 0) {
            return (short)((xvect < 0 ? 1 : 0) << 10);
        }
        if (xvect == yvect) {
            return (short)(256 + ((xvect < 0 ? 1 : 0) << 10));
        }
        if (xvect == -yvect) {
            return (short)(768 + ((xvect > 0 ? 1 : 0) << 10));
        }
        if (Pragmas.klabs(xvect) > Pragmas.klabs(yvect)) {
            return (short)(this.radarang[160 + Pragmas.scale(160L, yvect, xvect)] + ((xvect < 0 ? 1 : 0) << 10) & 0x7FF);
        }
        return (short)(this.radarang[160 - Pragmas.scale(160L, xvect, yvect)] + 512 + ((yvect < 0 ? 1 : 0) << 10) & 0x7FF);
    }
}

