/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.LSP.Animate;
import ru.m210projects.LSP.Enemies;
import ru.m210projects.LSP.Factory.LSPInput;
import ru.m210projects.LSP.Factory.LSPRenderer;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Menus.MenuCorruptGame;
import ru.m210projects.LSP.Quotes;
import ru.m210projects.LSP.Screens.GameScreen;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Types.ANIMATION;
import ru.m210projects.LSP.Types.LSInfo;
import ru.m210projects.LSP.Types.SafeLoader;

public class LoadSave {
    public static final String savsign = "LSP0";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 101;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final int SAVEGDXDATA = 16272;
    public static final char[] filenum = new char[4];
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static final LSInfo lsInf;
    public static FileEntry lastload;
    public static int quickslot;
    public static final SafeLoader loader;

    public static void FindSaves(Directory dir) {
        for (Entry file : dir) {
            if (!file.isExtension("sav") || !(file instanceof FileEntry)) continue;
            try {
                InputStream is = file.getInputStream();
                try {
                    short nVersion;
                    String signature = StreamUtils.readString(is, 4);
                    if (signature.isEmpty() || !signature.equals(savsign) || (nVersion = StreamUtils.readShort(is)) < 100) continue;
                    long time = StreamUtils.readLong(is);
                    String savname = StreamUtils.readString(is, 32);
                    Main.game.pSavemgr.add(savname, time, (FileEntry)file);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Main.game.pSavemgr.sort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int lsReadLoadData(FileEntry file) {
        if (file.exists()) {
            ArtEntry pic = Main.engine.getTile(SaveManager.Screenshot);
            if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
                pic = Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            try (InputStream is = file.getInputStream();){
                int nVersion = LoadSave.checkSave(is) & 0xFFFF;
                lsInf.clear();
                if (nVersion == 101) {
                    LoadSave.lsInf.date = Main.game.date.getDate(StreamUtils.readLong(is));
                    StreamUtils.skip(is, 32);
                    lsInf.read(is);
                    if (is.available() <= 16000) {
                        int n = -1;
                        return n;
                    }
                    StreamUtils.readBytes(is, pic.getBytes(), 16000);
                    ((DynamicArtEntry)pic).invalidate();
                    int n = 1;
                    return n;
                }
                LoadSave.lsInf.info = "Incompatible ver. " + nVersion + " != " + 101;
                int n = -1;
                return n;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        lsInf.clear();
        return -1;
    }

    public static String makeNum(int num) {
        LoadSave.filenum[3] = (char)(num % 10 + 48);
        LoadSave.filenum[2] = (char)(num / 10 % 10 + 48);
        LoadSave.filenum[1] = (char)(num / 100 % 10 + 48);
        LoadSave.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(InputStream is) throws IOException {
        String signature = StreamUtils.readString(is, 4);
        if (!signature.equals(savsign)) {
            return 0;
        }
        return StreamUtils.readShort(is);
    }

    public static boolean checkfile(InputStream is) throws IOException {
        int nVersion = LoadSave.checkSave(is);
        if (nVersion != 101) {
            return false;
        }
        return loader.load(is);
    }

    public static void load() {
        Main.gDemoScreen.onLoad();
        Sounds.stopallsounds();
        Globals.mapnum = LoadSave.loader.mapnum;
        Globals.nDifficult = (short)LoadSave.loader.skill;
        LoadSave.LoadGDXBlock();
        LoadSave.LoadStuff();
        LoadSave.MapLoad();
        LoadSave.SectorLoad();
        LoadSave.AnimationLoad();
        Globals.screenpeek = Mmulti.myconnectindex;
        Main.engine.getTileManager().setTilesPath(Globals.mapnum == 0 ? 0 : 1);
        ListNode<Sprite> node = Main.boardService.getStatNode(21);
        while (node != null) {
            ListNode<Sprite> next = node.getNext();
            Sprite spr = node.get();
            Main.engine.changespritestat(node.getIndex(), 2);
            spr.setPicnum(spr.getExtra());
            node = next;
        }
        Globals.nKickSprite = -1;
        if (Globals.mapnum == 0) {
            for (int sec = 0; sec < Main.boardService.getSectorCount(); sec = (int)((short)(sec + 1))) {
                for (ListNode<Sprite> node2 = Main.boardService.getSectNode(sec); node2 != null; node2 = node2.getNext()) {
                    if (node2.get().getPicnum() != 51) continue;
                    Globals.nKickSprite = node2.getIndex();
                }
            }
        }
        Globals.gPlayer[Globals.screenpeek].isWeaponsSwitching = 0;
        Globals.gPlayer[Globals.screenpeek].nSwitchingClock = 0;
        int mnum = GameScreen.getMap((int)Globals.mapnum).num & 0xFF;
        Globals.book = mnum % 100 % 10;
        Globals.chapter = mnum / 100;
        Globals.verse = mnum % 100 / 10;
        Main.game.doPrecache(() -> {
            Main.game.nNetMode = BuildGame.NetMode.Single;
            if (Globals.mUserFlag != Main.UserFlag.UserMap) {
                Sounds.startmusic(GameScreen.getMap((int)Globals.mapnum).music - 1);
            } else {
                Sounds.stopmusic();
            }
            Main.game.changeScreen(Main.gGameScreen);
            ((LSPInput)Main.game.getProcessor()).reset();
            Main.game.gPaused = false;
            Main.engine.getTimer().setTotalClock(Globals.lockclock);
            Main.game.pNet.ototalclock = Globals.lockclock;
            Quotes.resetQuotes();
            Quotes.viewSetMessage("Game loaded");
            System.gc();
            Main.game.pNet.ResetTimers();
            Main.game.pNet.ready2send = true;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadgame(FileEntry fil) {
        if (fil.exists()) {
            try (InputStream is = fil.getInputStream();){
                Console.out.println("debug: start loadgame()", OsdColor.BLUE);
                boolean status = LoadSave.checkfile(is);
                if (status) {
                    LoadSave.load();
                    if (lastload == null || !lastload.exists()) {
                        lastload = fil;
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                Quotes.viewSetMessage("Incompatible version of saved game found!");
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        Quotes.viewSetMessage("Can't access to file or file not found!");
        return false;
    }

    public static void LoadGDXBlock() {
        Globals.mUserFlag = Main.UserFlag.None;
    }

    public static void SectorLoad() {
        int i;
        System.arraycopy(LoadSave.loader.waterfountainwall, 0, Globals.waterfountainwall, 0, LoadSave.loader.waterfountainwall.length);
        System.arraycopy(LoadSave.loader.waterfountaincnt, 0, Globals.waterfountaincnt, 0, LoadSave.loader.waterfountaincnt.length);
        Globals.ypanningwallcnt = LoadSave.loader.ypanningwallcnt;
        System.arraycopy(LoadSave.loader.ypanningwalllist, 0, Globals.ypanningwalllist, 0, LoadSave.loader.ypanningwalllist.length);
        Globals.floorpanningcnt = LoadSave.loader.floorpanningcnt;
        System.arraycopy(LoadSave.loader.floorpanninglist, 0, Globals.floorpanninglist, 0, LoadSave.loader.floorpanninglist.length);
        Globals.warpsectorcnt = LoadSave.loader.warpsectorcnt;
        System.arraycopy(LoadSave.loader.warpsectorlist, 0, Globals.warpsectorlist, 0, LoadSave.loader.warpsectorlist.length);
        Globals.xpanningsectorcnt = LoadSave.loader.xpanningsectorcnt;
        System.arraycopy(LoadSave.loader.xpanningsectorlist, 0, Globals.xpanningsectorlist, 0, LoadSave.loader.xpanningsectorlist.length);
        Globals.warpsector2cnt = LoadSave.loader.warpsector2cnt;
        System.arraycopy(LoadSave.loader.warpsector2list, 0, Globals.warpsector2list, 0, LoadSave.loader.warpsector2list.length);
        Globals.subwaytrackcnt = LoadSave.loader.subwaytrackcnt;
        for (i = 0; i < 5; ++i) {
            System.arraycopy(LoadSave.loader.subwaytracksector[i], 0, Globals.subwaytracksector[i], 0, LoadSave.loader.subwaytracksector[i].length);
        }
        System.arraycopy(LoadSave.loader.subwaynumsectors, 0, Globals.subwaynumsectors, 0, LoadSave.loader.subwaynumsectors.length);
        for (i = 0; i < 5; ++i) {
            System.arraycopy(LoadSave.loader.subwaystop[i], 0, Globals.subwaystop[i], 0, LoadSave.loader.subwaystop[i].length);
        }
        System.arraycopy(LoadSave.loader.subwaystopcnt, 0, Globals.subwaystopcnt, 0, LoadSave.loader.subwaystopcnt.length);
        System.arraycopy(LoadSave.loader.subwaytrackx1, 0, Globals.subwaytrackx1, 0, LoadSave.loader.subwaytrackx1.length);
        System.arraycopy(LoadSave.loader.subwaytracky1, 0, Globals.subwaytracky1, 0, LoadSave.loader.subwaytracky1.length);
        System.arraycopy(LoadSave.loader.subwaytrackx2, 0, Globals.subwaytrackx2, 0, LoadSave.loader.subwaytrackx2.length);
        System.arraycopy(LoadSave.loader.subwaytracky2, 0, Globals.subwaytracky2, 0, LoadSave.loader.subwaytracky2.length);
        System.arraycopy(LoadSave.loader.subwayx, 0, Globals.subwayx, 0, LoadSave.loader.subwayx.length);
        System.arraycopy(LoadSave.loader.subwaygoalstop, 0, Globals.subwaygoalstop, 0, LoadSave.loader.subwaygoalstop.length);
        System.arraycopy(LoadSave.loader.subwayvel, 0, Globals.subwayvel, 0, LoadSave.loader.subwayvel.length);
        System.arraycopy(LoadSave.loader.subwaypausetime, 0, Globals.subwaypausetime, 0, LoadSave.loader.subwaypausetime.length);
        Globals.revolvecnt = LoadSave.loader.revolvecnt;
        System.arraycopy(LoadSave.loader.revolvesector, 0, Globals.revolvesector, 0, LoadSave.loader.revolvesector.length);
        System.arraycopy(LoadSave.loader.revolveang, 0, Globals.revolveang, 0, LoadSave.loader.revolveang.length);
        for (i = 0; i < 4; ++i) {
            System.arraycopy(LoadSave.loader.revolvex[i], 0, Globals.revolvex[i], 0, LoadSave.loader.revolvex[i].length);
        }
        for (i = 0; i < 4; ++i) {
            System.arraycopy(LoadSave.loader.revolvey[i], 0, Globals.revolvey[i], 0, LoadSave.loader.revolvey[i].length);
        }
        System.arraycopy(LoadSave.loader.revolvepivotx, 0, Globals.revolvepivotx, 0, LoadSave.loader.revolvepivotx.length);
        System.arraycopy(LoadSave.loader.revolvepivoty, 0, Globals.revolvepivoty, 0, LoadSave.loader.revolvepivoty.length);
        Globals.swingcnt = LoadSave.loader.swingcnt;
        for (i = 0; i < 32; ++i) {
            Globals.swingdoor[i].copy(LoadSave.loader.swingdoor[i]);
        }
        Globals.dragsectorcnt = LoadSave.loader.dragsectorcnt;
        System.arraycopy(LoadSave.loader.dragsectorlist, 0, Globals.dragsectorlist, 0, LoadSave.loader.dragsectorlist.length);
        System.arraycopy(LoadSave.loader.dragxdir, 0, Globals.dragxdir, 0, LoadSave.loader.dragxdir.length);
        System.arraycopy(LoadSave.loader.dragydir, 0, Globals.dragydir, 0, LoadSave.loader.dragydir.length);
        System.arraycopy(LoadSave.loader.dragx1, 0, Globals.dragx1, 0, LoadSave.loader.dragx1.length);
        System.arraycopy(LoadSave.loader.dragy1, 0, Globals.dragy1, 0, LoadSave.loader.dragy1.length);
        System.arraycopy(LoadSave.loader.dragx2, 0, Globals.dragx2, 0, LoadSave.loader.dragx2.length);
        System.arraycopy(LoadSave.loader.dragy2, 0, Globals.dragy2, 0, LoadSave.loader.dragy2.length);
        System.arraycopy(LoadSave.loader.dragfloorz, 0, Globals.dragfloorz, 0, LoadSave.loader.dragfloorz.length);
    }

    public static void LoadStuff() {
        int i;
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            Enemies.gEnemyClock[i] = LoadSave.loader.gEnemyClock[i];
            Enemies.gMoveStatus[i] = LoadSave.loader.gMoveStatus[i];
        }
        for (i = 0; i < 6; ++i) {
            Enemies.nKills[i] = LoadSave.loader.nKills[i];
            Enemies.nTotalKills[i] = LoadSave.loader.nTotalKills[i];
        }
        Enemies.nEnemyKills = LoadSave.loader.nEnemyKills;
        Enemies.nEnemyMax = LoadSave.loader.nEnemyMax;
        Globals.nDiffDoor = LoadSave.loader.nDiffDoor;
        Globals.nDiffDoorBack = LoadSave.loader.nDiffDoorBack;
        Globals.nTrainWall = LoadSave.loader.nTrainWall;
        Globals.bActiveTrain = LoadSave.loader.bActiveTrain;
        Globals.bTrainSoundSwitch = LoadSave.loader.bTrainSoundSwitch;
        Globals.lockclock = LoadSave.loader.lockclock;
        Globals.totalmoves = LoadSave.loader.totalmoves;
        Engine.visibility = LoadSave.loader.visibility;
        Main.engine.srand(LoadSave.loader.randomseed);
        Engine.show2dsector.copy(LoadSave.loader.show2dsector);
        Engine.show2dwall.copy(LoadSave.loader.show2dwall);
        Engine.show2dsprite.copy(LoadSave.loader.show2dsprite);
        Engine.automapping = LoadSave.loader.automapping;
        Engine.pskybits = LoadSave.loader.pskybits;
        LSPRenderer renderer = Main.game.getRenderer();
        renderer.setParallaxOffset(256);
        renderer.setParallaxScale(LoadSave.loader.parallaxyscale);
        System.arraycopy(LoadSave.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Engine.parallaxtype = 0;
        Mmulti.connecthead = LoadSave.loader.connecthead;
        System.arraycopy(LoadSave.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        for (int i2 = 0; i2 < 16; ++i2) {
            Globals.gPlayer[i2].copy(LoadSave.loader.plr[i2]);
        }
        Globals.nPlayerFirstWeapon = LoadSave.loader.nPlayerFirstWeapon;
        Globals.oldchoose = LoadSave.loader.oldchoose;
        Globals.oldpic = LoadSave.loader.oldpic;
    }

    public static void MapLoad() {
        Main.boardService.setBoard(new Board(null, LoadSave.loader.sector, LoadSave.loader.wall, LoadSave.loader.sprite));
    }

    public static void AnimationLoad() {
        int i;
        for (i = 0; i < 512; ++i) {
            Animate.gAnimationData[i].id = LoadSave.loader.gAnimationData[i].id;
            Animate.gAnimationData[i].type = LoadSave.loader.gAnimationData[i].type;
            Animate.gAnimationData[i].ptr = LoadSave.loader.gAnimationData[i].ptr;
            Animate.gAnimationData[i].goal = LoadSave.loader.gAnimationData[i].goal;
            Animate.gAnimationData[i].vel = LoadSave.loader.gAnimationData[i].vel;
            Animate.gAnimationData[i].acc = LoadSave.loader.gAnimationData[i].acc;
        }
        Animate.gAnimationCount = LoadSave.loader.gAnimationCount;
        block6: for (i = Animate.gAnimationCount - 1; i >= 0; --i) {
            ANIMATION gAnm = Animate.gAnimationData[i];
            Object object = gAnm.ptr = Animate.getobject(gAnm.id, gAnm.type);
            switch (gAnm.type) {
                case 1: 
                case 2: {
                    Main.game.pInt.setwallinterpolate(gAnm.id, (Wall)object);
                    continue block6;
                }
                case 4: {
                    Main.game.pInt.setfloorinterpolate(gAnm.id, (Sector)object);
                    continue block6;
                }
                case 8: {
                    Main.game.pInt.setceilinterpolate(gAnm.id, (Sector)object);
                }
            }
        }
    }

    public static boolean canLoad(FileEntry fil) {
        if (fil.exists()) {
            boolean bl;
            block11: {
                InputStream is = fil.getInputStream();
                try {
                    int nVersion = LoadSave.checkSave(is) & 0xFFFF;
                    if (nVersion != 101 && nVersion >= 100) {
                        loader.LoadGDXHeader(is);
                        if (LoadSave.loader.mapnum <= Globals.maps.length && LoadSave.loader.skill >= 0 && LoadSave.loader.skill < 4) {
                            MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[15];
                            menu.setRunnable(() -> {
                                Globals.nDifficult = (short)LoadSave.loader.skill;
                                Main.gGameScreen.newgame(LoadSave.loader.mapnum);
                            });
                            Main.game.menu.mOpen(menu, -1);
                        }
                    }
                    boolean bl2 = bl = nVersion == 101;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        FileEntry loadFile = Main.game.pSavemgr.getLast();
        if (LoadSave.canLoad(loadFile)) {
            Main.game.changeScreen(Main.gLoadingScreen.setTitle(loadFile.getName()));
            Main.gLoadingScreen.init(() -> {
                if (!LoadSave.loadgame(loadFile)) {
                    Main.game.setPrevScreen();
                    if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                        Quotes.viewSetMessage("Incompatible version of saved game found!");
                        Main.game.pNet.ready2send = true;
                    }
                }
            });
        }
    }

    private static void save(OutputStream fil, String savename, long time) throws IOException {
        LoadSave.SaveHeader(fil, savename, time);
        LoadSave.SaveGDXBlock(fil);
        LoadSave.StuffSave(fil);
        LoadSave.MapSave(fil);
        LoadSave.SectorSave(fil);
        LoadSave.AnimationSave(fil);
    }

    public static void savegame(Directory dir, String savename, String filename) {
        block9: {
            FileEntry file = dir.getEntry(filename);
            if (file.exists() && !file.delete()) {
                Quotes.viewSetMessage("Game not saved. Access denied!");
                return;
            }
            Path path = dir.getPath().resolve(filename);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                long time = Main.game.date.getCurrentDate();
                LoadSave.save(os, savename, time);
                file = dir.addEntry(path);
                if (file.exists()) {
                    Main.game.pSavemgr.add(savename, time, file);
                    lastload = file;
                    Quotes.viewSetMessage("Game saved");
                    break block9;
                }
                throw new FileNotFoundException(filename);
            }
            catch (Exception e) {
                Quotes.viewSetMessage("Game not saved! " + e);
            }
        }
    }

    public static void SaveHeader(OutputStream os, String savename, long time) throws IOException {
        LoadSave.SaveVersion(os, 101);
        StreamUtils.writeLong(os, time);
        StreamUtils.writeString(os, savename, 32);
        StreamUtils.writeInt(os, Globals.mapnum);
        StreamUtils.writeInt(os, Globals.nDifficult);
    }

    public static void SaveGDXBlock(OutputStream os) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(16272);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put(Main.gGameScreen.captBuffer);
        Main.gGameScreen.captBuffer = null;
        StreamUtils.writeBytes(os, bb.array());
    }

    public static void SectorSave(OutputStream os) throws IOException {
        int j;
        int b;
        int a;
        int i;
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Globals.waterfountainwall[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Globals.waterfountaincnt[i]);
        }
        StreamUtils.writeShort(os, Globals.ypanningwallcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Globals.ypanningwalllist[i]);
        }
        StreamUtils.writeShort(os, Globals.floorpanningcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Globals.floorpanninglist[i]);
        }
        StreamUtils.writeShort(os, Globals.warpsectorcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Globals.warpsectorlist[i]);
        }
        StreamUtils.writeShort(os, Globals.xpanningsectorcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Globals.xpanningsectorlist[i]);
        }
        StreamUtils.writeShort(os, Globals.warpsector2cnt);
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeShort(os, Globals.warpsector2list[i]);
        }
        StreamUtils.writeShort(os, Globals.subwaytrackcnt);
        for (a = 0; a < 5; ++a) {
            for (b = 0; b < 128; ++b) {
                StreamUtils.writeShort(os, Globals.subwaytracksector[a][b]);
            }
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeShort(os, Globals.subwaynumsectors[i]);
        }
        for (a = 0; a < 5; ++a) {
            for (b = 0; b < 8; ++b) {
                StreamUtils.writeInt(os, Globals.subwaystop[a][b]);
            }
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwaystopcnt[i]);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwaytrackx1[i]);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwaytracky1[i]);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwaytrackx2[i]);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwaytracky2[i]);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwayx[i]);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwaygoalstop[i]);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwayvel[i]);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeInt(os, Globals.subwaypausetime[i]);
        }
        StreamUtils.writeShort(os, Globals.revolvecnt);
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeShort(os, Globals.revolvesector[i]);
            StreamUtils.writeShort(os, Globals.revolveang[i]);
            for (j = 0; j < 48; ++j) {
                StreamUtils.writeInt(os, Globals.revolvex[i][j]);
                StreamUtils.writeInt(os, Globals.revolvey[i][j]);
            }
            StreamUtils.writeInt(os, Globals.revolvepivotx[i]);
            StreamUtils.writeInt(os, Globals.revolvepivoty[i]);
        }
        StreamUtils.writeShort(os, Globals.swingcnt);
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 8; ++j) {
                StreamUtils.writeShort(os, (short)Globals.swingdoor[i].wall[j]);
            }
            StreamUtils.writeShort(os, (short)Globals.swingdoor[i].sector);
            StreamUtils.writeShort(os, (short)Globals.swingdoor[i].angopen);
            StreamUtils.writeShort(os, (short)Globals.swingdoor[i].angclosed);
            StreamUtils.writeShort(os, (short)Globals.swingdoor[i].angopendir);
            StreamUtils.writeShort(os, (short)Globals.swingdoor[i].ang);
            StreamUtils.writeShort(os, (short)Globals.swingdoor[i].anginc);
            for (j = 0; j < 8; ++j) {
                StreamUtils.writeInt(os, Globals.swingdoor[i].x[j]);
            }
            for (j = 0; j < 8; ++j) {
                StreamUtils.writeInt(os, Globals.swingdoor[i].y[j]);
            }
        }
        StreamUtils.writeShort(os, Globals.dragsectorcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Globals.dragsectorlist[i]);
            StreamUtils.writeShort(os, Globals.dragxdir[i]);
            StreamUtils.writeShort(os, Globals.dragydir[i]);
            StreamUtils.writeInt(os, Globals.dragx1[i]);
            StreamUtils.writeInt(os, Globals.dragy1[i]);
            StreamUtils.writeInt(os, Globals.dragx2[i]);
            StreamUtils.writeInt(os, Globals.dragy2[i]);
            StreamUtils.writeInt(os, Globals.dragfloorz[i]);
        }
    }

    public static void StuffSave(OutputStream os) throws IOException {
        int i;
        int i2;
        for (i2 = 0; i2 < Engine.MAXSPRITES; ++i2) {
            StreamUtils.writeInt(os, Enemies.gEnemyClock[i2]);
            StreamUtils.writeShort(os, Enemies.gMoveStatus[i2]);
        }
        for (i2 = 0; i2 < 6; ++i2) {
            StreamUtils.writeShort(os, Enemies.nKills[i2]);
            StreamUtils.writeShort(os, Enemies.nTotalKills[i2]);
        }
        StreamUtils.writeInt(os, Enemies.nEnemyKills);
        StreamUtils.writeInt(os, Enemies.nEnemyMax);
        StreamUtils.writeShort(os, Globals.nDiffDoor);
        StreamUtils.writeShort(os, Globals.nDiffDoorBack);
        StreamUtils.writeShort(os, Globals.nTrainWall);
        StreamUtils.writeBoolean(os, Globals.bActiveTrain);
        StreamUtils.writeBoolean(os, Globals.bTrainSoundSwitch);
        StreamUtils.writeInt(os, Globals.lockclock);
        StreamUtils.writeInt(os, Globals.totalmoves);
        StreamUtils.writeInt(os, Engine.visibility);
        StreamUtils.writeInt(os, Main.engine.getrand());
        Engine.show2dsector.writeObject(os);
        Engine.show2dwall.writeObject(os);
        Engine.show2dsprite.writeObject(os);
        StreamUtils.writeByte(os, Engine.automapping);
        StreamUtils.writeShort(os, Engine.pskybits);
        LSPRenderer renderer = Main.game.getRenderer();
        StreamUtils.writeInt(os, renderer.getParallaxScale());
        for (i = 0; i < 256; ++i) {
            StreamUtils.writeShort(os, Engine.pskyoff[i]);
        }
        StreamUtils.writeShort(os, Mmulti.connecthead);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Mmulti.connectpoint2[i]);
        }
        for (i = 0; i < 16; ++i) {
            Globals.gPlayer[i].writeObject(os);
        }
        StreamUtils.writeShort(os, Globals.nPlayerFirstWeapon);
        StreamUtils.writeInt(os, Globals.oldchoose);
        StreamUtils.writeShort(os, Globals.oldpic);
    }

    public static void MapSave(OutputStream os) throws IOException {
        Board board = Main.boardService.getBoard();
        Sector[] sectors = board.getSectors();
        StreamUtils.writeInt(os, sectors.length);
        for (Sector s : sectors) {
            s.writeObject(os);
        }
        Wall[] walls = board.getWalls();
        StreamUtils.writeInt(os, walls.length);
        for (Wall wal : walls) {
            wal.writeObject(os);
        }
        List<Sprite> sprites = board.getSprites();
        StreamUtils.writeInt(os, sprites.size());
        for (Sprite s : sprites) {
            s.writeObject(os);
        }
    }

    public static void SaveVersion(OutputStream os, int nVersion) throws IOException {
        StreamUtils.writeString(os, savsign);
        StreamUtils.writeShort(os, nVersion);
    }

    public static void AnimationSave(OutputStream os) throws IOException {
        for (int i = 0; i < 512; ++i) {
            StreamUtils.writeShort(os, Animate.gAnimationData[i].id);
            StreamUtils.writeByte(os, Animate.gAnimationData[i].type);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].goal);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].vel);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].acc);
        }
        StreamUtils.writeInt(os, Animate.gAnimationCount);
    }

    public static void quicksave() {
        if (Globals.gPlayer[Mmulti.myconnectindex].nHealth != 0) {
            gQuickSaving = true;
        }
    }

    static {
        lsInf = new LSInfo();
        quickslot = 0;
        loader = new SafeLoader();
    }
}

