/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.LogSender;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.MessageScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.MemLog;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdCallback;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.LSP.Animate;
import ru.m210projects.LSP.Config;
import ru.m210projects.LSP.Factory.LSPDummyRenderer;
import ru.m210projects.LSP.Factory.LSPEngine;
import ru.m210projects.LSP.Factory.LSPFactory;
import ru.m210projects.LSP.Factory.LSPInput;
import ru.m210projects.LSP.Factory.LSPMenuHandler;
import ru.m210projects.LSP.Factory.LSPRenderer;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.LoadSave;
import ru.m210projects.LSP.Menus.AdvertisingMenu;
import ru.m210projects.LSP.Menus.GameMenu;
import ru.m210projects.LSP.Menus.LSPMenuAudio;
import ru.m210projects.LSP.Menus.LSPMenuLoad;
import ru.m210projects.LSP.Menus.LSPMenuSave;
import ru.m210projects.LSP.Menus.MainMenu;
import ru.m210projects.LSP.Menus.MenuCorruptGame;
import ru.m210projects.LSP.Menus.MenuLastLoad;
import ru.m210projects.LSP.Menus.MenuOptions;
import ru.m210projects.LSP.Menus.MenuQuit;
import ru.m210projects.LSP.Quotes;
import ru.m210projects.LSP.Screens.DemoScreen;
import ru.m210projects.LSP.Screens.GameScreen;
import ru.m210projects.LSP.Screens.IntroScreen;
import ru.m210projects.LSP.Screens.LSPMessageScreen;
import ru.m210projects.LSP.Screens.LoadingScreen;
import ru.m210projects.LSP.Screens.MenuScreen;
import ru.m210projects.LSP.Screens.MovieScreen;
import ru.m210projects.LSP.Screens.PrecacheScreen;
import ru.m210projects.LSP.Screens.StatisticScreen;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Types.LSPDatFile;
import ru.m210projects.LSP.Types.PlayerStruct;
import ru.m210projects.LSP.Types.SwingDoor;

public class Main
extends BuildGame {
    public static Main game;
    public static LSPEngine engine;
    public static BoardService boardService;
    public static Config cfg;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static MovieScreen gMovieScreen;
    public static IntroScreen gIntroScreen;
    public static MenuScreen gMenuScreen;
    public static StatisticScreen gStatisticScreen;
    public static DemoScreen gDemoScreen;
    public static LSPDatFile gMapGroup;
    public static LSPDatFile gResGroup;
    public LSPMenuHandler menu;
    public final Runnable toMenu = new Runnable(){

        @Override
        public void run() {
            Sounds.stopallsounds();
            gDemoScreen.onStopRecord();
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.isEmpty() || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo()) {
                Main.this.changeScreen(gMenuScreen);
            }
            if (!Main.this.menu.gShowMenu) {
                Main.this.menu.mOpen(Main.this.menu.mMenus[0], -1);
            }
        }
    };

    public Main(List<String> args, GameConfig bcfg, String appname, String version, boolean isRelease) throws IOException {
        super(args, bcfg, appname, version, isRelease);
        game = this;
        cfg = (Config)bcfg;
    }

    @Override
    protected MessageScreen createMessage(String header, String text, MessageType type) {
        return new LSPMessageScreen(this, header, text, type);
    }

    @Override
    @NotNull
    public LSPRenderer getRenderer() {
        Renderer renderer = super.getRenderer();
        if (renderer instanceof LSPRenderer) {
            LSPRenderer lSPRenderer = (LSPRenderer)renderer;
            if (lSPRenderer == null) {
                Main.$$$reportNull$$$0(0);
            }
            return lSPRenderer;
        }
        return new LSPDummyRenderer();
    }

    @Override
    public GameProcessor createGameProcessor() {
        return new LSPInput(this);
    }

    @Override
    public BuildFactory getFactory() {
        return new LSPFactory(this);
    }

    @Override
    public boolean init() {
        FileEntry filgdx;
        int i;
        boardService = engine.getBoardService();
        this.ConsoleInit();
        Sounds.sndInit();
        for (i = 0; i < 16; ++i) {
            Globals.gPlayer[i] = new PlayerStruct();
        }
        for (i = 0; i < 32; ++i) {
            Globals.swingdoor[i] = new SwingDoor();
        }
        Animate.initanimations();
        Quotes.InitQuotes();
        Main.game.pNet.ResetTimers();
        Directory gameDir = this.cache.getGameDirectory();
        Console.out.println("Initializing def-scripts...");
        this.cache.loadGdxDef(this.baseDef, "lspgdx.def", "lspgdx.dat");
        if (this.pCfg.isAutoloadFolder()) {
            Console.out.println("Initializing autoload folder");
            block11: for (Entry file : gameDir.getDirectory(gameDir.getEntry("autoload"))) {
                switch (file.getExtension()) {
                    case "PK3": 
                    case "ZIP": {
                        Group group = this.cache.newGroup(file);
                        Entry def = group.getEntry("lspgdx.def");
                        if (!def.exists()) continue block11;
                        this.cache.addGroup(group, CacheResourceMap.CachePriority.NORMAL);
                        this.baseDef.loadScript(file.getName(), def);
                        break;
                    }
                    case "DEF": {
                        this.baseDef.loadScript(file);
                    }
                }
            }
        }
        if ((filgdx = gameDir.getEntry("lspgdx.def")).exists()) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        LoadSave.FindSaves(this.getUserDirectory());
        this.menu.mMenus[3] = new LSPMenuLoad(this);
        this.menu.mMenus[4] = new LSPMenuSave(this);
        this.menu.mMenus[8] = new LSPMenuAudio(this);
        this.menu.mMenus[10] = new MenuOptions(this);
        this.menu.mMenus[6] = new MenuQuit(this);
        this.menu.mMenus[1] = new GameMenu(this);
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[13] = new AdvertisingMenu();
        this.menu.mMenus[14] = new MenuLastLoad(this);
        this.menu.mMenus[15] = new MenuCorruptGame(this);
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gMovieScreen = new MovieScreen(this);
        gIntroScreen = new IntroScreen(this);
        gMenuScreen = new MenuScreen(this);
        gStatisticScreen = new StatisticScreen(this);
        gDemoScreen = new DemoScreen(this);
        gDemoScreen.demoscan(gameDir);
        System.gc();
        MemLog.log("create");
        return true;
    }

    @Override
    public void onDropEntry(FileEntry entry) {
        if (entry.isExtension("dmo")) {
            Console.out.println("Start dropped demo: " + entry.getName());
            gDemoScreen.showDemo(entry);
        }
    }

    private void ConsoleInit() {
        Console.out.println("Initializing on-screen display system");
        Console.out.getPrompt().setVersion(this.getTitle(), OsdColor.YELLOW, 10);
        Console.out.registerCommand(new OsdCallback("noclip", "noclip", argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                Globals.gPlayer[Mmulti.myconnectindex].noclip = !Globals.gPlayer[Mmulti.myconnectindex].noclip;
                Console.out.println("Noclip: " + (Globals.gPlayer[Mmulti.myconnectindex].noclip ? "ON" : "OFF"));
            } else {
                Console.out.println("noclip: not in a game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("god", "god", argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                Globals.gPlayer[Mmulti.myconnectindex].nPlayerStatus = Globals.gPlayer[Mmulti.myconnectindex].nPlayerStatus != 5 ? (short)5 : (short)0;
                Console.out.println("God mode: " + (Globals.gPlayer[Mmulti.myconnectindex].nPlayerStatus == 5 ? "ON" : "OFF"));
            } else {
                Console.out.println("god: not in a game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("changemap", "changemap: map number", argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                if (argv.length != 1) {
                    Console.out.println("changemap: map number");
                    return CommandResponse.SILENT_RESPONSE;
                }
                try {
                    int num = Integer.parseInt(argv[0]);
                    gGameScreen.changemap(num);
                }
                catch (Exception e) {
                    Console.out.println("type out of range");
                }
            } else {
                Console.out.println("changemap: not in a game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
    }

    @Override
    public void show() {
        gDemoScreen.onStopRecord();
        engine.getTileManager().setTilesPath(0);
        game.changeScreen(gIntroScreen.setSkipping(this.toMenu));
    }

    @Override
    public DefaultPrecacheScreen getPrecacheScreen(Runnable readyCallback, PrecacheListener listener) {
        return new PrecacheScreen(readyCallback, listener);
    }

    @Override
    public LogSender getLogSender() {
        return new LogSender(this){

            @Override
            public byte[] reportData() {
                String report = "Map: " + Globals.mapnum;
                report = report + "\r\n";
                report = report + "Skill " + Globals.nDifficult;
                report = report + "\r\n";
                if (Globals.gPlayer[Mmulti.myconnectindex] != null) {
                    report = report + "PlayerX " + Globals.gPlayer[Mmulti.myconnectindex].x;
                    report = report + "\r\n";
                    report = report + "PlayerY " + Globals.gPlayer[Mmulti.myconnectindex].y;
                    report = report + "\r\n";
                    report = report + "PlayerZ " + Globals.gPlayer[Mmulti.myconnectindex].z;
                    report = report + "\r\n";
                    report = report + "PlayerAng " + Globals.gPlayer[Mmulti.myconnectindex].ang;
                    report = report + "\r\n";
                    report = report + "PlayerSect " + Globals.gPlayer[Mmulti.myconnectindex].sectnum;
                    report = report + "\r\n";
                }
                return report.getBytes();
            }
        };
    }

    @Override
    public void dispose() {
        gDemoScreen.onStopRecord();
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/LSP/Main", "getRenderer"));
    }

    public static enum UserFlag {
        None,
        UserMap;

    }
}

