/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.LSP.Factory.LSPRenderer;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;

public class Quotes {
    public static final int showQuotes = 4;
    public static final int quoteTime = 500;
    public static int nextTime;
    public static int nextY;
    public static final int kMaxQuotes = 16;
    public static int numQuotes;
    public static int hideQuotes;
    public static int totalQuotes;
    public static final QUOTE[] quotes;
    public static final int yOffset = 11;

    public static void InitQuotes() {
        for (int i = 0; i < 16; ++i) {
            Quotes.quotes[i] = new QUOTE();
        }
    }

    public static void resetQuotes() {
        numQuotes = 0;
        totalQuotes = 0;
        hideQuotes = 0;
    }

    public static void viewSetMessage(String message) {
        QUOTE quote = quotes[totalQuotes];
        quote.messageText = message;
        Console.out.println(message);
        quote.messageTime = 2000 + Globals.lockclock;
        ++totalQuotes;
        totalQuotes %= 16;
        if (++numQuotes > 4) {
            ++hideQuotes;
            hideQuotes %= 16;
            nextTime = 0;
            numQuotes = 4;
            nextY = 11;
        }
    }

    public static void viewDisplayMessage() {
        LSPRenderer renderer = Main.game.getRenderer();
        if (!Main.cfg.gShowMessages || Main.game.menu.gShowMenu) {
            return;
        }
        int x = Pragmas.scale(10L, Main.cfg.gHUDSize, 65536L);
        int y = Pragmas.scale(10L, Main.cfg.gHUDSize, 65536L);
        int nShade = Gameutils.BClipHigh(numQuotes << 3, 48);
        y += Pragmas.scale(nextY, Main.cfg.gHUDSize, 65536L);
        for (int i = 0; i < numQuotes; ++i) {
            QUOTE quote = quotes[(i + hideQuotes) % 16];
            if (Globals.lockclock < quote.messageTime) {
                int col = Math.max(16 + (32 - nShade), 0) * 255 / 48;
                PaletteManager paletteManager = Main.engine.getPaletteManager();
                byte palcol = Main.engine.getPaletteManager().getFastColorLookup().getClosestColorIndex(paletteManager.getCurrentPalette().getBytes(), col, col, col);
                Main.game.getFont(1).drawText((Renderer)renderer, x + 1, y, quote.messageText, (float)Main.cfg.gHUDSize / 65536.0f, nShade, (int)palcol, TextAlign.Left, Transparent.None, true);
                y += Pragmas.scale(11L, Main.cfg.gHUDSize, 65536L);
                nShade = Gameutils.BClipLow(nShade - 64 / numQuotes, -128);
                continue;
            }
            --numQuotes;
            ++hideQuotes;
            hideQuotes %= 16;
        }
        if (nextY != 0) {
            nextY = nextTime * 11 / 4;
        }
    }

    static {
        quotes = new QUOTE[16];
    }

    public static class QUOTE {
        public String messageText;
        public int messageTime;
    }
}

