/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import java.util.Arrays;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.AbstractRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.LSP.Animate;
import ru.m210projects.LSP.Config;
import ru.m210projects.LSP.Enemies;
import ru.m210projects.LSP.Factory.LSPInput;
import ru.m210projects.LSP.Factory.LSPMenuHandler;
import ru.m210projects.LSP.Factory.LSPRenderer;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.LoadSave;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Menus.MenuInterfaceSet;
import ru.m210projects.LSP.Player;
import ru.m210projects.LSP.Quotes;
import ru.m210projects.LSP.Screens.DemoScreen;
import ru.m210projects.LSP.Sectors;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Sprites;
import ru.m210projects.LSP.Types.PlayerStruct;
import ru.m210projects.LSP.View;
import ru.m210projects.LSP.Weapons;

public class GameScreen
extends GameAdapter {
    public int gNameShowTime;
    public final Main game;
    private int nonsharedtimer;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        View.FixPalette();
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.gPlayer[i].pInput.Copy(net.gFifoInput[net.gNetFifoTail & 0xFF][i]);
            if ((Globals.gPlayer[i].pInput.bits & 0x20000) != 0) {
                this.game.gPaused = !this.game.gPaused;
                this.sndHandlePause(this.game.gPaused);
            }
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
        if ((this.game.gPaused || !DemoScreen.isDemoPlaying() && !DemoScreen.isDemoScreen(this) && (this.game.menu.gShowMenu || Console.out.isShowing())) && !this.game.menu.isOpened(this.game.menu.mMenus[14])) {
            return;
        }
        Main.gDemoScreen.onRecord();
        int TICSPERFRAME = Main.engine.getTimer().getFrameTicks();
        Globals.lockclock += TICSPERFRAME;
        short i2 = Mmulti.connecthead;
        while (i2 >= 0) {
            Globals.gPlayer[i2].UpdatePlayerLoc();
            Player.processinput(i2);
            Sprites.checktouchsprite(i2);
            i2 = Mmulti.connectpoint2[i2];
        }
        View.MarkSectorSeen(Globals.gPlayer[Mmulti.myconnectindex].sectnum);
        if (Globals.followmode) {
            Globals.followx += Globals.followvel * EngineUtils.sin(2560 - (Globals.followa += (int)Globals.followang) & 0x7FF) >> 10;
            Globals.followy += Globals.followvel * EngineUtils.sin(1024 - Globals.followa & 0x7FF) >> 10;
            Globals.followx += Globals.followsvel * EngineUtils.sin(1024 - Globals.followa & 0x7FF) >> 10;
            Globals.followy -= Globals.followsvel * EngineUtils.sin(2560 - Globals.followa & 0x7FF) >> 10;
        }
        Animate.doanimations(TICSPERFRAME);
        Sectors.tagcode();
        Sprites.statuslistcode();
        Sounds.updatesounds();
        ++Globals.totalmoves;
    }

    @Override
    public void DrawWorld(float smooth) {
        View.drawscreen(Globals.screenpeek, (int)smooth);
    }

    @Override
    public void DrawHud(float smooth) {
        if (this.pMenu.gShowMenu && !(this.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            return;
        }
        LSPRenderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        if (Globals.mapnum > 0) {
            if (Globals.gPlayer[Globals.screenpeek].gViewMode != 4 && Globals.gPlayer[Globals.screenpeek].nHealth > 0 && !Player.isonwater(Globals.screenpeek) && Globals.mapnum > 0) {
                Weapons.drawweapons(Globals.screenpeek);
            }
            int yoffs = Pragmas.scale(50L, Main.cfg.gHUDSize, 65536L);
            View.drawbar(10, ydim - yoffs, Main.cfg.gHUDSize, Mmulti.myconnectindex);
            View.viewDrawStats(10, ydim - yoffs, Main.cfg.gHUDSize);
        }
        Quotes.viewDisplayMessage();
        if (Globals.gPlayer[Mmulti.myconnectindex].gViewMode != 3) {
            int pos = 25;
            if (Globals.followmode) {
                this.game.getFont(1).drawText((Renderer)renderer, 20, pos += Pragmas.scale(25L, Main.cfg.gHUDSize, 65536L), "Follow mode", (float)Main.cfg.gHUDSize / 65536.0f, 0, 4, TextAlign.Left, Transparent.None, true);
            }
            this.game.getFont(1).drawText((Renderer)renderer, 20, pos + Pragmas.scale(25L, Main.cfg.gHUDSize, 65536L), Globals.book + "b " + Globals.chapter + "c " + Globals.verse + "v", (float)Main.cfg.gHUDSize / 65536.0f, 0, 4, TextAlign.Left, Transparent.None, true);
        }
        if (Main.engine.getTotalClock() < this.gNameShowTime) {
            Transparent transp = Transparent.None;
            if (Main.engine.getTotalClock() > this.gNameShowTime - 20) {
                transp = Transparent.Bit1;
            }
            if (Main.engine.getTotalClock() > this.gNameShowTime - 10) {
                transp = Transparent.Bit2;
            }
            if (Main.cfg.showMapInfo != 0 && !this.game.menu.gShowMenu && Globals.mapnum > 0) {
                this.game.getFont(2).drawTextScaled((Renderer)renderer, 160, 100, Globals.book + "b " + Globals.chapter + "c " + Globals.verse + "v", 1.0f, -128, 70, TextAlign.Center, transp, ConvertType.Normal, true);
            }
        }
        if (this.game.gPaused && !this.game.menu.gShowMenu) {
            this.game.getFont(2).drawTextScaled((Renderer)renderer, 160, 100, "GAME PAUSED", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        }
        if (View.nPalDiff != 0) {
            AbstractRenderer.DEFAULT_SCREEN_FADE.set(Math.min(63, View.rtint) << 2, Math.min(63, View.gtint) << 2, Math.min(63, View.btint) << 2, View.nPalDiff | 0x80);
            renderer.showScreenFade(AbstractRenderer.DEFAULT_SCREEN_FADE);
        }
    }

    @Override
    public void processInput(GameProcessor processor) {
        if (Globals.gPlayer[Mmulti.myconnectindex].gViewMode != 3) {
            int j = Main.engine.getTotalClock() - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (processor.isGameKeyPressed(GameKeys.Enlarge_Screen)) {
                Globals.gPlayer[Mmulti.myconnectindex].zoom += Pragmas.mulscale(j, Math.max(Globals.gPlayer[Mmulti.myconnectindex].zoom, 256), 6);
            }
            if (processor.isGameKeyPressed(GameKeys.Shrink_Screen)) {
                Globals.gPlayer[Mmulti.myconnectindex].zoom -= Pragmas.mulscale(j, Math.max(Globals.gPlayer[Mmulti.myconnectindex].zoom, 256), 6);
            }
            if (Globals.gPlayer[Mmulti.myconnectindex].zoom > 2048) {
                Globals.gPlayer[Mmulti.myconnectindex].zoom = 2048;
            }
            if (Globals.gPlayer[Mmulti.myconnectindex].zoom < 48) {
                Globals.gPlayer[Mmulti.myconnectindex].zoom = 48;
            }
        }
    }

    protected boolean gameKeyDownCommon(GameKey gameKey, boolean inGame) {
        if (super.gameKeyDown(gameKey)) {
            return true;
        }
        LSPMenuHandler menu = this.game.menu;
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            if (inGame) {
                menu.mOpen(menu.mMenus[1], -1);
            } else {
                menu.mOpen(menu.mMenus[0], -1);
            }
            return true;
        }
        if (Config.LSPKeys.Show_Loadmenu.equals(gameKey)) {
            if (Mmulti.numplayers > 1 || this.game.nNetMode != BuildGame.NetMode.Single) {
                return false;
            }
            menu.mOpen(menu.mMenus[3], -1);
            return true;
        }
        if (Config.LSPKeys.Show_Sounds.equals(gameKey)) {
            menu.mOpen(menu.mMenus[8], -1);
            return true;
        }
        if (Config.LSPKeys.Show_Options.equals(gameKey)) {
            menu.mOpen(menu.mMenus[10], -1);
            return true;
        }
        if (Config.LSPKeys.Gamma.equals(gameKey)) {
            menu.mOpen(menu.mMenus[11], -1);
            return true;
        }
        if (Config.LSPKeys.Quit.equals(gameKey)) {
            menu.mOpen(menu.mMenus[6], -1);
            return true;
        }
        if (Config.LSPKeys.Toggle_Crosshair.equals(gameKey)) {
            Main.cfg.gCrosshair = !Main.cfg.gCrosshair;
            Quotes.viewSetMessage("Crosshair: " + (Main.cfg.gCrosshair ? "ON" : "OFF"));
        }
        if (Config.LSPKeys.Make_Screenshot.equals(gameKey)) {
            this.makeScreenshot();
            return true;
        }
        return false;
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        LSPMenuHandler menu = this.game.menu;
        if (this.gameKeyDownCommon(gameKey, true)) {
            return true;
        }
        if (Config.LSPKeys.Show_Savemenu.equals(gameKey)) {
            if (this.game.nNetMode == BuildGame.NetMode.Single) {
                Main.gGameScreen.capture(160, 100);
                menu.mOpen(menu.mMenus[4], -1);
            }
        } else if (Config.LSPKeys.Quicksave.equals(gameKey)) {
            LoadSave.quicksave();
        } else if (Config.LSPKeys.Quickload.equals(gameKey)) {
            LoadSave.quickload();
        } else if (Config.LSPKeys.AutoRun.equals(gameKey)) {
            Main.cfg.gAutoRun = !Main.cfg.gAutoRun;
            Quotes.viewSetMessage("Autorun: " + (Main.cfg.gAutoRun ? "ON" : "OFF"));
        } else if (GameKeys.Mouse_Aiming.equals(gameKey)) {
            Main.cfg.setgMouseAim(!Main.cfg.isgMouseAim());
            Quotes.viewSetMessage("Mouse aiming: " + (Main.cfg.isgMouseAim() ? "ON" : "OFF"));
        } else if (Config.LSPKeys.Map_Follow_Mode.equals(gameKey)) {
            boolean bl = Globals.followmode = !Globals.followmode;
            if (Globals.followmode) {
                Globals.followx = Globals.gPlayer[Mmulti.myconnectindex].x;
                Globals.followy = Globals.gPlayer[Mmulti.myconnectindex].y;
                Globals.followa = (int)Globals.gPlayer[Mmulti.myconnectindex].ang;
            }
            Quotes.viewSetMessage("Follow mode " + (Globals.followmode ? "ON" : "OFF"));
        } else if (GameKeys.Map_Toggle.equals(gameKey)) {
            Globals.gPlayer[Mmulti.myconnectindex].gViewMode = (byte)this.setOverHead(Globals.gPlayer[Mmulti.myconnectindex].gViewMode);
        }
        return false;
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (LoadSave.gQuickSaving) {
            if (this.captBuffer != null) {
                LoadSave.savegame(this.game.getUserDirectory(), "[quicksave_" + LoadSave.quickslot + "]", "quicksav" + LoadSave.quickslot + ".sav");
                LoadSave.quickslot ^= 1;
                LoadSave.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (LoadSave.gAutosaveRequest) {
            if (this.captBuffer != null) {
                LoadSave.savegame(this.game.getUserDirectory(), "[autosave]", "autosave.sav");
                LoadSave.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
    }

    protected void makeScreenshot() {
        String name = "scr-map" + Globals.mapnum + "-xxxx.png";
        LSPRenderer renderer = this.game.getRenderer();
        String filename = renderer.screencapture(this.game.getUserDirectory(), name);
        if (filename != null) {
            Quotes.viewSetMessage(filename + " saved");
        } else {
            Quotes.viewSetMessage("Screenshot not saved. Access denied!");
        }
    }

    protected int setOverHead(int mode) {
        int out = 0;
        switch (mode) {
            case 3: {
                if (Main.cfg.gOverlayMap != 0) {
                    out = 2;
                    break;
                }
                out = 4;
                break;
            }
            case 2: {
                if (Main.cfg.gOverlayMap == 1) {
                    out = 3;
                    break;
                }
                out = 4;
                break;
            }
            case 4: {
                out = 3;
            }
        }
        return out;
    }

    @Override
    protected boolean prepareboard(Entry entry) {
        Sounds.stopmusic();
        Sounds.stopallsounds();
        try {
            Sector sec;
            int i;
            Board board = Main.engine.loadboard(entry);
            BuildPos pos = board.getPos();
            short i2 = Mmulti.connecthead;
            while (i2 >= 0) {
                PlayerStruct pPlayer = Globals.gPlayer[i2];
                if (Globals.mapnum > 1) {
                    pPlayer.savePlayersInventory();
                }
                pPlayer.pInput.reset();
                pPlayer.ox = pPlayer.x = pos.x;
                pPlayer.oy = pPlayer.y = pos.y;
                pPlayer.oz = pPlayer.z = pos.z;
                pPlayer.oang = pPlayer.ang = (float)pos.ang;
                pPlayer.osectnum = pPlayer.sectnum = pos.sectnum;
                pPlayer.horiz = 100.0f;
                pPlayer.ohoriz = 100.0f;
                pPlayer.gViewMode = (byte)3;
                pPlayer.zoom = 768;
                pPlayer.nSprite = -1;
                pPlayer.nWeaponState = 0;
                pPlayer.nBobCount = 0;
                pPlayer.nWeaponSeq = 0;
                pPlayer.nWeapon = Globals.nPlayerFirstWeapon;
                pPlayer.nLastChoosedWeapon = (short)6;
                pPlayer.nLastManaWeapon = (short)13;
                pPlayer.nPlayerStatus = 0;
                pPlayer.word_586FC = 0;
                pPlayer.nWeaponImpact = 0;
                pPlayer.nWeaponImpactAngle = 0;
                pPlayer.hvel = 0;
                pPlayer.isWeaponsSwitching = 0;
                pPlayer.nSwitchingClock = 0;
                pPlayer.word_58794 = 0;
                pPlayer.nWeaponShootCount = 0;
                pPlayer.nSlimeDamageCount = 0;
                pPlayer.nWeaponClock = 0;
                switch (Globals.nPlayerFirstWeapon) {
                    case 18: 
                    case 20: {
                        pPlayer.nFirstWeaponDamage = 9;
                        pPlayer.nSecondWeaponDamage = 18;
                        break;
                    }
                    case 19: {
                        pPlayer.nFirstWeaponDamage = 7;
                        pPlayer.nSecondWeaponDamage = 21;
                        break;
                    }
                    case 21: {
                        pPlayer.nFirstWeaponDamage = 8;
                        pPlayer.nSecondWeaponDamage = 18;
                        break;
                    }
                    case 22: {
                        pPlayer.nFirstWeaponDamage = 6;
                        pPlayer.nSecondWeaponDamage = 17;
                        break;
                    }
                    case 23: {
                        pPlayer.nFirstWeaponDamage = 6;
                        pPlayer.nSecondWeaponDamage = 16;
                        break;
                    }
                    case 24: {
                        pPlayer.nFirstWeaponDamage = pPlayer.nRandDamage1;
                        pPlayer.nSecondWeaponDamage = pPlayer.nRandDamage1 + pPlayer.nRandDamage2;
                        break;
                    }
                    default: {
                        pPlayer.nFirstWeaponDamage = 9;
                        pPlayer.nSecondWeaponDamage = 16;
                    }
                }
                i2 = Mmulti.connectpoint2[i2];
            }
            LSPRenderer renderer = this.game.getRenderer();
            renderer.setVisibility(15);
            Engine.pskyoff[0] = 0;
            Engine.pskyoff[1] = 0;
            Engine.pskyoff[2] = 0;
            Engine.pskyoff[3] = 0;
            Engine.parallaxtype = 0;
            renderer.setParallaxOffset(256);
            Engine.pskybits = (short)2;
            Globals.totalmoves = 0;
            Globals.nNextMap = 0;
            Quotes.numQuotes = 0;
            for (i = 0; i < 16; ++i) {
                Globals.waterfountainwall[i] = -1;
                Globals.waterfountaincnt[i] = 0;
            }
            Globals.warpsectorcnt = 0;
            Globals.warpsector2cnt = 0;
            Globals.xpanningsectorcnt = 0;
            Globals.floorpanningcnt = 0;
            Globals.swingcnt = 0;
            Globals.revolvecnt = 0;
            Globals.subwaytrackcnt = 0;
            Globals.dragsectorcnt = 0;
            Globals.nKickSprite = -1;
            for (i = 0; i < Main.boardService.getSectorCount(); i = (int)((short)(i + 1))) {
                Sector sec2 = Main.boardService.getSector(i);
                if (sec2 == null) continue;
                switch (sec2.getCeilingpicnum()) {
                    case 250: {
                        sec2.setCeilingpicnum(252);
                        break;
                    }
                    case 251: {
                        sec2.setCeilingpicnum(255);
                        break;
                    }
                    case 254: {
                        sec2.setCeilingpicnum(253);
                    }
                }
                switch (sec2.getFloorpicnum()) {
                    case 250: {
                        sec2.setFloorpicnum(252);
                        break;
                    }
                    case 251: {
                        sec2.setFloorpicnum(255);
                        break;
                    }
                    case 254: {
                        sec2.setFloorpicnum(253);
                    }
                }
                switch (sec2.getLotag()) {
                    case 4: 
                    case 5: {
                        short s = Globals.floorpanningcnt;
                        Globals.floorpanningcnt = (short)(s + 1);
                        Globals.floorpanninglist[s] = i;
                        break;
                    }
                    case 10: {
                        short s = Globals.warpsectorcnt;
                        Globals.warpsectorcnt = (short)(s + 1);
                        Globals.warpsectorlist[s] = i;
                        break;
                    }
                    case 11: {
                        short s = Globals.xpanningsectorcnt;
                        Globals.xpanningsectorcnt = (short)(s + 1);
                        Globals.xpanningsectorlist[s] = i;
                        break;
                    }
                    case 12: {
                        Wall w1;
                        short dasector;
                        Sector nsec;
                        ListNode<Wall> wn3;
                        int dax = Integer.MAX_VALUE;
                        int day = Integer.MAX_VALUE;
                        int dax2 = Integer.MIN_VALUE;
                        int day2 = Integer.MIN_VALUE;
                        Wall k = null;
                        for (wn3 = sec2.getWallNode(); wn3 != null; wn3 = wn3.getNext()) {
                            Wall wal = wn3.get();
                            if (wal.getX() < dax) {
                                dax = wal.getX();
                            }
                            if (wal.getY() < day) {
                                day = wal.getY();
                            }
                            if (wal.getX() > dax2) {
                                dax2 = wal.getX();
                            }
                            if (wal.getY() > day2) {
                                day2 = wal.getY();
                            }
                            if (wal.getLotag() != 3) continue;
                            k = wal;
                        }
                        if (k == null) break;
                        if (k.getX() == dax) {
                            Globals.dragxdir[Globals.dragsectorcnt] = -16;
                        }
                        if (k.getY() == day) {
                            Globals.dragydir[Globals.dragsectorcnt] = -16;
                        }
                        if (k.getX() == dax2) {
                            Globals.dragxdir[Globals.dragsectorcnt] = 16;
                        }
                        if (k.getY() == day2) {
                            Globals.dragydir[Globals.dragsectorcnt] = 16;
                        }
                        if ((nsec = Main.boardService.getSector(dasector = (w1 = sec2.getWallNode().get()).getNextsector())) == null) break;
                        Globals.dragx1[Globals.dragsectorcnt] = Integer.MAX_VALUE;
                        Globals.dragy1[Globals.dragsectorcnt] = Integer.MAX_VALUE;
                        Globals.dragx2[Globals.dragsectorcnt] = Integer.MIN_VALUE;
                        Globals.dragy2[Globals.dragsectorcnt] = Integer.MIN_VALUE;
                        for (ListNode<Wall> wn2 = nsec.getWallNode(); wn2 != null; wn2 = wn2.getNext()) {
                            Wall wal = wn2.get();
                            if (wal.getX() < Globals.dragx1[Globals.dragsectorcnt]) {
                                Globals.dragx1[Globals.dragsectorcnt] = wal.getX();
                            }
                            if (wal.getY() < Globals.dragy1[Globals.dragsectorcnt]) {
                                Globals.dragy1[Globals.dragsectorcnt] = wal.getY();
                            }
                            if (wal.getX() > Globals.dragx2[Globals.dragsectorcnt]) {
                                Globals.dragx2[Globals.dragsectorcnt] = wal.getX();
                            }
                            if (wal.getY() <= Globals.dragy2[Globals.dragsectorcnt]) continue;
                            Globals.dragy2[Globals.dragsectorcnt] = wal.getY();
                        }
                        short s = Globals.dragsectorcnt;
                        Globals.dragx1[s] = Globals.dragx1[s] + (w1.getX() - dax);
                        short s2 = Globals.dragsectorcnt;
                        Globals.dragy1[s2] = Globals.dragy1[s2] + (w1.getY() - day);
                        short s3 = Globals.dragsectorcnt;
                        Globals.dragx2[s3] = Globals.dragx2[s3] - (dax2 - w1.getX());
                        short s4 = Globals.dragsectorcnt;
                        Globals.dragy2[s4] = Globals.dragy2[s4] - (day2 - w1.getY());
                        Globals.dragfloorz[Globals.dragsectorcnt] = sec2.getFloorz();
                        short s5 = Globals.dragsectorcnt;
                        Globals.dragsectorcnt = (short)(s5 + 1);
                        Globals.dragsectorlist[s5] = i;
                        sec2.setFloorstat(sec2.getFloorstat() | 0x40);
                        break;
                    }
                    case 13: {
                        for (ListNode<Wall> wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                            Wall wal = wn.get();
                            if (wal.getLotag() != 4) continue;
                            Wall w4 = wal.getWall2().getWall2().getWall2().getWall2();
                            if (wal.getX() == w4.getX() && wal.getY() == w4.getY()) {
                                Globals.swingdoor[Globals.swingcnt].wall[0] = wn.getIndex();
                                Globals.swingdoor[Globals.swingcnt].wall[1] = wal.getPoint2();
                                Globals.swingdoor[Globals.swingcnt].wall[2] = wal.getWall2().getPoint2();
                                Globals.swingdoor[Globals.swingcnt].wall[3] = wal.getWall2().getWall2().getPoint2();
                                Globals.swingdoor[Globals.swingcnt].angopen = 1536;
                                Globals.swingdoor[Globals.swingcnt].angclosed = 0;
                                Globals.swingdoor[Globals.swingcnt].angopendir = -1;
                            } else {
                                Globals.swingdoor[Globals.swingcnt].wall[0] = wal.getPoint2();
                                Globals.swingdoor[Globals.swingcnt].wall[1] = wn.getIndex();
                                Globals.swingdoor[Globals.swingcnt].wall[2] = Main.engine.lastwall(wn.getIndex());
                                Globals.swingdoor[Globals.swingcnt].wall[3] = Main.engine.lastwall(Globals.swingdoor[Globals.swingcnt].wall[2]);
                                Globals.swingdoor[Globals.swingcnt].angopen = 512;
                                Globals.swingdoor[Globals.swingcnt].angclosed = 0;
                                Globals.swingdoor[Globals.swingcnt].angopendir = 1;
                            }
                            for (int k = 0; k < 4; ++k) {
                                Wall w = Main.boardService.getWall(Globals.swingdoor[Globals.swingcnt].wall[k]);
                                if (w == null) continue;
                                Globals.swingdoor[Globals.swingcnt].x[k] = w.getX();
                                Globals.swingdoor[Globals.swingcnt].y[k] = w.getY();
                            }
                            Globals.swingdoor[Globals.swingcnt].sector = i;
                            Globals.swingdoor[Globals.swingcnt].ang = Globals.swingdoor[Globals.swingcnt].angclosed;
                            Globals.swingdoor[Globals.swingcnt].anginc = 0;
                            Globals.swingcnt = (short)(Globals.swingcnt + 1);
                        }
                        break;
                    }
                    case 14: {
                        Wall wal;
                        ListNode<Wall> wn;
                        ListNode<Wall> wn3;
                        short startwall = sec2.getWallptr();
                        short endwall = (short)(startwall + sec2.getWallnum() - 1);
                        int dax = 0;
                        int day = 0;
                        for (wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                            wal = wn.get();
                            dax += wal.getX();
                            day += wal.getY();
                        }
                        Globals.revolvepivotx[Globals.revolvecnt] = dax / (endwall - startwall + 1);
                        Globals.revolvepivoty[Globals.revolvecnt] = day / (endwall - startwall + 1);
                        int k = 0;
                        for (wn3 = sec2.getWallNode(); wn3 != null; wn3 = wn3.getNext()) {
                            Wall wal2 = wn3.get();
                            Globals.revolvex[Globals.revolvecnt][k] = wal2.getX();
                            Globals.revolvey[Globals.revolvecnt][k] = wal2.getY();
                            ++k;
                        }
                        Globals.revolvesector[Globals.revolvecnt] = i;
                        Globals.revolveang[Globals.revolvecnt] = 0;
                        Globals.revolvecnt = (short)(Globals.revolvecnt + 1);
                        break;
                    }
                    case 15: {
                        int j;
                        Wall wal;
                        ListNode<Wall> wn;
                        Globals.subwaytracksector[Globals.subwaytrackcnt][0] = i;
                        Globals.subwaystopcnt[Globals.subwaytrackcnt] = 0;
                        int dax = Integer.MAX_VALUE;
                        int day = Integer.MAX_VALUE;
                        int dax2 = Integer.MIN_VALUE;
                        int day2 = Integer.MIN_VALUE;
                        for (wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                            wal = wn.get();
                            if (wal.getX() < dax) {
                                dax = wal.getX();
                            }
                            if (wal.getY() < day) {
                                day = wal.getY();
                            }
                            if (wal.getX() > dax2) {
                                dax2 = wal.getX();
                            }
                            if (wal.getY() <= day2) continue;
                            day2 = wal.getY();
                        }
                        for (wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                            wal = wn.get();
                            if (wal.getLotag() != 5) continue;
                            if (wal.getX() > dax && wal.getY() > day && wal.getX() < dax2 && wal.getY() < day2) {
                                Globals.subwayx[Globals.subwaytrackcnt] = wal.getX();
                                continue;
                            }
                            Globals.subwaystop[Globals.subwaytrackcnt][Globals.subwaystopcnt[Globals.subwaytrackcnt]] = wal.getX();
                            short s = Globals.subwaytrackcnt;
                            Globals.subwaystopcnt[s] = Globals.subwaystopcnt[s] + 1;
                        }
                        for (j = 1; j < Globals.subwaystopcnt[Globals.subwaytrackcnt]; ++j) {
                            for (int k = 0; k < j; ++k) {
                                if (Globals.subwaystop[Globals.subwaytrackcnt][j] >= Globals.subwaystop[Globals.subwaytrackcnt][k]) continue;
                                int s = Globals.subwaystop[Globals.subwaytrackcnt][j];
                                Globals.subwaystop[Globals.subwaytrackcnt][j] = Globals.subwaystop[Globals.subwaytrackcnt][k];
                                Globals.subwaystop[Globals.subwaytrackcnt][k] = s;
                            }
                        }
                        Globals.subwaygoalstop[Globals.subwaytrackcnt] = 0;
                        for (j = 0; j < Globals.subwaystopcnt[Globals.subwaytrackcnt]; ++j) {
                            if (Math.abs(Globals.subwaystop[Globals.subwaytrackcnt][j] - Globals.subwayx[Globals.subwaytrackcnt]) >= Math.abs(Globals.subwaystop[Globals.subwaytrackcnt][Globals.subwaygoalstop[Globals.subwaytrackcnt]] - Globals.subwayx[Globals.subwaytrackcnt])) continue;
                            Globals.subwaygoalstop[Globals.subwaytrackcnt] = j;
                        }
                        Globals.subwaytrackx1[Globals.subwaytrackcnt] = dax;
                        Globals.subwaytracky1[Globals.subwaytrackcnt] = day;
                        Globals.subwaytrackx2[Globals.subwaytrackcnt] = dax2;
                        Globals.subwaytracky2[Globals.subwaytrackcnt] = day2;
                        Globals.subwaynumsectors[Globals.subwaytrackcnt] = 1;
                        for (j = 0; j < Main.boardService.getSectorCount(); ++j) {
                            short startwall;
                            Wall w1;
                            Sector sec22;
                            if (j == i || (sec22 = Main.boardService.getSector(j)) == null || (w1 = Main.boardService.getWall(startwall = sec22.getWallptr())) == null || w1.getX() <= Globals.subwaytrackx1[Globals.subwaytrackcnt] || w1.getY() <= Globals.subwaytracky1[Globals.subwaytrackcnt] || w1.getX() >= Globals.subwaytrackx2[Globals.subwaytrackcnt] || w1.getY() >= Globals.subwaytracky2[Globals.subwaytrackcnt]) continue;
                            if (sec22.getLotag() == 16) {
                                sec22.setLotag(17);
                            }
                            if (sec22.getFloorz() != sec2.getFloorz()) {
                                sec22.setCeilingstat(sec22.getCeilingstat() | 0x40);
                                sec22.setFloorstat(sec22.getFloorstat() | 0x40);
                            }
                            Globals.subwaytracksector[Globals.subwaytrackcnt][Globals.subwaynumsectors[Globals.subwaytrackcnt]] = (short)j;
                            short s = Globals.subwaytrackcnt;
                            Globals.subwaynumsectors[s] = (short)(Globals.subwaynumsectors[s] + 1);
                        }
                        Globals.subwayvel[Globals.subwaytrackcnt] = 64;
                        Globals.subwaypausetime[Globals.subwaytrackcnt] = 2400;
                        Globals.subwaytrackcnt = (short)(Globals.subwaytrackcnt + 1);
                        break;
                    }
                    case 30: {
                        short s = Globals.warpsector2cnt;
                        Globals.warpsector2cnt = (short)(s + 1);
                        Globals.warpsector2list[s] = i;
                        break;
                    }
                    case 97: 
                    case 98: 
                    case 99: {
                        if (!Main.cfg.bShowExit) break;
                        Engine.show2dsector.setBit(i);
                    }
                }
                block51: for (ListNode<Sprite> node = Main.boardService.getSectNode(i); node != null; node = node.getNext()) {
                    Sprite spr = node.get();
                    if (!Main.engine.getTile(spr.getPicnum()).hasSize()) {
                        spr.setCstat(spr.getCstat() & 0xFFFFFFFE);
                    }
                    switch (spr.getPicnum()) {
                        case 51: {
                            if (Globals.mapnum != 0) continue block51;
                            Globals.nKickSprite = node.getIndex();
                            continue block51;
                        }
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: {
                            spr.setCstat(spr.getCstat() & 0xFFFFFFCF);
                        }
                        case 601: 
                        case 602: 
                        case 603: 
                        case 604: 
                        case 605: 
                        case 606: 
                        case 607: 
                        case 608: 
                        case 609: 
                        case 700: 
                        case 701: 
                        case 702: 
                        case 703: 
                        case 705: 
                        case 706: 
                        case 707: 
                        case 710: 
                        case 711: 
                        case 712: 
                        case 713: 
                        case 714: 
                        case 720: 
                        case 721: 
                        case 722: 
                        case 723: 
                        case 724: 
                        case 725: 
                        case 727: {
                            spr.setCstat(spr.getCstat() & 0xFFFFFEFE);
                        }
                    }
                }
            }
            Globals.ypanningwallcnt = 0;
            for (int w = 0; w < Main.boardService.getWallCount(); w = (int)((short)(w + 1))) {
                Wall wal = Main.boardService.getWall(w);
                if (wal == null) continue;
                if (wal.getLotag() == 1) {
                    short s = Globals.ypanningwallcnt;
                    Globals.ypanningwallcnt = (short)(s + 1);
                    Globals.ypanningwalllist[s] = w;
                }
                Wall wal2 = Main.boardService.getWall(wal.getNextwall());
                if ((wal.getCstat() & 1) != 0 && wal2 != null) {
                    wal2.setCstat(wal2.getCstat() | 1);
                }
                if (Globals.mapnum != 0) continue;
                if (wal.getLotag() == 121) {
                    Globals.nTrainWall = (short)w;
                    continue;
                }
                if (wal.getLotag() == 124) {
                    Globals.nDiffDoor = (short)w;
                    continue;
                }
                if (wal.getLotag() != 125) continue;
                Globals.nDiffDoorBack = (short)w;
            }
            Globals.bActiveTrain = false;
            Enemies.inienemies();
            i = Mmulti.connecthead;
            while (i >= 0) {
                Player.InitPlayer(i, pos);
                if (Globals.mapnum > 1) {
                    Globals.gPlayer[i].loadPlayersInventory();
                }
                i = Mmulti.connectpoint2[i];
            }
            if (Globals.mapnum == 4 && (sec = Main.boardService.getSector(82)) != null && sec.getHitag() == 0 && sec.getLotag() == 20) {
                sec.setLotag(21);
            }
            if (Globals.mapnum == 11 && (sec = Main.boardService.getSector(22)) != null && sec.getFloorz() == -2048 && sec.getLotag() == 2 && sec.getHitag() == 3) {
                sec.setFloorz(sec.getFloorz() + 4096);
                for (ListNode<Sprite> node = Main.boardService.getSectNode(22); node != null; node = node.getNext()) {
                    Sprite spr = node.get();
                    spr.setZ(spr.getZ() + 4096);
                }
                sec.setLotag(1);
            }
            if (Globals.mapnum == 21 && (sec = Main.boardService.getSector(32)) != null && sec.getCeilingz() == sec.getFloorz() && sec.getLotag() == 8 && sec.getHitag() == 2) {
                sec.setCeilingz(sec.getCeilingz() - 8192);
                sec.setFloorz(sec.getFloorz() + 8192);
                sec.setHitag(0);
            }
            if (Globals.mapnum == 32 && (sec = Main.boardService.getSector(29)) != null && sec.getFloorz() == -5120 && sec.getLotag() == 30) {
                sec.setFloorz(sec.getFloorz() + 8192);
            }
            Quotes.resetQuotes();
            View.GrabPalette();
            Globals.lockclock = 0;
            Main.engine.srand(17);
            ((LSPInput)this.game.getProcessor()).reset();
            Main.gDemoScreen.onPrepareboard(this);
            Sounds.startmusic(GameScreen.getMap((int)Globals.mapnum).music - 1);
            this.gNameShowTime = 500;
            this.game.pNet.ResetTimers();
            return true;
        }
        catch (Exception e) {
            Console.out.println("Load map exception: " + e);
            if (e.getMessage() != null) {
                this.game.GameMessage("Load map exception:\n" + e.getMessage());
            } else {
                this.game.GameMessage("Can't load the map " + entry);
            }
            return false;
        }
    }

    public static Globals.MapStruct getMap(int mapnum) {
        if (mapnum < 0 || mapnum >= Globals.maps.length) {
            throw new AssertException("Wrong map");
        }
        return Globals.maps[mapnum];
    }

    public void newgame(int num) {
        Main.gDemoScreen.onStopRecord();
        Globals.mapnum = num;
        Main.engine.getTileManager().setTilesPath(num == 0 ? 0 : 1);
        String map = "lev" + num + ".map";
        this.game.nNetMode = BuildGame.NetMode.Single;
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.gPlayer[i].nHealth = (short)160;
            Globals.gPlayer[i].nMana = (short)160;
            Arrays.fill(Globals.gPlayer[i].nAmmo, (short)0);
            Globals.gPlayer[i].nAmmo[1] = 100;
            Globals.gPlayer[i].nAmmo[7] = 1;
            Globals.gPlayer[i].calcRandomVariables();
            i = Mmulti.connectpoint2[i];
        }
        this.updatechapter(Globals.mapnum);
        this.loadboard(this.game.getCache().getEntry(map, true), null).setTitle("Loading " + map);
    }

    private void updatechapter(int map) {
        int mnum = Globals.maps[map].num & 0xFF;
        Globals.book = mnum % 100 % 10;
        Globals.chapter = mnum / 100;
        Globals.verse = mnum % 100 / 10;
    }

    public boolean NextMap() {
        byte nextmap = GameScreen.getMap((int)Globals.mapnum).nextmap[Globals.nNextMap - 1];
        Globals.nNextMap = 0;
        if (nextmap == 99) {
            return true;
        }
        if (nextmap == 0) {
            nextmap = 1;
        }
        this.updatechapter(Globals.mapnum);
        LoadSave.gAutosaveRequest = true;
        this.changemap(nextmap);
        return false;
    }

    public void changemap(int num) {
        Globals.mapnum = num;
        this.updatechapter(Globals.mapnum);
        String map = "lev" + Globals.mapnum + ".map";
        this.loadboard(this.game.getCache().getEntry(map, true), null).setTitle("Loading " + map);
    }

    @Override
    public void sndHandlePause(boolean pause) {
        Sounds.sndHandlePause(pause);
    }
}

