/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import java.io.FileNotFoundException;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Types.LSPMovieFile;

public class MovieScreen
extends ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen {
    public MovieScreen(BuildGame game) {
        super(game, Globals.TILE_ANIM);
        this.nFlags |= 4;
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        try {
            return new LSPMovieFile(file);
        }
        catch (FileNotFoundException fnf) {
            Console.out.println(file + " is not found!", OsdColor.RED);
            return null;
        }
        catch (Exception e) {
            Console.out.println("Error: " + e, OsdColor.RED);
            return null;
        }
    }

    @Override
    protected void StopAllSounds() {
        Sounds.stopAllSounds();
    }

    @Override
    protected byte[] DoDrawFrame(int num) {
        byte[] pic = this.mvfil.getFrame(num);
        if (((LSPMovieFile)this.mvfil).paletteChanged) {
            this.changepalette(this.mvfil.getPalette());
        }
        return pic;
    }

    @Override
    protected Font GetFont() {
        return this.game.getFont(1);
    }

    @Override
    protected void DrawEscText(Font font, int pal) {
        Renderer renderer = this.game.getRenderer();
        int shade = 16 + Pragmas.mulscale(16L, EngineUtils.sin(20 * this.engine.getTotalClock() & 0x7FF), 16);
        this.game.getFont(1).drawTextScaled(renderer, 160, 5, "Press ESC to skip", 1.0f, shade, pal, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
    }
}

