/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import com.badlogic.gdx.audio.Music;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Architecture.common.audio.SourceListener;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.LSP.Factory.MusicEntry;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.VOCDecoder;

public class Sounds {
    public static final SoundResource[] SoundBufs = new SoundResource[100];
    public static int currChannel;
    public static ActiveSound[] sActiveSound;
    public static int currTrack;
    public static Music currMusic;
    public static int currSong;
    public static BuildAudio audio;

    public static void sndInit() {
        Console.out.println("Initializing sound system");
        Main.cfg.setAudioDriver(Main.cfg.getAudioDriver());
        Main.cfg.setMidiDevice(Main.cfg.getMidiDevice());
        audio = Main.cfg.getAudio();
        audio.registerDecoder("VOC", new VOCDecoder());
        sActiveSound = new ActiveSound[Main.cfg.getMaxvoices()];
        for (int i = 0; i < sActiveSound.length; ++i) {
            Sounds.sActiveSound[i] = new ActiveSound();
        }
        currChannel = 0;
    }

    public static void stopallsounds() {
        currChannel = 0;
        Sounds.stopAllSounds();
        for (ActiveSound activeSound : sActiveSound) {
            activeSound.stop();
        }
    }

    public static void stopmusic() {
        if (currMusic != null) {
            currMusic.stop();
        }
        currTrack = -1;
        currMusic = null;
    }

    public static void startmusic(int num) {
        String himus;
        if (Main.cfg.isMuteMusic() || currMusic != null && currMusic.isPlaying() && currSong != -1 && currSong == num) {
            return;
        }
        if (Main.cfg.getMusicType() == 1 && Main.game.currentDef != null && (himus = Main.game.currentDef.audInfo.getDigitalInfo(Integer.toString(num))) != null) {
            Sounds.stopmusic();
            currMusic = Sounds.newMusic(himus);
            if (currMusic != null) {
                currSong = num;
                System.out.println("Play ogg music " + num);
                currMusic.setLooping(true);
                currMusic.play();
                return;
            }
        }
        Sounds.stopmusic();
        currMusic = Sounds.newMusic(num + 103);
        if (currMusic != null) {
            System.out.println("Play midi music " + num);
            currSong = num;
            currMusic.setLooping(true);
            currMusic.play();
        }
    }

    private static boolean loadsound(int num) {
        Entry entry = Main.game.cache.getEntry(Integer.toString(num + 3), false);
        if (!entry.exists()) {
            Console.out.println("Sound " + num + " not found.", OsdColor.RED);
            return false;
        }
        SoundData soundData = audio.getSoundDecoder("VOC").decode(entry);
        if (soundData == null) {
            Console.out.println("Could not open sound " + num, OsdColor.RED);
            soundData = new SoundData(8000, 1, 8, ByteBuffer.allocateDirect(0));
        }
        Sounds.SoundBufs[num] = new SoundResource(soundData, num);
        return true;
    }

    private static ActiveSound preparesound(int num, int priority) {
        if (Main.cfg.isNoSound() || num < 0 || num >= SoundBufs.length) {
            return null;
        }
        if (SoundBufs[num] == null && !Sounds.loadsound(num)) {
            return null;
        }
        int channel = currChannel++ & sActiveSound.length - 1;
        ActiveSound pSound = sActiveSound[channel];
        SoundResource res = SoundBufs[num];
        Source hVoice = Sounds.newSound(res.getBuffer(), res.getRate(), res.getBits(), priority);
        if (hVoice != null) {
            hVoice.setListener(pSound);
            pSound.pHandle = hVoice;
            pSound.soundnum = channel;
            return pSound;
        }
        return null;
    }

    public static void playsound(int num) {
        ActiveSound pSound = Sounds.preparesound(num, 256);
        if (pSound != null) {
            pSound.spr = -1;
            pSound.pHandle.play(1.0f);
        }
    }

    public static void playsound(int num, int spriteid) {
        int vol = Sounds.calcvolume(spriteid);
        if (vol == 0) {
            return;
        }
        ActiveSound pSound = Sounds.preparesound(num, vol);
        if (pSound != null) {
            pSound.spr = spriteid;
            pSound.pHandle.play((float)vol / 255.0f);
        }
    }

    public static int calcvolume(int spr) {
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            return 0;
        }
        int dist = Pragmas.klabs(Globals.gPlayer[Globals.screenpeek].x - pSprite.getX()) + Pragmas.klabs(Globals.gPlayer[Globals.screenpeek].y - pSprite.getY());
        int vol = Gameutils.BClipLow(65536 - (dist << 2), 0);
        if (dist < 1500) {
            vol = 65536;
        }
        return Gameutils.BClipRange((int)((float)vol / 65536.0f * 255.0f), 0, 255);
    }

    public static void updatesounds() {
        if (Main.cfg.isNoSound()) {
            return;
        }
        audio.setListener(Globals.gPlayer[Globals.screenpeek].x, Globals.gPlayer[Globals.screenpeek].z >> 4, Globals.gPlayer[Globals.screenpeek].y, (int)Globals.gPlayer[Globals.screenpeek].ang);
        for (ActiveSound activeSound : sActiveSound) {
            Sprite pSprite;
            if (activeSound.pHandle == null) continue;
            if (!activeSound.pHandle.isActive()) {
                activeSound.onStop();
                continue;
            }
            int spr = activeSound.spr;
            if (spr == -1 || (pSprite = Main.boardService.getSprite(spr)) == null) continue;
            activeSound.pHandle.setPosition(pSprite.getX(), pSprite.getZ() >> 4, pSprite.getY());
            activeSound.pHandle.setVolume((float)Sounds.calcvolume(spr) / 255.0f);
        }
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (currMusic != null) {
                currMusic.pause();
            }
            Sounds.stopAllSounds();
        } else if (!Main.cfg.isMuteMusic() && currMusic != null) {
            currMusic.play();
        }
    }

    public static void stopAllSounds() {
        audio.stopAllSounds();
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, priority);
    }

    public static Music newMusic(int index) {
        Entry entry = Main.game.cache.getEntry(Integer.toString(index), false);
        if (entry.exists()) {
            return audio.newMusic(new MusicEntry(entry, "mid"));
        }
        return null;
    }

    public static Music newMusic(String filePath) {
        Entry entry = Main.game.cache.getEntry(filePath, true);
        return audio.newMusic(entry);
    }

    static {
        currTrack = -1;
        currMusic = null;
        currSong = -1;
    }

    public static class ActiveSound
    implements SourceListener {
        public Source pHandle;
        public int spr;
        public int soundnum;

        public void stop() {
            if (this.pHandle != null) {
                this.pHandle.stop();
            }
            this.pHandle = null;
            this.soundnum = -1;
            this.spr = -1;
        }

        @Override
        public void onStop() {
            this.stop();
        }
    }

    public static class SoundResource {
        public final int num;
        public final SoundData data;

        public SoundResource(SoundData soundData, int num) {
            this.data = soundData;
            this.num = num;
        }

        public int getRate() {
            return this.data.getRate();
        }

        public ByteBuffer getBuffer() {
            return this.data.getData();
        }

        public int getBits() {
            return this.data.getBits();
        }
    }
}

