/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.LSP.Types.Input;
import ru.m210projects.LSP.Types.PlayerStruct;

public class DemoFile {
    public int rcnt = 0;
    public Input[][] recsync;
    public int reccnt;
    public int version;
    public int map;
    public int skill;
    public PlayerDemoData playerData;

    public DemoFile(InputStream is) throws Exception {
        String header = StreamUtils.readString(is, "LSPD".length());
        if (!header.equalsIgnoreCase("LSPD")) {
            throw new Exception("Wrong header: " + header);
        }
        this.reccnt = StreamUtils.readInt(is);
        this.version = StreamUtils.readUnsignedByte(is);
        if (this.version != 100) {
            throw new Exception("Wrong version!");
        }
        this.map = StreamUtils.readUnsignedByte(is);
        this.skill = StreamUtils.readUnsignedByte(is);
        this.playerData = new PlayerDemoData();
        this.playerData.readObject(is);
        this.recsync = new Input[this.reccnt][16];
        int rccnt = 0;
        for (int c = 0; c <= this.reccnt / 2520; ++c) {
            int l = Math.min(this.reccnt - rccnt, 2520);
            for (int rcnt = rccnt; rcnt < rccnt + l; ++rcnt) {
                for (int i = 0; i < 1; ++i) {
                    this.recsync[rcnt][i] = new Input().readObject(is);
                }
            }
            rccnt += 2520;
        }
    }

    public static class PlayerDemoData {
        public short nMana = (short)160;
        public short nHealth = (short)160;
        public short[] nAmmo = new short[]{0, 100, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
        public short nWeapon = (short)17;
        public short nLastWeapon = 0;
        public short nLastChoosedWeapon = (short)6;
        public short nLastManaWeapon = (short)13;
        public short nRandDamage1 = (short)13;
        public short nRandDamage2 = (short)9;

        public void readObject(InputStream is) throws IOException {
            this.nHealth = (short)StreamUtils.readInt(is);
            this.nMana = (short)StreamUtils.readInt(is);
            for (int i = 0; i < this.nAmmo.length; ++i) {
                this.nAmmo[i] = (short)StreamUtils.readInt(is);
            }
            this.nWeapon = (short)StreamUtils.readInt(is);
            this.nLastChoosedWeapon = (short)StreamUtils.readInt(is);
            this.nLastManaWeapon = (short)StreamUtils.readInt(is);
            this.nLastWeapon = (short)StreamUtils.readInt(is);
            this.nRandDamage1 = (short)StreamUtils.readInt(is);
            this.nRandDamage2 = (short)StreamUtils.readInt(is);
        }

        public void writeObject(OutputStream os) throws IOException {
            StreamUtils.writeInt(os, this.nHealth);
            StreamUtils.writeInt(os, this.nMana);
            for (short value : this.nAmmo) {
                StreamUtils.writeInt(os, value);
            }
            StreamUtils.writeInt(os, this.nWeapon);
            StreamUtils.writeInt(os, this.nLastChoosedWeapon);
            StreamUtils.writeInt(os, this.nLastManaWeapon);
            StreamUtils.writeInt(os, this.nLastWeapon);
            StreamUtils.writeInt(os, this.nRandDamage1);
            StreamUtils.writeInt(os, this.nRandDamage2);
        }

        public PlayerDemoData setFrom(PlayerStruct plr) {
            this.nHealth = plr.nHealth;
            this.nMana = plr.nMana;
            System.arraycopy(plr.nAmmo, 0, this.nAmmo, 0, this.nAmmo.length);
            this.nWeapon = plr.nWeapon;
            this.nLastChoosedWeapon = plr.nLastChoosedWeapon;
            this.nLastManaWeapon = plr.nLastManaWeapon;
            this.nLastWeapon = plr.nLastWeapon;
            this.nRandDamage1 = plr.nRandDamage1;
            this.nRandDamage2 = plr.nRandDamage2;
            return this;
        }

        public void applyTo(PlayerStruct plr) {
            plr.nHealth = this.nHealth;
            plr.nMana = this.nMana;
            System.arraycopy(this.nAmmo, 0, plr.nAmmo, 0, this.nAmmo.length);
            plr.nWeapon = this.nWeapon;
            plr.nLastChoosedWeapon = this.nLastChoosedWeapon;
            plr.nLastManaWeapon = this.nLastManaWeapon;
            plr.nLastWeapon = this.nLastWeapon;
            plr.nRandDamage1 = this.nRandDamage1;
            plr.nRandDamage2 = this.nRandDamage2;
        }
    }
}

