/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class PCXFile {
    private final int width;
    private final int height;
    private int pos;
    private final byte[] buffer;
    private byte[] palette;

    public PCXFile(Entry fil) throws Exception {
        try (InputStream is = fil.getInputStream();){
            byte manufacturer = StreamUtils.readByte(is);
            byte version = StreamUtils.readByte(is);
            byte rle = StreamUtils.readByte(is);
            byte bpp = StreamUtils.readByte(is);
            if (manufacturer != 10 || version != 5 || rle != 1 || bpp != 8) {
                throw new UnsupportedOperationException("Couldn't read the pcx file. Unsupported version");
            }
            StreamUtils.skip(is, 4);
            this.width = StreamUtils.readShort(is) + 1;
            this.height = StreamUtils.readShort(is) + 1;
            StreamUtils.skip(is, 116);
            this.pos = 0;
            this.buffer = new byte[this.width * this.height];
            for (int y = 0; y < this.height; ++y) {
                this.decodeLine(is);
            }
            StreamUtils.readByte(is);
            if (is.available() >= 768) {
                this.palette = StreamUtils.readBytes(is, 768);
            }
        }
    }

    private void decodeLine(InputStream is) throws IOException {
        int i = 0;
        while (i < this.width) {
            byte header = StreamUtils.readByte(is);
            if ((header & 0xC0) == 192) {
                int len = header & 0x3F;
                Gameutils.fill(this.buffer, this.pos, this.pos += len, StreamUtils.readByte(is));
                i += len;
                continue;
            }
            this.buffer[this.pos++] = header;
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getData() {
        return this.buffer;
    }

    public byte[] getPalette() {
        return this.palette;
    }
}

