/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import java.util.concurrent.atomic.AtomicInteger;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.LSP.Enemies;
import ru.m210projects.LSP.Factory.LSPRenderer;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Screens.DemoScreen;
import ru.m210projects.LSP.Weapons;

public class View {
    public static final int kView2D = 2;
    public static final int kView3D = 3;
    public static final int kView2DIcon = 4;
    private static final char[] statbuffer = new char[80];
    public static final AtomicInteger fz = new AtomicInteger();
    public static final AtomicInteger cz = new AtomicInteger();
    public static int nPalDiff;
    public static int nPalDelay;
    public static int rtint;
    public static int btint;
    public static int gtint;

    public static void drawscreen(int snum, int dasmoothratio) {
        int cposx = Globals.gPlayer[snum].x;
        int cposy = Globals.gPlayer[snum].y;
        int cposz = Globals.gPlayer[snum].z;
        float choriz = Globals.gPlayer[snum].horiz + Globals.gPlayer[snum].nBobbing;
        int czoom = Globals.gPlayer[snum].zoom;
        float cang = Globals.gPlayer[snum].ang;
        int csect = Globals.gPlayer[snum].sectnum;
        LSPRenderer renderer = Main.game.getRenderer();
        if (!Main.game.menu.gShowMenu && !Console.out.isShowing() || DemoScreen.isDemoPlaying()) {
            int ix = Globals.gPlayer[snum].ox;
            int iy = Globals.gPlayer[snum].oy;
            int iz = Globals.gPlayer[snum].oz;
            float iHoriz = Globals.gPlayer[snum].ohoriz;
            float inAngle = Globals.gPlayer[snum].oang;
            int izoom = Globals.gPlayer[snum].ozoom;
            ix += Pragmas.mulscale(cposx - Globals.gPlayer[snum].ox, dasmoothratio, 16);
            iy += Pragmas.mulscale(cposy - Globals.gPlayer[snum].oy, dasmoothratio, 16);
            iz += Pragmas.mulscale(cposz - Globals.gPlayer[snum].oz, dasmoothratio, 16);
            iHoriz += (choriz - Globals.gPlayer[snum].ohoriz) * (float)dasmoothratio / 65536.0f;
            inAngle += (Gameutils.BClampAngle(cang - Globals.gPlayer[snum].oang + 1024.0f) - 1024.0f) * (float)dasmoothratio / 65536.0f;
            izoom += Pragmas.mulscale(czoom - Globals.gPlayer[snum].ozoom, dasmoothratio, 16);
            cposx = ix;
            cposy = iy;
            cposz = iz;
            czoom = izoom;
            choriz = iHoriz;
            cang = inAngle;
        }
        Main.engine.getzsofslope(csect, cposx, cposy, fz, cz);
        int lz = 1024;
        if (cposz < cz.get() + lz) {
            cposz = cz.get() + lz;
        }
        if (cposz > fz.get() - lz) {
            cposz = fz.get() - lz;
        }
        if (Globals.gPlayer[snum].gViewMode != 4) {
            renderer.drawrooms(cposx, cposy, cposz, cang, choriz, csect);
            View.analyzesprites(snum, dasmoothratio);
            renderer.drawmasks();
            byte[] gotsector = renderer.getRenderedSectors();
            for (int i = 0; i < Main.boardService.getSectorCount(); ++i) {
                if ((gotsector[i >> 3] & Engine.pow2char[i & 7]) == 0) continue;
                View.MarkSectorSeen(i);
            }
        }
        if (Globals.gPlayer[snum].gViewMode != 3) {
            if (Globals.followmode) {
                cposx = Globals.followx;
                cposy = Globals.followy;
                cang = Globals.followa;
            }
            if (Globals.gPlayer[snum].gViewMode == 4) {
                renderer.clearview(0);
                renderer.drawmapview(cposx, cposy, czoom, (int)cang);
            }
            renderer.drawoverheadmap(cposx, cposy, czoom, (short)cang);
        }
    }

    public static void MarkSectorSeen(int sect) {
        Sector sec = Main.boardService.getSector(sect);
        if (sec == null) {
            return;
        }
        if (!Engine.show2dsector.getBit(sect)) {
            Engine.show2dsector.setBit(sect);
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Engine.show2dwall.setBit(wn.getIndex());
            }
        }
    }

    public static void analyzesprites(int snum, int smoothratio) {
        LSPRenderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        for (int i = 0; i < renderedSpriteList.getSize(); ++i) {
            Interpolation.ILoc oldLoc;
            Sprite pTSprite = (Sprite)renderedSpriteList.get(i);
            if (pTSprite.getOwner() == -1 || (oldLoc = Main.game.pInt.getsprinterpolate(pTSprite.getOwner())) == null) continue;
            int x = oldLoc.x;
            int y = oldLoc.y;
            int z = oldLoc.z;
            short nAngle = oldLoc.ang;
            nAngle = (short)(nAngle + (short)Pragmas.mulscale((pTSprite.getAng() - oldLoc.ang + 1024 & 0x7FF) - 1024, smoothratio, 16));
            pTSprite.setX(x += Pragmas.mulscale(pTSprite.getX() - oldLoc.x, smoothratio, 16));
            pTSprite.setY(y += Pragmas.mulscale(pTSprite.getY() - oldLoc.y, smoothratio, 16));
            pTSprite.setZ(z += Pragmas.mulscale(pTSprite.getZ() - oldLoc.z, smoothratio, 16));
            pTSprite.setAng(nAngle);
        }
        int dax = Globals.gPlayer[snum].x;
        int day = Globals.gPlayer[snum].y;
        block5: for (int i = 0; i < renderedSpriteList.getSize(); ++i) {
            Sprite tspr = (Sprite)renderedSpriteList.get(i);
            short owner = tspr.getOwner();
            Sprite ownerSpr = Main.boardService.getSprite(owner);
            if (ownerSpr == null) {
                tspr.setOwner(-1);
                continue;
            }
            int dx = tspr.getX() - dax;
            int dy = tspr.getY() - day;
            int k = EngineUtils.getAngle(dx, dy);
            k = (tspr.getAng() + 3072 + 128 - k & 0x7FF) >> 8 & 7;
            switch (tspr.getPicnum()) {
                case 275: 
                case 339: {
                    if (k <= 4) {
                        tspr.setPicnum(tspr.getPicnum() + (k + 3 & 4));
                        tspr.setCstat(tspr.getCstat() & 0xFFFFFFFB);
                        continue block5;
                    }
                    tspr.setPicnum(tspr.getPicnum() + (8 - k + 3 & 4));
                    tspr.setCstat(tspr.getCstat() | 4);
                    continue block5;
                }
                case 1536: 
                case 1792: 
                case 2048: 
                case 2304: 
                case 2560: {
                    int fz;
                    Sector sec;
                    if (ownerSpr.getStatnum() == 1 || ownerSpr.getStatnum() == 2) {
                        if (k <= 4) {
                            tspr.setPicnum(tspr.getPicnum() + 4 * k);
                            tspr.setCstat(tspr.getCstat() & 0xFFFFFFFB);
                        } else {
                            tspr.setPicnum(tspr.getPicnum() + 4 * (8 - k));
                            tspr.setCstat(tspr.getCstat() | 4);
                        }
                    }
                    if (tspr.getStatnum() == 99 || renderedSpriteList.getSize() >= 1022 || (sec = Main.boardService.getSector(ownerSpr.getSectnum())) == null || (fz = sec.getFloorz()) <= Globals.gPlayer[snum].z) continue block5;
                    Sprite tshadow = (Sprite)renderedSpriteList.obtain();
                    tshadow.set(tspr);
                    int camangle = EngineUtils.getAngle(dax - tshadow.getX(), day - tshadow.getY());
                    tshadow.setX(tshadow.getX() - Pragmas.mulscale(EngineUtils.sin(camangle + 512 & 0x7FF), 100L, 16));
                    tshadow.setY(tshadow.getY() + Pragmas.mulscale(EngineUtils.sin(camangle + 1024 & 0x7FF), 100L, 16));
                    tshadow.setZ(fz + 1);
                    tshadow.setStatnum(99);
                    tshadow.setYrepeat((short)(tspr.getYrepeat() >> 3));
                    if (tshadow.getYrepeat() < 4) {
                        tshadow.setYrepeat(4);
                    }
                    tshadow.setShade(127);
                    tshadow.setCstat(tshadow.getCstat() | 2);
                }
            }
        }
    }

    public static void drawhealth(int snum, int x, int y, int scale, int nFlags) {
        LSPRenderer renderer = Main.game.getRenderer();
        String name = "health: ";
        float fscale = (float)scale / 65536.0f;
        int ydim = renderer.getHeight();
        Main.game.getFont(1).drawText((Renderer)renderer, x, y, Strhandler.toCharArray(name), fscale, 0, 175, TextAlign.Left, Transparent.None, true);
        int nGauge = Globals.gPlayer[snum].nHealth * Main.engine.getTile(641).getWidth() / 320;
        renderer.rotatesprite((x += Main.game.getFont(1).getWidth(name, fscale)) << 16, y << 16, scale, 0, 641, 0, 0, 0x18 | nFlags, 0, 0, x + Pragmas.scale(nGauge, scale, 65536L), ydim);
    }

    public static void drawmana(int snum, int x, int y, int scale, int nFlags) {
        LSPRenderer renderer = Main.game.getRenderer();
        String name = "mana:   ";
        float fscale = (float)scale / 65536.0f;
        int ydim = renderer.getHeight();
        Main.game.getFont(1).drawText((Renderer)renderer, x, y, Strhandler.toCharArray(name), fscale, 0, 197, TextAlign.Left, Transparent.None, true);
        ArtEntry pic = Main.engine.getTile(641);
        int nGauge = Globals.gPlayer[snum].nMana * pic.getWidth() / 320;
        renderer.rotatesprite((x += Main.game.getFont(1).getWidth(name, fscale)) - Pragmas.scale(pic.getWidth() / 2, scale, 65536L) - 1 << 16, y << 16, scale, 0, 641, 0, 0, 0x18 | nFlags, x, 0, x + Pragmas.scale(nGauge, scale, 65536L), ydim);
    }

    public static void drawammo(int snum, int x, int y, int scale, int nFlags) {
        LSPRenderer renderer = Main.game.getRenderer();
        String name = "ammo:   ";
        float fscale = (float)scale / 65536.0f;
        ArtEntry pic = Main.engine.getTile(640);
        int ydim = renderer.getHeight();
        Main.game.getFont(1).drawText((Renderer)renderer, x, y, Strhandler.toCharArray(name), fscale, 0, 120, TextAlign.Left, Transparent.None, true);
        int nGauge = Globals.gPlayer[snum].nAmmo[Globals.gPlayer[snum].nLastChoosedWeapon] * pic.getWidth() / 320;
        renderer.rotatesprite((x += Main.game.getFont(1).getWidth(name, fscale)) - Pragmas.scale(pic.getWidth() / 2, scale, 65536L) - 1 << 16, y << 16, scale, 0, 640, 0, 0, 0x18 | nFlags, x, 0, x + Pragmas.scale(nGauge, scale, 65536L), ydim);
    }

    public static void drawbar(int x, int y, int scale, int snum) {
        LSPRenderer renderer = Main.game.getRenderer();
        float fscale = (float)scale / 65536.0f;
        int sx1 = (int)((float)(x - 6) * fscale);
        int sy1 = y + (int)(4.0f * fscale);
        int sx2 = (int)((float)(x + 230) * fscale);
        int sy2 = y + (int)(45.0f * fscale);
        renderer.rotatesprite(sx1 << 16, sy1 << 16, scale, 0, 611, 64, 0, 313, 0, 0, sx2, sy2);
        x *= (int)fscale;
        int yoffs = (int)(10.0f * fscale);
        if (Globals.gPlayer[snum].nWeapon > 6) {
            View.drawmana(Mmulti.myconnectindex, x, y += yoffs, scale, 256);
        } else {
            View.drawammo(Mmulti.myconnectindex, x, y += yoffs, scale, 256);
        }
        View.drawhealth(Mmulti.myconnectindex, x, y += yoffs, scale, 256);
        y += yoffs;
        for (int i = 1; i < 13; ++i) {
            if (Globals.gPlayer[snum].nAmmo[i] != 0) {
                renderer.rotatesprite(x + 1 << 16, y + 1 << 16, scale, 0, Weapons.getIcon(i), 48, 0, 280);
                renderer.rotatesprite(x << 16, y << 16, scale, 0, Weapons.getIcon(i), 0, 0, 280);
            } else {
                renderer.rotatesprite(x + 1 << 16, y + 1 << 16, scale, 0, Weapons.getIcon(i), 48, 0, 280);
            }
            if (Globals.gPlayer[snum].nWeapon == i) {
                renderer.rotatesprite(x + 1 << 16, y + (int)(13.0f * fscale) << 16, scale / 2, 0, 9258, 0, 0, 280);
            }
            x += (int)(19.0f * fscale);
        }
    }

    public static void TintPalette(int r, int g, int b) {
        r = Gameutils.BClipRange(r, r != 0 && r < 3 ? 3 : 0, 63);
        g = Gameutils.BClipRange(g, g != 0 && g < 3 ? 3 : 0, 63);
        b = Gameutils.BClipRange(b, b != 0 && b < 3 ? 3 : 0, 63);
        if (g != 0 && gtint > 64) {
            return;
        }
        gtint += g;
        if (r != 0 && rtint > 64) {
            return;
        }
        rtint += r;
        if (b != 0 && btint > 64) {
            return;
        }
        btint += b;
        int nDiff = r;
        if (nDiff <= g) {
            nDiff = g;
        }
        if (nDiff <= b) {
            nDiff = b;
        }
        nPalDiff += nDiff;
        nPalDelay = 0;
    }

    public static void GrabPalette() {
        byte[] palette = Main.engine.getPaletteManager().getBasePalette();
        Main.engine.setbrightness(Main.cfg.getPaletteGamma(), palette);
        nPalDiff = 0;
        nPalDelay = 0;
        btint = 0;
        gtint = 0;
        rtint = 0;
    }

    public static void FixPalette() {
        if (nPalDiff == 0) {
            return;
        }
        if (nPalDelay-- > 0) {
            return;
        }
        nPalDelay = 1;
        nPalDiff = Gameutils.BClipLow(nPalDiff - 3, 0);
        rtint = Gameutils.BClipLow(rtint - 3, 0);
        gtint = Gameutils.BClipLow(gtint - 3, 0);
        btint = Gameutils.BClipLow(btint - 3, 0);
    }

    public static void viewDrawStats(int x, int y, int zoom) {
        LSPRenderer renderer = Main.game.getRenderer();
        if (Main.cfg.gShowStat == 0 || Main.cfg.gShowStat == 2 && Globals.gPlayer[Mmulti.myconnectindex].gViewMode == 3) {
            return;
        }
        int nBits = 256;
        float fscale = (float)zoom / 65536.0f;
        Font f = Main.game.getFont(1);
        int yoffset = (int)(2.5f * (float)f.getSize() * fscale);
        int sx1 = (int)((float)(x - 6) * fscale);
        int sy1 = y - (int)(4.0f * fscale) - yoffset;
        CharInfo charInfo = f.getCharInfo('x');
        int sx2 = (int)((float)(x + (11 * charInfo.getWidth() + 6)) * fscale);
        int sy2 = y - (int)fscale;
        renderer.rotatesprite(sx1 << 16, sy1 << 16, zoom, 0, 611, 64, 0, 0x39 | nBits, 0, 0, sx2, sy2);
        Strhandler.buildString(statbuffer, 0, "k: ");
        int alignx = f.getWidth(statbuffer, fscale);
        int statx = x *= (int)fscale;
        int staty = y -= yoffset;
        f.drawText((Renderer)renderer, statx, staty, statbuffer, fscale, 0, 175, TextAlign.Left, Transparent.None, true);
        int offs = Strhandler.Bitoa(Enemies.nEnemyKills, statbuffer);
        Strhandler.buildString(statbuffer, offs, " / ", Enemies.nEnemyMax);
        f.drawText((Renderer)renderer, statx + (alignx + 2), staty, statbuffer, fscale, 0, 4, TextAlign.Left, Transparent.None, true);
        staty = (int)((float)y + (float)f.getSize() * fscale);
        Strhandler.buildString(statbuffer, 0, "t: ");
        f.drawText((Renderer)renderer, statx, staty, statbuffer, fscale, 0, 175, TextAlign.Left, Transparent.None, true);
        alignx = f.getWidth(statbuffer, fscale);
        int sec = Globals.totalmoves / 30 % 60;
        int minutes = Globals.totalmoves / 1800 % 60;
        int hours = Globals.totalmoves / 108000 % 60;
        offs = Strhandler.Bitoa(hours, statbuffer, 2);
        offs = Strhandler.buildString(statbuffer, offs, ":", minutes, 2);
        Strhandler.buildString(statbuffer, offs, ":", sec, 2);
        f.drawText((Renderer)renderer, statx + (alignx + 2), staty, statbuffer, fscale, 0, 4, TextAlign.Left, Transparent.None, true);
    }
}

