/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.ui.HelpException;

public class ArgumentsParser {
    private final Path path;
    private final Game game;
    private final boolean showSettings;
    private final boolean forceUpdate;
    private final boolean updateSuccess;
    private final List<String> gameArgs = new ArrayList<String>();

    public ArgumentsParser(String[] args) {
        Path path = FileEntry.DUMMY_PATH;
        Game game = Game.NULL;
        boolean showLauncher = false;
        boolean forceUpdate = false;
        boolean updateSuccess = false;
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.equalsIgnoreCase("-path") && i + 1 < args.length) {
                if (Files.exists(path = Paths.get(args[++i], new String[0]), new LinkOption[0])) continue;
                throw new RuntimeException(String.format("Chosen path \"%s\" is not exist!", path));
            }
            if (s.equalsIgnoreCase("-?") || s.equalsIgnoreCase("/?") || s.equalsIgnoreCase("-help")) {
                StringBuilder sb = new StringBuilder();
                sb.append("<b>-game \"name\"</b> Force to start game without showing the launcher. The parameter should be used with <b>-path</b>").append("<br>");
                for (Game g : Game.values()) {
                    if (g == Game.NULL) continue;
                    LinkedHashSet<String> names = new LinkedHashSet<String>();
                    names.add(g.name().toUpperCase(Locale.ROOT));
                    names.add(g.getShortName().toUpperCase(Locale.ROOT));
                    names.add(g.getName().toUpperCase(Locale.ROOT));
                    sb.append("&emsp;&emsp;&emsp;&emsp;").append(g.getShortName()).append(" (");
                    StringJoiner nameJoiner = new StringJoiner(", ");
                    for (String n : names) {
                        nameJoiner.add(n);
                    }
                    sb.append(nameJoiner);
                    sb.append(") <br>");
                }
                sb.append("<b>-path \"path\"</b> path to the game, that you want to start (relative paths is supporting)").append("<br>");
                sb.append("<b>-settings</b> force to show launcher in case when you use <b>-game</b> and <b>-path</b> parameters").append("<br>");
                sb.append("<b>-name \"name\"</b> sets player name").append("<br>");
                sb.append("<b>-players \"player numbers\"</b> sets multiplayer number of players").append("<br>");
                sb.append("<b>-ip \"ip_address\"</b> sets ip address for multiplayer game").append("<br>");
                sb.append("<b>-port \"port\"</b> sets port for multiplayer game").append("<br>");
                sb.append("<b>-netmode \"master\" or \"slave\"</b> starts multiplayer game as server or client (should be used with <b>-ip</b> and <b>-port</b> parameters").append("<br>");
                throw new HelpException(sb.toString());
            }
            if (s.equalsIgnoreCase("-settings")) {
                showLauncher = true;
                continue;
            }
            if (s.equalsIgnoreCase("-game") && i + 1 < args.length) {
                String gameName;
                if ((game = Game.parseGame(gameName = args[++i])) != Game.NULL) continue;
                throw new RuntimeException(String.format("Game \"%s\" is not found!", gameName));
            }
            if (s.equalsIgnoreCase("-force_update")) {
                forceUpdate = true;
                continue;
            }
            if (s.equalsIgnoreCase("-updated")) {
                updateSuccess = true;
                continue;
            }
            this.gameArgs.add(s);
        }
        this.path = path;
        this.game = game;
        this.showSettings = showLauncher;
        this.forceUpdate = forceUpdate;
        this.updateSuccess = updateSuccess;
    }

    public boolean isUpdateSuccess() {
        return this.updateSuccess;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public List<String> getOtherArguments() {
        return this.gameArgs;
    }

    public Game getGame() {
        return this.game;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean showLauncher() {
        return this.showSettings;
    }
}

