/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher;

import com.badlogic.gdx.Graphics;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Build.Architecture.common.ResolutionUtils;
import ru.m210projects.Build.Architecture.common.audio.AudioDriver;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.settings.ApplicationContext;

public class ConfigApplicationContext
extends ApplicationContext {
    @Override
    public void setAudioDriver(AudioDriver audioDriver) {
        this.audioDriver = audioDriver;
    }

    @Override
    public Map<String, List<Graphics.DisplayMode>> getResolutions() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode[] videoModes = gd.getDisplayModes();
        LinkedHashSet<ResolutionUtils.UserDisplayMode> modes = new LinkedHashSet<ResolutionUtils.UserDisplayMode>();
        for (DisplayMode videoMode : videoModes) {
            modes.add(new ResolutionUtils.UserDisplayMode(videoMode.getWidth(), videoMode.getHeight(), videoMode.getRefreshRate(), Math.max(1, videoMode.getBitDepth())));
        }
        return modes.stream().sorted(Comparator.comparingInt(mode -> mode.width).thenComparingInt(mode -> mode.height)).collect(Collectors.groupingBy(e -> ResolutionUtils.getDisplayModeAsString(e.width, e.height), LinkedHashMap::new, Collectors.toList()));
    }

    @Override
    public void setMidiDevice(MidiDevice midiDevice) {
        this.midiDevice = midiDevice.getName();
    }
}

