/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.device.SoundBankDevice;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Stack;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.Architecture.common.audio.AudioDriver;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.Main;
import ru.m210projects.Launcher.desktop.newlauncher.LauncherModel;
import ru.m210projects.Launcher.desktop.newlauncher.View;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;

public class Controller {
    private final LauncherModel model;
    private final Stack<Runnable> backStack = new Stack();
    private View view;
    private Runnable lastCallback;

    public Controller(LauncherModel model) {
        this.model = model;
    }

    public void setView(View view) {
        this.view = view;
        this.view.setController(this);
        view.setBackButtonEnable(false);
        this.onOpenAbout();
    }

    public void onStartGame() {
        if (this.model.getCurrentEntry().canStart()) {
            this.view.startGame(this.model::launchGame);
        } else {
            Main.showMessage("Error", String.format("Can't start because %s resources not found", this.model.getCurrentEntry().getGame().getName()), MessageType.Error);
        }
    }

    public void onChooseGame(Game game) {
        this.model.chooseGame(game);
        this.view.chooseGame(game);
        this.onSetGamePath(this.model.getGamePath());
        if (this.lastCallback != null) {
            this.backStack.push(this.lastCallback);
            this.view.setBackButtonEnable(true);
        }
        this.lastCallback = () -> {
            this.model.chooseGame(game);
            this.view.chooseGame(game);
            this.onSetGamePath(this.model.getGamePath());
        };
    }

    public void onSetGamePath(Path path) {
        List<String> missingFiles = this.model.setGamePath(path);
        this.view.setGamePath(path);
        if (!missingFiles.isEmpty()) {
            this.view.showMissingFiles(missingFiles);
        }
    }

    public void onOpenSite() {
        this.view.openWebpage("https://m210.duke4.net/");
    }

    public void onOpenForum() {
        this.view.openWebpage("https://forums.duke4.net/forum/42-buildgdx/");
    }

    public void onOpenDiscord() {
        this.view.openWebpage("https://discord.gg/ebthbBB");
    }

    public void onChoosePath() {
        Path path = this.view.showDirectoryChooser(this.model.getGamePath(), this.model.getCurrentEntry());
        this.onSetGamePath(path);
    }

    public void onOpenGameFolder() {
        this.view.openFolder(this.model.getGamePath());
    }

    public void onOpenSettings() {
        GameEntry currentEntry = this.model.getCurrentEntry();
        this.view.openSettings(currentEntry.getConfig());
        if (this.lastCallback != null) {
            this.backStack.push(this.lastCallback);
            this.view.setBackButtonEnable(true);
        }
        this.lastCallback = () -> {
            this.model.chooseGame(currentEntry.getGame());
            this.view.chooseGame(currentEntry.getGame());
            this.view.openSettings(currentEntry.getConfig());
        };
    }

    public void onOpenAbout() {
        this.view.openAbout();
        if (this.lastCallback != null) {
            this.backStack.push(this.lastCallback);
            this.view.setBackButtonEnable(true);
        }
        this.lastCallback = () -> this.view.openAbout();
    }

    public void onBack() {
        if (!this.backStack.isEmpty()) {
            this.lastCallback = this.backStack.pop();
            this.lastCallback.run();
        }
        this.view.setBackButtonEnable(!this.backStack.isEmpty());
    }

    public void resetBackStack() {
        this.backStack.removeAllElements();
        this.view.setBackButtonEnable(false);
    }

    public void onOpenConfigFolder() {
        Path configFolder = this.model.getCurrentEntry().getConfig().getCfgPath().getParent();
        if (!Files.exists(configFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(configFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.view.openFolder(configFolder);
    }

    public void onChooseResolution(Graphics.DisplayMode displayMode) {
        GameConfig config = this.model.getCurrentEntry().getConfig();
        System.out.println("set display mode " + displayMode.width + " " + displayMode.height);
        config.setScreenMode(displayMode.width, displayMode.height, config.isFullscreen());
    }

    public void onChooseRender(Renderer.RenderType selectedRender) {
        this.model.getCurrentEntry().getConfig().setRenderType(selectedRender);
    }

    public void onChooseMidiDevice(MidiDevice device) {
        this.model.getCurrentEntry().getConfig().setMidiDevice(device);
        this.view.setMidiDevice(device);
    }

    public void onAddSoundBank(File file) {
        GameConfig config = this.model.getCurrentEntry().getConfig();
        try {
            SoundBankDevice device = new SoundBankDevice(file.toPath());
            config.addSoundBank(device);
            config.setMidiDevice(device);
            this.view.updateMidiDevices(config.getMidiDevices(), config.getMidiDevice().getName());
        }
        catch (Exception e) {
            Console.out.println(String.format("Can't add soundbank %s: %s", file.getName(), e));
        }
    }

    public void onDeleteSoundBank(MidiDevice device) {
        if (!(device instanceof SoundBankDevice)) {
            return;
        }
        GameConfig config = this.model.getCurrentEntry().getConfig();
        List<MidiDevice> list = config.getMidiDevices();
        int deviceIndex = list.indexOf(device);
        if (deviceIndex != -1) {
            list.remove(deviceIndex);
            device = list.get(Math.max(deviceIndex - 1, 0));
            config.setMidiDevice(device);
            this.view.updateMidiDevices(list, config.getMidiDevice().getName());
        }
    }

    public void onFullScreenChanged(boolean fullscreen) {
        GameConfig config = this.model.getCurrentEntry().getConfig();
        config.setScreenMode(config.getScreenWidth(), config.getScreenHeight(), fullscreen);
    }

    public void onBorderlessChanged(boolean borderless) {
        this.model.getCurrentEntry().getConfig().setBorderless(borderless);
    }

    public void onEnableAutoloadChanged(boolean autoloadFolder) {
        this.model.getCurrentEntry().getConfig().setAutoloadFolder(autoloadFolder);
    }

    public void onChooseSound(AudioDriver audioDriver) {
        this.model.getCurrentEntry().getConfig().setAudioDriver(audioDriver);
    }
}

