/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Tekwar.Config;
import ru.m210projects.Tekwar.Main;

public class TekwarEntry
implements GameEntry {
    private final String appName = "TekWarGDX";
    private final GameConfig entryConfig;
    private List<String> missingFilesCache;
    private boolean isDemo = false;

    public TekwarEntry(Path homePath) {
        this.missingFilesCache = this.checkAndGetMissingFiles(homePath);
        boolean portable = this.missingFilesCache.isEmpty();
        String configName = "TekWarGDX.ini".toLowerCase(Locale.ROOT);
        if (portable) {
            this.entryConfig = new Config(homePath.resolve(Paths.get(configName, new String[0])));
            this.entryConfig.setGamePath(homePath);
        } else {
            this.entryConfig = new Config(homePath.resolve(Paths.get("TekWarGDX", configName)));
        }
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headertw.png");
    }

    @Override
    public Game getGame() {
        return Game.TEKWAR;
    }

    @Override
    public String[] getFiles() {
        return new String[]{"smkmm.smk", "tiles000.art", "tables.dat", "palette.dat", "songs", "sounds"};
    }

    @Override
    public String[] getIcons() {
        return new String[]{"Games/Tekwar/tekwar16.png", "Games/Tekwar/tekwar32.png", "Games/Tekwar/tekwar128.png"};
    }

    @Override
    public List<String> checkAndGetMissingFiles(Path directoryPath) {
        this.isDemo = false;
        List<String> missingFiles = GameEntry.super.checkAndGetMissingFiles(directoryPath);
        if (!missingFiles.isEmpty()) {
            System.out.println("TekWarGDX: trying to find demo version");
            List<String> missingDemoFiles = this.checkAndGetMissingDemoFiles(directoryPath);
            if (missingDemoFiles.isEmpty()) {
                this.isDemo = true;
                return missingDemoFiles;
            }
            missingFiles.addAll(missingDemoFiles);
        }
        return missingFiles;
    }

    @Override
    public BuildGame getApplication(List<String> args, String version) throws IOException {
        return new Main(args, this.entryConfig, "TekWarGDX", version, true, this.isDemo);
    }

    @Override
    public GameConfig getConfig() {
        return this.entryConfig;
    }

    @Override
    public List<String> setGamePath(Path path) {
        this.entryConfig.setGamePath(path);
        this.missingFilesCache = this.checkAndGetMissingFiles(path);
        return this.missingFilesCache;
    }

    @Override
    public boolean canStart() {
        return this.missingFilesCache.isEmpty();
    }

    private List<String> checkAndGetMissingDemoFiles(Path directoryPath) {
        LinkedHashSet<String> missingFiles = new LinkedHashSet<String>(Arrays.asList("city.map", "tiles000.art", "tables.dat", "palette.dat", "songs", "sounds"));
        if (Files.exists(directoryPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directoryPath);){
                stream.forEach(path -> {
                    String fileName = path.getFileName().toString().toLowerCase(Locale.ROOT);
                    try {
                        if (!fileName.equalsIgnoreCase("sounds") || Files.size(path) == 0x20A000L) {
                            missingFiles.remove(fileName);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e) {
                Console.out.println(String.format("Failed to check path %s: %s", directoryPath, e), OsdColor.RED);
            }
        }
        return new ArrayList<String>(missingFiles);
    }
}

