/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameStoreService;
import ru.m210projects.Launcher.desktop.newlauncher.stores.Store;
import ru.m210projects.Witchaven.Config;
import ru.m210projects.Witchaven.Main;

public class WHEntry
implements GameEntry {
    private final String appName = "WitchavenGDX";
    private final GameConfig entryConfig;
    private List<String> missingFilesCache;

    public WHEntry(Path homePath) {
        this.missingFilesCache = this.checkAndGetMissingFiles(homePath);
        boolean portable = this.missingFilesCache.isEmpty();
        String configName = "WitchavenGDX.ini".toLowerCase(Locale.ROOT);
        if (portable) {
            this.entryConfig = new Config(homePath.resolve(Paths.get(configName, new String[0])));
            this.entryConfig.setGamePath(homePath);
        } else {
            this.entryConfig = new Config(homePath.resolve(Paths.get("WitchavenGDX", configName)));
        }
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headerwh.png");
    }

    @Override
    public Game getGame() {
        return Game.WITCHAVEN;
    }

    @Override
    public String[] getFiles() {
        return new String[]{"songs", "joesnd", "tiles000.art", "tables.dat", "palette.dat", "lookup.dat", "level1.map"};
    }

    @Override
    public String[] getIcons() {
        return new String[]{"Games/WH/wh16.png", "Games/WH/wh32.png", "Games/WH/wh128.png"};
    }

    @Override
    public BuildGame getApplication(List<String> args, String version) throws IOException {
        return new Main(args, this.entryConfig, "WitchavenGDX", version, true, false);
    }

    @Override
    public GameConfig getConfig() {
        return this.entryConfig;
    }

    @Override
    public List<String> setGamePath(Path path) {
        this.entryConfig.setGamePath(path);
        this.missingFilesCache = this.checkAndGetMissingFiles(path);
        return this.missingFilesCache;
    }

    @Override
    public boolean canStart() {
        return this.missingFilesCache.isEmpty();
    }

    @Override
    public void registerStorePath(GameStoreService gameStoreService) {
        gameStoreService.registerGame(Store.GOG, this.getGame(), "[GOG]:\\Games\\1315510047");
        gameStoreService.registerGame(Store.STEAM, this.getGame(), "[Steam]:\\Witchaven" + File.separator + "Enhanced" + File.separator + "GAME" + File.separator + "WHAVEN");
    }
}

