/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class DirectoryBrowser
extends JDialog
implements TreeExpansionListener,
TreeSelectionListener,
TreeCellRenderer {
    private final DefaultTreeCellRenderer renderer;
    private final ImageIcon gameFolderIcon;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTree tree;

    private DirectoryBrowser(JFrame f, Path path, String name, Image icon) {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setTitle("Select " + name + " folder");
        this.setIconImage(icon);
        this.renderer = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
        this.gameFolderIcon = new ImageIcon(icon);
        this.tree.setCellRenderer(this);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(name);
        FileSystems.getDefault().getRootDirectories().forEach(p -> root.add(new DirectoryNode((Path)p)));
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.tree.setModel(model);
        DirectoryNode directoryNode = this.findNodeByPath(model, path);
        if (directoryNode != null) {
            TreePath treePath = new TreePath(directoryNode.getPath());
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
        this.tree.addTreeExpansionListener(this);
        this.tree.addTreeSelectionListener(this);
        this.buttonOK.addActionListener(e -> this.onOK());
        this.buttonCancel.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DirectoryBrowser.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.pack();
        this.setLocationRelativeTo(f);
        this.setMinimumSize(new Dimension(300, 300));
        this.setVisible(true);
    }

    public static Path showDirectoryChooser(JFrame f, Path path, String name, URL icon) {
        DirectoryBrowser dc = new DirectoryBrowser(f, path, name, Toolkit.getDefaultToolkit().getImage(icon));
        return dc.getSelectedPath(path);
    }

    public Path getSelectedPath(Path defaultPath) {
        Object o = this.tree.getLastSelectedPathComponent();
        if (o instanceof DirectoryNode) {
            return ((DirectoryNode)o).getDirectoryPath();
        }
        return defaultPath;
    }

    private DirectoryNode findNodeByPath(DefaultTreeModel model, Path path) {
        DirectoryNode directoryNode = null;
        TreeNode nextNode = (TreeNode)model.getRoot();
        block0: while (nextNode != null) {
            TreeNode currentNode = nextNode;
            nextNode = null;
            int childCount = model.getChildCount(currentNode);
            for (int i = 0; i < childCount; ++i) {
                DirectoryNode node = (DirectoryNode)model.getChild(currentNode, i);
                if (!path.startsWith(node.directory)) continue;
                this.scanChildren(model, node);
                directoryNode = node;
                nextNode = node;
                continue block0;
            }
        }
        return directoryNode;
    }

    private void scanChildren(DefaultTreeModel model, DirectoryNode n) {
        if (n.scanned) {
            return;
        }
        try (Stream<Path> stream = Files.list(n.directory).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(Files::isReadable);){
            stream.forEach(path -> model.insertNodeInto(new DirectoryNode((Path)path), n, n.getChildCount()));
        }
        catch (IOException e) {
            Console.out.println(String.format("Failed accessing to directory %s: %s", n.directory, e), OsdColor.RED);
        }
        n.scanned = true;
    }

    private void treeScanNode(TreePath tp) {
        Object o = tp.getLastPathComponent();
        if (o instanceof DirectoryNode) {
            this.scanChildren((DefaultTreeModel)this.tree.getModel(), (DirectoryNode)o);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.treeScanNode(event.getPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.treeScanNode(e.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof DirectoryNode && ((DirectoryNode)value).isGameFolder()) {
            this.renderer.setIcon(this.gameFolderIcon);
        }
        return c;
    }

    private void onOK() {
        this.dispose();
    }

    private void onCancel() {
        this.tree.setSelectionPath(null);
        this.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTree jTree;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton2 = new JButton();
        jButton2.setText("OK");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton = new JButton();
        jButton.setText("Cancel");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel4.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.tree = jTree = new JTree();
        jTree.setRootVisible(false);
        jTree.setRowHeight(20);
        jTree.setShowsRootHandles(true);
        jTree.setVisibleRowCount(15);
        jScrollPane.setViewportView(jTree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static class DirectoryNode
    extends DefaultMutableTreeNode {
        private final Path directory;
        private boolean scanned = false;
        private boolean gameFolder = false;

        public DirectoryNode(Path path) {
            super(path.getFileName() != null ? path.getFileName().toString() : path.toString());
            this.directory = path;
        }

        public boolean isGameFolder() {
            return this.gameFolder;
        }

        public void setGameFolder(boolean gameFolder) {
            this.gameFolder = gameFolder;
        }

        public Path getDirectoryPath() {
            return this.directory;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }
}

