/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lwjgl.system.Platform;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Launcher.desktop.newlauncher.Controller;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameLabel;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameStoreService;
import ru.m210projects.Launcher.desktop.newlauncher.stores.Store;
import ru.m210projects.Launcher.desktop.newlauncher.ui.BoundsPopupMenuListener;
import ru.m210projects.Launcher.desktop.newlauncher.ui.ComboItem;

public class GamePanel
extends JPanel {
    private final GameStoreService gameStoreService;
    private JComboBox<ComboItem> gameFoldersList;
    private JButton choosePathButton;
    private JButton openPathButton;
    private JButton launchButton;
    private JButton settingsButton;
    private JLabel messageField;
    private JPanel gameForm;
    private Game game;

    public GamePanel() {
        this.$$$setupUI$$$();
        this.add(this.gameForm);
        this.gameStoreService = new GameStoreService(Platform.get());
        this.gameFoldersList.addPopupMenuListener(new BoundsPopupMenuListener(true, false));
        this.gameFoldersList.setPrototypeDisplayValue(new ComboItem(null, ""));
    }

    public void registerStorePaths(Set<GameEntry> entrySet) {
        for (GameEntry entry : entrySet) {
            entry.registerStorePath(this.gameStoreService);
        }
    }

    public void initListeners(Controller controller) {
        this.choosePathButton.addActionListener(e -> controller.onChoosePath());
        this.openPathButton.addActionListener(e -> controller.onOpenGameFolder());
        this.launchButton.addActionListener(e -> controller.onStartGame());
        this.settingsButton.addActionListener(e -> controller.onOpenSettings());
        this.gameFoldersList.addItemListener(e -> {
            if (this.gameFoldersList.isEnabled() && e.getStateChange() == 1 && e.getItem() instanceof ComboItem) {
                controller.onSetGamePath(((ComboItem)e.getItem()).getValue());
            }
        });
    }

    public void startGame() {
        this.launchButton.setText("Loading...");
        this.launchButton.setEnabled(false);
        this.gameFoldersList.setEnabled(false);
    }

    public void setGamePath(Path path) {
        this.launchButton.setText("Play " + this.game.getShortName());
        this.launchButton.setEnabled(true);
        this.messageField.setText("");
        this.handlePath(path);
    }

    public void showMissingFiles(List<String> missingFiles) {
        this.launchButton.setEnabled(false);
        this.launchButton.setText(this.game.getShortName() + " resources not found!");
        StringBuilder missingFilesMessage = new StringBuilder("<html>");
        for (String name : missingFiles) {
            missingFilesMessage.append(name.toUpperCase()).append(" is missing<br>");
        }
        missingFilesMessage.append("</html>");
        this.messageField.setText(missingFilesMessage.toString());
    }

    public void chooseGame(Game game) {
        this.game = game;
    }

    private void handlePath(Path path) {
        ComboItem configPath = new ComboItem(path, !path.equals(FileEntry.DUMMY_PATH) ? path.toString() : "");
        boolean isEnabled = this.choosePathButton.isEnabled();
        this.gameFoldersList.setEnabled(false);
        this.gameFoldersList.removeAllItems();
        this.gameFoldersList.addItem(configPath);
        SwingUtilities.invokeLater(() -> {
            List<GameLabel> labels = this.gameStoreService.getGameLabels(this.game);
            for (GameLabel l : labels) {
                Path gamePath = Paths.get(l.getPath(), new String[0]);
                switch (this.game) {
                    case DUKE_NUKEM_3D: {
                        if (l.getStore() != Store.ANTHOLOGY || gamePath.endsWith("Duke Nukem 3D")) break;
                        gamePath = gamePath.resolve("Duke Nukem 3D");
                        break;
                    }
                    case WITCHAVEN: {
                        if (l.getStore() != Store.GOG) break;
                        gamePath = gamePath.resolve("Enhanced\\GAME\\WHAVEN\\");
                        break;
                    }
                    case WITCHAVEN_2: {
                        if (l.getStore() != Store.GOG) break;
                        gamePath = gamePath.resolve("Enhanced\\GAME\\WHAVEN2\\");
                    }
                }
                ComboItem comboItem = new ComboItem(gamePath, l.getLabel() + " " + gamePath);
                if (Objects.equals(gamePath, path)) {
                    this.gameFoldersList.removeItem(configPath);
                    this.gameFoldersList.insertItemAt(comboItem, 0);
                    continue;
                }
                this.gameFoldersList.addItem(comboItem);
            }
            this.gameFoldersList.setSelectedIndex(0);
            this.gameFoldersList.setEnabled(isEnabled);
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JLabel jLabel;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel;
        this.gameForm = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComboBox jComboBox = new JComboBox();
        this.gameFoldersList = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, new Dimension(150, -1), null, null));
        this.choosePathButton = jButton4 = new JButton();
        jButton4.setText("...");
        jPanel.add((Component)jButton4, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.openPathButton = jButton3 = new JButton();
        jButton3.setIcon(new ImageIcon(this.getClass().getResource("/Games/iconopen.png")));
        jButton3.setText("");
        jPanel.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.messageField = jLabel = new JLabel();
        jLabel.setText("files is missing");
        jLabel.setVerticalAlignment(1);
        jLabel.setVerticalTextPosition(1);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 3, 0, 3, 0, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(true);
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 2, 1, 3, 0, null, null, null));
        this.launchButton = jButton2 = new JButton();
        jButton2.setText("Start game");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.settingsButton = jButton = new JButton();
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/Games/iconsettings.png")));
        jButton.setText("");
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.gameForm;
    }
}

