/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.ui;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.device.SoundBankDevice;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import ru.m210projects.Build.Architecture.common.ResolutionUtils;
import ru.m210projects.Build.Architecture.common.audio.AudioDriver;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.newlauncher.Controller;
import ru.m210projects.Launcher.desktop.newlauncher.Utils;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;

public class SettingsPanel
extends JPanel {
    private JPanel settingsForm;
    private JComboBox<Graphics.DisplayMode> resolutionComboBox;
    private JComboBox<String> renderComboBox;
    private JCheckBox borderlessCheckBox;
    private JCheckBox fullscreenCheckBox;
    private JComboBox<AudioDriver> soundComboBox;
    private JComboBox<MidiDevice> midiComboBox;
    private JButton deleteSoundFontButton;
    private JButton chooseSoundFontButton;
    private JCheckBox enableAutoloadFolderCheckBox;
    private JButton launchButton;

    public SettingsPanel() {
        this.$$$setupUI$$$();
        this.add(this.settingsForm);
        SwingUtilities.invokeLater(() -> {
            for (Renderer.RenderType renderType : Renderer.RenderType.values()) {
                this.renderComboBox.addItem(renderType.getName());
            }
            this.soundComboBox.setRenderer(new SoundDriverRenderer());
            this.midiComboBox.setRenderer(new MidiDeviceCellRenderer());
        });
        this.launchButton.setVisible(false);
    }

    public void oneGameMode(Game game) {
        this.launchButton.setVisible(true);
        this.launchButton.setText("Play " + game.getShortName());
    }

    public void initListeners(Controller controller) {
        this.renderComboBox.addItemListener(e -> {
            if (this.renderComboBox.isEnabled() && e.getStateChange() == 1 && e.getItem() instanceof String) {
                controller.onChooseRender(Renderer.RenderType.parseType((String)e.getItem()));
            }
        });
        this.resolutionComboBox.addItemListener(e -> {
            if (this.resolutionComboBox.isEnabled() && e.getStateChange() == 1 && e.getItem() instanceof Graphics.DisplayMode) {
                Graphics.DisplayMode displayMode = (Graphics.DisplayMode)e.getItem();
                if (displayMode != null) {
                    controller.onChooseResolution(displayMode);
                }
                this.fullscreenCheckBox.setEnabled(true);
                if (displayMode instanceof ResolutionUtils.UserDisplayMode) {
                    this.fullscreenCheckBox.setEnabled(((ResolutionUtils.UserDisplayMode)displayMode).isFullScreenSupport());
                }
            }
        });
        this.midiComboBox.addItemListener(e -> {
            if (this.midiComboBox.isEnabled() && e.getStateChange() == 1 && e.getItem() instanceof MidiDevice) {
                controller.onChooseMidiDevice((MidiDevice)e.getItem());
            }
        });
        this.soundComboBox.addItemListener(e -> {
            if (this.soundComboBox.isEnabled() && e.getStateChange() == 1 && e.getItem() instanceof AudioDriver) {
                controller.onChooseSound((AudioDriver)((Object)((Object)e.getItem())));
            }
        });
        this.fullscreenCheckBox.addItemListener(e -> controller.onFullScreenChanged(e.getStateChange() == 1));
        this.borderlessCheckBox.addItemListener(e -> controller.onBorderlessChanged(e.getStateChange() == 1));
        this.enableAutoloadFolderCheckBox.addItemListener(e -> controller.onEnableAutoloadChanged(e.getStateChange() == 1));
        this.chooseSoundFontButton.addActionListener(e -> this.onChooseSoundFontButton(controller));
        this.deleteSoundFontButton.addActionListener(e -> controller.onDeleteSoundBank((MidiDevice)this.midiComboBox.getSelectedItem()));
        this.launchButton.addActionListener(e -> controller.onStartGame());
    }

    public void openSettings(GameConfig config) {
        Graphics.DisplayMode currentMode;
        String configResolution;
        Map<String, List<Graphics.DisplayMode>> resolutions = config.getResolutions();
        if (!resolutions.containsKey(configResolution = ResolutionUtils.getDisplayModeAsString(currentMode = new ResolutionUtils.UserDisplayMode(config.getScreenWidth(), config.getScreenHeight())))) {
            resolutions.put(configResolution, Collections.singletonList(currentMode));
        } else {
            currentMode = resolutions.get(configResolution).stream().max(Comparator.comparingInt(a -> a.refreshRate)).orElse(currentMode);
        }
        String currentModeName = ResolutionUtils.getDisplayModeAsString(currentMode);
        this.resolutionComboBox.setEnabled(false);
        this.resolutionComboBox.removeAllItems();
        this.resolutionComboBox.addItem(currentMode);
        this.fullscreenCheckBox.setEnabled(false);
        Graphics.DisplayMode finalCurrentMode = currentMode;
        SwingUtilities.invokeLater(() -> {
            for (String resolution : resolutions.keySet()) {
                Graphics.DisplayMode displayMode = ((List)resolutions.get(resolution)).stream().max(Comparator.comparingInt(a -> a.refreshRate)).orElse(null);
                this.resolutionComboBox.removeItem(displayMode);
                if (displayMode instanceof ResolutionUtils.UserDisplayMode && !((ResolutionUtils.UserDisplayMode)displayMode).isFullScreenSupport()) {
                    this.resolutionComboBox.insertItemAt(displayMode, 0);
                    continue;
                }
                if (resolution.equalsIgnoreCase(currentModeName)) {
                    this.fullscreenCheckBox.setEnabled(true);
                }
                this.resolutionComboBox.addItem(displayMode);
            }
            this.resolutionComboBox.setSelectedItem(finalCurrentMode);
            this.resolutionComboBox.setEnabled(true);
        });
        this.renderComboBox.setSelectedItem(config.getRenderType().getName());
        this.fullscreenCheckBox.setSelected(config.isFullscreen());
        this.borderlessCheckBox.setSelected(config.isBorderless());
        this.enableAutoloadFolderCheckBox.setSelected(config.isAutoloadFolder());
        this.deleteSoundFontButton.setEnabled(false);
        this.updateMidiDevices(config.getMidiDevices(), config.getMidiDevice().getName());
        this.updateAudioDevices(Arrays.asList(AudioDriver.values()), config.getAudioDriver());
    }

    public void updateMidiDevices(List<MidiDevice> deviceList, String selectedDevice) {
        this.midiComboBox.setEnabled(false);
        this.midiComboBox.removeAllItems();
        for (MidiDevice device : deviceList) {
            this.midiComboBox.addItem(device);
            if (!device.getName().equalsIgnoreCase(selectedDevice)) continue;
            this.checkSelectedSoundBank(device);
            this.midiComboBox.setSelectedItem(device);
        }
        this.midiComboBox.setEnabled(true);
    }

    public void updateAudioDevices(List<AudioDriver> audioList, AudioDriver selectedDevice) {
        this.soundComboBox.setEnabled(false);
        this.soundComboBox.removeAllItems();
        for (AudioDriver device : audioList) {
            this.soundComboBox.addItem(device);
            if (!device.equals((Object)selectedDevice)) continue;
            this.soundComboBox.setSelectedItem((Object)device);
        }
        this.soundComboBox.setEnabled(true);
    }

    public void setMidiDevice(MidiDevice device) {
        this.checkSelectedSoundBank(device);
        this.midiComboBox.setSelectedItem(device);
    }

    private void onChooseSoundFontButton(Controller controller) {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setCurrentDirectory(Utils.getDirPath().toFile());
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("SoundFont bank (*.sf2)", "sf2"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Downloadable Sounds bank (*.dls)", "dls"));
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal == 0 && (file = fileChooser.getSelectedFile()) != null) {
            controller.onAddSoundBank(file);
        }
    }

    private void checkSelectedSoundBank(MidiDevice device) {
        this.deleteSoundFontButton.setEnabled(device instanceof SoundBankDevice);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JCheckBox jCheckBox;
        JButton jButton2;
        JButton jButton3;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.settingsForm = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Resolution");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.resolutionComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 3, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Renderer");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.renderComboBox = jComboBox2;
        jPanel.add(jComboBox2, new GridConstraints(1, 1, 1, 3, 8, 1, 2, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 4, 5, 0, 3, 0, null, null, null));
        this.borderlessCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Borderless");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.fullscreenCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Fullscreen");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.soundComboBox = jComboBox3;
        jPanel.add(jComboBox3, new GridConstraints(3, 1, 1, 3, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Sound");
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Midi");
        jPanel.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox4 = new JComboBox();
        this.midiComboBox = jComboBox4;
        jPanel.add(jComboBox4, new GridConstraints(4, 1, 1, 3, 8, 1, 2, 0, null, null, null));
        this.deleteSoundFontButton = jButton3 = new JButton();
        jButton3.setText("Delete sound font");
        jPanel.add((Component)jButton3, new GridConstraints(5, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.chooseSoundFontButton = jButton2 = new JButton();
        jButton2.setText("Add sound font");
        jPanel.add((Component)jButton2, new GridConstraints(5, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(6, 0, 1, 4, 1, 1, 3, 3, null, null, null));
        this.enableAutoloadFolderCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable \"autoload\" folder");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.launchButton = jButton = new JButton();
        jButton.setText("Start game");
        jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.settingsForm;
    }

    private static class SoundDriverRenderer
    extends JLabel
    implements ListCellRenderer<AudioDriver> {
        private SoundDriverRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AudioDriver> list, AudioDriver value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.getName());
            return this;
        }
    }

    private static class MidiDeviceCellRenderer
    extends JLabel
    implements ListCellRenderer<MidiDevice> {
        private MidiDeviceCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends MidiDevice> list, MidiDevice value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.getName());
            return this;
        }
    }
}

