/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.update;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Launcher.desktop.Main;
import ru.m210projects.Launcher.desktop.newlauncher.ui.DownloadDialog;
import ru.m210projects.Launcher.desktop.newlauncher.update.CheckUpdateResponse;
import ru.m210projects.Launcher.desktop.newlauncher.update.DownloadInputStream;
import ru.m210projects.Launcher.desktop.newlauncher.update.ModelEventListener;
import ru.m210projects.Launcher.desktop.newlauncher.update.UpdateParameters;

public class VersionChecker
implements Runnable {
    public static final String UPDATER_VERSION = "1.0";
    public static final String VERSION_FILE = "buildgdx.ver";
    public static final String UPDATE_FILE = "update.zip";
    private final String serverUrl = "http://m210.ucoz.ru/Files/";
    private final ModelEventListener eventListener;
    private String serverVersion;

    public VersionChecker(ModelEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void run() {
        CheckUpdateResponse response = this.checkVersion(Main.appversion);
        if (Objects.requireNonNull(response) == CheckUpdateResponse.UPDATE_AVAILABLE) {
            if (this.eventListener.onUpdateResult(CheckUpdateResponse.UPDATE_AVAILABLE, this.serverVersion)) {
                this.runUpdate();
            }
            return;
        }
        this.eventListener.onUpdateResult(CheckUpdateResponse.NOT_AVAILABLE, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckUpdateResponse checkVersion(String version) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new DownloadInputStream(new URL("http://m210.ucoz.ru/Files/buildgdx.ver"), 1000)));){
            double serverVersion = Double.parseDouble(br.readLine().replaceAll("[^0-9.,]", ""));
            if (serverVersion == 117.0) {
                CheckUpdateResponse checkUpdateResponse = CheckUpdateResponse.NOT_AVAILABLE;
                return checkUpdateResponse;
            }
            double appVersion = Double.parseDouble(version.replaceAll("[^0-9.,]", ""));
            if (serverVersion <= appVersion) {
                CheckUpdateResponse checkUpdateResponse = CheckUpdateResponse.NOT_AVAILABLE;
                return checkUpdateResponse;
            }
            this.serverVersion = "v" + serverVersion;
            return CheckUpdateResponse.UPDATE_AVAILABLE;
        }
        catch (FileNotFoundException e) {
            return CheckUpdateResponse.VERSION_FILE_NOT_FOUND;
        }
        catch (Exception e) {
            return CheckUpdateResponse.VERSION_FILE_ERROR;
        }
    }

    public void runUpdate() {
        DownloadDialog dialog = new DownloadDialog();
        dialog.setVisible(true);
        AtomicBoolean isDismissed = new AtomicBoolean(false);
        dialog.setCancelListener(e -> {
            isDismissed.set(true);
            this.eventListener.onUpdateResult(CheckUpdateResponse.UPDATE_CANCELED, "Update canceled");
        });
        new Thread(() -> {
            Path updateFile;
            try (DownloadInputStream inputStream = new DownloadInputStream(new URL("http://m210.ucoz.ru/Files/update.zip"), 5000);){
                updateFile = Files.createTempFile(UPDATE_FILE, "", new FileAttribute[0]);
                try (OutputStream outputStream = Files.newOutputStream(updateFile, new OpenOption[0]);){
                    int len;
                    updateFile.toFile().deleteOnExit();
                    int size = 0;
                    byte[] data = new byte[1024];
                    int contentLength = inputStream.getContentLength();
                    while ((len = inputStream.read(data)) != -1 && !isDismissed.get()) {
                        outputStream.write(data, 0, len);
                        int percents = (int)((float)(size += len) / (float)contentLength * 100.0f);
                        dialog.setProgress(percents);
                    }
                    if (isDismissed.get()) {
                        return;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.eventListener.onUpdateResult(CheckUpdateResponse.UPDATE_ERROR, e.toString());
                return;
            }
            finally {
                dialog.dispose();
            }
            if (this.unpackUpdateFile(updateFile)) {
                try {
                    Path jarPath = this.getJarPath();
                    Path javaExecutablePath = this.getJavaExecutablePath();
                    Path updateApp = updateFile.getParent().resolve("appupdater.jar");
                    String command = String.format("%s -jar %s", javaExecutablePath, updateApp);
                    Process updaterProcess = Runtime.getRuntime().exec(command);
                    while (updaterProcess.isAlive()) {
                        if (updaterProcess.getInputStream().available() != 0) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(updaterProcess.getInputStream()));
                            while (reader.ready()) {
                                String message = reader.readLine();
                                if (message.equals("Updater started")) {
                                    UpdateParameters parameters = new UpdateParameters(UPDATER_VERSION, javaExecutablePath, jarPath, updateApp.getParent(), Main.appversion);
                                    parameters.sendData(updaterProcess.getOutputStream());
                                    continue;
                                }
                                if (!message.equals("Ready to replace")) continue;
                                System.exit(0);
                            }
                            continue;
                        }
                        if (updaterProcess.getErrorStream().available() == 0) continue;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(updaterProcess.getErrorStream()));
                        StringBuilder stringBuffer = new StringBuilder();
                        while (reader.ready()) {
                            stringBuffer.append(reader.readLine());
                        }
                        Console.out.println(stringBuffer.toString(), OsdColor.RED);
                        throw new IOException(stringBuffer.toString());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.eventListener.onUpdateResult(CheckUpdateResponse.UPDATE_ERROR, e.toString());
                }
            } else {
                this.eventListener.onUpdateResult(CheckUpdateResponse.UPDATE_ERROR, "Can't unpack an update file.");
            }
        }).start();
    }

    private Path getJarPath() {
        CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            try {
                Path path = Paths.get(codeSource.getLocation().toURI());
                if (path.getFileName() != null) {
                    return path;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return FileEntry.DUMMY_PATH;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean unpackUpdateFile(Path file) {
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(file.toFile()));){
            ZipEntry zipEntry = zis.getNextEntry();
            if (zipEntry == null) return false;
            while (zipEntry != null) {
                try (FileOutputStream fos = new FileOutputStream(file.getParent().resolve(zipEntry.getName()).toFile());){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Path getJavaExecutablePath() {
        Path javaHome = FileUtils.getPath(System.getProperty("java.home"), new String[0]);
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            return javaHome.resolve("bin").resolve("java.exe");
        }
        return javaHome.resolve("bin").resolve("java");
    }
}

