/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.Gdx;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Sound;

public class Cinema {
    private static final short[] nBeforeScene = new short[]{0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final short[] nAfterScene = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 7, 0, 0, 0, 0, 6};
    public static int nCrawlY;
    public static int nHeight;
    public static int nextclock;
    private static int line;
    private static int linecount;
    private static final int[] nLeft;

    public static void ReadyCinemaText(int a1) {
        line = Main.game.FindGString("CINEMAS");
        if (line >= 0) {
            while (a1 != 0) {
                while (!Globals.gString[line].equals("END")) {
                    ++line;
                }
                ++line;
                --a1;
            }
            Cinema.ComputeCinemaText(line);
        }
    }

    public static boolean CheckBeforeScene(int nNewLevel, Runnable run) {
        if (nNewLevel == 20) {
            return Cinema.DoLastLevelCinema(run);
        }
        short num = nBeforeScene[Math.max(nNewLevel - 1, 0)];
        if (num != 0) {
            return Cinema.GoToTheCinema(num, run);
        }
        return false;
    }

    public static boolean DoAfterCinemaScene(int nLevel, Runnable run) {
        short num = nAfterScene[Math.max(nLevel - 1, 0)];
        if (num != 0) {
            return Cinema.GoToTheCinema(num, run);
        }
        return false;
    }

    public static boolean DoLastLevelCinema(Runnable run) {
        Main.gCinemaScreen.setNum(8).setSkipping(run).escSkipping(true);
        Main.game.changeScreen(Main.gCinemaScreen);
        return true;
    }

    public static boolean GoToTheCinema(int num, Runnable run) {
        Main.gCinemaScreen.setNum(num).setSkipping(run).escSkipping(true);
        Main.game.changeScreen(Main.gCinemaScreen);
        return true;
    }

    public static void ComputeCinemaText(int line) {
        linecount = 0;
        while (!Globals.gString[line + linecount].equals("END")) {
            Cinema.nLeft[Cinema.linecount] = 160 - Main.game.getFont(0).getWidth(Globals.gString[line + linecount], 1.0f) / 2;
            ++linecount;
        }
        nCrawlY = 199;
        nHeight = (Main.game.getFont(0).getSize() + 4) * linecount;
        nextclock = Main.engine.getTotalClock();
    }

    public static boolean AdvanceCinemaText() {
        int height = Main.game.getFont(0).getSize() + 4;
        int i = 0;
        for (int y = nCrawlY; i < linecount && y <= 199; ++i, y += height) {
            if (y < -height) continue;
            Cinema.myprintext(nLeft[i], y, Globals.gString[i + line]);
        }
        return nHeight + nCrawlY > 0;
    }

    public static void myprintext(int x, int y, String text) {
        if (y < -15 || y >= 200) {
            return;
        }
        Main.game.getFont(0).drawTextScaled(Main.game.getRenderer(), x, y, text, 1.0f, 0, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
    }

    public static void DoFailedFinalScene() {
        Gdx.app.postRunnable(() -> Cinema.GoToTheCinema(4, Main.game.rMenu));
    }

    public static void DoGameOverScene() {
        Gdx.app.postRunnable(() -> {
            Palette.LoadCinemaPalette(16);
            Sound.PlayGameOverSound();
            Main.engine.setbrightness(Main.cfg.getPaletteGamma(), Palette.cinemapal);
            Main.game.changeScreen(Main.gLogoScreen.setTime(10.0f).setTile(3591).setCallback(Main.game.rMenu).setSkipping(Main.game.rMenu));
        });
    }

    static {
        nLeft = new int[50];
    }
}

