/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.stream.IntStream;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Build.settings.InputContext;
import ru.m210projects.Build.settings.Properties;

public class Config
extends GameConfig {
    public static final int[] defclassickeys = new int[]{19, 20, 21, 22, 67, 57, 55, 56, 29, 54, 59, 62, 129, 75, 74, 92, 93, 61, 70, 69, 0, 49, 111, 68, 0, 115, 3, 123, 149, 8, 9, 10, 11, 12, 13, 14, 66, 71, 72, 0, 0, 0, 0, 0, 0, 137, 34, 37, 0, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142};
    public static final int[] defkeys = new int[]{51, 47, 21, 22, 67, 57, 29, 32, 62, 129, 59, 33, 0, 75, 74, 92, 93, 61, 70, 69, 0, 49, 111, 68, 0, 115, 3, 123, 149, 8, 9, 10, 11, 12, 13, 14, 66, 71, 72, 0, 0, 0, 0, 0, 0, 137, 34, 37, 45, 132, 133, 134, 135, 136, 0, 139, 140, 141, 142};
    public boolean gShowMessages = true;
    public boolean gCrosshair = true;
    public boolean gAutoRun = false;
    public int gCrossSize = 65536;
    public int nScreenSize = 2;
    public int gOverlayMap = 1;
    public boolean gAutoAim = true;
    public int showMapInfo = 1;
    public int gStatSize = 65536;
    public int gShowStat = 1;
    public boolean bNewShadows = true;
    public int gDemoSeq = 1;
    public boolean bSubtitles = true;
    public boolean bGrenadeFix = false;
    public boolean bWaspSound = true;
    public int weaponIndex = -1;

    public Config(Path path) {
        super(path);
    }

    public GameKey[] getKeyMap() {
        return new GameKey[]{GameKeys.Move_Forward, GameKeys.Move_Backward, GameKeys.Turn_Left, GameKeys.Turn_Right, GameKeys.Turn_Around, GameKeys.Strafe, GameKeys.Strafe_Left, GameKeys.Strafe_Right, GameKeys.Jump, GameKeys.Crouch, PsKeys.Crouch_toggle, GameKeys.Run, PsKeys.AutoRun, GameKeys.Open, GameKeys.Weapon_Fire, PsKeys.Aim_Up, PsKeys.Aim_Down, PsKeys.Aim_Center, GameKeys.Look_Up, GameKeys.Look_Down, PsKeys.Weapon_1, PsKeys.Weapon_2, PsKeys.Weapon_3, PsKeys.Weapon_4, PsKeys.Weapon_5, PsKeys.Weapon_6, PsKeys.Weapon_7, PsKeys.Inventory_Use, PsKeys.Inventory_Left, PsKeys.Inventory_Right, PsKeys.Inventory_Hand, PsKeys.Inventory_Eye, PsKeys.Inventory_Mask, PsKeys.Inventory_Heart, PsKeys.Inventory_Torch, PsKeys.Inventory_Scarab, PsKeys.Third_View, PsKeys.Toggle_Crosshair, PsKeys.Last_Used_Weapon, GameKeys.Next_Weapon, GameKeys.Previous_Weapon, GameKeys.Map_Toggle, PsKeys.Map_Follow_Mode, GameKeys.Shrink_Screen, GameKeys.Enlarge_Screen, GameKeys.Mouse_Aiming, PsKeys.Toggle_messages, GameKeys.Show_Console, PsKeys.Show_SaveMenu, PsKeys.Show_LoadMenu, PsKeys.Show_SoundSetup, PsKeys.Show_Options, PsKeys.Quicksave, PsKeys.Quickload, PsKeys.Quit, PsKeys.Gamma, PsKeys.Make_Screenshot, GameKeys.Menu_Toggle};
    }

    @Override
    protected InputContext createDefaultInputContext() {
        return new InputContext(this.getKeyMap(), defkeys, defclassickeys){

            @Override
            protected void clearInput() {
                super.clearInput();
                Config.this.weaponIndex = IntStream.range(0, this.keymap.length).filter(i -> this.keymap[i].equals(PsKeys.Weapon_1)).findFirst().orElse(-1);
            }
        };
    }

    @Override
    protected ConfigContext createDefaultGameContext() {
        return new ConfigContext(){

            @Override
            public void load(Properties prop) {
                if (prop.setContext("Options")) {
                    Config.this.gShowMessages = prop.getBooleanValue("ShowMessages", Config.this.gShowMessages);
                    Config.this.gCrosshair = prop.getBooleanValue("Crosshair", Config.this.gCrosshair);
                    Config.this.gAutoRun = prop.getBooleanValue("AutoRun", Config.this.gAutoRun);
                    Config.this.gCrossSize = Math.max(16384, prop.getIntValue("CrossSize", Config.this.gCrossSize));
                    Config.this.nScreenSize = Gameutils.BClipRange(prop.getIntValue("ScreenSize", Config.this.nScreenSize), 0, 2);
                    Config.this.gOverlayMap = Gameutils.BClipRange(prop.getIntValue("OverlayMap", Config.this.gOverlayMap), 0, 2);
                    Config.this.showMapInfo = prop.getIntValue("showMapInfo", Config.this.showMapInfo);
                    Config.this.gStatSize = Math.max(16384, prop.getIntValue("StatSize", Config.this.gStatSize));
                    Config.this.gShowStat = prop.getIntValue("ShowStat", Config.this.gShowStat);
                    Config.this.gAutoAim = prop.getBooleanValue("AutoAim", Config.this.gAutoAim);
                    Config.this.gDemoSeq = prop.getIntValue("DemoSequence", Config.this.gDemoSeq);
                    Config.this.bNewShadows = prop.getBooleanValue("NewShadows", Config.this.bNewShadows);
                    Config.this.bSubtitles = prop.getBooleanValue("Subtitles", Config.this.bSubtitles);
                    Config.this.bGrenadeFix = prop.getBooleanValue("GrenadeFix", Config.this.bGrenadeFix);
                    Config.this.bWaspSound = prop.getBooleanValue("WaspSound", Config.this.bWaspSound);
                }
            }

            @Override
            public void save(OutputStream os) throws IOException {
                this.putString(os, "[Options]\r\n");
                this.putBoolean(os, "ShowMessages", Config.this.gShowMessages);
                this.putBoolean(os, "Crosshair", Config.this.gCrosshair);
                this.putBoolean(os, "AutoRun", Config.this.gAutoRun);
                this.putInteger(os, "CrossSize", Config.this.gCrossSize);
                this.putInteger(os, "ScreenSize", Config.this.nScreenSize);
                this.putInteger(os, "OverlayMap", Config.this.gOverlayMap);
                this.putInteger(os, "showMapInfo", Config.this.showMapInfo);
                this.putInteger(os, "StatSize", Config.this.gStatSize);
                this.putInteger(os, "ShowStat", Config.this.gShowStat);
                this.putBoolean(os, "AutoAim", Config.this.gAutoAim);
                this.putInteger(os, "DemoSequence", Config.this.gDemoSeq);
                this.putBoolean(os, "NewShadows", Config.this.bNewShadows);
                this.putBoolean(os, "Subtitles", Config.this.bSubtitles);
                this.putBoolean(os, "GrenadeFix", Config.this.bGrenadeFix);
                this.putBoolean(os, "WaspSound", Config.this.bWaspSound);
            }
        };
    }

    public static enum PsKeys implements GameKey
    {
        Crouch_toggle,
        AutoRun,
        Aim_Up,
        Aim_Down,
        Aim_Center,
        Weapon_1,
        Weapon_2,
        Weapon_3,
        Weapon_4,
        Weapon_5,
        Weapon_6,
        Weapon_7,
        Inventory_Use,
        Inventory_Left,
        Inventory_Right,
        Inventory_Hand,
        Inventory_Eye,
        Inventory_Mask,
        Inventory_Heart,
        Inventory_Torch,
        Inventory_Scarab,
        Third_View,
        Map_Follow_Mode,
        Toggle_Crosshair,
        Last_Used_Weapon,
        Show_SaveMenu,
        Show_LoadMenu,
        Show_SoundSetup,
        Show_Options,
        Quicksave,
        Toggle_messages,
        Quickload,
        Quit,
        Gamma,
        Make_Screenshot;


        @Override
        public int getNum() {
            return GameKeys.values().length + this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

