/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Anubis {
    public static final int MAXANUBIS = 80;
    private static final short[][] ActionSeq_X_1 = new short[][]{{0, 0}, {8, 0}, {16, 0}, {24, 0}, {32, 0}, {-1, 0}, {46, 1}, {46, 1}, {47, 1}, {49, 1}, {49, 1}, {40, 1}, {42, 1}, {41, 1}, {43, 1}};
    private static int AnubisCount;
    private static int nAnubisDrum;
    private static final Enemy.EnemyStruct[] AnubisList;

    public static void InitAnubis() {
        AnubisCount = 80;
        nAnubisDrum = 1;
    }

    public static void saveAnubis(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, AnubisCount);
        StreamUtils.writeByte(os, (byte)nAnubisDrum);
        for (int i = AnubisCount; i < 80; ++i) {
            AnubisList[i].save(os);
        }
    }

    public static void loadAnubis(SafeLoader loader) {
        AnubisCount = loader.AnubisCount;
        nAnubisDrum = loader.nAnubisDrum;
        for (int i = loader.AnubisCount; i < 80; ++i) {
            if (AnubisList[i] == null) {
                Anubis.AnubisList[i] = new Enemy.EnemyStruct();
            }
            AnubisList[i].copy(loader.AnubisList[i]);
        }
    }

    public static void loadAnubis(SafeLoader loader, InputStream is) throws IOException {
        loader.AnubisCount = StreamUtils.readShort(is);
        loader.nAnubisDrum = StreamUtils.readByte(is);
        for (int i = loader.AnubisCount; i < 80; ++i) {
            if (loader.AnubisList[i] == null) {
                loader.AnubisList[i] = new Enemy.EnemyStruct();
            }
            loader.AnubisList[i].load(is);
        }
    }

    public static void BuildAnubis(int sn, int x, int y, int z, int sectnum, int ang, int a7) {
        Sector sec;
        int count;
        if ((count = --AnubisCount) < 0) {
            return;
        }
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            sn = Main.engine.insertsprite(sectnum, 101);
            spr = Main.boardService.getSprite(sn);
            if (spr == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = spr.getX();
            y = spr.getY();
            sec = Main.boardService.getSector(spr.getSectnum());
            if (sec != null) {
                z = sec.getFloorz();
            }
            ang = spr.getAng();
            Main.engine.changespritestat(sn, 101);
        }
        if ((sec = Main.boardService.getSector(spr.getSectnum())) == null) {
            return;
        }
        spr.setX(x);
        spr.setY(y);
        spr.setZ(z);
        spr.setCstat(257);
        spr.setXoffset(0);
        spr.setShade(-12);
        spr.setYoffset(0);
        spr.setPicnum(1);
        spr.setPal(sec.getCeilingpal());
        spr.setClipdist(60);
        spr.setAng(ang);
        spr.setXrepeat(40);
        spr.setYrepeat(40);
        spr.setXvel(0);
        spr.setYvel(0);
        spr.setZvel(0);
        spr.setHitag(0);
        spr.setLotag(RunList.HeadRun() + 1);
        spr.setExtra(-1);
        if (AnubisList[count] == null) {
            Anubis.AnubisList[count] = new Enemy.EnemyStruct();
        }
        if (a7 != 0) {
            Anubis.AnubisList[count].nState = nAnubisDrum++ + 6;
            if (nAnubisDrum >= 5) {
                nAnubisDrum = 0;
            }
        } else {
            Anubis.AnubisList[count].nState = 0;
        }
        Anubis.AnubisList[count].nHealth = 540;
        Anubis.AnubisList[count].nSeq = 0;
        Anubis.AnubisList[count].nSprite = sn;
        Anubis.AnubisList[count].nTarget = -1;
        Anubis.AnubisList[count].field_C = 0;
        spr.setOwner(RunList.AddRunRec(spr.getLotag() - 1, 0x90000 | count));
        RunList.AddRunRec(RunList.NewRun, 0x90000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncAnubis(int nStack, int a2, int RunPtr) {
        int nAnubis = RunList.RunData[RunPtr].getObject();
        if (nAnubis < 0 || nAnubis >= 80) {
            throw new AssertException("anubis>=0 && anubis<MAXANUBIS");
        }
        int nSprite = Anubis.AnubisList[nAnubis].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int damage = a2;
        int nState = Anubis.AnubisList[nAnubis].nState;
        boolean v66 = false;
        short plr = (short)(nStack & 0xFFFF);
        Sprite plrSpr = Main.boardService.getSprite(plr);
        switch (nStack & 0x7F0000) {
            case 131072: {
                if (nState < 11) {
                    Sprites.Gravity(nSprite);
                }
                int nSeq = ActionSeq_X_1[nState][0] + Seq.SeqOffsets[17];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, Anubis.AnubisList[nAnubis].nSeq));
                Seq.MoveSequence(nSprite, nSeq, Anubis.AnubisList[nAnubis].nSeq);
                int nTarget = Anubis.AnubisList[nAnubis].nTarget;
                Sprite pTarget = Main.boardService.getSprite(nTarget);
                if (++Anubis.AnubisList[nAnubis].nSeq >= Seq.SeqSize[nSeq]) {
                    Anubis.AnubisList[nAnubis].nSeq = 0;
                    v66 = true;
                }
                int flags = Seq.FrameFlag[Anubis.AnubisList[nAnubis].nSeq + Seq.SeqBase[nSeq]];
                int v60 = 0;
                if (Anubis.AnubisList[nAnubis].nState > 0 && Anubis.AnubisList[nAnubis].nState < 11) {
                    v60 = Enemy.MoveCreatureWithCaution(nSprite);
                }
                block6 : switch (nState) {
                    default: {
                        return;
                    }
                    case 0: {
                        if ((nAnubis & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            if (nTarget < 0) {
                                nTarget = Enemy.FindPlayer(nSprite, 100);
                                pTarget = Main.boardService.getSprite(nTarget);
                            }
                            if (pTarget != null) {
                                Sound.D3PlayFX(Sound.StaticSound[8], nSprite);
                                Anubis.AnubisList[nAnubis].nState = 1;
                                Anubis.AnubisList[nAnubis].nSeq = 0;
                                Anubis.AnubisList[nAnubis].nTarget = nTarget;
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 2);
                            }
                        }
                        return;
                    }
                    case 3: {
                        if (!v66) {
                            if ((flags & 0x80) != 0) {
                                Bullet.BuildBullet(nSprite, 8, -1, pSprite.getAng(), nTarget + 10000, 1);
                            }
                            return;
                        }
                        Anubis.AnubisList[nAnubis].nState = 1;
                        pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                        pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 2);
                        Anubis.AnubisList[nAnubis].nSeq = 0;
                        return;
                    }
                    case 4: 
                    case 5: {
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                        if (v66) {
                            Anubis.AnubisList[nAnubis].nState = 1;
                            Anubis.AnubisList[nAnubis].nSeq = 0;
                        }
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        if (v66) {
                            Anubis.AnubisList[nAnubis].nState = Random.RandomSize(3) % 5 + 6;
                            Anubis.AnubisList[nAnubis].nSeq = 0;
                        }
                        return;
                    }
                    case 11: 
                    case 12: {
                        if (v66) {
                            Anubis.AnubisList[nAnubis].nState = nState + 2;
                            Anubis.AnubisList[nAnubis].nSeq = 0;
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                        }
                        return;
                    }
                    case 13: 
                    case 14: {
                        pSprite.setCstat(pSprite.getCstat() & 0xFEFE);
                        return;
                    }
                    case 2: {
                        if (nTarget == -1) {
                            Anubis.AnubisList[nAnubis].nState = 0;
                            Anubis.AnubisList[nAnubis].field_C = 50;
                            break;
                        }
                        if (Enemy.PlotCourseToSprite(nSprite, nTarget) >= 768) {
                            Anubis.AnubisList[nAnubis].nState = 1;
                            break;
                        }
                        if ((flags & 0x80) == 0) break;
                        Sprites.DamageEnemy(nTarget, nSprite, 7);
                        break;
                    }
                    case 1: {
                        if ((nAnubis & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            int ang = pSprite.getAng() & 0xFFF8;
                            pSprite.setXvel(EngineUtils.sin(ang + 512 & 0x7FF) >> 2);
                            pSprite.setYvel(EngineUtils.sin(ang & 0x7FF) >> 2);
                        }
                        switch (v60 & 0xE000) {
                            case 49152: {
                                if ((v60 & 0x1FFF) == nTarget) {
                                    if (pTarget == null || Sprites.AngleDiff(pSprite.getAng(), EngineUtils.getAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY())) >= 64) break block6;
                                    Anubis.AnubisList[nAnubis].nState = 2;
                                    Anubis.AnubisList[nAnubis].nSeq = 0;
                                    break block6;
                                }
                            }
                            case 32768: {
                                pSprite.setAng(pSprite.getAng() + 256 & 0x7FF);
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 2);
                                break block6;
                            }
                            default: {
                                if (Anubis.AnubisList[nAnubis].field_C != 0) {
                                    --Anubis.AnubisList[nAnubis].field_C;
                                    break block6;
                                }
                                Anubis.AnubisList[nAnubis].field_C = 60;
                                if (pTarget == null || !Main.engine.cansee(pSprite.getX(), pSprite.getY(), pSprite.getZ() - Sprites.GetSpriteHeight(nSprite), pSprite.getSectnum(), pTarget.getX(), pTarget.getY(), pTarget.getZ() - Sprites.GetSpriteHeight(nTarget), pTarget.getSectnum())) break block6;
                                Anubis.AnubisList[nAnubis].nState = 3;
                                pSprite.setXvel(0);
                                pSprite.setYvel(0);
                                pSprite.setAng(Main.engine.GetMyAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY()));
                                Anubis.AnubisList[nAnubis].nSeq = 0;
                            }
                        }
                    }
                }
                if (pTarget != null && (pTarget.getCstat() & 0x101) == 0) {
                    Anubis.AnubisList[nAnubis].nState = 0;
                    Anubis.AnubisList[nAnubis].nSeq = 0;
                    Anubis.AnubisList[nAnubis].field_C = 100;
                    Anubis.AnubisList[nAnubis].nTarget = -1;
                    pSprite.setXvel(0);
                    pSprite.setYvel(0);
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(plr);
                Seq.PlotSequence(tsp, ActionSeq_X_1[Anubis.AnubisList[nAnubis].nState][0] + Seq.SeqOffsets[17], Anubis.AnubisList[nAnubis].nSeq, ActionSeq_X_1[Anubis.AnubisList[nAnubis].nState][1]);
                return;
            }
            case 655360: {
                if (Anubis.AnubisList[nAnubis].nState >= 11) {
                    return;
                }
                damage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (damage == 0 || Anubis.AnubisList[nAnubis].nHealth <= 0) break;
                Anubis.AnubisList[nAnubis].nHealth -= damage;
                if (Anubis.AnubisList[nAnubis].nHealth > 0) {
                    if (plrSpr == null) break;
                    short statnum = plrSpr.getStatnum();
                    if (statnum < 199 && Random.RandomSize(5) == 0) {
                        Anubis.AnubisList[nAnubis].nTarget = plr;
                    }
                    if (Random.RandomSize(1) != 0) {
                        int j;
                        Sprite spr2;
                        if (Anubis.AnubisList[nAnubis].nState >= 6 && Anubis.AnubisList[nAnubis].nState <= 10 && (spr2 = Main.boardService.getSprite(j = Main.engine.insertsprite(pSprite.getSectnum(), 98))) != null) {
                            spr2.setX(pSprite.getX());
                            spr2.setY(pSprite.getY());
                            Sector sec2 = Main.boardService.getSector(spr2.getSectnum());
                            if (sec2 != null) {
                                spr2.setZ(sec2.getFloorz());
                            }
                            spr2.setYrepeat(40);
                            spr2.setXrepeat(40);
                            spr2.setShade(-64);
                            Object.BuildObject(j, 2, 0);
                        }
                        Anubis.AnubisList[nAnubis].nState = 4;
                        Anubis.AnubisList[nAnubis].nSeq = 0;
                        break;
                    }
                    Sound.D3PlayFX(Sound.StaticSound[39], nSprite);
                    break;
                }
                pSprite.setXvel(0);
                pSprite.setYvel(0);
                pSprite.setZvel(0);
                Sector sec = Main.boardService.getSector(pSprite.getSectnum());
                if (sec != null) {
                    pSprite.setZ(sec.getFloorz());
                }
                Anubis.AnubisList[nAnubis].nHealth = 0;
                pSprite.setCstat(pSprite.getCstat() & 0xFEFE);
                if (Anubis.AnubisList[nAnubis].nState < 11) {
                    Enemy.DropMagic(nSprite);
                    Anubis.AnubisList[nAnubis].nState = ((nStack & 0x7F0000) == 655360 ? 1 : 0) + 11;
                    Anubis.AnubisList[nAnubis].nSeq = 0;
                }
                --Globals.nCreaturesLeft;
            }
        }
    }

    static {
        AnubisList = new Enemy.EnemyStruct[80];
    }
}

