/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Sprites;

public class Enemy {
    public static int MoveCreature(int nSprite) {
        Sprite spr = Main.boardService.getSprite(nSprite);
        if (spr == null) {
            return 0;
        }
        return Main.engine.movesprite(nSprite, spr.getXvel() << 8, spr.getYvel() << 8, spr.getZvel(), 15360, -5120, 0);
    }

    public static int MoveCreatureWithCaution(int nSprite) {
        Sprite spr = Main.boardService.getSprite(nSprite);
        if (spr == null) {
            return 0;
        }
        int x = spr.getX();
        int y = spr.getY();
        int z = spr.getZ();
        short nOldSector = spr.getSectnum();
        Sector osec = Main.boardService.getSector(nOldSector);
        int hitMove = Enemy.MoveCreature(nSprite);
        short nSector = spr.getSectnum();
        Sector sec = Main.boardService.getSector(nSector);
        if (nSector != nOldSector && sec != null && osec != null && (Pragmas.klabs(osec.getFloorz() - sec.getFloorz()) > 15360 || (Globals.SectFlag[nSector] & 0x2000) != 0 || Globals.SectBelow[nSector] > -1 && Globals.SectFlag[Globals.SectBelow[nSector]] != 0 || Globals.SectDamage[nSector] != 0)) {
            spr.setX(x);
            spr.setY(y);
            spr.setZ(z);
            Main.engine.mychangespritesect(nSprite, nOldSector);
            spr.setAng(spr.getAng() + 256 & 0x7FF);
            spr.setXvel(EngineUtils.sin(spr.getAng() + 512 & 0x7FF) >> 2);
            spr.setYvel(EngineUtils.sin(spr.getAng() & 0x7FF) >> 2);
            return 0;
        }
        return hitMove;
    }

    public static void DropMagic(int nSprite) {
        Sprite spr = Main.boardService.getSprite(nSprite);
        if (spr == null) {
            return;
        }
        if (Globals.lFinaleStart == 0 && --Globals.nMagicCount <= 0) {
            int v1 = Anim.BuildAnim(-1, 64, 0, spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum(), 48, 4);
            int animIndex = Anim.GetAnimSprite(v1);
            Sprite animSprite = Main.boardService.getSprite(animIndex);
            if (animSprite == null) {
                return;
            }
            animSprite.setOwner(v1);
            Light.AddFlash(animSprite.getSectnum(), animSprite.getX(), animSprite.getY(), animSprite.getZ(), 128);
            Main.engine.changespritestat(animIndex, 950);
            Globals.nMagicCount = Random.RandomSize(2);
        }
    }

    public static int UpdateEnemy(int nTarget) {
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        if (pTarget != null) {
            if ((pTarget.getCstat() & 0x101) == 0) {
                nTarget = -1;
            }
            return nTarget;
        }
        return -1;
    }

    public static int PlotCourseToSprite(int a1, int nTarget) {
        Sprite v3 = Main.boardService.getSprite(a1);
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        if (v3 != null && pTarget != null) {
            int dx = pTarget.getX() - v3.getX();
            int dy = pTarget.getY() - v3.getY();
            v3.setAng(Main.engine.GetMyAngle(dx, dy));
            return EngineUtils.sqrt(dx * dx + dy * dy);
        }
        return -1;
    }

    public static int FindPlayer(int nDude, int dist) {
        boolean bCourse = true;
        if (nDude < 0) {
            nDude = -nDude;
            bCourse = false;
        }
        if (dist < 0) {
            dist = 100;
        }
        dist <<= 8;
        Sprite pDude = Main.boardService.getSprite(nDude);
        if (pDude == null) {
            return -1;
        }
        int dz = pDude.getZ() - Sprites.GetSpriteHeight(nDude);
        for (int i = 0; i < Mmulti.numplayers; ++i) {
            Sprite pPlayer = Main.boardService.getSprite(Globals.PlayerList[i].spriteId);
            if (pPlayer == null || (pPlayer.getCstat() & 0x101) == 0 || (pPlayer.getCstat() & 0x8000) != 0 || Pragmas.klabs(pPlayer.getX() - pDude.getX()) >= dist || Pragmas.klabs(pPlayer.getY() - pDude.getY()) >= dist || !Main.engine.cansee(pPlayer.getX(), pPlayer.getY(), pPlayer.getZ() - 7680, pPlayer.getSectnum(), pDude.getX(), pDude.getY(), dz, pDude.getSectnum())) continue;
            if (bCourse) {
                Enemy.PlotCourseToSprite(nDude, Globals.PlayerList[i].spriteId);
            }
            return Globals.PlayerList[i].spriteId;
        }
        return -1;
    }

    public static class EnemyStruct {
        public static final int size = 16;
        public int nHealth;
        public int nSeq;
        public int nState;
        public int nSprite;
        public int nTarget;
        public int field_A;
        public int field_C;
        public int nFunc = -1;

        public void save(OutputStream os) throws IOException {
            StreamUtils.writeShort(os, this.nHealth);
            StreamUtils.writeShort(os, this.nSeq);
            StreamUtils.writeShort(os, this.nState);
            StreamUtils.writeShort(os, this.nSprite);
            StreamUtils.writeShort(os, this.nTarget);
            StreamUtils.writeShort(os, this.field_A);
            StreamUtils.writeShort(os, this.field_C);
            StreamUtils.writeShort(os, this.nFunc);
        }

        public void load(InputStream is) throws IOException {
            this.nHealth = StreamUtils.readShort(is);
            this.nSeq = StreamUtils.readShort(is);
            this.nState = StreamUtils.readShort(is);
            this.nSprite = StreamUtils.readShort(is);
            this.nTarget = StreamUtils.readShort(is);
            this.field_A = StreamUtils.readShort(is);
            this.field_C = StreamUtils.readShort(is);
            this.nFunc = StreamUtils.readShort(is);
        }

        public EnemyStruct copy(EnemyStruct src) {
            this.nHealth = src.nHealth;
            this.nSeq = src.nSeq;
            this.nState = src.nState;
            this.nSprite = src.nSprite;
            this.nTarget = src.nTarget;
            this.field_A = src.field_A;
            this.field_C = src.field_C;
            this.nFunc = src.nFunc;
            return this;
        }
    }
}

