/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.FishChunk;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Fish {
    public static final int MAX_FISHS = 128;
    private static final int[][] ActionSeq_X_5 = new int[][]{{8, 0}, {8, 0}, {0, 0}, {24, 0}, {8, 0}, {32, 1}, {33, 1}, {34, 1}, {35, 1}, {39, 1}};
    private static int FishCount;
    private static int nChunksFree;
    private static final int[] nFreeChunk;
    private static final FishChunk[] FishChunk;
    private static final Enemy.EnemyStruct[] FishList;

    public static void InitFishes() {
        int i;
        FishCount = 0;
        nChunksFree = 128;
        for (i = 0; i < 128; ++i) {
            Fish.nFreeChunk[i] = i;
        }
        for (i = 0; i < 128; ++i) {
            if (FishChunk[i] != null) continue;
            Fish.FishChunk[i] = new FishChunk();
        }
    }

    public static void saveFish(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, FishCount);
        StreamUtils.writeByte(os, (byte)nChunksFree);
        for (i = 0; i < 128; ++i) {
            StreamUtils.writeShort(os, nFreeChunk[i]);
            FishChunk[i].save(os);
        }
        for (i = 0; i < FishCount; ++i) {
            FishList[i].save(os);
        }
    }

    public static void loadFish(SafeLoader loader) {
        int i;
        FishCount = loader.FishCount;
        nChunksFree = loader.nChunksFree;
        for (i = 0; i < 128; ++i) {
            Fish.nFreeChunk[i] = loader.nFreeChunk[i];
            if (FishChunk[i] == null) {
                Fish.FishChunk[i] = new FishChunk();
            }
            FishChunk[i].copy(loader.FishChunk[i]);
        }
        for (i = 0; i < loader.FishCount; ++i) {
            if (FishList[i] == null) {
                Fish.FishList[i] = new Enemy.EnemyStruct();
            }
            FishList[i].copy(loader.FishList[i]);
        }
    }

    public static void loadFish(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.FishCount = StreamUtils.readShort(is);
        loader.nChunksFree = StreamUtils.readUnsignedByte(is);
        for (i = 0; i < 128; ++i) {
            loader.nFreeChunk[i] = StreamUtils.readShort(is);
            if (loader.FishChunk[i] == null) {
                loader.FishChunk[i] = new FishChunk();
            }
            loader.FishChunk[i].load(is);
        }
        for (i = 0; i < loader.FishCount; ++i) {
            if (loader.FishList[i] == null) {
                loader.FishList[i] = new Enemy.EnemyStruct();
            }
            loader.FishList[i].load(is);
        }
    }

    public static void BuildBlood(int a1, int a2, int a3, int a4) {
        Anim.BuildAnim(-1, 19, 36, a1, a2, a3, a4, 75, -128);
    }

    public static void BuildFishLimb(int a1, int a2) {
        if (nChunksFree > 0) {
            int nSprite = Fish.FishList[a1].nSprite;
            Sprite spr = Main.boardService.getSprite(nSprite);
            if (spr == null) {
                return;
            }
            int nChunk = nFreeChunk[nChunksFree-- - 1];
            FishChunk pChunk = FishChunk[nChunk];
            int j = Main.engine.insertsprite(spr.getSectnum(), 99);
            Sprite pSprite = Main.boardService.getSprite(j);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
            pChunk.nSprite = j;
            pChunk.ActionSeq = a2 + 40;
            pChunk.nSeq = Random.RandomSize(3) % Seq.SeqSize[Seq.SeqOffsets[19] + pChunk.ActionSeq];
            pSprite.setX(spr.getX());
            pSprite.setY(spr.getY());
            pSprite.setZ(spr.getZ());
            pSprite.setCstat(0);
            pSprite.setShade(-12);
            pSprite.setPal(0);
            pSprite.setXvel((Random.RandomSize(5) & 0xFFFF) - 16 << 8);
            pSprite.setYvel((Random.RandomSize(5) & 0xFFFF) - 16 << 8);
            pSprite.setXrepeat(64);
            pSprite.setYrepeat(64);
            pSprite.setXoffset(0);
            pSprite.setYoffset(0);
            pSprite.setZvel(-2 * (Random.RandomByte() + 512));
            a2 = Seq.GetSeqPicnum(19, pChunk.ActionSeq, 0);
            pSprite.setPicnum(a2);
            pSprite.setLotag(RunList.HeadRun() + 1);
            pSprite.setClipdist(0);
            pSprite.setExtra(-1);
            pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x200000 | nChunk));
            pSprite.setHitag(RunList.AddRunRec(RunList.NewRun, 0x200000 | nChunk));
        }
    }

    public static void BuildFish(int i, int x, int y, int z, int sectnum, int ang) {
        int count;
        if ((count = FishCount++) >= 128) {
            return;
        }
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            i = Main.engine.insertsprite(sectnum, 103);
            spr = Main.boardService.getSprite(i);
            if (spr == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = spr.getX();
            y = spr.getY();
            z = spr.getZ();
            ang = spr.getAng();
            Main.engine.changespritestat(i, 103);
        }
        spr.setX(x);
        spr.setY(y);
        spr.setZ(z);
        spr.setShade(-12);
        spr.setCstat(257);
        spr.setClipdist(80);
        spr.setXrepeat(40);
        spr.setYrepeat(40);
        Sector sec = Main.boardService.getSector(spr.getSectnum());
        spr.setPal(sec != null ? sec.getCeilingpal() : (short)0);
        spr.setXoffset(0);
        spr.setYoffset(0);
        spr.setPicnum(Seq.GetSeqPicnum(19, ActionSeq_X_5[0][0], 0));
        spr.setAng(ang);
        spr.setXvel(0);
        spr.setYvel(0);
        spr.setZvel(0);
        spr.setHitag(0);
        spr.setLotag(RunList.HeadRun() + 1);
        spr.setExtra(-1);
        if (FishList[count] == null) {
            Fish.FishList[count] = new Enemy.EnemyStruct();
        }
        Fish.FishList[count].nState = 0;
        Fish.FishList[count].nHealth = 200;
        Fish.FishList[count].nSprite = i;
        Fish.FishList[count].nTarget = -1;
        Fish.FishList[count].field_C = 60;
        Fish.FishList[count].nSeq = 0;
        spr.setOwner(RunList.AddRunRec(spr.getLotag() - 1, 0x120000 | count));
        Fish.FishList[count].nFunc = RunList.AddRunRec(RunList.NewRun, 0x120000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void IdleFish(int nFish, int a2) {
        int nSprite = Fish.FishList[nFish].nSprite;
        Sprite spr = Main.boardService.getSprite(nSprite);
        if (spr == null) {
            return;
        }
        spr.setAng(spr.getAng() + (256 - Random.RandomSize(9)) + 1024);
        spr.setAng(spr.getAng() & 0x7FF);
        spr.setXvel(EngineUtils.sin(spr.getAng() + 512 & 0x7FF) >> 8);
        spr.setYvel(EngineUtils.sin(spr.getAng() & 0x7FF) >> 8);
        Fish.FishList[nFish].nState = 0;
        Fish.FishList[nFish].nSeq = 0;
        spr.setZvel(Random.RandomSize(9));
        if (a2 > 0) {
            return;
        }
        if (a2 == 0 && Random.RandomBit() == 0) {
            return;
        }
        spr.setZvel(-spr.getZvel());
    }

    private static void DestroyFish(int nFish) {
        Sprite spr = Main.boardService.getSprite(Fish.FishList[nFish].nSprite);
        if (spr == null) {
            return;
        }
        RunList.DoSubRunRec(spr.getOwner());
        RunList.FreeRun(spr.getLotag() - 1);
        RunList.SubRunRec(Fish.FishList[nFish].nFunc);
        Main.engine.mydeletesprite(Fish.FishList[nFish].nSprite);
    }

    public static void FuncFishLimb(int nStack, int ignored, int RunPtr) {
        int nChunk = RunList.RunData[RunPtr].getObject();
        int nSprite = Fish.FishChunk[nChunk].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int v6 = Seq.SeqOffsets[19] + Fish.FishChunk[nChunk].ActionSeq;
        switch (nStack & 0x7F0000) {
            case 131072: {
                Sector sec;
                pSprite.setPicnum(Seq.GetSeqPicnum2(v6, Fish.FishChunk[nChunk].nSeq));
                Sprites.Gravity(nSprite);
                ++Fish.FishChunk[nChunk].nSeq;
                if (Fish.FishChunk[nChunk].nSeq >= Seq.SeqSize[v6]) {
                    Fish.FishChunk[nChunk].nSeq = 0;
                    if (Random.RandomBit() != 0) {
                        Fish.BuildBlood(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum());
                    }
                }
                if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
                    return;
                }
                if (sec.getFloorz() > pSprite.getZ()) {
                    if (Main.engine.movesprite(nSprite, pSprite.getXvel() << 8, pSprite.getYvel() << 8, pSprite.getZvel(), 2560, -2560, 1) != 0) {
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                    }
                } else {
                    pSprite.setZ(pSprite.getZ() + 256);
                    int dz = pSprite.getZ() - sec.getFloorz();
                    if (dz <= 25600) {
                        if (dz > 0) {
                            pSprite.setZvel(1024);
                        }
                    } else {
                        pSprite.setZvel(0);
                        RunList.DoSubRunRec(pSprite.getOwner());
                        RunList.FreeRun(pSprite.getLotag() - 1);
                        RunList.SubRunRec(pSprite.getHitag());
                        Main.engine.mydeletesprite(nSprite);
                    }
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, v6, Fish.FishChunk[nChunk].nSeq, 1);
            }
        }
    }

    public static void FuncFish(int nStack, int a2, int RunPtr) {
        int nFish = RunList.RunData[RunPtr].getObject();
        if (nFish < 0 || nFish >= 128) {
            throw new AssertException("Fish>=0 && Fish<MAX_FISHS");
        }
        int nSprite = Fish.FishList[nFish].nSprite;
        Sprite spr = Main.boardService.getSprite(nSprite);
        if (spr == null) {
            return;
        }
        int nState = Fish.FishList[nFish].nState;
        short plr = (short)(nStack & 0xFFFF);
        int damage = a2;
        switch (nStack & 0x7F0000) {
            case 131072: {
                int v18;
                if ((Globals.SectFlag[spr.getSectnum()] & 0x2000) == 0) {
                    Sprites.Gravity(nSprite);
                }
                int v10 = ActionSeq_X_5[nState][0] + Seq.SeqOffsets[19];
                spr.setPicnum(Seq.GetSeqPicnum2(v10, Fish.FishList[nFish].nSeq));
                Seq.MoveSequence(nSprite, v10, Fish.FishList[nFish].nSeq);
                ++Fish.FishList[nFish].nSeq;
                if (Fish.FishList[nFish].nSeq >= Seq.SeqSize[v10]) {
                    Fish.FishList[nFish].nSeq = 0;
                }
                int nTarget = Fish.FishList[nFish].nTarget;
                Sprite pTarget = Main.boardService.getSprite(nTarget);
                switch (nState) {
                    default: {
                        return;
                    }
                    case 4: {
                        if (Fish.FishList[nFish].nSeq == 0) {
                            Fish.IdleFish(nFish, 0);
                        }
                        return;
                    }
                    case 9: {
                        if (Fish.FishList[nFish].nSeq == 0) {
                            Fish.DestroyFish(nFish);
                        }
                        return;
                    }
                    case 2: 
                    case 3: {
                        --Fish.FishList[nFish].field_C;
                        if (Fish.FishList[nFish].field_C <= 0) {
                            Fish.IdleFish(nFish, 0);
                            return;
                        }
                        if (pTarget == null) break;
                        Enemy.PlotCourseToSprite(nSprite, nTarget);
                        int dz = pTarget.getZ() - spr.getZ();
                        if (Pragmas.klabs(dz) <= Sprites.GetSpriteHeight(nSprite) >> 1) {
                            int cos = EngineUtils.sin(spr.getAng() + 512 & 0x7FF);
                            int sin = EngineUtils.sin(spr.getAng() & 0x7FF);
                            spr.setXvel((cos >> 5) - (cos >> 7));
                            spr.setYvel((sin >> 5) - (sin >> 7));
                        } else {
                            spr.setXvel(0);
                            spr.setYvel(0);
                        }
                        spr.setZvel(dz >> 3);
                        break;
                    }
                    case 0: {
                        --Fish.FishList[nFish].field_C;
                        if (Fish.FishList[nFish].field_C > 0) break;
                        nTarget = Enemy.FindPlayer(nSprite, 60);
                        pTarget = Main.boardService.getSprite(nTarget);
                        if (pTarget == null) {
                            Fish.IdleFish(nFish, 0);
                            break;
                        }
                        Fish.FishList[nFish].nTarget = nTarget;
                        Fish.FishList[nFish].nState = 2;
                        Fish.FishList[nFish].nSeq = 0;
                        spr.setZvel(EngineUtils.sin(Main.engine.GetMyAngle(pTarget.getX() - spr.getX(), pTarget.getZ() - spr.getZ()) & 0x7FF) >> 5);
                        Fish.FishList[nFish].field_C = Random.RandomSize(6) + 90;
                    }
                }
                int ox = spr.getX();
                int oy = spr.getY();
                int oz = spr.getZ();
                short osect = spr.getSectnum();
                int hitMove = Main.engine.movesprite(nSprite, spr.getXvel() << 13, spr.getYvel() << 13, 4 * spr.getZvel(), 0, 0, 0);
                if ((Globals.SectFlag[spr.getSectnum()] & 0x2000) != 0) {
                    if (hitMove == 0) {
                        if (nState == 3) {
                            Fish.FishList[nFish].nState = 2;
                            Fish.FishList[nFish].nSeq = 0;
                        }
                        return;
                    }
                    if ((hitMove & 0x30000) == 0) {
                        switch (hitMove & 0xE000) {
                            default: {
                                return;
                            }
                            case 49152: {
                                int nHitObject = hitMove & 0x1FFF;
                                pTarget = Main.boardService.getSprite(nHitObject);
                                if (pTarget != null && pTarget.getStatnum() == 100) {
                                    nTarget = Fish.FishList[nFish].nTarget = nHitObject;
                                    spr.setAng(Main.engine.GetMyAngle(pTarget.getX() - spr.getX(), pTarget.getY() - spr.getY()));
                                    if (nState != 3) {
                                        Fish.FishList[nFish].nState = 3;
                                        Fish.FishList[nFish].nSeq = 0;
                                    }
                                    if (Fish.FishList[nFish].nSeq == 0) {
                                        Sprites.DamageEnemy(nTarget, nSprite, 2);
                                    }
                                }
                                return;
                            }
                            case 32768: 
                        }
                        Fish.IdleFish(nFish, 0);
                        return;
                    }
                    v18 = (hitMove & 0x20000) != 0 ? -1 : 1;
                } else {
                    Main.engine.mychangespritesect(nSprite, osect);
                    spr.setX(ox);
                    spr.setY(oy);
                    spr.setZ(oz);
                    v18 = 0;
                }
                Fish.IdleFish(nFish, v18);
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(plr);
                Seq.PlotSequence(tsp, ActionSeq_X_5[Fish.FishList[nFish].nState][0] + Seq.SeqOffsets[19], Fish.FishList[nFish].nSeq, ActionSeq_X_5[Fish.FishList[nFish].nState][1]);
                return;
            }
            case 655360: {
                if (Fish.FishList[nFish].nHealth <= 0) {
                    return;
                }
                damage = Sprites.CheckRadialDamage(nSprite);
                if (damage != 0) {
                    Fish.FishList[nFish].field_C = 10;
                }
            }
            case 524288: {
                if (damage == 0 || Fish.FishList[nFish].nHealth <= 0) break;
                Fish.FishList[nFish].nHealth -= damage;
                if (Fish.FishList[nFish].nHealth > 0) {
                    Sprite plrSpr = Main.boardService.getSprite(plr);
                    if (plrSpr != null && plrSpr.getStatnum() < 199) {
                        Fish.FishList[nFish].nTarget = plr;
                    }
                    Fish.FishList[nFish].nSeq = 0;
                    Fish.FishList[nFish].nState = 4;
                    Fish.FishList[nFish].field_C += 10;
                    break;
                }
                Fish.FishList[nFish].nHealth = 0;
                spr.setCstat(spr.getCstat() & 0xFEFE);
                if ((nStack & 0x7F0000) != 524288) {
                    Fish.FishList[nFish].nState = 9;
                    Fish.FishList[nFish].nSeq = 0;
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    Fish.BuildFishLimb(nFish, i);
                }
                Sound.PlayFXAtXYZ(Sound.StaticSound[40], spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum());
                Fish.DestroyFish(nFish);
                --Globals.nCreaturesLeft;
            }
        }
    }

    static {
        nFreeChunk = new int[128];
        FishChunk = new FishChunk[128];
        FishList = new Enemy.EnemyStruct[128];
    }
}

