/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class LavaDude {
    public static final int MAX_LAVAS = 20;
    private static final short[][] ActionSeq_X_6 = new short[][]{{0, 1}, {0, 1}, {1, 0}, {10, 0}, {19, 0}, {28, 1}, {29, 1}, {33, 0}, {42, 1}};
    private static final Enemy.EnemyStruct[] LavaList = new Enemy.EnemyStruct[20];
    private static int LavaCount;

    public static void InitLava() {
        LavaCount = 0;
    }

    public static void saveLava(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, LavaCount);
        for (int i = 0; i < LavaCount; ++i) {
            LavaList[i].save(os);
        }
    }

    public static void loadLava(SafeLoader loader, InputStream is) throws IOException {
        loader.LavaCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.LavaCount; ++i) {
            if (loader.LavaList[i] == null) {
                loader.LavaList[i] = new Enemy.EnemyStruct();
            }
            loader.LavaList[i].load(is);
        }
    }

    public static void loadLava(SafeLoader loader) {
        LavaCount = loader.LavaCount;
        for (int i = 0; i < loader.LavaCount; ++i) {
            if (LavaList[i] == null) {
                LavaDude.LavaList[i] = new Enemy.EnemyStruct();
            }
            LavaList[i].copy(loader.LavaList[i]);
        }
    }

    public static void BuildLava(int spr, int x, int y, int sectnum, int ang, int channel) {
        Sector sec;
        int count;
        if ((count = LavaCount++) >= 20) {
            return;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 118);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = pSprite.getX();
            y = pSprite.getY();
            sectnum = pSprite.getSectnum();
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 118);
        }
        if ((sec = Main.boardService.getSector(sectnum)) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(sec.getFloorz());
        pSprite.setCstat(32768);
        pSprite.setXoffset(0);
        pSprite.setShade(-12);
        pSprite.setYoffset(0);
        pSprite.setPicnum(Seq.GetSeqPicnum(42, ActionSeq_X_6[3][0], 0));
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setClipdist(127);
        pSprite.setAng(ang);
        pSprite.setXrepeat(200);
        pSprite.setYrepeat(200);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (LavaList[count] == null) {
            LavaDude.LavaList[count] = new Enemy.EnemyStruct();
        }
        LavaDude.LavaList[count].nState = 0;
        LavaDude.LavaList[count].nHealth = 4000;
        LavaDude.LavaList[count].nSprite = spr;
        LavaDude.LavaList[count].nTarget = -1;
        LavaDude.LavaList[count].field_C = channel;
        LavaDude.LavaList[count].nSeq = 0;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x150000 | count));
        LavaDude.LavaList[count].nFunc = RunList.AddRunRec(RunList.NewRun, 0x150000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncLava(int nStack, int nDamage, int RunPtr) {
        int nLava = RunList.RunData[RunPtr].getObject();
        if (nLava < 0 || nLava >= 20) {
            throw new AssertException("Lava>=0 && Lava<MAX_LAVAS");
        }
        Enemy.EnemyStruct pLava = LavaList[nLava];
        int nSprite = pLava.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pLava.nState;
        int nTarget = pLava.nTarget;
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        short nObject = (short)(nStack & 0xFFFF);
        boolean v57 = false;
        switch (nStack & 0x7F0000) {
            case 131072: {
                int nSeq = ActionSeq_X_6[nState][0] + Seq.SeqOffsets[42];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pLava.nSeq));
                if (nState != 0) {
                    Seq.MoveSequence(nSprite, nSeq, pLava.nSeq);
                    if (++pLava.nSeq >= Seq.SeqSize[nSeq]) {
                        pLava.nSeq = 0;
                        v57 = true;
                    }
                }
                int nFlags = Seq.FrameFlag[pLava.nSeq + Seq.SeqBase[nSeq]];
                if (pTarget != null && nState < 4 && ((pTarget.getCstat() & 0x101) == 0 || pTarget.getSectnum() >= 1024)) {
                    nTarget = -1;
                    pTarget = null;
                    pLava.nTarget = -1;
                }
                switch (nState) {
                    case 0: {
                        if ((nLava & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            if (nTarget < 0) {
                                nTarget = Enemy.FindPlayer(nSprite, 76800);
                                pTarget = Main.boardService.getSprite(nTarget);
                            }
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                            if (pTarget != null && Random.RandomSize(1) == 0) {
                                pLava.nTarget = nTarget;
                                pLava.nState = 2;
                                pSprite.setCstat(257);
                                pLava.nSeq = 0;
                                break;
                            }
                        }
                        int sx = pSprite.getX();
                        int sy = pSprite.getY();
                        int sz = pSprite.getZ();
                        short ssec = pSprite.getSectnum();
                        int hitMove = Main.engine.movesprite(nSprite, pSprite.getXvel() << 8, pSprite.getYvel() << 8, 0, 0, 0, 0);
                        if (ssec == pSprite.getSectnum()) {
                            if (hitMove == 0) break;
                            switch (hitMove & 0xE000) {
                                case 32768: {
                                    pSprite.setAng(pSprite.getAng() + ((Random.RandomWord() & 0x300) + 1024) & 0x7FF);
                                    pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                                    pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                                    pSprite.setPal(1);
                                    return;
                                }
                                case 49152: {
                                    if ((hitMove & 0x1FFF) == nTarget && pTarget != null && Sprites.AngleDiff(pSprite.getAng(), EngineUtils.getAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY())) < 64) {
                                        pLava.nState = 2;
                                        pSprite.setCstat(257);
                                        pLava.nSeq = 0;
                                    }
                                    pSprite.setPal(1);
                                    return;
                                }
                            }
                        } else {
                            Main.engine.changespritesect(nSprite, ssec);
                            pSprite.setX(sx);
                            pSprite.setY(sy);
                            pSprite.setZ(sz);
                        }
                        pSprite.setAng(pSprite.getAng() + ((Random.RandomWord() & 0x300) + 1024) & 0x7FF);
                        pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                        pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                        break;
                    }
                    case 2: {
                        if (!v57) break;
                        pLava.nState = 3;
                        pLava.nSeq = 0;
                        Enemy.PlotCourseToSprite(nSprite, nTarget);
                        pSprite.setCstat(pSprite.getCstat() | 0x101);
                        break;
                    }
                    case 3: {
                        if ((nFlags & 0x80) != 0 && pTarget != null) {
                            Bullet.BuildBullet(nSprite, 10, -1, pSprite.getAng(), nTarget + 10000, 1);
                            break;
                        }
                        if (!v57) break;
                        Enemy.PlotCourseToSprite(nSprite, nTarget);
                        pLava.nState = 7;
                        pLava.nSeq = 0;
                        break;
                    }
                    case 5: {
                        if ((nFlags & 0x40) != 0) {
                            Sound.D3PlayFX(Sound.StaticSound[26], LavaDude.BuildLavaLimb(nSprite, pLava.nSeq, 64000));
                        }
                        if (pLava.nSeq != 0) {
                            if ((nFlags & 0x80) == 0) break;
                            for (int i = 0; i < 20; ++i) {
                                LavaDude.BuildLavaLimb(nSprite, i, 64000);
                            }
                            RunList.ChangeChannel(pLava.field_C, 1);
                            break;
                        }
                        for (int i = 0; i < 20; ++i) {
                            LavaDude.BuildLavaLimb(nSprite, i, 256);
                        }
                        RunList.DoSubRunRec(pSprite.getOwner());
                        RunList.FreeRun(pSprite.getLotag() - 1);
                        RunList.SubRunRec(pLava.nFunc);
                        Main.engine.mydeletesprite(nSprite);
                        break;
                    }
                    case 4: {
                        if (!v57) break;
                        pLava.nState = 7;
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                        break;
                    }
                    case 7: {
                        if (!v57) break;
                        pLava.nState = 8;
                        break;
                    }
                    case 8: {
                        if (!v57) break;
                        pLava.nState = 0;
                        pSprite.setCstat(32768);
                    }
                }
                pSprite.setPal(1);
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(nObject);
                Seq.PlotSequence(tsp, ActionSeq_X_6[nState][0] + Seq.SeqOffsets[42], pLava.nSeq, ActionSeq_X_6[nState][1]);
                tsp.setOwner(-1);
                return;
            }
            case 524288: {
                if (nDamage == 0 || pLava.nHealth <= 0) break;
                pLava.nHealth -= nDamage;
                if (pLava.nHealth <= 0) {
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                    pLava.nHealth = 0;
                    pLava.nState = 5;
                    pLava.nSeq = 0;
                    --Globals.nCreaturesLeft;
                    break;
                }
                if (pTarget != null && pTarget.getStatnum() < 199) {
                    pLava.nTarget = nTarget;
                }
                if (nState == 3 && Random.RandomSize(2) == 0) {
                    pLava.nState = 4;
                    pLava.nSeq = 0;
                    pSprite.setCstat(0);
                }
                LavaDude.BuildLavaLimb(nSprite, Globals.totalmoves, 64000);
            }
        }
    }

    public static int BuildLavaLimb(int nSprite, int a2, int a3) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return -1;
        }
        int spr = Main.engine.insertsprite(pSprite.getSectnum(), 118);
        Sprite lavaSprite = Main.boardService.getSprite(spr);
        if (lavaSprite == null) {
            throw new AssertException("spr>=0 && spr<MAXSPRITES");
        }
        lavaSprite.setX(pSprite.getX());
        lavaSprite.setY(pSprite.getY());
        lavaSprite.setZ(pSprite.getZ() - Random.RandomLong() % a3);
        lavaSprite.setCstat(0);
        lavaSprite.setShade(-127);
        lavaSprite.setPal(1);
        lavaSprite.setXvel(Random.RandomSize(5) - 16 << 8);
        lavaSprite.setYvel(Random.RandomSize(5) - 16 << 8);
        lavaSprite.setZvel(2560 - (Random.RandomSize(5) << 8));
        lavaSprite.setYoffset(0);
        lavaSprite.setXoffset(0);
        lavaSprite.setXrepeat(90);
        lavaSprite.setYrepeat(90);
        lavaSprite.setPicnum((a2 & 3) % 3);
        lavaSprite.setClipdist(0);
        lavaSprite.setExtra(-1);
        lavaSprite.setLotag(RunList.HeadRun() + 1);
        lavaSprite.setOwner(RunList.AddRunRec(lavaSprite.getLotag() - 1, 0x160000 | spr));
        lavaSprite.setHitag(RunList.AddRunRec(RunList.NewRun, 0x160000 | spr));
        return spr;
    }

    public static void FuncLavaLimb(int nStack, int ignored, int RunPtr) {
        int spr = RunList.RunData[RunPtr].getObject();
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            throw new AssertException("spr>=0 && spr<MAXSPRITES");
        }
        switch (nStack & 0x7F0000) {
            case 131072: {
                pSprite.setShade(pSprite.getShade() + 3);
                if (Main.engine.movesprite(spr, pSprite.getXvel() << 12, pSprite.getYvel() << 12, pSprite.getZvel(), 2560, -2560, 1) != 0 || pSprite.getShade() > 100) {
                    pSprite.setXvel(0);
                    pSprite.setYvel(0);
                    pSprite.setZvel(0);
                    if (pSprite.getOwner() != -1) {
                        System.out.println("Bad sprite " + pSprite);
                        RunList.DoSubRunRec(pSprite.getOwner());
                    }
                    RunList.FreeRun(pSprite.getLotag() - 1);
                    RunList.SubRunRec(pSprite.getHitag());
                    Main.engine.mydeletesprite(spr);
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, pSprite.getPicnum() + Seq.SeqOffsets[42] + 30, 0, 1);
            }
        }
    }
}

