/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Lion {
    public static final int MAXLION = 40;
    private static final short[][] ActionSeq_X_13 = new short[][]{{54, 1}, {18, 0}, {0, 0}, {10, 0}, {44, 0}, {18, 0}, {26, 0}, {34, 0}, {8, 1}, {9, 1}, {52, 1}, {53, 1}};
    private static int LionCount;
    private static final LionStruct[] LionList;

    public static void InitLion() {
        LionCount = 40;
    }

    public static void saveLion(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, LionCount);
        for (int i = LionCount; i < 40; ++i) {
            LionList[i].save(os);
        }
    }

    public static void loadLion(SafeLoader loader, InputStream is) throws IOException {
        for (int i = loader.LionCount = (int)StreamUtils.readShort(is); i < 40; ++i) {
            if (loader.LionList[i] == null) {
                loader.LionList[i] = new LionStruct();
            }
            loader.LionList[i].load(is);
        }
    }

    public static void loadLion(SafeLoader loader) {
        LionCount = loader.LionCount;
        for (int i = loader.LionCount; i < 40; ++i) {
            if (LionList[i] == null) {
                Lion.LionList[i] = new LionStruct();
            }
            LionList[i].copy(loader.LionList[i]);
        }
    }

    public static void BuildLion(int spr, int x, int y, int z, int sectnum, int ang) {
        Sector sec;
        int count;
        if ((count = --LionCount) < 0) {
            return;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 104);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = pSprite.getX();
            y = pSprite.getY();
            sectnum = pSprite.getSectnum();
            sec = Main.boardService.getSector(sectnum);
            if (sec != null) {
                z = sec.getFloorz();
            }
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 104);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setShade(-12);
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setAng(ang);
        pSprite.setXrepeat(40);
        pSprite.setYrepeat(40);
        pSprite.setPicnum(1);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setClipdist(60);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (LionList[count] == null) {
            Lion.LionList[count] = new LionStruct();
        }
        Lion.LionList[count].nState = 0;
        Lion.LionList[count].nHealth = 500;
        Lion.LionList[count].nSeq = 0;
        Lion.LionList[count].nSprite = spr;
        Lion.LionList[count].nTarget = -1;
        Lion.LionList[count].field_C = 0;
        Lion.LionList[count].field_A = count;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x130000 | count));
        Lion.LionList[count].MoveHook = RunList.AddRunRec(RunList.NewRun, 0x130000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncLion(int nStack, int nDamage, int RunPtr) {
        int nLion = RunList.RunData[RunPtr].getObject();
        if (nLion < 0 || nLion >= 40) {
            throw new AssertException("lion>=0 && lion<MAXLION");
        }
        LionStruct pLion = LionList[nLion];
        int nSprite = pLion.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        boolean v114 = false;
        int nState = pLion.nState;
        int nTarget = pLion.nTarget;
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        short nObject = (short)(nStack & 0xFFFF);
        switch (nStack & 0x7F0000) {
            case 131072: {
                if (nState != 7) {
                    Sprites.Gravity(nSprite);
                }
                int nSeq = ActionSeq_X_13[nState][0] + Seq.SeqOffsets[40];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pLion.nSeq));
                Seq.MoveSequence(nSprite, nSeq, pLion.nSeq);
                if (++pLion.nSeq >= Seq.SeqSize[nSeq]) {
                    pLion.nSeq = 0;
                    v114 = true;
                }
                int nFlags = Seq.FrameFlag[pLion.nSeq + Seq.SeqBase[nSeq]];
                int moveHit = Enemy.MoveCreatureWithCaution(nSprite);
                switch (nState) {
                    case 0: 
                    case 1: {
                        int nTarg;
                        if ((pLion.field_A & 0x1F) != (Globals.totalmoves & 0x1F) || nTarget >= 0 || (nTarg = Enemy.FindPlayer(nSprite, 40)) < 0) {
                            if (nState != 0 && --pLion.field_C <= 0) {
                                if (Random.RandomBit() != 0) {
                                    pSprite.setAng(Random.RandomWord() & 0x7FF);
                                    pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                                    pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 1);
                                } else {
                                    pSprite.setXvel(0);
                                    pSprite.setYvel(0);
                                }
                                pLion.field_C = 100;
                            }
                        } else {
                            Sound.D3PlayFX(Sound.StaticSound[24], nSprite);
                            pLion.nState = 2;
                            pLion.nSeq = 0;
                            pLion.nTarget = nTarg;
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 1);
                        }
                        return;
                    }
                    case 2: {
                        if ((Globals.totalmoves & 0x1F) == (pLion.field_A & 0x1F)) {
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            int ang = pSprite.getAng() & 0xFFF8;
                            if ((pSprite.getCstat() & 0x8000) != 0) {
                                pSprite.setXvel(2 * EngineUtils.sin(ang + 512 & 0x7FF));
                                pSprite.setYvel(2 * EngineUtils.sin(ang & 0x7FF));
                            } else {
                                pSprite.setXvel(EngineUtils.sin(ang + 512 & 0x7FF) >> 1);
                                pSprite.setYvel(EngineUtils.sin(ang & 0x7FF) >> 1);
                            }
                        }
                        switch (moveHit & 0xE000) {
                            case 49152: {
                                if ((moveHit & 0x1FFF) == nTarget) {
                                    if ((pSprite.getCstat() & 0x8000) != 0) {
                                        pLion.nState = 9;
                                        pSprite.setCstat(pSprite.getCstat() & 0xFFFF7FFF);
                                        pSprite.setXvel(0);
                                        pSprite.setYvel(0);
                                    } else if (pTarget != null && Sprites.AngleDiff(pSprite.getAng(), EngineUtils.getAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY())) < 64) {
                                        pLion.nState = 3;
                                    }
                                    pLion.nSeq = 0;
                                }
                            }
                            case 32768: {
                                pSprite.setAng(pSprite.getAng() + 256 & 0x7FF);
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 1);
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (nTarget == -1) {
                            pLion.nState = 1;
                            pLion.field_C = 50;
                            break;
                        }
                        if (Enemy.PlotCourseToSprite(nSprite, nTarget) >= 768) {
                            pLion.nState = 2;
                            break;
                        }
                        if ((nFlags & 0x80) == 0) break;
                        Sprites.DamageEnemy(nTarget, nSprite, 10);
                        break;
                    }
                    case 10: 
                    case 11: {
                        if (v114) {
                            RunList.SubRunRec(pSprite.getOwner());
                            RunList.SubRunRec(pLion.MoveHook);
                            pSprite.setCstat(32768);
                        }
                        return;
                    }
                    case 4: {
                        if (v114) {
                            pLion.nState = 2;
                            pLion.nSeq = 0;
                        }
                        if ((moveHit & 0x200) != 0) {
                            pSprite.setXvel(pSprite.getXvel() >> 1);
                            pSprite.setYvel(pSprite.getYvel() >> 1);
                        }
                        return;
                    }
                    case 8: {
                        if (v114) {
                            pLion.nSeq = 0;
                            pLion.nState = 2;
                            pSprite.setCstat(pSprite.getCstat() | 0x8000);
                        }
                        return;
                    }
                    case 9: {
                        if (v114) {
                            pLion.nSeq = 0;
                            pLion.nState = 2;
                            pSprite.setCstat(pSprite.getCstat() | 0x101);
                        }
                        return;
                    }
                    case 6: {
                        if ((moveHit & 0x30000) != 0) {
                            pLion.nState = 2;
                            pLion.nSeq = 0;
                        } else if ((moveHit & 0xE000) == 32768) {
                            pLion.nState = 7;
                            pSprite.setAng(Main.engine.GetWallNormal(moveHit & 0x1FFF) + 1024 & 0x7FF);
                            pLion.field_C = Random.RandomSize(4);
                        } else if ((moveHit & 0xE000) == 49152) {
                            if ((moveHit & 0x1FFF) == nTarget) {
                                if (pTarget != null && Sprites.AngleDiff(pSprite.getAng(), EngineUtils.getAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY())) < 64) {
                                    pLion.nState = 3;
                                    pLion.nSeq = 0;
                                }
                            } else {
                                pSprite.setAng(pSprite.getAng() + 256 & 0x7FF);
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 1);
                                break;
                            }
                        }
                        return;
                    }
                    case 5: 
                    case 7: {
                        if (--pLion.field_C <= 0) {
                            pLion.field_C = 0;
                            if (nState == 7) {
                                if (nTarget <= -1) {
                                    pSprite.setAng(pSprite.getAng() + Random.RandomSize(9) & 0x7FF);
                                } else {
                                    Enemy.PlotCourseToSprite(nSprite, nTarget);
                                }
                                pSprite.setZvel(-1000);
                            } else {
                                pSprite.setZvel(-4000);
                                int ang = pSprite.getAng();
                                int hita = ang - 512 & 0x7FF;
                                int xs = pSprite.getX();
                                int ys = pSprite.getY();
                                int zs = pSprite.getZ() - Sprites.GetSpriteHeight(nSprite) >> 1;
                                short sectnum = pSprite.getSectnum();
                                int v104 = Integer.MAX_VALUE;
                                for (int i = 0; i < 5; ++i) {
                                    int v70;
                                    Main.engine.hitscan(xs, ys, zs, sectnum, EngineUtils.sin(hita + 512 & 0x7FF), EngineUtils.sin(hita & 0x7FF), 0, Engine.pHitInfo, 0x1000040);
                                    if (Engine.pHitInfo.hitwall != -1 && (v70 = Pragmas.klabs(Engine.pHitInfo.hitx - xs) + Pragmas.klabs(Engine.pHitInfo.hity - ys)) < v104) {
                                        v104 = v70;
                                        ang = hita;
                                    }
                                    hita = hita + 256 & 0x7FF;
                                }
                                pSprite.setAng(ang);
                            }
                            pLion.nState = 6;
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) - (EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 3));
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) - (EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 3));
                            Sound.D3PlayFX(Sound.StaticSound[24], nSprite);
                        }
                        return;
                    }
                }
                if (pTarget != null && (pTarget.getCstat() & 0x101) == 0) {
                    pLion.nState = 1;
                    pLion.nSeq = 0;
                    pLion.field_C = 100;
                    pLion.nTarget = -1;
                    pSprite.setXvel(0);
                    pSprite.setYvel(0);
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(nObject);
                Seq.PlotSequence(tsp, ActionSeq_X_13[nState][0] + Seq.SeqOffsets[40], pLion.nSeq, ActionSeq_X_13[nState][1]);
                return;
            }
            case 655360: {
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage == 0 || pLion.nHealth <= 0) break;
                pLion.nHealth -= nDamage;
                if (pLion.nHealth > 0) {
                    Sprite pObject = Main.boardService.getSprite(nObject);
                    if (pObject == null) break;
                    if (pObject.getStatnum() < 199) {
                        pLion.nTarget = nObject;
                    }
                    if (nState == 6) break;
                    if (Random.RandomSize(8) <= pLion.nHealth) {
                        pLion.nState = 4;
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                    } else if (Random.RandomSize(1) != 0) {
                        Enemy.PlotCourseToSprite(nSprite, nObject);
                        pSprite.setAng(pSprite.getAng() - (Random.RandomSize(1) << 8));
                        pSprite.setAng(pSprite.getAng() + (Random.RandomSize(1) << 8));
                        pSprite.setAng(pSprite.getAng() & 0x7FF);
                        pLion.nState = 5;
                        pLion.field_C = Random.RandomSize(3);
                    } else {
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                        pLion.nState = 8;
                    }
                    pLion.nSeq = 0;
                    break;
                }
                pSprite.setXvel(0);
                pSprite.setYvel(0);
                pSprite.setZvel(0);
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                pLion.nHealth = 0;
                if (pLion.nState < 10) {
                    Enemy.DropMagic(nSprite);
                    pLion.nState = ((nStack & 0x7F0000) == 655360 ? 1 : 0) + 10;
                    pLion.nSeq = 0;
                }
                --Globals.nCreaturesLeft;
            }
        }
    }

    static {
        LionList = new LionStruct[40];
    }

    public static class LionStruct
    extends Enemy.EnemyStruct {
        public int MoveHook;

        @Override
        public void save(OutputStream os) throws IOException {
            super.save(os);
            StreamUtils.writeShort(os, this.MoveHook);
        }

        @Override
        public void load(InputStream is) throws IOException {
            super.load(is);
            this.MoveHook = StreamUtils.readShort(is);
        }

        public LionStruct copy(LionStruct src) {
            super.copy(src);
            this.MoveHook = src.MoveHook;
            return this;
        }
    }
}

