/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.BulletStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Mummy {
    public static final int MAX_MUMMIES = 150;
    private static final short[][] ActionSeq_X_4 = new short[][]{{8, 0}, {0, 0}, {16, 0}, {24, 0}, {32, 1}, {40, 1}, {48, 1}, {50, 0}};
    private static int MummyCount;
    private static final Enemy.EnemyStruct[] MummyList;

    public static void InitMummy() {
        MummyCount = 0;
    }

    public static void saveMummy(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, MummyCount);
        for (int i = 0; i < MummyCount; ++i) {
            MummyList[i].save(os);
        }
    }

    public static void loadMummy(SafeLoader loader, InputStream is) throws IOException {
        loader.MummyCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.MummyCount; ++i) {
            if (loader.MummyList[i] == null) {
                loader.MummyList[i] = new Enemy.EnemyStruct();
            }
            loader.MummyList[i].load(is);
        }
    }

    public static void loadMummy(SafeLoader loader) {
        MummyCount = loader.MummyCount;
        for (int i = 0; i < loader.MummyCount; ++i) {
            if (MummyList[i] == null) {
                Mummy.MummyList[i] = new Enemy.EnemyStruct();
            }
            MummyList[i].copy(loader.MummyList[i]);
        }
    }

    public static void BuildMummy(int spr, int x, int y, int z, int sectnum, int ang) {
        Sector sec;
        int count;
        if ((count = MummyCount++) >= 150) {
            return;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 102);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            y = pSprite.getY();
            x = pSprite.getX();
            z = pSprite.getZ();
            Main.engine.changespritestat(spr, 102);
            ang = pSprite.getAng();
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setShade(-12);
        pSprite.setClipdist(32);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setXrepeat(42);
        pSprite.setYrepeat(42);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setAng(ang);
        pSprite.setPicnum(1);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0xE0000 | count));
        if (MummyList[count] == null) {
            Mummy.MummyList[count] = new Enemy.EnemyStruct();
        }
        Mummy.MummyList[count].nHealth = 640;
        Mummy.MummyList[count].nSeq = 0;
        Mummy.MummyList[count].nState = 0;
        Mummy.MummyList[count].nSprite = spr;
        Mummy.MummyList[count].nTarget = -1;
        Mummy.MummyList[count].field_A = count;
        Mummy.MummyList[count].field_C = 0;
        Mummy.MummyList[count].nFunc = RunList.AddRunRec(RunList.NewRun, 0xE0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncMummy(int nStack, int a2, int RunPtr) {
        int nMummy = RunList.RunData[RunPtr].getObject();
        if (nMummy < 0 || nMummy >= 150) {
            throw new AssertException("Mummy>=0 && Mummy<MAX_MUMMIES");
        }
        int nSprite = Mummy.MummyList[nMummy].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int damage = a2;
        short plr = (short)(nStack & 0xFFFF);
        int nTarget = Enemy.UpdateEnemy(Mummy.MummyList[nMummy].nTarget);
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        int nState = Mummy.MummyList[nMummy].nState;
        switch (nStack & 0x7F0000) {
            case 131072: {
                Sprites.Gravity(nSprite);
                int v10 = ActionSeq_X_4[nState][0] + Seq.SeqOffsets[10];
                int v13 = Mummy.MummyList[nMummy].nSeq++;
                pSprite.setPicnum(Seq.GetSeqPicnum2(v10, v13));
                int flags = Seq.FrameFlag[v13 + Seq.SeqBase[v10]];
                Seq.MoveSequence(nSprite, v10, v13);
                boolean v18 = false;
                if (Mummy.MummyList[nMummy].nSeq >= Seq.SeqSize[v10]) {
                    Mummy.MummyList[nMummy].nSeq = 0;
                    v18 = true;
                }
                if (pTarget != null && nState < 4 && pTarget.getCstat() == 0 && nState != 0) {
                    Mummy.MummyList[nMummy].nState = 0;
                    Mummy.MummyList[nMummy].nSeq = 0;
                    pSprite.setYvel(0);
                    pSprite.setXvel(0);
                }
                int v17 = Enemy.MoveCreatureWithCaution(nSprite);
                switch (Mummy.MummyList[nMummy].nState) {
                    case 0: {
                        if ((Mummy.MummyList[nMummy].field_A & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            pSprite.setCstat(257);
                            if (pTarget == null) {
                                nTarget = Enemy.FindPlayer(nSprite, 100);
                                pTarget = Main.boardService.getSprite(nTarget);
                            }
                            if (pTarget != null) {
                                Sound.D3PlayFX(Sound.StaticSound[7], nSprite);
                                Mummy.MummyList[nMummy].nSeq = 0;
                                Mummy.MummyList[nMummy].nTarget = nTarget;
                                Mummy.MummyList[nMummy].nState = 1;
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 2);
                                Mummy.MummyList[nMummy].field_C = 90;
                            }
                        }
                        return;
                    }
                    case 1: {
                        int v20 = Mummy.MummyList[nMummy].field_C--;
                        if (v20 > 0) {
                            // empty if block
                        }
                        if ((Globals.totalmoves & 0x1F) == (Mummy.MummyList[nMummy].field_A & 0x1F)) {
                            pSprite.setCstat(257);
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            if (Mummy.MummyList[nMummy].nState == 1 && Random.RandomBit() != 0 && pTarget != null && Main.engine.cansee(pSprite.getX(), pSprite.getY(), pSprite.getZ() - Sprites.GetSpriteHeight(nSprite), pSprite.getSectnum(), pTarget.getX(), pTarget.getY(), pTarget.getZ() - Sprites.GetSpriteHeight(nTarget), pTarget.getSectnum())) {
                                Mummy.MummyList[nMummy].nState = 3;
                                Mummy.MummyList[nMummy].nSeq = 0;
                                pSprite.setYvel(0);
                                pSprite.setXvel(0);
                                return;
                            }
                        }
                        if (Mummy.MummyList[nMummy].nSeq == 0) {
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 1);
                        }
                        if (pSprite.getXvel() != 0 && pSprite.getYvel() != 0) {
                            if (pSprite.getXvel() > 0) {
                                pSprite.setXvel(Gameutils.BClipLow(pSprite.getXvel() - 1024, 0));
                            } else {
                                pSprite.setXvel(Gameutils.BClipHigh(pSprite.getXvel() + 1024, 0));
                            }
                            if (pSprite.getYvel() > 0) {
                                pSprite.setYvel(Gameutils.BClipLow(pSprite.getYvel() - 1024, 0));
                            } else {
                                pSprite.setYvel(Gameutils.BClipHigh(pSprite.getYvel() + 1024, 0));
                            }
                        }
                        if (v17 != 0) {
                            switch (v17 & 0xE000) {
                                case 32768: {
                                    pSprite.setAng(pSprite.getAng() + (Random.RandomWord() & 0x300) + 1024 & 0x7FF);
                                    pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                                    pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 2);
                                    break;
                                }
                                case 49152: {
                                    if ((v17 & 0x1FFF) != nTarget || pTarget == null || Sprites.AngleDiff(pSprite.getAng(), EngineUtils.getAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY())) >= 64) break;
                                    Mummy.MummyList[nMummy].nState = 2;
                                    Mummy.MummyList[nMummy].nSeq = 0;
                                    pSprite.setYvel(0);
                                    pSprite.setXvel(0);
                                }
                            }
                        }
                        return;
                    }
                    case 2: {
                        if (nTarget == -1) {
                            Mummy.MummyList[nMummy].nState = 0;
                        } else {
                            if (Enemy.PlotCourseToSprite(nSprite, nTarget) < 1024) {
                                if ((flags & 0x80) != 0) {
                                    Sprites.DamageEnemy(nTarget, nSprite, 5);
                                }
                                return;
                            }
                            Mummy.MummyList[nMummy].nState = 1;
                        }
                        Mummy.MummyList[nMummy].nSeq = 0;
                        return;
                    }
                    case 3: {
                        if (v18) {
                            Mummy.MummyList[nMummy].nSeq = 0;
                            Mummy.MummyList[nMummy].nState = 0;
                            Mummy.MummyList[nMummy].field_C = 100;
                            Mummy.MummyList[nMummy].nTarget = -1;
                        } else if ((flags & 0x80) != 0) {
                            Object.SetQuake(nSprite, 100);
                            BulletStruct.BulletResult nBullet = Bullet.BuildBullet(nSprite, 9, -15360, pSprite.getAng(), nTarget + 10000, 1);
                            Mummy.CheckMummyRevive(nMummy);
                            if (nBullet.hasResult() && Random.RandomSize(3) == 0) {
                                Bullet.SetBulletEnemy(nBullet.getBullet(), nTarget);
                                Sprite spr = Main.boardService.getSprite(nBullet.getSpriteIndex());
                                if (spr != null) {
                                    spr.setPal(5);
                                }
                            }
                        }
                        return;
                    }
                    case 4: {
                        if (v18) {
                            Mummy.MummyList[nMummy].nSeq = 0;
                            Mummy.MummyList[nMummy].nState = 5;
                        }
                        return;
                    }
                    case 5: {
                        Mummy.MummyList[nMummy].nSeq = 0;
                        return;
                    }
                    case 6: {
                        if (v18) {
                            Mummy.MummyList[nMummy].nState = 0;
                            pSprite.setCstat(257);
                            Mummy.MummyList[nMummy].nHealth = 300;
                            Mummy.MummyList[nMummy].nTarget = -1;
                            ++Globals.nCreaturesLeft;
                        }
                        return;
                    }
                    case 7: {
                        if ((v17 & 0x20000) != 0) {
                            pSprite.setXvel(pSprite.getXvel() >> 1);
                            pSprite.setYvel(pSprite.getYvel() >> 1);
                        }
                        if (v18) {
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                            Mummy.MummyList[nMummy].nState = 0;
                            Mummy.MummyList[nMummy].nSeq = 0;
                            pSprite.setCstat(257);
                            Mummy.MummyList[nMummy].nTarget = -1;
                        }
                        return;
                    }
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(plr);
                Seq.PlotSequence(tsp, ActionSeq_X_4[nState][0] + Seq.SeqOffsets[10], Mummy.MummyList[nMummy].nSeq, ActionSeq_X_4[nState][1]);
                return;
            }
            case 655360: {
                if (Mummy.MummyList[nMummy].nHealth <= 0) {
                    return;
                }
                damage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (damage == 0 || Mummy.MummyList[nMummy].nHealth <= 0) break;
                Mummy.MummyList[nMummy].nHealth -= damage;
                if (Mummy.MummyList[nMummy].nHealth > 0) {
                    if (Random.RandomSize(2) != 0) break;
                    Mummy.MummyList[nMummy].nState = 7;
                    Mummy.MummyList[nMummy].nSeq = 0;
                    pSprite.setXvel(0);
                    pSprite.setYvel(0);
                    break;
                }
                Mummy.MummyList[nMummy].nHealth = 0;
                pSprite.setCstat(pSprite.getCstat() & 0xFEFE);
                Enemy.DropMagic(nSprite);
                Mummy.MummyList[nMummy].nSeq = 0;
                Mummy.MummyList[nMummy].nState = 4;
                pSprite.setZvel(0);
                pSprite.setYvel(0);
                pSprite.setXvel(0);
                Sector sec = Main.boardService.getSector(pSprite.getSectnum());
                if (sec != null) {
                    pSprite.setZ(sec.getFloorz());
                }
                --Globals.nCreaturesLeft;
            }
        }
    }

    private static void CheckMummyRevive(int nMummy) {
        Sprite pSprite = Main.boardService.getSprite(Mummy.MummyList[nMummy].nSprite);
        if (pSprite == null) {
            return;
        }
        for (int i = 0; i < MummyCount; ++i) {
            Sprite v3;
            Enemy.EnemyStruct pOther = MummyList[i];
            if (i == nMummy || (v3 = Main.boardService.getSprite(pOther.nSprite)) == null || v3.getStatnum() != 102 || pOther.nState != 5 || Pragmas.klabs(v3.getX() - pSprite.getX()) >> 8 > 20 || Pragmas.klabs(v3.getY() - pSprite.getY()) >> 8 > 20 || !Main.engine.cansee(pSprite.getX(), pSprite.getY(), pSprite.getZ() - 8192, pSprite.getSectnum(), v3.getX(), v3.getY(), v3.getZ() - 8192, v3.getSectnum())) continue;
            v3.setCstat(0);
            Mummy.MummyList[i].nState = 6;
            Mummy.MummyList[i].nSeq = 0;
        }
    }

    static {
        MummyList = new Enemy.EnemyStruct[150];
    }
}

