/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Enemies.LavaDude;
import ru.m210projects.Powerslave.Enemies.Wasp;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Weapons;

public class Queen {
    public static final int MAX_QUEEN = 1;
    public static final int MAX_EGGS = 10;
    private static final int[][] HeadSeq = new int[][]{{56, 1}, {65, 0}, {65, 0}, {65, 0}, {65, 0}, {65, 0}, {74, 0}, {82, 0}, {90, 0}};
    private static final int[][] EggSeq = new int[][]{{19, 1}, {18, 1}, {0, 0}, {9, 0}, {23, 1}};
    private static final int[][] ActionSeq_X_10 = new int[][]{{0, 0}, {0, 0}, {9, 0}, {36, 0}, {18, 0}, {27, 0}, {45, 0}, {45, 0}, {54, 1}, {53, 1}, {55, 1}};
    private static int QueenCount;
    private static final int[] nEggFree;
    private static int nEggsFree;
    private static final Enemy.EnemyStruct[] QueenEgg;
    private static int nVelShift;
    private static final Enemy.EnemyStruct QueenHead;
    private static int nHeadVel;
    private static final QueenStruct QueenList;
    private static int QueenChan;
    private static final int[] tailspr;
    private static int nQHead;
    private static final int[] MoveQX;
    private static final int[] MoveQY;
    private static final int[] MoveQZ;
    private static final int[] MoveQA;
    private static final int[] MoveQS;

    public static void InitQueens() {
        QueenCount = 1;
        for (int i = 0; i < 10; ++i) {
            if (QueenEgg[i] == null) {
                Queen.QueenEgg[i] = new Enemy.EnemyStruct();
            }
            Queen.nEggFree[i] = i;
            Queen.QueenEgg[i].nFunc = -1;
        }
        nEggsFree = 10;
    }

    public static void saveQueen(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, QueenCount);
        QueenList.save(os);
        QueenHead.save(os);
        StreamUtils.writeShort(os, nEggsFree);
        for (i = 0; i < 10; ++i) {
            StreamUtils.writeShort(os, nEggFree[i]);
            QueenEgg[i].save(os);
        }
        StreamUtils.writeInt(os, nVelShift);
        StreamUtils.writeInt(os, nHeadVel);
        StreamUtils.writeShort(os, QueenChan);
        for (i = 0; i < 7; ++i) {
            StreamUtils.writeShort(os, tailspr[i]);
        }
        StreamUtils.writeInt(os, nQHead);
        for (i = 0; i < 25; ++i) {
            StreamUtils.writeInt(os, MoveQX[i]);
            StreamUtils.writeInt(os, MoveQY[i]);
            StreamUtils.writeInt(os, MoveQZ[i]);
            StreamUtils.writeShort(os, MoveQA[i]);
            StreamUtils.writeShort(os, MoveQS[i]);
        }
    }

    public static void loadQueen(SafeLoader loader) {
        QueenCount = loader.QueenCount;
        QueenList.copy(loader.QueenList);
        QueenHead.copy(loader.QueenHead);
        nEggsFree = loader.nEggsFree;
        System.arraycopy(loader.nEggFree, 0, nEggFree, 0, 10);
        for (int i = 0; i < 10; ++i) {
            if (QueenEgg[i] == null) {
                Queen.QueenEgg[i] = new Enemy.EnemyStruct();
            }
            QueenEgg[i].copy(loader.QueenEgg[i]);
        }
        nVelShift = loader.nVelShift;
        nHeadVel = loader.nHeadVel;
        QueenChan = loader.QueenChan;
        nQHead = loader.nQHead;
        System.arraycopy(loader.tailspr, 0, tailspr, 0, 7);
        System.arraycopy(loader.MoveQX, 0, MoveQX, 0, 25);
        System.arraycopy(loader.MoveQY, 0, MoveQY, 0, 25);
        System.arraycopy(loader.MoveQZ, 0, MoveQZ, 0, 25);
        System.arraycopy(loader.MoveQA, 0, MoveQA, 0, 25);
        System.arraycopy(loader.MoveQS, 0, MoveQS, 0, 25);
    }

    public static void loadQueen(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.QueenCount = StreamUtils.readShort(is);
        loader.QueenList.load(is);
        loader.QueenHead.load(is);
        loader.nEggsFree = StreamUtils.readShort(is);
        for (i = 0; i < 10; ++i) {
            loader.nEggFree[i] = StreamUtils.readShort(is);
            if (loader.QueenEgg[i] == null) {
                loader.QueenEgg[i] = new Enemy.EnemyStruct();
            }
            loader.QueenEgg[i].load(is);
        }
        loader.nVelShift = StreamUtils.readInt(is);
        loader.nHeadVel = StreamUtils.readInt(is);
        loader.QueenChan = StreamUtils.readShort(is);
        for (i = 0; i < 7; ++i) {
            loader.tailspr[i] = StreamUtils.readShort(is);
        }
        loader.nQHead = StreamUtils.readInt(is);
        for (i = 0; i < 25; ++i) {
            loader.MoveQX[i] = StreamUtils.readInt(is);
            loader.MoveQY[i] = StreamUtils.readInt(is);
            loader.MoveQZ[i] = StreamUtils.readInt(is);
            loader.MoveQA[i] = StreamUtils.readShort(is);
            loader.MoveQS[i] = StreamUtils.readShort(is);
        }
    }

    public static int GrabEgg() {
        if (nEggsFree != 0) {
            return nEggFree[--nEggsFree];
        }
        return -1;
    }

    public static void BlowChunks(int a1) {
        int v2 = 41;
        for (int i = 0; i < 4; ++i) {
            Sprites.BuildCreatureChunk(a1, Seq.GetSeqPicnum(16, v2++, 0));
        }
    }

    public static void DestroyEgg(int nEgg) {
        int nSprite = Queen.QueenEgg[nEgg].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if (Queen.QueenEgg[nEgg].nState == 4) {
            for (int i = 0; i < 4; ++i) {
                Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(56, i % 2 + 24, 0));
            }
        } else {
            Anim.BuildAnim(-1, 34, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getXrepeat(), 4);
        }
        RunList.DoSubRunRec(pSprite.getOwner());
        RunList.DoSubRunRec(pSprite.getLotag() - 1);
        RunList.SubRunRec(Queen.QueenEgg[nEgg].nFunc);
        Queen.QueenEgg[nEgg].nFunc = -1;
        Main.engine.mydeletesprite(nSprite);
        Queen.nEggFree[Queen.nEggsFree++] = nEgg;
    }

    public static void DestroyAllEggs() {
        for (int i = 0; i < 10; ++i) {
            if (Queen.QueenEgg[i].nFunc <= -1) continue;
            Queen.DestroyEgg(i);
        }
    }

    public static void SetHeadVel(int nSprite) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if (nVelShift < 0) {
            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) << -nVelShift);
            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) << -nVelShift);
        } else {
            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> nVelShift);
            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> nVelShift);
        }
    }

    public static void BuildExplosion(int a1) {
        Sprite pSprite = Main.boardService.getSprite(a1);
        if (pSprite == null) {
            return;
        }
        short nSector = pSprite.getSectnum();
        Sector sec = Main.boardService.getSector(nSector);
        if ((Globals.SectFlag[nSector] & 0x2000) != 0) {
            Anim.BuildAnim(-1, 75, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getXrepeat(), 4);
        } else if (sec != null && pSprite.getZ() == sec.getFloorz()) {
            Anim.BuildAnim(-1, 34, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getXrepeat(), 4);
        } else {
            Anim.BuildAnim(-1, 36, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getXrepeat(), 4);
        }
    }

    public static boolean DestroyTailPart() {
        if (Queen.QueenHead.field_C == 0) {
            return false;
        }
        int nPart = --Queen.QueenHead.field_C;
        int spr = tailspr[nPart];
        Queen.BlowChunks(spr);
        Queen.BuildExplosion(spr);
        for (int i = 0; i < 5; ++i) {
            LavaDude.BuildLavaLimb(spr, i, Sprites.GetSpriteHeight(nPart));
        }
        Main.engine.mydeletesprite(spr);
        return true;
    }

    public static void SetQueenSpeed(int nSprite, int shift) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2 - shift);
        pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 2 - shift);
    }

    public static int QueenAngleChase(int nSprite, int nTarget, int nVel, int a4) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return 0;
        }
        int nNewAngle = pSprite.getAng();
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        if (pTarget != null) {
            int zTop = 2 * pTarget.getYrepeat() * Main.engine.getTile(pTarget.getPicnum()).getHeight();
            int dx = pTarget.getX() - pSprite.getX();
            int dy = pTarget.getY() - pSprite.getY();
            int dz = pTarget.getZ() - pSprite.getZ();
            int nGoalAngle = Sprites.AngleDelta(pSprite.getAng(), Main.engine.GetMyAngle(dx, dy), 1024);
            if (Pragmas.klabs(nGoalAngle) > 127 && (nVel /= Pragmas.klabs(nGoalAngle >> 7)) < 256) {
                nVel = 256;
            }
            if (Pragmas.klabs(nGoalAngle) > a4) {
                nGoalAngle = nGoalAngle >= 0 ? a4 : -a4;
            }
            nNewAngle = pSprite.getAng() + nGoalAngle & 0x7FF;
            pSprite.setZvel(pSprite.getZvel() + Sprites.AngleDelta(pSprite.getZvel(), Main.engine.GetMyAngle(EngineUtils.sqrt(dx * dx + dy * dy), dz - zTop >> 8), 24) & 0x7FF);
        } else {
            pSprite.setZvel(0);
        }
        pSprite.setAng(nNewAngle);
        int v28 = Pragmas.klabs(EngineUtils.sin(pSprite.getZvel() + 512 & 0x7FF));
        int xvel = v28 * (nVel * EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 14);
        int yvel = v28 * (nVel * EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 14);
        int v31 = EngineUtils.sqrt((xvel >> 8) * (xvel >> 8) + (yvel >> 8) * (yvel >> 8));
        return Main.engine.movesprite(nSprite, xvel >> 2, yvel >> 2, (EngineUtils.sin(Weapons.bobangle & 0x7FF) >> 5) + (v31 * EngineUtils.sin(pSprite.getZvel() & 0x7FF) >> 13), 0, 0, 1);
    }

    public static void BuildTail() {
        int i;
        int nSprite = Queen.QueenHead.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int x = pSprite.getX();
        int y = pSprite.getY();
        int z = pSprite.getZ();
        short nSector = pSprite.getSectnum();
        Sector sec = Main.boardService.getSector(nSector);
        if (sec == null) {
            return;
        }
        for (i = 0; i < 7; ++i) {
            int j = Main.engine.insertsprite(nSector, 121);
            Sprite spr = Main.boardService.getSprite(j);
            if (spr == null) {
                throw new AssertException("Can't create queen's tail!");
            }
            Queen.tailspr[i] = j;
            spr.setX(x);
            spr.setY(y);
            spr.setZ(z);
            spr.setCstat(0);
            spr.setXoffset(0);
            spr.setYoffset(0);
            spr.setShade(-12);
            spr.setPicnum(1);
            spr.setPal(sec.getCeilingpal());
            spr.setClipdist(100);
            spr.setXrepeat(80);
            spr.setYrepeat(80);
            spr.setXvel(0);
            spr.setYvel(0);
            spr.setZvel(0);
            spr.setHitag(0);
            spr.setLotag(RunList.HeadRun() + 1);
            spr.setExtra(-1);
            spr.setOwner(RunList.AddRunRec(spr.getLotag() - 1, 0x1B0000 | i));
        }
        for (i = 0; i < 25; ++i) {
            Queen.MoveQX[i] = x;
            Queen.MoveQY[i] = y;
            Queen.MoveQZ[i] = z;
            Queen.MoveQS[i] = nSector;
        }
        nQHead = 0;
        Queen.QueenHead.field_C = 7;
    }

    public static void BuildQueenEgg(int ignoredQueenIndex, int nState) {
        int nEgg = Queen.GrabEgg();
        if (nEgg >= 0) {
            Sprite pQueen = Main.boardService.getSprite(Queen.QueenList.nSprite);
            if (pQueen == null) {
                return;
            }
            Sector sec = Main.boardService.getSector(pQueen.getSectnum());
            if (sec == null) {
                return;
            }
            int x = pQueen.getX();
            int y = pQueen.getY();
            int z = sec.getFloorz();
            short ang = pQueen.getAng();
            int j = Main.engine.insertsprite(pQueen.getSectnum(), 121);
            Sprite spr2 = Main.boardService.getSprite(j);
            if (spr2 == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
            spr2.setX(x);
            spr2.setY(y);
            spr2.setPal(0);
            spr2.setZ(z);
            spr2.setClipdist(50);
            spr2.setXoffset(0);
            spr2.setYoffset(0);
            spr2.setShade(-12);
            spr2.setPicnum(1);
            spr2.setAng(ang - 256 + Random.RandomSize(9) & 0x7FF);
            if (nState != 0) {
                spr2.setYrepeat(60);
                spr2.setXrepeat(60);
                spr2.setXvel(0);
                spr2.setYvel(0);
                spr2.setZvel(-2000);
                spr2.setCstat(257);
            } else {
                spr2.setXrepeat(30);
                spr2.setYrepeat(30);
                spr2.setCstat(0);
                spr2.setXvel(EngineUtils.sin(spr2.getAng() + 512 & 0x7FF));
                spr2.setYvel(EngineUtils.sin(spr2.getAng() & 0x7FF));
                spr2.setZvel(-6000);
            }
            spr2.setLotag(RunList.HeadRun() + 1);
            spr2.setExtra(-1);
            spr2.setHitag(0);
            Queen.QueenEgg[nEgg].nHealth = 200;
            Queen.QueenEgg[nEgg].nSeq = 0;
            Queen.QueenEgg[nEgg].nSprite = j;
            Queen.QueenEgg[nEgg].field_C = nState;
            Queen.QueenEgg[nEgg].nTarget = Queen.QueenList.nTarget;
            if (nState != 0) {
                nState = 4;
                Queen.QueenEgg[nEgg].field_A = 200;
            }
            Queen.QueenEgg[nEgg].nState = nState;
            spr2.setOwner(RunList.AddRunRec(spr2.getLotag() - 1, 0x1D0000 | nEgg));
            Queen.QueenEgg[nEgg].nFunc = RunList.AddRunRec(RunList.NewRun, 0x1D0000 | nEgg);
        }
    }

    public static void BuildQueenHead(int ignoredQueenIndex) {
        Sprite pQueen = Main.boardService.getSprite(Queen.QueenList.nSprite);
        if (pQueen == null) {
            return;
        }
        Sector sec = Main.boardService.getSector(pQueen.getSectnum());
        if (sec == null) {
            return;
        }
        int x = pQueen.getX();
        int y = pQueen.getY();
        short ang = pQueen.getAng();
        int z = sec.getFloorz();
        int j = Main.engine.insertsprite(pQueen.getSectnum(), 121);
        Sprite spr2 = Main.boardService.getSprite(j);
        if (spr2 == null) {
            throw new AssertException("spr>=0 && spr<MAXSPRITES");
        }
        spr2.setX(x);
        spr2.setY(y);
        spr2.setZ(z);
        spr2.setPal(0);
        spr2.setClipdist(70);
        spr2.setYrepeat(80);
        spr2.setXrepeat(80);
        spr2.setCstat(0);
        spr2.setPicnum(1);
        spr2.setShade(-12);
        spr2.setXoffset(0);
        spr2.setYoffset(0);
        spr2.setAng(ang);
        nVelShift = 2;
        Queen.SetHeadVel(j);
        spr2.setZvel(-8192);
        spr2.setLotag(RunList.HeadRun() + 1);
        spr2.setHitag(0);
        spr2.setExtra(-1);
        Queen.QueenHead.nHealth = 800;
        Queen.QueenHead.nState = 0;
        Queen.QueenHead.nTarget = Queen.QueenList.nTarget;
        Queen.QueenHead.nSeq = 0;
        Queen.QueenHead.nSprite = j;
        Queen.QueenHead.field_A = 0;
        spr2.setOwner(RunList.AddRunRec(spr2.getLotag() - 1, 0x1B0000));
        Queen.QueenHead.nFunc = RunList.AddRunRec(RunList.NewRun, 0x1B0000);
        Queen.QueenHead.field_C = 0;
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void BuildQueen(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        Sector sec;
        int count;
        if ((count = --QueenCount) < 0) {
            return;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 121);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = pSprite.getX();
            y = pSprite.getY();
            sec = Main.boardService.getSector(pSprite.getSectnum());
            if (sec != null) {
                z = sec.getFloorz();
            }
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 121);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setPal(0);
        pSprite.setShade(-12);
        pSprite.setClipdist(100);
        pSprite.setXrepeat(80);
        pSprite.setYrepeat(80);
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setPicnum(1);
        pSprite.setAng(ang);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        pSprite.setHitag(0);
        Queen.QueenList.nState = 0;
        Queen.QueenList.nHealth = 4000;
        Queen.QueenList.nSeq = 0;
        Queen.QueenList.nSprite = spr;
        Queen.QueenList.nTarget = -1;
        Queen.QueenList.field_A = 0;
        Queen.QueenList.field_10 = (short)5;
        Queen.QueenList.field_C = 0;
        QueenChan = channel;
        nHeadVel = 800;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x1A0000 | count));
        RunList.AddRunRec(RunList.NewRun, 0x1A0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncQueen(int nStack, int nDamage, int RunPtr) {
        int nQueen = RunList.RunData[RunPtr].getObject();
        if (nQueen < 0 || nQueen >= 1) {
            throw new AssertException("queen>=0 && queen<MAX_QUEEN");
        }
        QueenStruct pQueen = QueenList;
        int nSprite = pQueen.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pQueen.nState;
        int field_A = pQueen.field_A;
        boolean v59 = false;
        switch (nStack & 0x7F0000) {
            case 131072: {
                if (field_A < 3) {
                    Sprites.Gravity(nSprite);
                }
                int nSeq = ActionSeq_X_10[nState][0] + Seq.SeqOffsets[49];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pQueen.nSeq));
                Seq.MoveSequence(nSprite, nSeq, pQueen.nSeq);
                if (++pQueen.nSeq >= Seq.SeqSize[nSeq]) {
                    pQueen.nSeq = 0;
                    v59 = true;
                }
                int nFlags = Seq.FrameFlag[pQueen.nSeq + Seq.SeqBase[nSeq]];
                int nTarget = pQueen.nTarget;
                Sprite pTarget = Main.boardService.getSprite(nTarget);
                if (pTarget != null && nState < 7 && (pTarget.getCstat() & 0x101) == 0) {
                    pQueen.nTarget = -1;
                    nTarget = -1;
                    pQueen.nState = 0;
                }
                switch (nState) {
                    case 0: {
                        if (nTarget < 0) {
                            nTarget = Enemy.FindPlayer(nSprite, 60);
                            pTarget = Main.boardService.getSprite(nTarget);
                        }
                        if (pTarget != null) {
                            pQueen.nState = pQueen.field_A + 1;
                            pQueen.nSeq = 0;
                            pQueen.nTarget = nTarget;
                            pQueen.field_C = Random.RandomSize(7);
                            Queen.SetQueenSpeed(nSprite, field_A);
                        }
                        return;
                    }
                    case 6: {
                        if (v59) {
                            Queen.BuildQueenEgg(nQueen, 1);
                            pQueen.nState = 3;
                            pQueen.field_C = Random.RandomSize(6) + 60;
                        }
                        return;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        --pQueen.field_C;
                        if ((Globals.totalmoves & 0x1F) == 0) {
                            if (field_A >= 2) {
                                if (pQueen.field_C <= 0) {
                                    if (Wasp.nWaspCount < 100) {
                                        pQueen.nState = 6;
                                        pQueen.nSeq = 0;
                                        return;
                                    }
                                    pQueen.field_C = 30000;
                                }
                            } else {
                                if (pQueen.field_C <= 0) {
                                    pQueen.nSeq = 0;
                                    pSprite.setYvel(0);
                                    pSprite.setXvel(0);
                                    pQueen.nState = field_A + 4;
                                    pQueen.field_C = Random.RandomSize(6) + 30;
                                    return;
                                }
                                if (pQueen.field_10 < 5) {
                                    pQueen.field_10 = (short)(pQueen.field_10 + 1);
                                }
                            }
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            Queen.SetQueenSpeed(nSprite, field_A);
                        }
                        int nHit = Enemy.MoveCreatureWithCaution(nSprite);
                        switch (nHit & 0xE000) {
                            case 49152: {
                                if (field_A == 2 && (nHit & 0x1FFF) == nTarget) {
                                    Sprites.DamageEnemy(nTarget, nSprite, 5);
                                    break;
                                }
                            }
                            case 32768: {
                                pSprite.setAng(pSprite.getAng() + 256 & 0x7FF);
                                Queen.SetQueenSpeed(nSprite, field_A);
                            }
                        }
                        if (pTarget != null && (pTarget.getCstat() & 0x101) == 0) {
                            pQueen.nState = 0;
                            pQueen.nSeq = 0;
                            pQueen.field_C = 100;
                            pQueen.nTarget = -1;
                            pSprite.setYvel(0);
                            pSprite.setXvel(0);
                        }
                        return;
                    }
                    case 4: 
                    case 5: {
                        if (v59 && pQueen.field_10 <= 0) {
                            pQueen.nState = 0;
                            pQueen.field_C = 15;
                        } else if ((nFlags & 0x80) != 0) {
                            pQueen.field_10 = (short)(pQueen.field_10 - 1);
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            if (field_A != 0) {
                                Queen.BuildQueenEgg(nQueen, 0);
                            } else {
                                Bullet.BuildBullet(nSprite, 12, -1, pSprite.getAng(), nTarget + 10000, 1);
                            }
                        }
                        return;
                    }
                    case 7: {
                        if (v59) {
                            pQueen.nState = 0;
                            pQueen.nSeq = 0;
                        }
                        return;
                    }
                    case 8: 
                    case 9: {
                        if (!v59) {
                            return;
                        }
                        if (nState == 9) {
                            if (--pQueen.field_C > 0) {
                                return;
                            }
                            pSprite.setCstat(0);
                            for (int i = 0; i < 20; ++i) {
                                int j = Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(49, 57, 0));
                                Sprite spr2 = Main.boardService.getSprite(j);
                                if (spr2 == null) continue;
                                spr2.setPicnum(i % 3 + 3117);
                                spr2.setYrepeat(100);
                                spr2.setXrepeat(100);
                            }
                            int j = Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(49, 57, 0));
                            Sprite spr2 = Main.boardService.getSprite(j);
                            if (spr2 != null) {
                                spr2.setPicnum(3126);
                                spr2.setYrepeat(100);
                                spr2.setXrepeat(100);
                            }
                            Sound.PlayFXAtXYZ(Sound.StaticSound[40], pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum());
                            Queen.BuildQueenHead(nQueen);
                        }
                        ++pQueen.nState;
                        return;
                    }
                    case 10: {
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                        return;
                    }
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, ActionSeq_X_10[nState][0] + Seq.SeqOffsets[49], pQueen.nSeq, ActionSeq_X_10[nState][1]);
                return;
            }
            case 655360: {
                Sprite pRadialSpr = Main.boardService.getSprite(Globals.nRadialSpr);
                if (pRadialSpr != null && pRadialSpr.getStatnum() != 121 && (pSprite.getCstat() & 0x101) != 0) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage == 0 || pQueen.nHealth <= 0) break;
                pQueen.nHealth -= nDamage;
                if (pQueen.nHealth <= 0) {
                    pSprite.setXvel(0);
                    pSprite.setYvel(0);
                    pSprite.setZvel(0);
                    switch (++pQueen.field_A) {
                        case 1: {
                            pQueen.nHealth = 4000;
                            pQueen.nState = 7;
                            Anim.BuildAnim(-1, 36, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ() - 7680, pSprite.getSectnum(), pSprite.getXrepeat(), 4);
                            break;
                        }
                        case 2: {
                            pQueen.nHealth = 4000;
                            pQueen.nState = 7;
                            Queen.DestroyAllEggs();
                            break;
                        }
                        case 3: {
                            pQueen.nHealth = 0;
                            pQueen.nState = 8;
                            pQueen.field_C = 5;
                            --Globals.nCreaturesLeft;
                        }
                    }
                    pQueen.nSeq = 0;
                    break;
                }
                if (field_A <= 0 || Random.RandomSize(4) != 0) break;
                pQueen.nState = 7;
                pQueen.nSeq = 0;
            }
        }
    }

    public static void FuncQueenHead(int nStack, int nDamage, int ignored) {
        Enemy.EnemyStruct pHead = QueenHead;
        int nSprite = pHead.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pHead.nState;
        int nTarget = pHead.nTarget;
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        boolean v73 = false;
        switch (nStack & 0x7F0000) {
            case 131072: {
                if (pHead.nState == 0) {
                    Sprites.Gravity(Queen.QueenHead.nSprite);
                }
                int nSeq = HeadSeq[nState][0] + Seq.SeqOffsets[49];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pHead.nSeq));
                Seq.MoveSequence(nSprite, nSeq, pHead.nSeq);
                if (++pHead.nSeq >= Seq.SeqSize[nSeq]) {
                    pHead.nSeq = 0;
                    v73 = true;
                }
                if (pTarget == null) {
                    nTarget = Enemy.FindPlayer(nSprite, 1000);
                    pTarget = Main.boardService.getSprite(pHead.nTarget);
                } else if ((pTarget.getCstat() & 0x101) == 0) {
                    nTarget = -1;
                    pTarget = null;
                }
                pHead.nTarget = nTarget;
                switch (nState) {
                    case 0: {
                        int v13 = pHead.field_A--;
                        if (v13 > 0) {
                            if (v13 == 1) {
                                Queen.BuildTail();
                                pHead.nState = 6;
                                nHeadVel = 800;
                                pSprite.setCstat(257);
                            } else if (v13 - 1 < 60) {
                                pSprite.setShade(pSprite.getShade() - 1);
                            }
                            return;
                        }
                        int hit = Enemy.MoveCreature(nSprite);
                        int nNewAngle = 0;
                        switch (hit & 0xFC000) {
                            case 32768: {
                                nNewAngle = Main.engine.GetWallNormal(hit & 0x1FFF);
                                break;
                            }
                            case 49152: {
                                Sprite hitSpr = Main.boardService.getSprite(hit & 0x1FFF);
                                if (hitSpr == null) break;
                                nNewAngle = hitSpr.getAng();
                                break;
                            }
                            case 131072: {
                                pSprite.setZvel(-(pSprite.getZvel() >> 1));
                                if (pSprite.getZvel() <= -256) break;
                                nVelShift = 100;
                                pSprite.setZvel(0);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        pSprite.setAng(nNewAngle);
                        if (++nVelShift >= 5) {
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                            if (pSprite.getZvel() == 0) {
                                pHead.field_A = 120;
                            }
                        } else {
                            Queen.SetHeadVel(nSprite);
                        }
                        return;
                    }
                    case 6: {
                        if (v73) {
                            pHead.nState = 1;
                            pHead.nSeq = 0;
                            return;
                        }
                    }
                    case 1: {
                        if (pTarget != null && pTarget.getZ() - 51200 <= pSprite.getZ()) {
                            pSprite.setZ(pSprite.getZ() - 2048);
                            break;
                        }
                        pHead.nState = 4;
                        pHead.nSeq = 0;
                        return;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        int hitMove;
                        if (v73) {
                            switch (Random.RandomSize(2)) {
                                case 0: {
                                    pHead.nState = 4;
                                    break;
                                }
                                case 1: {
                                    pHead.nState = 7;
                                    break;
                                }
                                default: {
                                    pHead.nState = 8;
                                }
                            }
                        }
                        if (pTarget == null || ((hitMove = Queen.QueenAngleChase(nSprite, nTarget, nHeadVel, 64)) & 0xE000) != 49152 || (hitMove & 0x1FFF) != nTarget) break;
                        Sprites.DamageEnemy(nTarget, nSprite, 10);
                        Sound.D3PlayFX(Sound.StaticSound[50] | 0x2000, nSprite);
                        pSprite.setAng(pSprite.getAng() + (Random.RandomSize(9) + 768));
                        pSprite.setAng(pSprite.getAng() & 0x7FF);
                        pSprite.setZvel(-20 - Random.RandomSize(6));
                        Queen.SetHeadVel(nSprite);
                        break;
                    }
                    case 5: {
                        if (--pHead.field_A <= 0) {
                            pHead.field_A = 3;
                            if (pHead.field_C-- != 0) {
                                if (pHead.field_C >= 15 || pHead.field_C < 10) {
                                    int ox = pSprite.getX();
                                    int oy = pSprite.getY();
                                    int oz = pSprite.getZ();
                                    short sect = pSprite.getSectnum();
                                    int nAngle = Random.RandomSize(11) & 0x7FF;
                                    int size = 127 - pHead.field_C;
                                    pSprite.setXrepeat(size);
                                    pSprite.setYrepeat(size);
                                    pSprite.setCstat(32768);
                                    int v54 = Random.RandomSize(5);
                                    int v53 = Random.RandomSize(5);
                                    Main.engine.movesprite(nSprite, EngineUtils.sin(nAngle & 0x7FF) << 10, EngineUtils.sin(nAngle + 512 & 0x7FF) << 10, v54 - v53 << 7, 0, 0, 1);
                                    Queen.BlowChunks(nSprite);
                                    Queen.BuildExplosion(nSprite);
                                    Main.engine.mychangespritesect(nSprite, sect);
                                    pSprite.setX(ox);
                                    pSprite.setY(oy);
                                    pSprite.setZ(oz);
                                    if (pHead.field_C < 10) {
                                        for (int i = 2 * (10 - pHead.field_C); i > 0; --i) {
                                            LavaDude.BuildLavaLimb(nSprite, i, Sprites.GetSpriteHeight(nSprite));
                                        }
                                    }
                                }
                            } else {
                                int i;
                                Queen.BuildExplosion(nSprite);
                                for (i = 0; i < 10; ++i) {
                                    Queen.BlowChunks(nSprite);
                                }
                                for (i = 0; i < 20; ++i) {
                                    LavaDude.BuildLavaLimb(nSprite, i, Sprites.GetSpriteHeight(nSprite));
                                }
                                RunList.SubRunRec(pSprite.getOwner());
                                RunList.SubRunRec(pHead.nFunc);
                                Main.engine.mydeletesprite(nSprite);
                                RunList.ChangeChannel(QueenChan, 1);
                            }
                        }
                        return;
                    }
                }
                Queen.MoveQX[Queen.nQHead] = pSprite.getX();
                Queen.MoveQY[Queen.nQHead] = pSprite.getY();
                Queen.MoveQZ[Queen.nQHead] = pSprite.getZ();
                Queen.MoveQS[Queen.nQHead] = pSprite.getSectnum();
                Queen.MoveQA[Queen.nQHead] = pSprite.getAng();
                int nQ = nQHead;
                for (int i = 0; i < pHead.field_C; ++i) {
                    int j;
                    Sprite spr2;
                    if ((nQ -= 3) < 0) {
                        nQ += 25;
                    }
                    if ((spr2 = Main.boardService.getSprite(j = tailspr[i])) == null) continue;
                    if (MoveQS[nQ] != spr2.getSectnum()) {
                        Main.engine.mychangespritesect(j, MoveQS[nQ]);
                    }
                    spr2.setX(MoveQX[nQ]);
                    spr2.setY(MoveQY[nQ]);
                    spr2.setZ(MoveQZ[nQ]);
                    spr2.setAng(MoveQA[nQ]);
                }
                if (++nQHead >= 25) {
                    nQHead = 0;
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, HeadSeq[nState][0] + Seq.SeqOffsets[49], pHead.nSeq, HeadSeq[nState][1]);
                return;
            }
            case 655360: {
                Sprite pRadialSpr = Main.boardService.getSprite(Globals.nRadialSpr);
                if (pRadialSpr != null && pRadialSpr.getStatnum() != 121 && (pSprite.getCstat() & 0x101) != 0) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage == 0 || pHead.nHealth <= 0) break;
                pHead.nHealth -= nDamage;
                if (Random.RandomSize(4) == 0) {
                    pHead.nTarget = (short)(nStack & 0xFFFF);
                    pHead.nState = 7;
                    pHead.nSeq = 0;
                }
                if (pHead.nHealth > 0) break;
                if (Queen.DestroyTailPart()) {
                    pHead.nHealth = 200;
                    nHeadVel += 100;
                    break;
                }
                --Globals.nCreaturesLeft;
                pHead.nState = 5;
                pHead.nSeq = 0;
                pHead.field_A = 0;
                pHead.field_C = 80;
                pSprite.setCstat(0);
            }
        }
    }

    public static void FuncQueenEgg(int nStack, int nDamage, int RunPtr) {
        int nEgg = RunList.RunData[RunPtr].getObject();
        Enemy.EnemyStruct pEgg = QueenEgg[nEgg];
        int nSprite = pEgg.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pEgg.nState;
        int nTarget = -1;
        boolean v44 = false;
        switch (nStack & 0x7F0000) {
            case 131072: {
                if (pEgg.nHealth > 0) {
                    if (nState == 0 || nState == 4) {
                        Sprites.Gravity(nSprite);
                    }
                    int nSeq = EggSeq[nState][0] + Seq.SeqOffsets[56];
                    pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pEgg.nSeq));
                    if (nState != 4) {
                        Seq.MoveSequence(nSprite, nSeq, pEgg.nSeq);
                        if (++pEgg.nSeq >= Seq.SeqSize[nSeq]) {
                            pEgg.nSeq = 0;
                            v44 = true;
                        }
                        nTarget = Enemy.UpdateEnemy(pEgg.nTarget);
                        Sprite pTarget = Main.boardService.getSprite(nTarget);
                        pEgg.nTarget = nTarget;
                        if (pTarget == null || (pTarget.getCstat() & 0x101) != 0) {
                            nTarget = pEgg.nTarget = Enemy.FindPlayer(-nSprite, 1000);
                        } else {
                            pEgg.nTarget = -1;
                            pEgg.nState = 0;
                        }
                    }
                    switch (nState) {
                        case 0: {
                            int hitMove = Enemy.MoveCreature(nSprite);
                            int nAngle = 0;
                            switch (hitMove & 0xFC000) {
                                case 131072: {
                                    if (Random.RandomSize(1) != 0) {
                                        Queen.DestroyEgg(nEgg);
                                        return;
                                    }
                                    pEgg.nState = 1;
                                    pEgg.nSeq = 0;
                                    return;
                                }
                                case 32768: {
                                    nAngle = Main.engine.GetWallNormal(hitMove & 0x1FFF);
                                    break;
                                }
                                case 49152: {
                                    Sprite hitSpr = Main.boardService.getSprite(hitMove & 0x1FFF);
                                    if (hitSpr == null) break;
                                    nAngle = hitSpr.getAng();
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            pSprite.setAng(nAngle);
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 1);
                            return;
                        }
                        case 1: {
                            if (v44) {
                                pEgg.nState = 3;
                                pSprite.setCstat(257);
                            }
                            return;
                        }
                        case 2: 
                        case 3: {
                            int nHit = Queen.QueenAngleChase(nSprite, nTarget, nHeadVel, 64);
                            switch (nHit & 0xE000) {
                                case 49152: {
                                    Sprite hitSpr = Main.boardService.getSprite(nHit & 0x1FFF);
                                    if (hitSpr != null && hitSpr.getStatnum() != 121) {
                                        Sprites.DamageEnemy(nHit & 0x1FFF, nSprite, 5);
                                    }
                                }
                                case 32768: {
                                    pSprite.setAng(pSprite.getAng() + Random.RandomSize(9) + 768);
                                    pSprite.setAng(pSprite.getAng() & 0x7FF);
                                    pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 3);
                                    pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 3);
                                    pSprite.setZvel(-Random.RandomSize(5));
                                    return;
                                }
                            }
                            return;
                        }
                        case 4: {
                            if ((Enemy.MoveCreature(nSprite) & 0x20000) != 0) {
                                pSprite.setZvel(-(pSprite.getZvel() - 256));
                                if (pSprite.getZvel() < -512) {
                                    pSprite.setZvel(0);
                                }
                            }
                            if (--pEgg.field_A > 0) break;
                            int spr = Wasp.BuildWasp(-2, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getAng());
                            Sprite s = Main.boardService.getSprite(spr);
                            if (s != null) {
                                pSprite.setZ(s.getZ());
                            }
                            Queen.DestroyEgg(nEgg);
                            return;
                        }
                    }
                    return;
                }
                Queen.DestroyEgg(nEgg);
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, EggSeq[nState][0] + Seq.SeqOffsets[56], pEgg.nSeq, EggSeq[nState][1]);
                return;
            }
            case 655360: {
                Sprite pRadialSpr = Main.boardService.getSprite(Globals.nRadialSpr);
                if (pRadialSpr != null && pRadialSpr.getStatnum() != 121 && (pSprite.getCstat() & 0x101) != 0) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage == 0 || pEgg.nHealth <= 0) break;
                pEgg.nHealth -= nDamage;
                if (pEgg.nHealth > 0) break;
                Queen.DestroyEgg(nEgg);
            }
        }
    }

    static {
        nEggFree = new int[10];
        QueenEgg = new Enemy.EnemyStruct[10];
        QueenHead = new Enemy.EnemyStruct();
        QueenList = new QueenStruct();
        tailspr = new int[7];
        MoveQX = new int[25];
        MoveQY = new int[25];
        MoveQZ = new int[25];
        MoveQA = new int[25];
        MoveQS = new int[25];
    }

    public static class QueenStruct
    extends Enemy.EnemyStruct {
        public static final int size = 18;
        public short field_10;

        @Override
        public void save(OutputStream os) throws IOException {
            super.save(os);
            StreamUtils.writeShort(os, this.field_10);
        }

        @Override
        public void load(InputStream is) throws IOException {
            super.load(is);
            this.field_10 = StreamUtils.readShort(is);
        }

        public void copy(QueenStruct src) {
            super.copy(src);
            this.field_10 = src.field_10;
        }
    }
}

