/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Roach {
    public static final int MAXROACH = 100;
    private static final short[][] ActionSeq_X_11 = new short[][]{{24, 0}, {0, 0}, {0, 0}, {16, 0}, {8, 0}, {32, 1}, {42, 1}};
    private static int RoachCount;
    private static final Enemy.EnemyStruct[] RoachList;

    public static void InitRoach() {
        RoachCount = 100;
    }

    public static void saveRoach(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, RoachCount);
        for (int i = RoachCount; i < 100; ++i) {
            RoachList[i].save(os);
        }
    }

    public static void loadRoach(SafeLoader loader) {
        RoachCount = loader.RoachCount;
        for (int i = loader.RoachCount; i < 100; ++i) {
            if (RoachList[i] == null) {
                Roach.RoachList[i] = new Enemy.EnemyStruct();
            }
            RoachList[i].copy(loader.RoachList[i]);
        }
    }

    public static void loadRoach(SafeLoader loader, InputStream is) throws IOException {
        for (int i = loader.RoachCount = (int)StreamUtils.readShort(is); i < 100; ++i) {
            if (loader.RoachList[i] == null) {
                loader.RoachList[i] = new Enemy.EnemyStruct();
            }
            loader.RoachList[i].load(is);
        }
    }

    public static void BuildRoach(int a1, int spr, int x, int y, int z, int sectnum, int ang) {
        Sector sec;
        int count;
        if ((count = --RoachCount) < 0) {
            return;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 105);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = pSprite.getX();
            y = pSprite.getY();
            sectnum = pSprite.getSectnum();
            sec = Main.boardService.getSector(sectnum);
            if (sec != null) {
                z = sec.getFloorz();
            }
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 105);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setShade(-12);
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setAng(ang);
        pSprite.setXrepeat(40);
        pSprite.setYrepeat(40);
        pSprite.setPicnum(1);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setClipdist(60);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (RoachList[count] == null) {
            Roach.RoachList[count] = new Enemy.EnemyStruct();
        }
        Roach.RoachList[count].nState = a1 != 0 ? 0 : 1;
        Roach.RoachList[count].nSeq = 0;
        Roach.RoachList[count].nHealth = 600;
        Roach.RoachList[count].nTarget = -1;
        Roach.RoachList[count].nSprite = spr;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x1C0000 | count));
        Roach.RoachList[count].field_C = 0;
        Roach.RoachList[count].field_A = RunList.AddRunRec(RunList.NewRun, 0x1C0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void GoRoach(int nSprite) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite != null) {
            pSprite.setXvel((EngineUtils.cos(pSprite.getAng() & 0x7FF) >> 1) - (EngineUtils.cos(pSprite.getAng() & 0x7FF) >> 3));
            pSprite.setYvel((EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 1) - (EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 3));
        }
    }

    public static void FuncRoach(int nStack, int nDamage, int RunPtr) {
        int nRoach = RunList.RunData[RunPtr].getObject();
        if (nRoach < 0 || nRoach >= 100) {
            throw new AssertException("roach>=0 && roach<MAXROACH");
        }
        Enemy.EnemyStruct pRoach = RoachList[nRoach];
        int nSprite = pRoach.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pRoach.nState;
        boolean v42 = false;
        short nObject = (short)(nStack & 0xFFFF);
        switch (nStack & 0x7F0000) {
            case 131072: {
                Sprites.Gravity(nSprite);
                int nSeq = ActionSeq_X_11[nState][0] + Seq.SeqOffsets[50];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pRoach.nSeq));
                Seq.MoveSequence(nSprite, nSeq, pRoach.nSeq);
                if (++pRoach.nSeq >= Seq.SeqSize[nSeq]) {
                    pRoach.nSeq = 0;
                    v42 = true;
                }
                if (nState > 5) {
                    return;
                }
                block6 : switch (nState) {
                    case 0: {
                        if (pRoach.nSeq == 1) {
                            if (--pRoach.field_C > 0) {
                                pRoach.nSeq = 0;
                            } else {
                                pRoach.field_C = Random.RandomSize(6);
                            }
                        }
                    }
                    case 1: {
                        int v18;
                        int plDist = 100;
                        if ((nRoach & 0xF) == (Globals.totalmoves & 0xF) && pRoach.nTarget < 0 && (v18 = Enemy.FindPlayer(nSprite, plDist)) >= 0) {
                            pRoach.nState = 2;
                            pRoach.nSeq = 0;
                            pRoach.nTarget = v18;
                            Roach.GoRoach(nSprite);
                        }
                        return;
                    }
                    case 2: {
                        if ((Globals.totalmoves & 0xF) == (nRoach & 0xF)) {
                            Enemy.PlotCourseToSprite(nSprite, pRoach.nTarget);
                            Roach.GoRoach(nSprite);
                        }
                        int hitMove = Enemy.MoveCreatureWithCaution(nSprite);
                        switch (hitMove & 0xE000) {
                            default: {
                                if (pRoach.field_C != 0) {
                                    --pRoach.field_C;
                                    break block6;
                                }
                            }
                            case 49152: {
                                if (((hitMove & 0xE000) != 49152 || (hitMove & 0x1FFF) != pRoach.nTarget) && (hitMove & 0xE000) >= 32768) break;
                                pRoach.nFunc = Random.RandomSize(2) + 1;
                                pRoach.nState = 3;
                                pSprite.setXvel(0);
                                pSprite.setYvel(0);
                                Sprite pTarget = Main.boardService.getSprite(pRoach.nTarget);
                                if (pTarget != null) {
                                    pSprite.setAng(Main.engine.GetMyAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY()));
                                }
                                pRoach.nSeq = 0;
                                break block6;
                            }
                            case 32768: 
                        }
                        pSprite.setAng(pSprite.getAng() + 256 & 0x7FF);
                        Roach.GoRoach(nSprite);
                        break;
                    }
                    case 3: {
                        if (v42) {
                            if (pRoach.nFunc-- <= 0) {
                                pRoach.nState = 2;
                                Roach.GoRoach(nSprite);
                                pRoach.nSeq = 0;
                                pRoach.field_C = Random.RandomSize(7);
                            }
                        } else if ((Seq.FrameFlag[pRoach.nSeq + Seq.SeqBase[nSeq]] & 0x80) != 0) {
                            Bullet.BuildBullet(nSprite, 13, -1, pSprite.getAng(), pRoach.nTarget + 10000, 1);
                        }
                        return;
                    }
                    case 4: {
                        if (!v42) {
                            return;
                        }
                        pRoach.nState = 2;
                        return;
                    }
                    case 5: {
                        if (v42) {
                            pSprite.setCstat(0);
                            pRoach.nState = 6;
                            pRoach.nSeq = 0;
                        }
                        return;
                    }
                }
                Sprite pTarget = Main.boardService.getSprite(pRoach.nTarget);
                if (pTarget != null && (pTarget.getCstat() & 0x101) == 0) {
                    pRoach.nState = 1;
                    pRoach.nSeq = 0;
                    pRoach.field_C = 100;
                    pRoach.nTarget = -1;
                    pSprite.setXvel(0);
                    pSprite.setYvel(0);
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(nObject);
                Seq.PlotSequence(tsp, ActionSeq_X_11[nState][0] + Seq.SeqOffsets[50], pRoach.nSeq, ActionSeq_X_11[nState][1]);
                return;
            }
            case 655360: {
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage == 0 || pRoach.nHealth <= 0) break;
                pRoach.nHealth -= nDamage;
                if (pRoach.nHealth > 0) {
                    Sprite pObject = Main.boardService.getSprite(nObject);
                    if (pObject == null) break;
                    if (pObject.getStatnum() < 199) {
                        pRoach.nTarget = nObject;
                    }
                    if (nState != 0 && nState != 1) {
                        if (Random.RandomSize(4) != 0) break;
                        pRoach.nState = 4;
                        pRoach.nSeq = 0;
                        break;
                    }
                    pRoach.nState = 2;
                    Roach.GoRoach(nRoach);
                    pRoach.nSeq = 0;
                    break;
                }
                pSprite.setXvel(0);
                pSprite.setYvel(0);
                pSprite.setZvel(0);
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                pRoach.nHealth = 0;
                if (pRoach.nState < 5) {
                    Enemy.DropMagic(nSprite);
                    pRoach.nState = 5;
                    pRoach.nSeq = 0;
                }
                --Globals.nCreaturesLeft;
            }
        }
    }

    static {
        RoachList = new Enemy.EnemyStruct[100];
    }
}

