/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Enemies.Spider;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.BulletStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Scorp {
    public static final int MAXSCORP = 5;
    private static final short[][] ActionSeq_X_7 = new short[][]{{0, 0}, {8, 0}, {29, 0}, {19, 0}, {45, 1}, {46, 1}, {47, 1}, {48, 1}, {50, 1}, {53, 1}};
    private static int ScorpCount;
    private static final ScorpStruct[] ScorpList;
    private static final int[] ScorpChan;

    public static void InitScorp() {
        ScorpCount = 5;
    }

    public static void saveScorp(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, ScorpCount);
        for (i = ScorpCount; i < 5; ++i) {
            ScorpList[i].save(os);
        }
        for (i = 0; i < 5; ++i) {
            StreamUtils.writeShort(os, ScorpChan[i]);
        }
    }

    public static void loadScorp(SafeLoader loader) {
        ScorpCount = loader.ScorpCount;
        for (int i = loader.ScorpCount; i < 5; ++i) {
            if (ScorpList[i] == null) {
                Scorp.ScorpList[i] = new ScorpStruct();
            }
            ScorpList[i].copy(loader.ScorpList[i]);
        }
        System.arraycopy(loader.ScorpChan, 0, ScorpChan, 0, 5);
    }

    public static void loadScorp(SafeLoader loader, InputStream is) throws IOException {
        int i;
        for (i = loader.ScorpCount = (int)StreamUtils.readShort(is); i < 5; ++i) {
            if (loader.ScorpList[i] == null) {
                loader.ScorpList[i] = new ScorpStruct();
            }
            loader.ScorpList[i].load(is);
        }
        for (i = 0; i < 5; ++i) {
            loader.ScorpChan[i] = StreamUtils.readShort(is);
        }
    }

    public static void BuildScorp(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        Sector sec;
        int count;
        if ((count = --ScorpCount) < 0) {
            return;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 122);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = pSprite.getX();
            y = pSprite.getY();
            sectnum = pSprite.getSectnum();
            sec = Main.boardService.getSector(sectnum);
            if (sec != null) {
                z = sec.getFloorz();
            }
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 122);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setXoffset(0);
        pSprite.setShade(-12);
        pSprite.setYoffset(0);
        pSprite.setPicnum(1);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setClipdist(70);
        pSprite.setAng(ang);
        pSprite.setXrepeat(80);
        pSprite.setYrepeat(80);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (ScorpList[count] == null) {
            Scorp.ScorpList[count] = new ScorpStruct();
        }
        Scorp.ScorpList[count].nState = 0;
        Scorp.ScorpList[count].nHealth = 20000;
        Scorp.ScorpList[count].nSeq = 0;
        Scorp.ScorpList[count].nSprite = spr;
        Scorp.ScorpList[count].nTarget = -1;
        Scorp.ScorpList[count].field_A = 1;
        Scorp.ScorpList[count].field_C = 0;
        Scorp.ScorpChan[count] = channel;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x220000 | count));
        Scorp.ScorpList[count].nFunc = RunList.AddRunRec(RunList.NewRun, 0x220000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncScorp(int nStack, int nDamage, int RunPtr) {
        int nScorp = RunList.RunData[RunPtr].getObject();
        if (nScorp < 0 || nScorp >= 5) {
            throw new AssertException("scorp>=0 && scorp<MAXSCORP");
        }
        ScorpStruct pScorp = ScorpList[nScorp];
        int nSprite = pScorp.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pScorp.nState;
        int nTarget = pScorp.nTarget;
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        short nObject = (short)(nStack & 0xFFFF);
        boolean v5 = false;
        block0 : switch (nStack & 0x7F0000) {
            case 131072: {
                if (pScorp.nHealth != 0) {
                    Sprites.Gravity(nSprite);
                }
                int nSeq = ActionSeq_X_7[nState][0] + Seq.SeqOffsets[24];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pScorp.nSeq));
                Seq.MoveSequence(nSprite, nSeq, pScorp.nSeq);
                if (++pScorp.nSeq >= Seq.SeqSize[nSeq]) {
                    pScorp.nSeq = 0;
                    v5 = true;
                }
                int nFlags = Seq.FrameFlag[pScorp.nSeq + Seq.SeqBase[nSeq]];
                switch (nState) {
                    case 0: {
                        if (pScorp.field_C <= 0) {
                            int nNewTarget;
                            if ((nScorp & 0x1F) == (Globals.totalmoves & 0x1F) && nTarget < 0 && (nNewTarget = Enemy.FindPlayer(nSprite, 500)) >= 0) {
                                Sound.D3PlayFX(Sound.StaticSound[41], nSprite);
                                pScorp.nSeq = 0;
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                                pScorp.nState = 1;
                                pScorp.nTarget = nNewTarget;
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                            }
                        } else {
                            --pScorp.field_C;
                        }
                        return;
                    }
                    case 1: {
                        if (--pScorp.field_A <= 0) {
                            pScorp.field_A = Random.RandomSize(5);
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            pSprite.setAng(pSprite.getAng() + Random.RandomSize(7) - 63);
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                            break block0;
                        }
                        int hitMove = Enemy.MoveCreatureWithCaution(nSprite);
                        switch (hitMove & 0xE000) {
                            case 32768: 
                            case 49152: {
                                if ((hitMove & 0x1FFF) == nTarget && pTarget != null && Sprites.AngleDiff(pSprite.getAng(), EngineUtils.getAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY())) < 64) {
                                    pScorp.nState = 2;
                                    pScorp.nSeq = 0;
                                    break;
                                }
                                Enemy.PlotCourseToSprite(nSprite, nTarget);
                                pSprite.setAng(pSprite.getAng() + Random.RandomSize(7) - 63);
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        if (nTarget == -1) {
                            pScorp.nState = 0;
                            pScorp.field_C = 5;
                            break block0;
                        }
                        if (Enemy.PlotCourseToSprite(nSprite, nTarget) >= 768) {
                            pScorp.nState = 1;
                            break block0;
                        }
                        if ((nFlags & 0x80) == 0) break block0;
                        Sprites.DamageEnemy(nTarget, nSprite, 7);
                        break block0;
                    }
                    case 3: {
                        BulletStruct.BulletResult nBullet;
                        if (v5 && --pScorp.field_B <= 0) {
                            pScorp.nState = 1;
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                        } else if ((nFlags & 0x80) != 0 && (nBullet = Bullet.BuildBullet(nSprite, 16, -1, pSprite.getAng(), nTarget + 10000, 1)).hasResult()) {
                            Enemy.PlotCourseToSprite(nBullet.getSpriteIndex(), nTarget);
                        }
                        return;
                    }
                    case 8: {
                        if (v5) {
                            ++pScorp.nState;
                            RunList.ChangeChannel(ScorpChan[nScorp], 1);
                        } else {
                            int nSpider = Spider.BuildSpider(-1, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getAng());
                            Sprite pSpider = Main.boardService.getSprite(nSpider);
                            if (pSpider != null) {
                                pSpider.setAng(Random.RandomSize(11) & 0x7FF);
                                int vel = Random.RandomSize(5) + 1;
                                pSpider.setXvel(vel * (EngineUtils.sin(pSpider.getAng() + 512 & 0x7FF) >> 8));
                                pSpider.setYvel(vel * (EngineUtils.sin(pSpider.getAng()) >> 8));
                                pSpider.setZvel(-256 * (Random.RandomSize(5) + 3));
                            }
                        }
                        return;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (v5) {
                            if (pScorp.nHealth > 0) {
                                pScorp.nState = 1;
                                pScorp.field_C = 0;
                            } else {
                                pScorp.nState = --pScorp.field_C > 0 ? Random.RandomBit() + 6 : 8;
                            }
                        }
                        return;
                    }
                    case 9: {
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                        if (v5) {
                            RunList.SubRunRec(pScorp.nFunc);
                            RunList.DoSubRunRec(pSprite.getOwner());
                            RunList.FreeRun(pSprite.getLotag() - 1);
                            Main.engine.mydeletesprite(nSprite);
                        }
                        return;
                    }
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(nObject);
                Seq.PlotSequence(tsp, ActionSeq_X_7[nState][0] + Seq.SeqOffsets[24], pScorp.nSeq, ActionSeq_X_7[nState][1]);
                return;
            }
            case 655360: {
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage != 0 && pScorp.nHealth > 0) {
                    pScorp.nHealth -= nDamage;
                    if (pScorp.nHealth > 0) {
                        Sprite pObject = Main.boardService.getSprite(nObject);
                        if (pObject != null && (pObject.getStatnum() == 100 || pObject.getStatnum() < 199 && Random.RandomSize(5) == 0)) {
                            pScorp.nTarget = nObject;
                        }
                        if (Random.RandomSize(5) == 0) {
                            pScorp.nState = Random.RandomSize(2) + 4;
                            pScorp.nSeq = 0;
                            return;
                        }
                        if (Random.RandomSize(2) == 0) {
                            Sound.D3PlayFX(Sound.StaticSound[41], nSprite);
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            pSprite.setAng(pSprite.getAng() + Random.RandomSize(7) - 63);
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                            break;
                        }
                    } else {
                        pSprite.setZvel(0);
                        pScorp.nHealth = 0;
                        pSprite.setYvel(0);
                        pScorp.nState = 4;
                        pSprite.setXvel(0);
                        pScorp.nSeq = 0;
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                        pScorp.field_C = 10;
                        --Globals.nCreaturesLeft;
                    }
                }
                return;
            }
        }
        if (nState != 2) {
            if (pScorp.field_C != 0) {
                --pScorp.field_C;
            } else {
                pScorp.field_C = 45;
                if (pTarget != null && Main.engine.cansee(pSprite.getX(), pSprite.getY(), pSprite.getZ() - Sprites.GetSpriteHeight(nSprite), pSprite.getSectnum(), pTarget.getX(), pTarget.getY(), pTarget.getZ() - Sprites.GetSpriteHeight(nTarget), pTarget.getSectnum())) {
                    pSprite.setYvel(0);
                    pSprite.setXvel(0);
                    pSprite.setAng(Main.engine.GetMyAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY()));
                    int v41 = Random.RandomSize(3);
                    pScorp.field_B = v41 + Random.RandomSize(2);
                    if (pScorp.field_B != 0) {
                        pScorp.nState = 3;
                        pScorp.nSeq = 0;
                    } else {
                        pScorp.field_C = Random.RandomSize(5);
                    }
                }
            }
        }
        if (nState != 0 && pTarget != null && (pTarget.getCstat() & 0x101) == 0) {
            pScorp.nState = 0;
            pScorp.nSeq = 0;
            pScorp.field_C = 30;
            pScorp.nTarget = -1;
            pSprite.setXvel(0);
            pSprite.setYvel(0);
        }
    }

    static {
        ScorpList = new ScorpStruct[5];
        ScorpChan = new int[5];
    }

    public static class ScorpStruct
    extends Enemy.EnemyStruct {
        public static final int size = 18;
        public int field_B;

        @Override
        public void save(OutputStream os) throws IOException {
            super.save(os);
            StreamUtils.writeShort(os, this.field_B);
        }

        @Override
        public void load(InputStream is) throws IOException {
            super.load(is);
            this.field_B = StreamUtils.readShort(is);
        }

        public void copy(ScorpStruct src) {
            super.copy(src);
            this.field_B = src.field_B;
        }
    }
}

