/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.BulletStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Set {
    public static final int MAX_SET = 10;
    private static final short[][] ActionSeq_X_9 = new short[][]{{0, 0}, {77, 1}, {78, 1}, {0, 0}, {9, 0}, {63, 0}, {45, 0}, {18, 0}, {27, 0}, {36, 0}, {72, 1}, {74, 1}};
    private static int SetCount;
    private static final SetStruct[] SetList;
    private static final int[] SetChan;

    public static void InitSets() {
        SetCount = 10;
    }

    public static void saveSet(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, SetCount);
        for (i = SetCount; i < 10; ++i) {
            SetList[i].save(os);
        }
        for (i = 0; i < 10; ++i) {
            StreamUtils.writeShort(os, SetChan[i]);
        }
    }

    public static void loadSet(SafeLoader loader) {
        SetCount = loader.SetCount;
        for (int i = loader.SetCount; i < 10; ++i) {
            if (SetList[i] == null) {
                Set.SetList[i] = new SetStruct();
            }
            SetList[i].copy(loader.SetList[i]);
        }
        System.arraycopy(loader.SetChan, 0, SetChan, 0, 10);
    }

    public static void loadSet(SafeLoader loader, InputStream is) throws IOException {
        int i;
        for (i = loader.SetCount = (int)StreamUtils.readShort(is); i < 10; ++i) {
            if (loader.SetList[i] == null) {
                loader.SetList[i] = new SetStruct();
            }
            loader.SetList[i].load(is);
        }
        for (i = 0; i < 10; ++i) {
            loader.SetChan[i] = StreamUtils.readShort(is);
        }
    }

    public static void BuildSet(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        Sector sec;
        int count;
        if ((count = --SetCount) < 0) {
            return;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 120);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = pSprite.getX();
            y = pSprite.getY();
            sectnum = pSprite.getSectnum();
            sec = Main.boardService.getSector(sectnum);
            if (sec != null) {
                z = sec.getFloorz();
            }
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 120);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setXoffset(0);
        pSprite.setShade(-12);
        pSprite.setYoffset(0);
        pSprite.setPicnum(1);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setClipdist(110);
        pSprite.setAng(ang);
        pSprite.setXrepeat(87);
        pSprite.setYrepeat(96);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (SetList[count] == null) {
            Set.SetList[count] = new SetStruct();
        }
        Set.SetList[count].nState = 1;
        Set.SetList[count].nHealth = 8000;
        Set.SetList[count].nSprite = spr;
        Set.SetList[count].nSeq = 0;
        Set.SetList[count].nTarget = -1;
        Set.SetList[count].field_A = 90;
        Set.SetList[count].field_C = 0;
        Set.SetList[count].field_D = 0;
        Set.SetChan[count] = channel;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x190000 | count));
        RunList.AddRunRec(RunList.NewRun, 0x190000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void BuildSoul(int nSet) {
        Sprite pSet = Main.boardService.getSprite(Set.SetList[nSet].nSprite);
        if (pSet == null) {
            return;
        }
        int spr = Main.engine.insertsprite(pSet.getSectnum(), 0);
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            throw new AssertException("spr>=0 && spr<MAXSPRITES");
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            return;
        }
        Sector sec = Main.boardService.getSector(pSprite.getSectnum());
        if (sec == null) {
            return;
        }
        pSprite.setCstat(32768);
        pSprite.setShade(-127);
        pSprite.setXrepeat(1);
        pSprite.setYrepeat(1);
        pSprite.setPal(0);
        pSprite.setClipdist(5);
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setPicnum(Seq.GetSeqPicnum(48, 75, 0));
        pSprite.setAng(Random.RandomSize(11));
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(-256 - Random.RandomSize(10));
        pSprite.setX(pSet.getX());
        pSprite.setY(pSet.getY());
        pSprite.setZ((Random.RandomSize(8) << 8) + 8192 + (sec.getCeilingz() - Sprites.GetSpriteHeight(spr)));
        pSprite.setHitag(nSet);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(0);
        pSprite.setOwner(RunList.AddRunRec(RunList.NewRun, 0x230000 | spr));
    }

    public static void FuncSet(int nStack, int nDamage, int RunPtr) {
        int nSet = RunList.RunData[RunPtr].getObject();
        if (nSet < 0 || nSet >= 10) {
            throw new AssertException("set>=0 && set<MAX_SET");
        }
        SetStruct pSet = SetList[nSet];
        int nSprite = pSet.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pSet.nState;
        int nTarget = pSet.nTarget;
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        boolean v68 = false;
        short nObject = (short)(nStack & 0xFFFF);
        block0 : switch (nStack & 0x7F0000) {
            case 131072: {
                Sprites.Gravity(nSprite);
                int nSeq = ActionSeq_X_9[nState][0] + Seq.SeqOffsets[48];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pSet.nSeq));
                Seq.MoveSequence(nSprite, nSeq, pSet.nSeq);
                if (nState == 3 && pSet.field_D != 0) {
                    ++pSet.nSeq;
                }
                if (++pSet.nSeq >= Seq.SeqSize[nSeq]) {
                    pSet.nSeq = 0;
                    v68 = true;
                }
                int nFlags = Seq.FrameFlag[pSet.nSeq + Seq.SeqBase[nSeq]];
                if (pTarget != null && nState < 10 && (pTarget.getCstat() & 0x101) == 0) {
                    pSet.nTarget = -1;
                    pTarget = null;
                    pSet.nState = 0;
                    pSet.nSeq = 0;
                    nTarget = -1;
                }
                int hitMove = Enemy.MoveCreature(nSprite);
                Main.engine.pushmove(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), 4 * pSprite.getClipdist(), 5120, -5120, 0);
                if (pSprite.getZvel() > 4000 && (hitMove & 0x20000) != 0) {
                    Object.SetQuake(nSprite, 100);
                }
                switch (nState) {
                    case 0: {
                        if ((nSet & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            if (nTarget < 0) {
                                nTarget = Enemy.FindPlayer(nSprite, 1000);
                            }
                            if ((pTarget = Main.boardService.getSprite(nTarget)) != null) {
                                pSet.nState = 3;
                                pSet.nSeq = 0;
                                pSet.nTarget = nTarget;
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 1);
                            }
                        }
                        return;
                    }
                    case 1: {
                        if (Enemy.FindPlayer(nSprite, 1000) >= 0 && --pSet.field_A <= 0) {
                            pSet.nState = 2;
                            pSet.nSeq = 0;
                        }
                        return;
                    }
                    case 2: {
                        if (v68) {
                            pSet.nState = 7;
                            pSet.field_C = 0;
                            pSet.nSeq = 0;
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                            pSet.nTarget = Enemy.FindPlayer(nSprite, 1000);
                        }
                        return;
                    }
                    case 6: {
                        if ((nFlags & 0x80) != 0) {
                            BulletStruct.BulletResult nBullet = Bullet.BuildBullet(nSprite, 11, -1, pSprite.getAng(), nTarget + 10000, 1);
                            Bullet.SetBulletEnemy(nBullet.getBullet(), nTarget);
                            if (--pSet.field_E <= 0 || Random.RandomBit() == 0) {
                                pSet.nState = 0;
                                pSet.nSeq = 0;
                            }
                        }
                        return;
                    }
                    case 3: {
                        boolean v34;
                        if (nTarget == -1) {
                            pSet.nState = 0;
                            pSet.nSeq = 0;
                            return;
                        }
                        if ((nFlags & 0x10) != 0 && (hitMove & 0x20000) != 0) {
                            Object.SetQuake(nSprite, 100);
                        }
                        int nGoalAngle = Enemy.PlotCourseToSprite(nSprite, nTarget);
                        boolean bl = v34 = (Globals.totalmoves & 0x1F) == (nSet & 0x1F);
                        if (v34) {
                            int v33 = Random.RandomSize(3);
                            boolean bl2 = v34 = v33 == 0 || v33 == 2;
                            if (v34) {
                                pSet.field_C = 0;
                            } else {
                                if (v33 == 1) break;
                                int n = pSet.field_D = nGoalAngle > 100 ? 1 : 0;
                            }
                        }
                        if (!v34) {
                            int nAngle = pSprite.getAng() & 0xFFF8;
                            pSprite.setXvel(EngineUtils.sin(nAngle + 512 & 0x7FF) >> 1);
                            pSprite.setYvel(EngineUtils.sin(nAngle) >> 1);
                            if (pSet.field_D != 0) {
                                pSprite.setXvel(pSprite.getXvel() * 2);
                                pSprite.setYvel(pSprite.getYvel() * 2);
                            }
                            switch (hitMove & 0xE000) {
                                default: {
                                    break block0;
                                }
                                case 32768: {
                                    Sector nsec;
                                    Wall hitWall = Main.boardService.getWall(hitMove & 0x1FFF);
                                    Sector sector = nsec = hitWall != null ? Main.boardService.getSector(hitWall.getNextsector()) : null;
                                    if (nsec != null && pSprite.getZ() - nsec.getFloorz() < 55000 && pSprite.getZ() > nsec.getCeilingz()) break;
                                    pSprite.setAng(pSprite.getAng() + 256 & 0x7FF);
                                    pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                                    pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 1);
                                    break block0;
                                }
                                case 49152: {
                                    if ((hitMove & 0x1FFF) != nTarget) break;
                                    if (pTarget == null || Sprites.AngleDiff(pSprite.getAng(), EngineUtils.getAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY())) >= 64) break block0;
                                    pSet.nState = 4;
                                    pSet.nSeq = 0;
                                    break block0;
                                }
                            }
                            pSet.field_C = 1;
                        }
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                        pSet.nState = 7;
                        pSet.nSeq = 0;
                        return;
                    }
                    case 5: {
                        if (v68) {
                            pSet.nState = 0;
                            pSet.field_A = 15;
                        }
                        return;
                    }
                    case 4: {
                        if (nTarget == -1) {
                            pSet.nState = 0;
                            pSet.field_A = 50;
                            break block0;
                        }
                        if (Enemy.PlotCourseToSprite(nSprite, nTarget) >= 768) {
                            pSet.nState = 3;
                            break block0;
                        }
                        if ((nFlags & 0x80) == 0) break block0;
                        Sprites.DamageEnemy(nTarget, nSprite, 5);
                        break block0;
                    }
                    case 7: {
                        if (v68) {
                            if (pSet.field_C != 0) {
                                pSprite.setZvel(-10000);
                            } else {
                                pSprite.setZvel(-Enemy.PlotCourseToSprite(nSprite, nTarget));
                            }
                            pSet.nState = 8;
                            pSet.nSeq = 0;
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF));
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF));
                        }
                        return;
                    }
                    case 8: {
                        if (v68) {
                            pSet.nSeq = Seq.SeqSize[nSeq] - 1;
                        }
                        if ((hitMove & 0x20000) != 0) {
                            Object.SetQuake(nSprite, 200);
                            pSet.nState = 9;
                            pSet.nSeq = 0;
                        }
                        return;
                    }
                    case 9: {
                        pSprite.setXvel(pSprite.getXvel() >> 1);
                        pSprite.setYvel(pSprite.getYvel() >> 1);
                        if (v68) {
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                            break;
                        }
                        return;
                    }
                    case 10: {
                        if ((nFlags & 0x80) != 0) {
                            pSprite.setZ(pSprite.getZ() - Sprites.GetSpriteHeight(nSprite));
                            Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(48, 76, 0));
                            pSprite.setZ(pSprite.getZ() + Sprites.GetSpriteHeight(nSprite));
                        }
                        if (v68) {
                            pSet.nState = 11;
                            pSet.nSeq = 0;
                            RunList.ChangeChannel(SetChan[nSet], 1);
                            for (int i = 0; i < 20; ++i) {
                                Set.BuildSoul(nSet);
                            }
                        }
                        return;
                    }
                    case 11: {
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                        return;
                    }
                }
                Enemy.PlotCourseToSprite(nSprite, nTarget);
                pSet.nState = 6;
                pSet.nSeq = 0;
                pSet.field_E = 5;
                pSprite.setXvel(0);
                pSprite.setYvel(0);
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(nObject);
                Seq.PlotSequence(tsp, ActionSeq_X_9[nState][0] + Seq.SeqOffsets[48], pSet.nSeq, ActionSeq_X_9[nState][1]);
                return;
            }
            case 655360: {
                if (nState == 5) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage != 0 && pSet.nHealth > 0) {
                    if (nState != 1) {
                        pSet.nHealth -= nDamage;
                    }
                    if (pSet.nHealth <= 0) {
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                        pSprite.setZvel(0);
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                        pSet.nHealth = 0;
                        --Globals.nCreaturesLeft;
                        if (pSet.nState < 10) {
                            pSet.nState = 10;
                            pSet.nSeq = 0;
                        }
                    } else if (nState == 1) {
                        pSet.nState = 2;
                        pSet.nSeq = 0;
                    }
                }
                return;
            }
        }
        if (nState > 0 && pTarget != null && (pTarget.getCstat() & 0x101) == 0) {
            pSet.nState = 0;
            pSet.nSeq = 0;
            pSet.field_A = 100;
            pSet.nTarget = -1;
            pSprite.setXvel(0);
            pSprite.setYvel(0);
        }
    }

    public static void FuncSoul(int nStack, int ignored, int RunPtr) {
        int nSprite = RunList.RunData[RunPtr].getObject();
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if ((nStack & 0x7F0000) == 131072) {
            int nSet;
            Sprite pSet;
            Seq.MoveSequence(nSprite, Seq.SeqOffsets[48] + 75, 0);
            if (pSprite.getXrepeat() < 32) {
                pSprite.setXrepeat(pSprite.getXrepeat() + 1);
                pSprite.setYrepeat(pSprite.getYrepeat() + 1);
            }
            pSprite.setExtra(pSprite.getExtra() + (nSprite & 0xF) + 5);
            pSprite.setExtra(pSprite.getExtra() & 0x7FF);
            int vel = EngineUtils.sin(pSprite.getExtra() + 512 & 0x7FF) >> 7;
            if ((Main.engine.movesprite(nSprite, EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) * vel, vel * EngineUtils.sin(pSprite.getAng()), pSprite.getZvel(), 5120, 0, 0) & 0x10000) != 0 && (pSet = Main.boardService.getSprite(nSet = Set.SetList[pSprite.getHitag()].nSprite)) != null) {
                pSprite.setCstat(0);
                pSprite.setYrepeat(1);
                pSprite.setXrepeat(1);
                pSprite.setX(pSet.getX());
                pSprite.setY(pSet.getY());
                pSprite.setZ(pSet.getZ() - (Sprites.GetSpriteHeight(nSet) >> 1));
                Main.engine.mychangespritesect(nSprite, pSet.getSectnum());
            }
        }
    }

    static {
        SetList = new SetStruct[10];
        SetChan = new int[10];
    }

    public static class SetStruct
    extends Enemy.EnemyStruct {
        public int field_D;
        public int field_E;

        @Override
        public void save(OutputStream os) throws IOException {
            super.save(os);
            StreamUtils.writeShort(os, this.field_D);
            StreamUtils.writeShort(os, this.field_E);
        }

        @Override
        public void load(InputStream is) throws IOException {
            super.load(is);
            this.field_D = StreamUtils.readShort(is);
            this.field_E = StreamUtils.readShort(is);
        }

        public void copy(SetStruct src) {
            super.copy(src);
            this.field_D = src.field_D;
            this.field_E = src.field_E;
        }
    }
}

