/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Wasp {
    public static final int MAX_WASPS = 100;
    private static final short[][] ActionSeq_X_12 = new short[][]{{0, 0}, {0, 0}, {9, 0}, {18, 0}, {27, 1}, {28, 1}, {29, 1}};
    public static int nWaspCount;
    private static int nVelShift_X_1;
    private static final WaspStruct[] WaspList;

    public static void InitWasps() {
        nWaspCount = 0;
    }

    public static void saveWasp(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, nWaspCount);
        for (int i = 0; i < nWaspCount; ++i) {
            WaspList[i].save(os);
        }
        StreamUtils.writeInt(os, nVelShift_X_1);
    }

    public static void loadWasp(SafeLoader loader) {
        nWaspCount = loader.nWaspCount;
        for (int i = 0; i < loader.nWaspCount; ++i) {
            if (WaspList[i] == null) {
                Wasp.WaspList[i] = new WaspStruct();
            }
            WaspList[i].copy(loader.WaspList[i]);
        }
        nVelShift_X_1 = loader.nVelShift_X_1;
    }

    public static void loadWasp(SafeLoader loader, InputStream is) throws IOException {
        loader.nWaspCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.nWaspCount; ++i) {
            if (loader.WaspList[i] == null) {
                loader.WaspList[i] = new WaspStruct();
            }
            loader.WaspList[i].load(is);
        }
        loader.nVelShift_X_1 = StreamUtils.readInt(is);
    }

    public static void SetWaspVel(int nSprite) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if (nVelShift_X_1 < 0) {
            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) << -nVelShift_X_1);
            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) << -nVelShift_X_1);
        } else {
            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> nVelShift_X_1);
            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> nVelShift_X_1);
        }
    }

    public static int BuildWasp(int spr, int x, int y, int z, int sectnum, int ang) {
        Sector sec;
        int count = nWaspCount++;
        if (nWaspCount >= 100) {
            return -1;
        }
        boolean opt = spr == -2;
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 107);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = pSprite.getX();
            y = pSprite.getY();
            z = pSprite.getX();
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 107);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return -1;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setShade(-12);
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setAng(ang);
        if (opt) {
            pSprite.setYrepeat(20);
            pSprite.setXrepeat(20);
        } else {
            pSprite.setXrepeat(50);
            pSprite.setYrepeat(50);
        }
        pSprite.setPicnum(1);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setClipdist(70);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (WaspList[count] == null) {
            Wasp.WaspList[count] = new WaspStruct();
        }
        Wasp.WaspList[count].nState = 0;
        Wasp.WaspList[count].nSeq = 0;
        Wasp.WaspList[count].nSprite = spr;
        Wasp.WaspList[count].nTarget = -1;
        Wasp.WaspList[count].nHealth = 800;
        Wasp.WaspList[count].nDamage = 10;
        if (opt) {
            Wasp.WaspList[count].field_C = 60;
            Wasp.WaspList[count].nDamage /= 2;
        } else {
            Wasp.WaspList[count].field_C = Random.RandomSize(5);
        }
        Wasp.WaspList[count].nAttackTime = 0;
        Wasp.WaspList[count].nVelocity = 0;
        Wasp.WaspList[count].dTime = Random.RandomSize(7) + 127;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x1E0000 | count));
        Wasp.WaspList[count].nFunc = RunList.AddRunRec(RunList.NewRun, 0x1E0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
        return spr;
    }

    public static void FuncWasp(int nStack, int nDamage, int RunPtr) {
        int nWasp = RunList.RunData[RunPtr].getObject();
        WaspStruct pWasp = WaspList[nWasp];
        int nSprite = pWasp.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pWasp.nState;
        boolean v48 = false;
        short nObject = (short)(nStack & 0xFFFF);
        block0 : switch (nStack & 0x7F0000) {
            case 131072: {
                int nSeq = ActionSeq_X_12[nState][0] + Seq.SeqOffsets[22];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pWasp.nSeq));
                Seq.MoveSequence(nSprite, nSeq, pWasp.nSeq);
                if (++pWasp.nSeq >= Seq.SeqSize[nSeq]) {
                    pWasp.nSeq = 0;
                    v48 = true;
                }
                int nTarget = pWasp.nTarget;
                Sprite pTarget = Main.boardService.getSprite(nTarget);
                if (pWasp.nHealth <= 0 || pTarget == null || (pTarget.getCstat() & 0x101) != 0 && (Globals.SectFlag[pTarget.getSectnum()] & 0x2000) == 0) {
                    switch (nState) {
                        case 0: {
                            pSprite.setZvel(EngineUtils.sin(pWasp.nAttackTime & 0x7FF) >> 4);
                            pWasp.nAttackTime = pWasp.nAttackTime + pWasp.dTime & 0x7FF;
                            Enemy.MoveCreature(nSprite);
                            if (nTarget < 0) {
                                if ((nWasp & 0x1F) == (Globals.totalmoves & 0x1F)) {
                                    pWasp.nTarget = Enemy.FindPlayer(nSprite, 60);
                                }
                            } else if (--pWasp.field_C > 0) {
                                Enemy.PlotCourseToSprite(nSprite, nTarget);
                            } else {
                                pWasp.nState = 1;
                                pSprite.setZvel(0);
                                pWasp.nSeq = 0;
                                pWasp.nVelocity = 1500;
                                pWasp.field_C = Random.RandomSize(5) + 60;
                            }
                            return;
                        }
                        case 2: 
                        case 3: {
                            if (v48) break block0;
                            return;
                        }
                        case 1: {
                            if (--pWasp.field_C > 0) {
                                int moveHit = Sprites.AngleChase(nSprite, nTarget, pWasp.nVelocity, 0, 16);
                                if ((moveHit & 0xE000) == 49152 && (moveHit & 0x1FFF) == nTarget) {
                                    pSprite.setXvel(0);
                                    pSprite.setYvel(0);
                                    Sprites.DamageEnemy(nTarget, nSprite, pWasp.nDamage);
                                    pWasp.nState = 2;
                                    pWasp.nSeq = 0;
                                }
                            } else {
                                pWasp.nState = 0;
                                pWasp.field_C = Random.RandomSize(6);
                            }
                            return;
                        }
                        case 4: {
                            Enemy.MoveCreature(nSprite);
                            pWasp.nState = 5;
                            pWasp.nSeq = 0;
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                            pSprite.setZvel(1024);
                            return;
                        }
                        case 5: {
                            pSprite.setZ(pSprite.getZ() + pSprite.getZvel());
                            Sector sec = Main.boardService.getSector(pSprite.getSectnum());
                            if (sec != null && pSprite.getZ() >= sec.getFloorz()) {
                                if (Globals.SectBelow[pSprite.getSectnum()] > -1) {
                                    Sprites.BuildSplash(pSprite, pSprite.getSectnum());
                                    pSprite.setCstat(pSprite.getCstat() | 0x8000);
                                }
                                pSprite.setXvel(0);
                                pSprite.setYvel(0);
                                pSprite.setZvel(0);
                                pWasp.nState = 6;
                                pWasp.nSeq = 0;
                                RunList.SubRunRec(pWasp.nFunc);
                            }
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                pWasp.nTarget = -1;
                pWasp.nState = 0;
                pWasp.field_C = Random.RandomSize(6);
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(nObject);
                Seq.PlotSequence(tsp, ActionSeq_X_12[nState][0] + Seq.SeqOffsets[22], pWasp.nSeq, ActionSeq_X_12[nState][1]);
                return;
            }
            case 655360: {
                if ((pSprite.getCstat() & 0x101) == 0) {
                    return;
                }
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage != 0 && pWasp.nHealth > 0) {
                    pWasp.nHealth -= nDamage;
                    if (pWasp.nHealth > 0) {
                        if (Random.RandomSize(4) == 0) {
                            pWasp.nState = 3;
                            pWasp.nSeq = 0;
                        }
                    } else {
                        pWasp.nState = 4;
                        nVelShift_X_1 = 0;
                        pWasp.nSeq = 0;
                        pSprite.setCstat(0);
                        pSprite.setAng(pSprite.getAng() + 1024 & 0x7FF);
                        Wasp.SetWaspVel(nSprite);
                        pSprite.setZvel(512);
                        --Globals.nCreaturesLeft;
                    }
                }
                return;
            }
        }
        pWasp.nState = 1;
        pSprite.setAng(pSprite.getAng() + (Random.RandomSize(9) + 768 & 0x7FF));
        pWasp.nVelocity = 3000;
        pSprite.setZvel(-20 - Random.RandomSize(6));
    }

    static {
        WaspList = new WaspStruct[100];
    }

    public static class WaspStruct
    extends Enemy.EnemyStruct {
        public int nAttackTime;
        public int dTime;
        public int nVelocity;
        public int nDamage;

        @Override
        public void save(OutputStream os) throws IOException {
            super.save(os);
            StreamUtils.writeShort(os, this.nAttackTime);
            StreamUtils.writeShort(os, this.dTime);
            StreamUtils.writeShort(os, this.nVelocity);
            StreamUtils.writeShort(os, this.nDamage);
        }

        @Override
        public void load(InputStream is) throws IOException {
            super.load(is);
            this.nAttackTime = StreamUtils.readShort(is);
            this.dTime = StreamUtils.readShort(is);
            this.nVelocity = StreamUtils.readShort(is);
            this.nDamage = StreamUtils.readShort(is);
        }

        public void copy(WaspStruct src) {
            super.copy(src);
            this.nAttackTime = src.nAttackTime;
            this.dTime = src.dTime;
            this.nVelocity = src.nVelocity;
            this.nDamage = src.nDamage;
        }
    }
}

