/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Factory;

import com.badlogic.gdx.math.Vector2;
import java.io.IOException;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Tables;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Factory.PSBoardService;
import ru.m210projects.Powerslave.Factory.PSPaletteManager;
import ru.m210projects.Powerslave.Factory.PSTables;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;

public class PSEngine
extends Engine {
    private final short[] AngTable = new short[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32, 33, 33, 33, 33, 33, 33, 33, 34, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 35, 35, 36, 36, 36, 36, 36, 36, 37, 37, 37, 37, 37, 37, 38, 38, 38, 38, 38, 38, 38, 39, 39, 39, 39, 39, 39, 40, 40, 40, 40, 40, 40, 41, 41, 41, 41, 41, 41, 41, 42, 42, 42, 42, 42, 42, 43, 43, 43, 43, 43, 43, 43, 44, 44, 44, 44, 44, 44, 45, 45, 45, 45, 45, 45, 46, 46, 46, 46, 46, 46, 46, 47, 47, 47, 47, 47, 47, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 59, 60, 60, 60, 60, 60, 60, 61, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 66, 67, 67, 67, 67, 67, 67, 67, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, 69, 69, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 73, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 75, 75, 75, 75, 76, 76, 76, 76, 76, 76, 77, 77, 77, 77, 77, 77, 77, 78, 78, 78, 78, 78, 78, 78, 79, 79, 79, 79, 79, 79, 80, 80, 80, 80, 80, 80, 80, 81, 81, 81, 81, 81, 81, 81, 82, 82, 82, 82, 82, 82, 83, 83, 83, 83, 83, 83, 83, 84, 84, 84, 84, 84, 84, 84, 85, 85, 85, 85, 85, 85, 86, 86, 86, 86, 86, 86, 86, 87, 87, 87, 87, 87, 87, 87, 88, 88, 88, 88, 88, 88, 88, 89, 89, 89, 89, 89, 89, 90, 90, 90, 90, 90, 90, 90, 91, 91, 91, 91, 91, 91, 91, 92, 92, 92, 92, 92, 92, 92, 93, 93, 93, 93, 93, 93, 93, 94, 94, 94, 94, 94, 94, 94, 95, 95, 95, 95, 95, 95, 96, 96, 96, 96, 96, 96, 96, 97, 97, 97, 97, 97, 97, 97, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 100, 100, 100, 100, 100, 100, 100, 101, 101, 101, 101, 101, 101, 101, 102, 102, 102, 102, 102, 102, 102, 103, 103, 103, 103, 103, 103, 103, 104, 104, 104, 104, 104, 104, 104, 105, 105, 105, 105, 105, 105, 105, 106, 106, 106, 106, 106, 106, 106, 107, 107, 107, 107, 107, 107, 107, 108, 108, 108, 108, 108, 108, 108, 109, 109, 109, 109, 109, 109, 109, 110, 110, 110, 110, 110, 110, 110, 111, 111, 111, 111, 111, 111, 111, 112, 112, 112, 112, 112, 112, 112, 113, 113, 113, 113, 113, 113, 113, 114, 114, 114, 114, 114, 114, 114, 115, 115, 115, 115, 115, 115, 115, 116, 116, 116, 116, 116, 116, 116, 117, 117, 117, 117, 117, 117, 117, 117, 118, 118, 118, 118, 118, 118, 118, 119, 119, 119, 119, 119, 119, 119, 120, 120, 120, 120, 120, 120, 120, 121, 121, 121, 121, 121, 121, 121, 122, 122, 122, 122, 122, 122, 122, 122, 123, 123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 125, 125, 125, 125, 125, 125, 125, 125, 126, 126, 126, 126, 126, 126, 126, 127, 127, 127, 127, 127, 127, 127, 128, 128, 128, 128, 128, 128, 128, 128, 129, 129, 129, 129, 129, 129, 129, 130, 130, 130, 130, 130, 130, 130, 131, 131, 131, 131, 131, 131, 131, 131, 132, 132, 132, 132, 132, 132, 132, 133, 133, 133, 133, 133, 133, 133, 133, 134, 134, 134, 134, 134, 134, 134, 135, 135, 135, 135, 135, 135, 135, 135, 136, 136, 136, 136, 136, 136, 136, 137, 137, 137, 137, 137, 137, 137, 137, 138, 138, 138, 138, 138, 138, 138, 139, 139, 139, 139, 139, 139, 139, 139, 140, 140, 140, 140, 140, 140, 140, 141, 141, 141, 141, 141, 141, 141, 141, 142, 142, 142, 142, 142, 142, 142, 142, 143, 143, 143, 143, 143, 143, 143, 144, 144, 144, 144, 144, 144, 144, 144, 145, 145, 145, 145, 145, 145, 145, 145, 146, 146, 146, 146, 146, 146, 146, 146, 147, 147, 147, 147, 147, 147, 147, 148, 148, 148, 148, 148, 148, 148, 148, 149, 149, 149, 149, 149, 149, 149, 149, 150, 150, 150, 150, 150, 150, 150, 150, 151, 151, 151, 151, 151, 151, 151, 151, 152, 152, 152, 152, 152, 152, 152, 153, 153, 153, 153, 153, 153, 153, 153, 154, 154, 154, 154, 154, 154, 154, 154, 155, 155, 155, 155, 155, 155, 155, 155, 156, 156, 156, 156, 156, 156, 156, 156, 157, 157, 157, 157, 157, 157, 157, 157, 158, 158, 158, 158, 158, 158, 158, 158, 159, 159, 159, 159, 159, 159, 159, 159, 160, 160, 160, 160, 160, 160, 160, 160, 161, 161, 161, 161, 161, 161, 161, 161, 162, 162, 162, 162, 162, 162, 162, 162, 162, 163, 163, 163, 163, 163, 163, 163, 163, 164, 164, 164, 164, 164, 164, 164, 164, 165, 165, 165, 165, 165, 165, 165, 165, 166, 166, 166, 166, 166, 166, 166, 166, 167, 167, 167, 167, 167, 167, 167, 167, 167, 168, 168, 168, 168, 168, 168, 168, 168, 169, 169, 169, 169, 169, 169, 169, 169, 170, 170, 170, 170, 170, 170, 170, 170, 170, 171, 171, 171, 171, 171, 171, 171, 171, 172, 172, 172, 172, 172, 172, 172, 172, 173, 173, 173, 173, 173, 173, 173, 173, 173, 174, 174, 174, 174, 174, 174, 174, 174, 175, 175, 175, 175, 175, 175, 175, 175, 175, 176, 176, 176, 176, 176, 176, 176, 176, 177, 177, 177, 177, 177, 177, 177, 177, 177, 178, 178, 178, 178, 178, 178, 178, 178, 178, 179, 179, 179, 179, 179, 179, 179, 179, 180, 180, 180, 180, 180, 180, 180, 180, 180, 181, 181, 181, 181, 181, 181, 181, 181, 181, 182, 182, 182, 182, 182, 182, 182, 182, 183, 183, 183, 183, 183, 183, 183, 183, 183, 184, 184, 184, 184, 184, 184, 184, 184, 184, 185, 185, 185, 185, 185, 185, 185, 185, 185, 186, 186, 186, 186, 186, 186, 186, 186, 186, 187, 187, 187, 187, 187, 187, 187, 187, 188, 188, 188, 188, 188, 188, 188, 188, 188, 189, 189, 189, 189, 189, 189, 189, 189, 189, 190, 190, 190, 190, 190, 190, 190, 190, 190, 191, 191, 191, 191, 191, 191, 191, 191, 191, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 193, 193, 193, 193, 193, 193, 193, 193, 193, 194, 194, 194, 194, 194, 194, 194, 194, 194, 195, 195, 195, 195, 195, 195, 195, 195, 195, 196, 196, 196, 196, 196, 196, 196, 196, 196, 197, 197, 197, 197, 197, 197, 197, 197, 197, 197, 198, 198, 198, 198, 198, 198, 198, 198, 198, 199, 199, 199, 199, 199, 199, 199, 199, 199, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 201, 201, 201, 201, 201, 201, 201, 201, 201, 202, 202, 202, 202, 202, 202, 202, 202, 202, 202, 203, 203, 203, 203, 203, 203, 203, 203, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 205, 205, 205, 205, 205, 205, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 207, 207, 207, 207, 207, 207, 207, 207, 207, 207, 208, 208, 208, 208, 208, 208, 208, 208, 208, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 215, 215, 215, 215, 215, 215, 215, 215, 215, 215, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 217, 217, 217, 217, 217, 217, 217, 217, 217, 217, 218, 218, 218, 218, 218, 218, 218, 218, 218, 218, 219, 219, 219, 219, 219, 219, 219, 219, 219, 219, 219, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 225, 225, 225, 225, 225, 225, 225, 225, 225, 225, 226, 226, 226, 226, 226, 226, 226, 226, 226, 226, 226, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 228, 228, 228, 228, 228, 228, 228, 228, 228, 228, 228, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 231, 231, 231, 231, 231, 231, 231, 231, 231, 231, 231, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 235, 235, 235, 235, 235, 235, 235, 235, 235, 235, 235, 236, 236, 236, 236, 236, 236, 236, 236, 236, 236, 236, 237, 237, 237, 237, 237, 237, 237, 237, 237, 237, 237, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 256, 256, 256, 256, 256, 256};
    private int next = 1;

    public PSEngine(BuildGame game) throws Exception {
        super(game);
        this.inittimer(game.pCfg.isLegacyTimer(), 120, 4);
    }

    @Override
    protected BoardService createBoardService() {
        return new PSBoardService();
    }

    @Override
    public int rand() {
        this.next = (int)(((long)this.next & 0xFFFFFFFFL) * 1103515245L + 12345L);
        return this.next >> 16 & Short.MAX_VALUE;
    }

    public int GetMyAngle(int a1, int a2) {
        int result;
        int v3 = -a1;
        int v4 = a2 << 11;
        if (a1 <= 0) {
            int result2;
            int v5 = -2048 * a1;
            if (a2 < 0) {
                int v7 = -a2;
                if (v3 == v7) {
                    return 1280;
                }
                if (v3 > v7) {
                    return (short)(this.AngTable[(v7 << 11) / v3 & 0x7FF] + 1024 & 0x7FF);
                }
                result2 = (short)(1024 - this.AngTable[v5 / v7 & 0x7FF]);
            } else {
                if (v3 == a2) {
                    return 768;
                }
                result2 = a2 <= v3 ? (int)((short)(512 - this.AngTable[v4 / v3 & 0x7FF])) : this.AngTable[v5 / a2 & 0x7FF];
            }
            result2 += 512;
            return result2 &= 0x7FF;
        }
        if (a2 < 0) {
            int v8 = -a2;
            if (a1 == -a2) {
                return 1792;
            }
            if (a1 < v8) {
                int result3 = this.AngTable[(a1 << 11) / v8 & 0x7FF];
                result3 += 1536;
                return result3 &= 0x7FF;
            }
            int result4 = 1536 - this.AngTable[-2048 * a2 / a1 & 0x7FF];
            result4 += 512;
            return result4 &= 0x7FF;
        }
        if (a1 == a2) {
            return 256;
        }
        if (a1 <= a2) {
            result = (short)(2048 - this.AngTable[(a1 << 11) / a2 & 0x7FF]);
            result += 512;
        } else {
            result = this.AngTable[v4 / a1 & 0x7FF];
            result += 2048;
        }
        return result &= 0x7FF;
    }

    public int GetWallNormal(int nWall) {
        Wall wal = this.boardService.getWall(nWall);
        if (wal == null) {
            return 0;
        }
        return this.GetMyAngle(wal.getWall2().getX() - wal.getX(), wal.getWall2().getY() - wal.getY()) + 512 & 0x7FF;
    }

    public void mydeletesprite(int num) {
        if (num < 0 || num >= MAXSPRITES) {
            throw new AssertException("bad sprite value " + num + " handed to mydeletesprite");
        }
        this.game.pInt.clearspriteinterpolate(num);
        this.deletesprite(num);
        if (num == Globals.besttarget) {
            Globals.besttarget = -1;
        }
    }

    public void mychangespritesect(int spritenum, int newsectnum) {
        Sprite sprite = this.boardService.getSprite(spritenum);
        if (sprite == null || sprite.getSectnum() == newsectnum) {
            return;
        }
        this.DoKenTest();
        this.changespritesect(spritenum, newsectnum);
        this.DoKenTest();
    }

    private void DoKenTest() {
        Sprite spr = this.boardService.getSprite(Globals.PlayerList[0].spriteId);
        if (spr == null) {
            return;
        }
        ListNode<Sprite> node = this.boardService.getSectNode(spr.getSectnum());
        while (true) {
            if (node == null) {
                return;
            }
            ListNode<Sprite> next = node.getNext();
            if (next != null && next.getIndex() == node.getIndex()) break;
            node = node.getNext();
        }
        throw new AssertException("ERROR in Ken's linked list!");
    }

    @Override
    public int clipmove(int x, int y, int z, int sectnum, long xvect, long yvect, int walldist, int ceildist, int flordist, int cliptype) {
        return Globals.CONVERT_HIT(super.clipmove(x, y, z, sectnum, xvect, yvect, walldist, ceildist, flordist, cliptype));
    }

    @Override
    public void getzrange(int x, int y, int z, int sectnum, int walldist, int cliptype) {
        super.getzrange(x, y, z, sectnum, walldist, cliptype);
        zr_ceilhit = Globals.CONVERT_HIT(zr_ceilhit);
        zr_florhit = Globals.CONVERT_HIT(zr_florhit);
    }

    public int movesprite(int spritenum, int dx, int dy, int dz, int ignoredceildist, int flordist, int cliptype) {
        cliptype = cliptype == 1 ? 0x1000040 : 65537;
        Sprite spr = this.boardService.getSprite(spritenum);
        if (spr == null) {
            return 0;
        }
        this.game.pInt.setsprinterpolate(spritenum, spr);
        Globals.bTouchFloor[0] = false;
        int sx = spr.getX();
        int sy = spr.getY();
        int sz = spr.getZ();
        Sector sec = this.boardService.getSector(spr.getSectnum());
        if (sec == null) {
            return 0;
        }
        int height = Sprites.GetSpriteHeight(spritenum);
        if ((Globals.SectFlag[spr.getSectnum()] & 0x2000) != 0 || sec.getFloorz() < spr.getZ()) {
            dx >>= 1;
            dy >>= 1;
        }
        int zhit = this.movespritez(spritenum, dz, height, flordist, spr.getClipdist() * 4);
        short sectnum = spr.getSectnum();
        if (spr.getStatnum() == 100) {
            int plr = Player.GetPlayerFromSprite(spritenum);
            Vector2 floorz = PSSector.CheckSectorFloor(PSSector.overridesect, spr.getZ(), 0, 0);
            if (floorz != null) {
                Globals.nXDamage[plr] = (int)floorz.x;
                Globals.nYDamage[plr] = (int)floorz.y;
            }
            dx += Globals.nXDamage[plr];
            dy += Globals.nYDamage[plr];
        } else {
            Vector2 floorz = PSSector.CheckSectorFloor(PSSector.overridesect, spr.getZ(), dx, dy);
            if (floorz != null) {
                dx = (int)floorz.x;
                dy = (int)floorz.y;
            }
        }
        int movehit = Main.engine.clipmove(spr.getX(), spr.getY(), spr.getZ(), sectnum, dx, dy, 4 * spr.getClipdist(), height, flordist, cliptype);
        spr.setX(clipmove_x);
        spr.setY(clipmove_y);
        spr.setZ(clipmove_z);
        sectnum = clipmove_sectnum;
        int sumhit = movehit | zhit;
        if (sectnum != spr.getSectnum() && sectnum >= 0) {
            if ((sumhit & 0x20000) != 0) {
                dz = 0;
            }
            if ((sec = this.boardService.getSector(sectnum)) == null) {
                return 0;
            }
            if (sec.getFloorz() - sz >= flordist + dz) {
                this.mychangespritesect(spritenum, sectnum);
                if (spr.getPal() < 5 && spr.getHitag() == 0) {
                    spr.setPal(sec.getCeilingpal());
                }
            } else {
                spr.setX(sx);
                spr.setY(sy);
            }
        }
        if ((sumhit & 0xE000) == 49152 && !this.boardService.isValidSprite(sumhit & 0x1FFF)) {
            sumhit = movehit;
        }
        return sumhit;
    }

    private int movespritez(int spritenum, int dz, int ceildist, int ignoredflordist, int cliptype) {
        Sprite pSprite = this.boardService.getSprite(spritenum);
        if (pSprite == null) {
            return 0;
        }
        int sectnum = pSprite.getSectnum();
        Sector sec = this.boardService.getSector(pSprite.getSectnum());
        if (sec == null) {
            return 0;
        }
        PSSector.overridesect = sectnum;
        int v6 = sectnum;
        short oldcstat = pSprite.getCstat();
        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFFE);
        int movehit = 0;
        if ((Globals.SectFlag[sectnum] & 0x2000) != 0) {
            dz >>= 1;
        }
        int sz = pSprite.getZ();
        int floorz = sec.getFloorz();
        int height = dz + sz;
        int v12 = (ceildist >> 1) + sec.getCeilingz();
        if ((Globals.SectFlag[sectnum] & 0x2000) != 0 && height < v12) {
            height = v12;
        }
        while (true) {
            short v13;
            if ((sec = this.boardService.getSector(v13 = pSprite.getSectnum())) == null) {
                return 0;
            }
            if (height <= sec.getFloorz() || Globals.SectBelow[v13] < 0) break;
            v6 = Globals.SectBelow[v13];
            this.mychangespritesect(spritenum, Globals.SectBelow[v13]);
        }
        if (v6 == sectnum) {
            while (true) {
                short v15;
                if ((sec = this.boardService.getSector(v15 = pSprite.getSectnum())) == null) {
                    return 0;
                }
                if (height < sec.getCeilingz() && Globals.SectAbove[v15] >= 0) {
                    v6 = Globals.SectAbove[v15];
                    this.mychangespritesect(spritenum, v6);
                    continue;
                }
                break;
            }
        } else {
            pSprite.setZ(height);
            if ((Globals.SectFlag[v6] & 0x2000) != 0) {
                if (spritenum == Globals.PlayerList[Globals.nLocalPlayer].spriteId) {
                    Sound.D3PlayFX(Sound.StaticSound[2], spritenum);
                }
                if (pSprite.getStatnum() <= 107) {
                    pSprite.setHitag(0);
                }
            }
        }
        this.getzrange(pSprite.getX(), pSprite.getY(), pSprite.getZ() - 256, pSprite.getSectnum(), 128, 65537);
        int lohit = zr_florhit;
        int hihit = zr_ceilhit;
        int sprceiling = zr_ceilz;
        int v17 = zr_florz;
        if ((lohit & 0xE000) != 49152) {
            v17 = (Globals.SectDepth[pSprite.getSectnum()] & 0xFFFF) + zr_florz;
        }
        if (height > v17) {
            if (dz > 0) {
                Globals.bTouchFloor[0] = true;
                if ((lohit & 0xE000) == 49152) {
                    int lospr = lohit & 0x1FFF;
                    Sprite hitSpr = this.boardService.getSprite(lospr);
                    if (hitSpr != null) {
                        if (pSprite.getStatnum() == 100 && hitSpr.getStatnum() != 0 && hitSpr.getStatnum() < 100) {
                            if (dz >> 9 != 0) {
                                Sprites.DamageEnemy(lospr, spritenum, 2 * (dz >> 9));
                            }
                            pSprite.setZvel(-dz);
                        } else {
                            movehit = hitSpr.getStatnum() != 0 && hitSpr.getStatnum() <= 199 ? lohit : 131072;
                            pSprite.setZvel(0);
                        }
                    }
                } else if (Globals.SectBelow[pSprite.getSectnum()] == -1) {
                    movehit = 131072;
                    if (Globals.SectDamage[pSprite.getSectnum()] != 0) {
                        if (pSprite.getHitag() < 15) {
                            Bullet.IgniteSprite(spritenum);
                            pSprite.setHitag(20);
                        }
                        if (Globals.SectDamage[pSprite.getSectnum()] >> 2 != Globals.SectDamage[pSprite.getSectnum()] >> 4) {
                            Sprites.DamageEnemy(spritenum, -1, (Globals.SectDamage[pSprite.getSectnum()] >> 2) - (Globals.SectDamage[pSprite.getSectnum()] >> 4));
                        }
                    }
                    pSprite.setZvel(0);
                }
            }
            height = v17;
            pSprite.setZ(v17);
        } else if (height - ceildist < sprceiling && ((hihit & 0xE000) == 49152 || Globals.SectAbove[pSprite.getSectnum()] == -1)) {
            height = sprceiling + ceildist;
            movehit = 65536;
        }
        if (sz <= floorz && height > floorz && (Globals.SectDepth[sectnum] != 0 || v6 != sectnum && (Globals.SectFlag[v6] & 0x2000) != 0)) {
            Sprites.BuildSplash(pSprite, sectnum);
        }
        pSprite.setCstat(oldcstat);
        pSprite.setZ(height);
        if (pSprite.getStatnum() == 100) {
            Sprites.BuildNear(pSprite.getX(), pSprite.getY(), cliptype / 2 + cliptype, pSprite.getSectnum());
            movehit |= Sprites.BelowNear(pSprite, lohit);
        }
        return movehit;
    }

    @Override
    protected Tables loadtables() throws IOException {
        return new PSTables(this.game.getCache().getEntry("tables.dat", true));
    }

    @Override
    public PaletteManager loadpalette() throws IOException {
        return new PSPaletteManager((Engine)this, this.game.getCache().getEntry("palette.dat", true));
    }

    @Override
    public PSPaletteManager getPaletteManager() {
        return (PSPaletteManager)this.paletteManager;
    }
}

