/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdFunc;
import ru.m210projects.Powerslave.Factory.PSEngine;
import ru.m210projects.Powerslave.Factory.PSMenuHandler;
import ru.m210projects.Powerslave.Factory.PSNetwork;
import ru.m210projects.Powerslave.Factory.PSOSDFunc;
import ru.m210projects.Powerslave.Factory.PSPolygdx;
import ru.m210projects.Powerslave.Factory.PSPolymost;
import ru.m210projects.Powerslave.Factory.PSSliderDrawable;
import ru.m210projects.Powerslave.Factory.PSSoftware;
import ru.m210projects.Powerslave.Font.FontA;
import ru.m210projects.Powerslave.Font.GameFont;
import ru.m210projects.Powerslave.Font.LargeFont;
import ru.m210projects.Powerslave.Font.MenuFont;
import ru.m210projects.Powerslave.Main;

public class PSFactory
extends BuildFactory {
    private final Main app;

    public PSFactory(Main app) {
        super("stuff.dat");
        this.app = app;
        OsdColor.DEFAULT.setPal(0);
    }

    @Override
    public void drawInitScreen() {
        Renderer renderer = this.app.getRenderer();
        renderer.rotatesprite(0, 0, 65536, 0, 3352, -128, 0, 26);
    }

    @Override
    public Engine engine() throws Exception {
        Main.engine = new PSEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new PSSoftware(this.app.pCfg);
        }
        if (type == Renderer.RenderType.PolyGDX) {
            return new PSPolygdx(this.app.pCfg);
        }
        return new PSPolymost(this.app.pCfg);
    }

    @Override
    public DefScript getBaseDef(Engine engine) {
        return new DefScript(engine);
    }

    @Override
    public OsdFunc getOsdFunc() {
        return new PSOSDFunc();
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new PSMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(4){

            @Override
            protected Font init(int i) {
                if (i == 0) {
                    return new GameFont(((PSFactory)PSFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new MenuFont();
                }
                if (i == 2) {
                    return new FontA(((PSFactory)PSFactory.this).app.pEngine);
                }
                return new LargeFont();
            }
        };
    }

    @Override
    public BuildNet net() {
        return new PSNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new PSSliderDrawable();
    }
}

