/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Type.FlashStruct;
import ru.m210projects.Powerslave.Type.FlickerStruct;
import ru.m210projects.Powerslave.Type.FlowStruct;
import ru.m210projects.Powerslave.Type.GrowStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Light {
    public static int bDoFlicks;
    public static int bDoGlows;
    public static final int[] flickermask;
    public static int nFlashDepth;
    public static int bTorch;
    private static int nFlickerCount;
    private static int nGlowCount;
    private static int nFlowCount;
    private static int nFlashes;
    private static int nFirstFlash;
    private static int nLastFlash;
    private static final int[] nFreeFlash;
    private static final int[] nNextFlash;
    private static final FlashStruct[] sFlash;
    private static final GrowStruct[] sGlow;
    private static final FlickerStruct[] sFlicker;
    private static final FlowStruct[] sFlowInfo;

    public static FlashStruct GrabFlash() {
        if (nFlashes < 2000) {
            int nFlash = nFreeFlash[nFlashes++];
            Light.nNextFlash[nFlash] = -1;
            if (nLastFlash <= -1) {
                nFirstFlash = nFlash;
            } else {
                Light.nNextFlash[Light.nLastFlash] = nFlash;
            }
            nLastFlash = nFlash;
            if (sFlash[nFlash] == null) {
                Light.sFlash[nFlash] = new FlashStruct();
            }
            return sFlash[nFlash];
        }
        return null;
    }

    public static void saveLights(OutputStream os) throws IOException {
        Light.saveFlashes(os);
        Light.saveGlows(os);
        Light.saveFlows(os);
        Light.saveFlickers(os);
    }

    public static void loadLights(SafeLoader loader) {
        Light.loadFlashes(loader);
        Light.loadGlows(loader);
        Light.loadFlows(loader);
        Light.loadFlickers(loader);
        for (int i = 0; i < 25; ++i) {
            Light.flickermask[i] = 2 * Random.RandomSize(31);
        }
        bDoFlicks = 0;
        bDoGlows = 0;
    }

    public static void loadLights(SafeLoader loader, InputStream is) throws IOException {
        Light.loadFlashes(loader, is);
        Light.loadGlows(loader, is);
        Light.loadFlows(loader, is);
        Light.loadFlickers(loader, is);
    }

    private static void saveFlashes(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, nFlashes);
        StreamUtils.writeShort(os, nFirstFlash);
        StreamUtils.writeShort(os, nLastFlash);
        for (i = 0; i < 2000; ++i) {
            StreamUtils.writeShort(os, nFreeFlash[i]);
            StreamUtils.writeShort(os, nNextFlash[i]);
        }
        if (nFlashes != 0) {
            i = nFirstFlash;
            while (i >= 0) {
                sFlash[i].save(os);
                i = nNextFlash[i];
            }
        }
    }

    private static void loadFlashes(SafeLoader loader) {
        nFlashes = loader.nFlashes;
        nFirstFlash = loader.nFirstFlash;
        nLastFlash = loader.nLastFlash;
        System.arraycopy(loader.nFreeFlash, 0, nFreeFlash, 0, 2000);
        System.arraycopy(loader.nNextFlash, 0, nNextFlash, 0, 2000);
        if (nFlashes != 0) {
            int i = nFirstFlash;
            while (i >= 0) {
                if (sFlash[i] == null) {
                    Light.sFlash[i] = new FlashStruct();
                }
                sFlash[i].copy(loader.sFlash[i]);
                i = nNextFlash[i];
            }
        }
    }

    private static void loadFlashes(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.nFlashes = StreamUtils.readShort(is);
        loader.nFirstFlash = StreamUtils.readShort(is);
        loader.nLastFlash = StreamUtils.readShort(is);
        for (i = 0; i < 2000; ++i) {
            loader.nFreeFlash[i] = StreamUtils.readShort(is);
            loader.nNextFlash[i] = StreamUtils.readShort(is);
        }
        if (loader.nFlashes != 0) {
            i = loader.nFirstFlash;
            while (i >= 0) {
                if (loader.sFlash[i] == null) {
                    loader.sFlash[i] = new FlashStruct();
                }
                loader.sFlash[i].load(is);
                i = loader.nNextFlash[i];
            }
        }
    }

    private static void saveGlows(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, nGlowCount);
        for (int i = 0; i < nGlowCount; ++i) {
            sGlow[i].save(os);
        }
    }

    private static void loadGlows(SafeLoader loader) {
        nGlowCount = loader.nGlowCount;
        for (int i = 0; i < loader.nGlowCount; ++i) {
            if (sGlow[i] == null) {
                Light.sGlow[i] = new GrowStruct();
            }
            sGlow[i].copy(loader.sGlow[i]);
        }
    }

    private static void loadGlows(SafeLoader loader, InputStream is) throws IOException {
        loader.nGlowCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.nGlowCount; ++i) {
            if (loader.sGlow[i] == null) {
                loader.sGlow[i] = new GrowStruct();
            }
            loader.sGlow[i].load(is);
        }
    }

    private static void saveFlows(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, nFlowCount);
        for (int i = 0; i < nFlowCount; ++i) {
            sFlowInfo[i].save(os);
        }
    }

    private static void loadFlows(SafeLoader loader, InputStream is) throws IOException {
        loader.nFlowCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.nFlowCount; ++i) {
            if (loader.sFlowInfo[i] == null) {
                loader.sFlowInfo[i] = new FlowStruct();
            }
            loader.sFlowInfo[i].load(is);
        }
    }

    private static void loadFlows(SafeLoader loader) {
        nFlowCount = loader.nFlowCount;
        for (int i = 0; i < loader.nFlowCount; ++i) {
            if (sFlowInfo[i] == null) {
                Light.sFlowInfo[i] = new FlowStruct();
            }
            sFlowInfo[i].copy(loader.sFlowInfo[i]);
        }
    }

    private static void saveFlickers(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, nFlickerCount);
        for (int i = 0; i < nFlickerCount; ++i) {
            sFlicker[i].save(os);
        }
    }

    private static void loadFlickers(SafeLoader loader, InputStream is) throws IOException {
        loader.nFlickerCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.nFlickerCount; ++i) {
            if (loader.sFlicker[i] == null) {
                loader.sFlicker[i] = new FlickerStruct();
            }
            loader.sFlicker[i].load(is);
        }
    }

    private static void loadFlickers(SafeLoader loader) {
        nFlickerCount = loader.nFlickerCount;
        for (int i = 0; i < loader.nFlickerCount; ++i) {
            if (sFlicker[i] == null) {
                Light.sFlicker[i] = new FlickerStruct();
            }
            sFlicker[i].copy(loader.sFlicker[i]);
        }
    }

    public static void InitLights() {
        int i;
        nFlickerCount = 0;
        for (i = 0; i < 25; ++i) {
            Light.flickermask[i] = 2 * Random.RandomSize(31);
        }
        nGlowCount = 0;
        nFlowCount = 0;
        nFlashes = 0;
        bDoFlicks = 0;
        bDoGlows = 0;
        for (i = 0; i < 2000; ++i) {
            Light.nFreeFlash[i] = i;
            Light.nNextFlash[i] = -1;
        }
        nFirstFlash = -1;
        nLastFlash = -1;
    }

    public static void AddFlash(int sectnum, int x, int y, int ignored, int a5) {
        int nDepth = a5 >> 8;
        int nShade = 0;
        if (nDepth < nFlashDepth) {
            FlashStruct v23;
            int v37 = a5 & 0x80;
            int v42 = nDepth + 1 << 8 | a5 & 0xFF;
            Sector pSector = Main.boardService.getSector(sectnum);
            if (pSector == null) {
                return;
            }
            int v40 = 0;
            for (ListNode<Wall> wn = pSector.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall pWall = wn.get();
                int cx = (pWall.getWall2().getX() + pWall.getX()) / 2;
                int cy = (pWall.getWall2().getY() + pWall.getY()) / 2;
                short nNextSector = pWall.getNextsector();
                Sector pNextSector = nNextSector <= -1 ? null : Main.boardService.getSector(nNextSector);
                int v14 = -255;
                if ((a5 & 0x40) == 0) {
                    v14 = (Pragmas.klabs(x - cx) + Pragmas.klabs(y - cy) >> 4) - 255;
                }
                if (v14 >= 0) continue;
                ++v40;
                nShade += v14;
                if (pWall.getPal() >= 5 || pNextSector != null && pNextSector.getFloorz() >= pSector.getFloorz()) continue;
                FlashStruct pFlash = Light.GrabFlash();
                if (pFlash == null) {
                    return;
                }
                pFlash.field_0 = (byte)(v37 | 2);
                pFlash.nShade = pWall.getShade();
                pFlash.nObject = wn.getIndex();
                pWall.setShade((byte)Gameutils.BClipLow(v14 + pWall.getShade(), -127));
                pWall.setPal(pWall.getPal() + 7);
                if (nDepth != 0 || pWall.getOverpicnum() != 0 || pNextSector == null) continue;
                Light.AddFlash(pWall.getNextsector(), x, y, ignored, v42);
            }
            if (v40 == 0 || pSector.getFloorpal() >= 4) {
                return;
            }
            FlashStruct v21 = Light.GrabFlash();
            if (v21 == null) {
                return;
            }
            v21.field_0 = (byte)(v37 | 1);
            v21.nShade = pSector.getFloorshade();
            v21.nObject = sectnum;
            pSector.setFloorshade((byte)Gameutils.BClipLow(nShade + pSector.getFloorshade(), -127));
            pSector.setFloorpal(pSector.getFloorpal() + 7);
            if ((pSector.getCeilingstat() & 1) == 0 && pSector.getCeilingpal() < 4 && (v23 = Light.GrabFlash()) != null) {
                v23.field_0 = (byte)(v37 | 3);
                v23.nShade = pSector.getCeilingshade();
                v23.nObject = sectnum;
                pSector.setCeilingshade((byte)Gameutils.BClipLow(nShade + pSector.getCeilingshade(), -127));
                pSector.setCeilingpal(pSector.getCeilingpal() + 7);
            }
            for (ListNode<Sprite> node = Main.boardService.getSectNode(sectnum); node != null; node = node.getNext()) {
                FlashStruct pFlash;
                int j = node.getIndex();
                Sprite pSprite = node.get();
                if (pSprite.getPal() >= 4 || (pFlash = Light.GrabFlash()) == null) continue;
                pFlash.field_0 = (byte)(v37 | 4);
                pFlash.nShade = pSprite.getShade();
                pFlash.nObject = j;
                pSprite.setPal(pSprite.getPal() + 7);
                int v14 = -255;
                if ((a5 & 0x40) == 0) {
                    v14 = (Pragmas.klabs(x - pSprite.getX()) + Pragmas.klabs(y - pSprite.getY()) >> 4) - 255;
                }
                if (v14 >= 0) continue;
                pSprite.setShade((byte)Gameutils.BClipLow(pSprite.getShade() + v14, -127));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void UndoFlashes() {
        block17: {
            nNext = -1;
            if (Light.nFlashes == 0) break block17;
            i = Light.nFirstFlash;
            while (i >= 0) {
                v3 = Light.sFlash[i];
                nObject = v3.nObject;
                switch ((v3.field_0 & 63) - 1) {
                    case 0: {
                        sec = Main.boardService.getSector(nObject);
                        if (sec != null) {
                            if ((v3.field_0 & 128) != 0 && sec.getFloorshade() + 6 < v3.nShade) {
                                nNext = i;
                                sec.setFloorshade(sec.getFloorshade() + 6);
                                break;
                            }
                            sec.setFloorpal(sec.getFloorpal() - 7);
                            sec.setFloorshade(v3.nShade);
                        }
                        ** GOTO lbl47
                    }
                    case 1: {
                        wall = Main.boardService.getWall(nObject);
                        if (wall != null) {
                            if ((v3.field_0 & 128) != 0 && wall.getShade() + 6 < v3.nShade) {
                                nNext = i;
                                wall.setShade(wall.getShade() + 6);
                                break;
                            }
                            wall.setPal(wall.getPal() - 7);
                            wall.setShade(v3.nShade);
                        }
                        ** GOTO lbl47
                    }
                    case 2: {
                        sec = Main.boardService.getSector(nObject);
                        if (sec != null) {
                            if ((v3.field_0 & 128) != 0 && sec.getCeilingshade() + 6 < v3.nShade) {
                                nNext = i;
                                sec.setCeilingshade(sec.getCeilingshade() + 6);
                                break;
                            }
                            sec.setCeilingpal(sec.getCeilingpal() - 7);
                            sec.setCeilingshade(v3.nShade);
                        }
                        ** GOTO lbl47
                    }
                    case 3: {
                        spr = Main.boardService.getSprite(nObject);
                        if (spr != null && spr.getPal() >= 7) {
                            if ((v3.field_0 & 128) != 0 && spr.getShade() + 6 < v3.nShade) {
                                nNext = i;
                                spr.setShade(spr.getShade() + 6);
                                break;
                            }
                            spr.setPal(spr.getPal() - 7);
                            spr.setShade(v3.nShade);
                        }
                    }
lbl47:
                    // 7 sources

                    default: {
                        Light.nFreeFlash[--Light.nFlashes] = i;
                        if (nNext != -1) {
                            Light.nNextFlash[nNext] = Light.nNextFlash[i];
                        }
                        if (i == Light.nFirstFlash) {
                            Light.nFirstFlash = Light.nNextFlash[Light.nFirstFlash];
                        }
                        if (i != Light.nLastFlash) break;
                        Light.nLastFlash = nNext;
                    }
                }
                i = Light.nNextFlash[i];
            }
        }
    }

    public static void AddGlow(int a1, int a2) {
        if (nGlowCount < 50) {
            if (sGlow[nGlowCount] == null) {
                Light.sGlow[Light.nGlowCount] = new GrowStruct();
            }
            Light.sGlow[Light.nGlowCount].field_6 = a2;
            Light.sGlow[Light.nGlowCount].field_4 = a1;
            Light.sGlow[Light.nGlowCount].field_0 = -1;
            Light.sGlow[Light.nGlowCount].field_2 = 0;
            ++nGlowCount;
        }
    }

    public static void AddFlicker(int a1, int a2) {
        if (nFlickerCount < 100) {
            if (sFlicker[nFlickerCount] == null) {
                Light.sFlicker[Light.nFlickerCount] = new FlickerStruct();
            }
            Light.sFlicker[Light.nFlickerCount].field_0 = a2;
            Light.sFlicker[Light.nFlickerCount].field_2 = a1;
            if (a2 >= 25) {
                a2 = 24;
            }
            ++nFlickerCount;
            Light.sFlicker[v0].field_4 = flickermask[a2];
        }
    }

    public static void DoGlows() {
        if (++bDoGlows < 3) {
            return;
        }
        int v1 = 0;
        bDoGlows = 0;
        for (int v0 = 0; v0 < nGlowCount; ++v0) {
            Sector sec;
            int v2 = Light.sGlow[v1].field_2 + 1;
            int v3 = Light.sGlow[v1].field_4;
            Light.sGlow[v1].field_2 = v2;
            int v4 = Light.sGlow[v1].field_0;
            if (v2 >= Light.sGlow[v1].field_6) {
                Light.sGlow[v1].field_2 = 0;
                Light.sGlow[v1].field_0 = -Light.sGlow[v1].field_0;
            }
            if ((sec = Main.boardService.getSector(v3)) != null) {
                sec.setCeilingshade(sec.getCeilingshade() + v4);
                sec.setFloorshade(sec.getFloorshade() + v4);
                for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall w = wn.get();
                    w.setShade(w.getShade() + v4);
                }
            }
            ++v1;
        }
    }

    public static void DoFlickers() {
        if ((bDoFlicks ^= 1) == 0) {
            return;
        }
        int v1 = 0;
        for (int v0 = 0; v0 < nFlickerCount; ++v0) {
            int v2 = Light.sFlicker[v1].field_4 & 1;
            int v3 = Light.sFlicker[v1].field_2;
            int v4 = Light.sFlicker[v1].field_4 >>> 1 & 1;
            Light.sFlicker[v1].field_4 = Light.sFlicker[v1].field_4 << 31 | Light.sFlicker[v1].field_4 >>> 1;
            if ((v2 ^ v4) != 0) {
                Sector sec;
                int v5 = Light.sFlicker[v1].field_0;
                if (v2 == 0) {
                    v5 = -Light.sFlicker[v1].field_0;
                }
                if ((sec = Main.boardService.getSector(v3)) != null) {
                    sec.setCeilingshade(sec.getCeilingshade() + v5);
                    sec.setFloorshade(sec.getFloorshade() + v5);
                    for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                        Wall w = wn.get();
                        w.setShade(w.getShade() + v5);
                    }
                }
            }
            ++v1;
        }
    }

    public static void AddFlow(int nObject, int nVelocity, int nState) {
        if (nFlowCount < 375) {
            if (sFlowInfo[nFlowCount] == null) {
                Light.sFlowInfo[Light.nFlowCount] = new FlowStruct();
            }
            FlowStruct pFlow = sFlowInfo[nFlowCount];
            ++nFlowCount;
            switch (nState) {
                case 0: 
                case 1: {
                    Sprite pSprite = Main.boardService.getSprite(nObject);
                    nObject = pSprite != null ? (int)pSprite.getSectnum() : -1;
                    Sector pSector = Main.boardService.getSector(nObject);
                    if (pSector == null || pSprite == null) break;
                    pFlow.xmax = (Main.engine.getTile(pSector.getFloorpicnum()).getWidth() << 14) - 1;
                    pFlow.ymax = (Main.engine.getTile(pSector.getFloorpicnum()).getHeight() << 14) - 1;
                    pFlow.xvel = nVelocity * -EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF);
                    pFlow.yvel = nVelocity * EngineUtils.sin(pSprite.getAng() & 0x7FF);
                    break;
                }
                case 2: 
                case 3: {
                    Wall pWall;
                    int nDirection = 1536;
                    if (nState == 2) {
                        nDirection = 512;
                    }
                    if ((pWall = Main.boardService.getWall(nObject)) == null) break;
                    pFlow.xmax = pWall.getXrepeat() * Main.engine.getTile(pWall.getPicnum()).getWidth() << 8;
                    pFlow.ymax = pWall.getYrepeat() * Main.engine.getTile(pWall.getPicnum()).getHeight() << 8;
                    pFlow.xvel = nVelocity * -EngineUtils.sin(nDirection + 512 & 0x7FF);
                    pFlow.yvel = nVelocity * EngineUtils.sin(nDirection & 0x7FF);
                }
            }
            pFlow.ypanning = 0;
            pFlow.xpanning = 0;
            pFlow.nObject = nObject;
            pFlow.nState = nState;
        }
    }

    public static void DoFlows() {
        block6: for (int i = 0; i < nFlowCount; ++i) {
            FlowStruct pFlow = sFlowInfo[i];
            pFlow.xpanning += pFlow.xvel;
            pFlow.ypanning += pFlow.yvel;
            switch (pFlow.nState) {
                case 0: {
                    pFlow.xpanning &= pFlow.xmax;
                    pFlow.ypanning &= pFlow.ymax;
                    Sector sec = Main.boardService.getSector(pFlow.nObject);
                    if (sec == null) continue block6;
                    sec.setFloorxpanning(pFlow.xpanning >> 14);
                    sec.setFloorypanning(pFlow.ypanning >> 14);
                    continue block6;
                }
                case 1: {
                    Sector sec = Main.boardService.getSector(pFlow.nObject);
                    if (sec != null) {
                        sec.setCeilingxpanning(pFlow.xpanning >> 14);
                        sec.setCeilingypanning(pFlow.ypanning >> 14);
                    }
                    pFlow.xpanning &= pFlow.xmax;
                    pFlow.ypanning &= pFlow.ymax;
                    continue block6;
                }
                case 2: {
                    Wall wall = Main.boardService.getWall(pFlow.nObject);
                    if (wall != null) {
                        wall.setXpanning(pFlow.xpanning >> 14);
                        wall.setYpanning(pFlow.ypanning >> 14);
                    }
                    if (pFlow.xpanning < 0) {
                        pFlow.xpanning += pFlow.xmax;
                    }
                    if (pFlow.ypanning >= 0) continue block6;
                    pFlow.ypanning += pFlow.ymax;
                    continue block6;
                }
                case 3: {
                    Wall wall = Main.boardService.getWall(pFlow.nObject);
                    if (wall != null) {
                        wall.setXpanning(pFlow.xpanning >> 14);
                        wall.setYpanning(pFlow.ypanning >> 14);
                    }
                    if (pFlow.xpanning >= pFlow.xmax) {
                        pFlow.xpanning -= pFlow.xmax;
                    }
                    if (pFlow.ypanning < pFlow.ymax) continue block6;
                    pFlow.ypanning -= pFlow.ymax;
                }
            }
        }
    }

    public static void DoLights() {
        Light.DoFlickers();
        Light.DoGlows();
        Light.DoFlows();
    }

    public static void BuildFlash(int player, int ignored, int value) {
        if (player == Globals.nLocalPlayer) {
            Globals.flash = -value;
        }
    }

    public static void UseTorch(int nPlayer) {
        if (Globals.nPlayerTorch[nPlayer] == 0) {
            Main.engine.getPaletteManager().SetTorch(nPlayer, 1);
        }
        Globals.nPlayerTorch[nPlayer] = 900;
    }

    static {
        flickermask = new int[25];
        nFlashDepth = 2;
        nFirstFlash = -1;
        nLastFlash = -1;
        nFreeFlash = new int[2000];
        nNextFlash = new int[2000];
        sFlash = new FlashStruct[2000];
        sGlow = new GrowStruct[50];
        sFlicker = new FlickerStruct[100];
        sFlowInfo = new FlowStruct[375];
    }
}

