/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.Gdx;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Cinema;
import ru.m210projects.Powerslave.Enemies.Anubis;
import ru.m210projects.Powerslave.Enemies.Fish;
import ru.m210projects.Powerslave.Enemies.LavaDude;
import ru.m210projects.Powerslave.Enemies.Lion;
import ru.m210projects.Powerslave.Enemies.Mummy;
import ru.m210projects.Powerslave.Enemies.Queen;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Enemies.Rat;
import ru.m210projects.Powerslave.Enemies.Rex;
import ru.m210projects.Powerslave.Enemies.Roach;
import ru.m210projects.Powerslave.Enemies.Scorp;
import ru.m210projects.Powerslave.Enemies.Set;
import ru.m210projects.Powerslave.Enemies.Spider;
import ru.m210projects.Powerslave.Enemies.Wasp;
import ru.m210projects.Powerslave.Energy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Grenade;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.LoadSave;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Screens.DemoScreen;
import ru.m210projects.Powerslave.Slide;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.SpiritHead;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Switch;
import ru.m210projects.Powerslave.Type.BobStruct;
import ru.m210projects.Powerslave.Type.BubbleMachineStruct;
import ru.m210projects.Powerslave.Type.TrailPointStruct;
import ru.m210projects.Powerslave.Type.TrailStruct;
import ru.m210projects.Powerslave.Type.TrapStruct;
import ru.m210projects.Powerslave.Weapons;

public class Map {
    public static int nPushBlocks;
    public static int nRegenerates;
    public static int nFirstRegenerate;
    public static int nSwitchSound;
    public static int nStoneSound;
    public static int nElevSound;
    public static int nStopSound;
    public static int ldMapZoom;
    public static int lMapZoom;
    public static int nTraps;
    public static final TrapStruct[] sTrap;
    public static final int[] nTrapInterval;
    private static final Runnable showCredits;
    private static final Runnable toNextMap;
    private static final int[] word_14032;

    public static void checkNextMap() {
        if (Globals.gCurrentEpisode == Globals.gOriginalEpisode) {
            if (Globals.nNetPlayerCount == 0 && !DemoScreen.isDemoPlaying() && Globals.levelnew > 0 && Globals.levelnew <= 20) {
                if (Globals.levelnum > Globals.nBestLevel) {
                    Globals.nBestLevel = Globals.levelnum;
                }
                Main.gMap.showMap(Globals.levelnum, Globals.levelnew, Globals.nBestLevel);
            }
        } else if (Globals.mUserFlag != Main.UserFlag.UserMap && Globals.levelnew > 0) {
            if (Globals.levelnew <= Globals.gCurrentEpisode.maps()) {
                if (Globals.levelnum > Globals.nBestLevel) {
                    Globals.nBestLevel = Globals.levelnum;
                }
                if (Globals.levelnew > 1 || LoadSave.gClassicMode) {
                    LoadSave.gAutosaveRequest = true;
                }
                Main.gGameScreen.changemap(Globals.levelnew, null);
            } else {
                Gdx.app.postRunnable(showCredits);
            }
        }
    }

    public static void FinishLevel() {
        Globals.bCamera = false;
        Globals.bMapMode = false;
        Sound.StopAllSounds();
        if (Globals.gCurrentEpisode != Globals.gOriginalEpisode || Globals.levelnum != 20) {
            Sound.SetLocalChan(1);
            Sound.PlayLocalSound(Sound.StaticSound[59], 0);
            Sound.SetLocalChan(0);
        }
        if (Globals.mUserFlag == Main.UserFlag.UserMap || Globals.gCurrentEpisode == Globals.gTrainingEpisode) {
            Gdx.app.postRunnable(() -> {
                Globals.nPlayerLives[0] = 0;
                Main.game.EndGame();
            });
        } else if (Globals.gCurrentEpisode == Globals.gOriginalEpisode) {
            if (!Cinema.DoAfterCinemaScene(Globals.levelnum, Globals.levelnum == 20 ? showCredits : toNextMap)) {
                Globals.levelnew = Globals.levelnum + 1;
            }
        } else {
            Globals.levelnew = Globals.levelnum + 1;
        }
    }

    public static void UpdateMap() {
        Sector sec = Main.boardService.getSector(Globals.initsect);
        if (sec != null && (sec.getCeilingpal() != 3 || Globals.nPlayerTorch[Globals.nLocalPlayer] != 0)) {
            Map.MarkSectorSeen(Globals.initsect);
        }
    }

    private static void MarkSectorSeen(int sect) {
        if (!Engine.show2dsector.getBit(sect)) {
            Engine.show2dsector.setBit(sect);
            Sector sec = Main.boardService.getSector(sect);
            if (sec != null) {
                int startwall = sec.getWallptr();
                int endwall = startwall + sec.getWallnum();
                for (int j = startwall; j < endwall; ++j) {
                    Engine.show2dwall.setBit(j);
                }
            }
        }
    }

    public static void GrabMap() {
        for (int i = 0; i < Main.boardService.getSectorCount(); ++i) {
            Map.MarkSectorSeen(i);
        }
    }

    public static boolean LoadLevel(Entry entry, int num) {
        try {
            Board board = Main.engine.loadboard(entry);
            if (num == 20) {
                Globals.lCountDown = 81000;
                Globals.nAlarmTicks = 30;
                Globals.nRedTicks = 0;
                Globals.nClockVal = 0;
                Globals.nEnergyTowers = 0;
            }
            Globals.nCreaturesLeft = 0;
            Globals.nCreaturesMax = 0;
            Globals.nFreeze = 0;
            SpiritHead.nSpiritSprite = -1;
            Lion.InitLion();
            Rex.InitRexs();
            Set.InitSets();
            Queen.InitQueens();
            Roach.InitRoach();
            Wasp.InitWasps();
            Rat.InitRats();
            Bullet.InitBullets();
            Weapons.InitWeapons();
            Grenade.InitGrenades();
            Anim.InitAnims();
            Snake.InitSnakes();
            Fish.InitFishes();
            Light.InitLights();
            Map.InitMap();
            Sprites.InitBubbles();
            Map.InitObjects();
            LavaDude.InitLava();
            nPushBlocks = 0;
            Anubis.InitAnubis();
            Spider.InitSpider();
            Mummy.InitMummy();
            Scorp.InitScorp();
            Map.InitPlayer();
            nRegenerates = 0;
            nFirstRegenerate = -1;
            Globals.nMagicCount = 0;
            if (num == 20) {
                Energy.InitEnergyTile();
            }
            if (num <= 15) {
                nSwitchSound = 33;
                nStoneSound = 23;
                nElevSound = 23;
                nStopSound = 66;
            } else {
                nSwitchSound = 35;
                nStoneSound = 23;
                nElevSound = 51;
                nStopSound = 35;
            }
            BuildPos out = board.getPos();
            Globals.initx = out.x;
            Globals.inity = out.y;
            Globals.initz = out.z;
            Globals.inita = out.ang;
            Globals.initsect = out.sectnum;
            Engine.pskyoff[0] = 0;
            Engine.pskyoff[1] = 0;
            Engine.pskyoff[2] = 0;
            Engine.pskyoff[3] = 0;
            Engine.parallaxtype = 0;
            Engine.visibility = 1024;
            Renderer renderer = Main.game.getRenderer();
            renderer.setParallaxOffset(256);
            Globals.flash = 0;
            Engine.pskybits = (short)2;
            Map.LoadObjects();
            Globals.levelnum = num;
            return true;
        }
        catch (Exception e) {
            Console.out.println("Load map exception: " + e);
            if (e.getMessage() != null) {
                Main.game.GameMessage("Load map exception:\n" + e.getMessage());
            } else {
                Main.game.GameMessage("Can't load the map " + entry);
            }
            return false;
        }
    }

    public static void LoadObjects() {
        short lotag;
        RunList.InitRun();
        RunList.InitChan();
        PSSector.LinkCount = 1024;
        Slide.InitPoint();
        Slide.InitSlide();
        Switch.InitSwitch();
        Object.InitElev();
        Object.InitWallFace();
        Map.InitSectFlag();
        Sector[] sectors = Main.boardService.getBoard().getSectors();
        for (int i = 0; i < sectors.length; i = (int)((short)(i + 1))) {
            Sector sec = sectors[i];
            short hitag = sec.getHitag();
            lotag = sec.getLotag();
            sec.setHitag(0);
            sec.setLotag(0);
            sec.setExtra(-1);
            if (hitag == 0 && lotag == 0) continue;
            sec.setLotag(RunList.HeadRun() + 1);
            sec.setHitag(lotag);
            PSSector.ProcessSectorTag(i, lotag, hitag);
        }
        Wall[] walls = Main.boardService.getBoard().getWalls();
        for (short j = 0; j < walls.length; j = (short)((short)(j + 1))) {
            Wall wal = walls[j];
            wal.setExtra(-1);
            lotag = wal.getLotag();
            wal.setLotag(0);
            if (wal.getHitag() == 0 && lotag == 0) continue;
            wal.setLotag(RunList.HeadRun() + 1);
            Map.ProcessWallTag(j, lotag, wal.getHitag());
        }
        Map.ExamineSprites();
        Map.PostProcess();
        Ra.InitRa();
        Sprites.InitChunks();
        for (int i = 0; i < 4096; i = (int)((short)(i + 1))) {
            RunList.ChangeChannel(i, 0);
            RunList.ReadyChannel(i);
        }
        Globals.nCamerax = Globals.initx;
        Globals.nCameray = Globals.inity;
        Globals.nCameraz = Globals.initz;
    }

    public static void PostProcess() {
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        while (true) {
            int v3;
            if (v1 >= Globals.nMoveSects) {
                int v9 = 0;
                int v42 = 0;
                int v36 = 0;
                while (v9 < Globals.nBobs) {
                    if (Globals.sBob[v42].field_3 == 0) {
                        int v11 = 0;
                        int v45 = Globals.sBobID[v36];
                        for (int v10 = 0; v10 < Globals.nBobs; ++v10) {
                            if (v10 != v9 && Globals.sBob[v42].field_3 != 0 && v45 == Globals.sBobID[v11]) {
                                PSSector.SnapSectors(v9, v10, 0);
                            }
                            ++v11;
                        }
                    }
                    ++v9;
                    ++v42;
                    ++v36;
                }
                if (Globals.levelnew == 20) {
                    int v12 = 0;
                    int v13 = 0;
                    int v43 = 0;
                    while (v12 < Main.boardService.getSectorCount()) {
                        Sector sec = Main.boardService.getSector(v13);
                        if (sec == null) continue;
                        short v14 = sec.getWallptr();
                        short v15 = sec.getWallnum();
                        Globals.SectSoundSect[v43] = v12;
                        short v16 = v14;
                        int v17 = v14 + v15;
                        Globals.SectSound[v43] = Sound.StaticSound[62];
                        while (v16 < v17) {
                            Wall wall = Main.boardService.getWall(v16);
                            if (wall != null && wall.getPicnum() == 3603) {
                                wall.setPal(1);
                                int i = Main.engine.insertsprite(v12, 407);
                                Sprite spr = Main.boardService.getSprite(i);
                                if (spr != null) {
                                    spr.setCstat(32768);
                                }
                            }
                            v16 = (short)(v16 + 1);
                            v14 = (short)(v14 + 1);
                        }
                        ++v13;
                        ++v12;
                        ++v43;
                    }
                    int v19 = 0;
                    int v20 = 0;
                    do {
                        Sprite spr;
                        if ((spr = Main.boardService.getSprite(v20)) != null && spr.getStatnum() < 1024 && spr.getPicnum() == 3603) {
                            Main.engine.changespritestat(v19, 407);
                            spr.setPal(1);
                        }
                        ++v20;
                    } while (++v19 < 4096);
                } else {
                    int v21 = 0;
                    int v40 = 0;
                    int v37 = 0;
                    int v35 = 0;
                    while (v21 < Main.boardService.getSectorCount()) {
                        int v44 = 30000;
                        if (Globals.SectSpeed[v37] != 0 && Globals.SectDepth[v40] != 0 && (Globals.SectFlag[v37] & 0x4000) == 0) {
                            Globals.SectSoundSect[v37] = v21;
                            Globals.SectSound[v37] = Sound.StaticSound[43];
                        } else {
                            int v22 = 0;
                            int v23 = 0;
                            int v39 = 0;
                            while (v22 < Main.boardService.getSectorCount()) {
                                if (v21 != v22 && Globals.SectSpeed[v23] != 0 && (Globals.SectFlag[v37] & 0x4000) == 0) {
                                    Sector s1 = Main.boardService.getSector(v35);
                                    Sector s2 = Main.boardService.getSector(v39);
                                    if (s1 != null && s2 != null) {
                                        Wall w1 = Main.boardService.getWall(s1.getWallptr());
                                        Wall w2 = Main.boardService.getWall(s2.getWallptr());
                                        if (w1 != null && w2 != null) {
                                            int v28;
                                            int v41;
                                            int v26 = v41 = w1.getX() - w2.getX();
                                            if (v41 < 0) {
                                                v26 = -v41;
                                            }
                                            int v38 = v26;
                                            int v27 = w1.getY() - w2.getY();
                                            if (v27 < 0) {
                                                v27 = -v27;
                                            }
                                            if (v38 < 15000 && v27 < 15000 && (v28 = v38 + v27) < v44) {
                                                int v29 = Sound.StaticSound[43];
                                                v44 = v28;
                                                Globals.SectSoundSect[v37] = v22;
                                                Globals.SectSound[v37] = v29;
                                            }
                                        }
                                    }
                                }
                                ++v23;
                                ++v22;
                                ++v39;
                            }
                        }
                        ++v21;
                        ++v40;
                        ++v37;
                        ++v35;
                    }
                }
                int v30 = 0;
                int v31 = 0;
                while (true) {
                    if (v30 >= Globals.ObjectCount) {
                        return;
                    }
                    Sprite spr = Main.boardService.getSprite(Globals.ObjectList[v31].field_6);
                    if (spr != null && spr.getStatnum() == 152) {
                        if (Globals.ObjectList[v31].obj_A != 0) {
                            int v32 = Globals.ObjectList[v31].obj_A;
                            int v34 = 0;
                            Globals.ObjectList[v31].obj_A = -1;
                            for (int v33 = 0; v33 < Globals.ObjectCount; v33 = (int)((short)(v33 + 1))) {
                                if (v33 != v30 && spr.getStatnum() == 152 && v32 == Globals.ObjectList[v34].obj_A) {
                                    Globals.ObjectList[v31].obj_A = v33;
                                    Globals.ObjectList[v34].obj_A = v30;
                                    break;
                                }
                                ++v34;
                            }
                        } else {
                            Globals.ObjectList[v31].obj_A = -1;
                        }
                    }
                    ++v31;
                    v30 = (short)(v30 + 1);
                }
            }
            Globals.sMoveSect[v0].field_4 = Globals.sTrail[Globals.sMoveSect[v0].field_2].field_0;
            if ((Globals.sMoveSect[v0].field_6 & 0x40) != 0) {
                RunList.ChangeChannel(Globals.sMoveSect[v0].field_E, 1);
            }
            if ((Globals.SectFlag[v3 = Globals.sMoveSect[v0].field_0] & 0x2000) != 0) {
                Sector v4 = Main.boardService.getSector(v3);
                if (v4 != null) {
                    v4.setCeilingstat(v4.getCeilingstat() | 0x40);
                    v4.setFloorstat(v4.getFloorstat() & 0xFFFFFFBF);
                }
                int v6 = 0;
                for (int v5 = 0; v5 < Globals.nMoveSects; ++v5) {
                    if (v1 != v5 && Globals.sMoveSect[v0].field_2 == Globals.sMoveSect[v6].field_2) {
                        int v7 = Globals.sMoveSect[v0].field_0;
                        Globals.sMoveSect[v6].field_8 = Globals.sMoveSect[v0].field_0;
                        PSSector.SnapSectors(Globals.sMoveSect[v6].field_0, v7, 0);
                        Globals.sMoveSect[v2].field_0 = v5;
                        break;
                    }
                    ++v6;
                }
            }
            ++v2;
            ++v1;
            ++v0;
        }
    }

    public static void InitSectFlag() {
        for (int i = 0; i < 1024; ++i) {
            Globals.SectSoundSect[i] = -1;
            Globals.SectSound[i] = -1;
            Globals.SectAbove[i] = -1;
            Globals.SectBelow[i] = -1;
            Globals.SectDepth[i] = 0;
            Globals.SectFlag[i] = 0;
            Globals.SectSpeed[i] = 0;
            Globals.SectDamage[i] = 0;
        }
    }

    public static void InitObjects() {
        Globals.ObjectCount = 0;
        nTraps = 0;
        Globals.nDrips = 0;
        Globals.nBobs = 0;
        Globals.nTrails = 0;
        Globals.nTrailPoints = 0;
        Globals.nMoveSects = 0;
        Globals.nEnergyBlocks = 0;
        Globals.nDronePitch = 0;
        Globals.nFinaleStage = 0;
        Globals.lFinaleStart = 0;
        Globals.nSmokeSparks = 0;
        for (int i = 0; i < 40; ++i) {
            if (Globals.sTrail[i] == null) {
                Globals.sTrail[i] = new TrailStruct();
            }
            Globals.sTrail[i].clear();
        }
    }

    public static void InitMap() {
        Engine.show2dsector.clear();
        Engine.show2dwall.clear();
        Engine.show2dsprite.clear();
        ldMapZoom = 64;
        lMapZoom = 1000;
    }

    public static void InitPlayer() {
        for (int i = 0; i < 8; ++i) {
            Globals.PlayerList[i].spriteId = -1;
            Globals.PlayerList[i].crouch_toggle = false;
        }
    }

    public static void SnapBobs(int a1, int a2) {
        int v3 = -1;
        int v6 = -1;
        for (int v4 = 0; v4 < Globals.nBobs; ++v4) {
            int v8;
            int v7 = Globals.sBob[v4].field_0;
            if (v7 == a1) {
                v8 = v3;
                v6 = v4;
            } else {
                if (a2 != v7) continue;
                v8 = v6;
                v3 = v4;
            }
            if (v8 != -1) break;
        }
        if (v3 == -1 && v6 == -1) {
            return;
        }
        Globals.sBob[v3].field_2 = Globals.sBob[v6].field_2;
    }

    public static void BuildBubbleMachine(int a1) {
        if (Globals.nMachineCount >= 125) {
            throw new AssertException("too many bubble machines in level " + Globals.levelnew);
        }
        if (Globals.Machine[Globals.nMachineCount] == null) {
            Globals.Machine[Globals.nMachineCount] = new BubbleMachineStruct();
        }
        BubbleMachineStruct v2 = Globals.Machine[Globals.nMachineCount];
        v2.field_4 = 75;
        v2.field_2 = a1;
        v2.field_0 = v2.field_4;
        ++Globals.nMachineCount;
        Sprite pSprite = Main.boardService.getSprite(a1);
        if (pSprite != null) {
            pSprite.setCstat(32768);
        }
    }

    public static void AddSectorBob(int a1, int a2, int a3) {
        if (Globals.nBobs >= 200) {
            throw new AssertException("Too many bobs!");
        }
        if (Globals.sBob[Globals.nBobs] == null) {
            Globals.sBob[Globals.nBobs] = new BobStruct();
        }
        Sector sec = Main.boardService.getSector(a1);
        Globals.sBob[Globals.nBobs].field_3 = (byte)a3;
        if (sec != null) {
            int nSector = a3 != 0 ? sec.getCeilingz() : sec.getFloorz();
            Globals.sBob[Globals.nBobs].field_4 = nSector;
        }
        Globals.sBob[Globals.nBobs].field_2 = (byte)(16 * a2);
        Globals.sBobID[Globals.nBobs] = a2;
        Globals.sBob[Globals.nBobs].field_0 = a1;
        int n = a1;
        Globals.SectFlag[n] = Globals.SectFlag[n] | 0x1000;
        ++Globals.nBobs;
    }

    public static void ProcessWallTag(short wallnum, int nLotag, int nHitag) {
        int real_chan = RunList.AllocChannel(nHitag % 1000);
        if (real_chan < 0 || real_chan >= 4096) {
            throw new AssertException("real_chan>=0 && real_chan <MAXCHAN");
        }
        int nVelocity = nLotag / 1000;
        if (nVelocity == 0) {
            nVelocity = 1;
        }
        Wall[] walls = Main.boardService.getBoard().getWalls();
        Wall wall = walls[wallnum];
        switch (nLotag % 1000) {
            case 1: {
                RunList.AddRunRec(RunList.channel[real_chan].head, Object.BuildWallFace(real_chan, wallnum, 2, wall.getPicnum(), wall.getPicnum() + 1));
                RunList.AddRunRec(RunList.channel[real_chan].head, Switch.BuildSwPressWall(real_chan, PSSector.BuildLink(2, 1, 0), wallnum));
                return;
            }
            case 6: {
                RunList.AddRunRec(RunList.channel[real_chan].head, Switch.BuildSwPressWall(real_chan, PSSector.BuildLink(2, 1, 0), wallnum));
                return;
            }
            case 7: {
                RunList.AddRunRec(RunList.channel[real_chan].head, Object.BuildWallFace(real_chan, wallnum, 2, wall.getPicnum(), wall.getPicnum() + 1));
                RunList.AddRunRec(RunList.channel[real_chan].head, Switch.BuildSwPressWall(real_chan, PSSector.BuildLink(1, 1), wallnum));
                return;
            }
            case 8: {
                RunList.AddRunRec(RunList.channel[real_chan].head, Object.BuildWallFace(real_chan, wallnum, 2, wall.getPicnum(), wall.getPicnum() + 1));
                RunList.AddRunRec(RunList.channel[real_chan].head, Switch.BuildSwPressWall(real_chan, PSSector.BuildLink(2, -1, 0), wallnum));
                return;
            }
            case 9: {
                RunList.AddRunRec(RunList.channel[real_chan].head, Switch.BuildSwPressWall(real_chan, PSSector.BuildLink(2, 1, 1), wallnum));
                return;
            }
            case 10: {
                RunList.AddRunRec(RunList.channel[real_chan].head, Switch.BuildSwPressWall(real_chan, PSSector.BuildLink(2, -1, 0), wallnum));
                return;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                short w1 = 0;
                short w2 = 0;
                short i = wall.getPoint2();
                while (i != wallnum) {
                    w2 = w1;
                    w1 = i;
                    i = walls[i].getPoint2();
                }
                RunList.AddRunRec(RunList.channel[real_chan].head, Slide.BuildSlide(real_chan, wallnum, w1, w2, wall.getPoint2(), walls[wall.getPoint2()].getPoint2(), walls[walls[wall.getPoint2()].getPoint2()].getPoint2()));
                return;
            }
            case 24: {
                Light.AddFlow(wallnum, 4 * nVelocity, 3);
                return;
            }
            case 25: {
                Light.AddFlow(wallnum, 4 * nVelocity, 2);
            }
        }
    }

    public static void ProcessTrailSprite(int spritenum, int a2, int a3) {
        Sprite pSprite;
        if (Globals.nTrailPoints >= 100) {
            throw new AssertException("Too many trail point sprites (900-949)... increase MAX_TRAILPOINT");
        }
        int p = Globals.nTrailPoints;
        if (Globals.sTrailPoint[p] == null) {
            Globals.sTrailPoint[p] = new TrailPointStruct();
        }
        if ((pSprite = Main.boardService.getSprite(spritenum)) == null) {
            return;
        }
        Globals.sTrailPoint[p].x = pSprite.getX();
        Globals.sTrailPoint[p].y = pSprite.getY();
        ++Globals.nTrailPoints;
        int v8 = Object.FindTrail(a3);
        int v9 = Globals.sTrail[v8].field_0;
        Globals.nTrailPointVal[p] = a2 + 124 & 0xFF;
        if (v9 == -1) {
            Globals.sTrail[v8].field_0 = p;
            Globals.sTrail[v8].field_4 = p;
            Globals.nTrailPointNext[p] = -1;
            Globals.nTrailPointPrev[p] = -1;
        } else {
            int v10 = -1;
            while (v9 != -1) {
                int v11 = v9;
                if (Globals.nTrailPointVal[v9] > a2 - 900) {
                    Globals.nTrailPointPrev[p] = Globals.nTrailPointPrev[v11];
                    Globals.nTrailPointPrev[v11] = p;
                    Globals.nTrailPointNext[p] = v9;
                    if (v9 != Globals.sTrail[v8].field_0) break;
                    Globals.sTrail[v8].field_0 = p;
                    break;
                }
                v10 = v9;
                v9 = Globals.nTrailPointNext[v9];
            }
            if (v9 == -1) {
                Globals.nTrailPointNext[v10] = p;
                Globals.nTrailPointPrev[p] = v10;
                Globals.nTrailPointNext[p] = -1;
                Globals.sTrail[v8].field_4 = p;
            }
        }
        Main.engine.deletesprite(spritenum);
    }

    public static void BuildItemAnim(int a1) {
        Sprite sprite = Main.boardService.getSprite(a1);
        if (sprite == null) {
            return;
        }
        int v4 = sprite.getStatnum() - 906;
        if (Globals.nItemAnimInfo[v4].field_0 < 0) {
            int v9 = Globals.nItemAnimInfo[v4].field_2;
            sprite.setOwner(-1);
            sprite.setYrepeat(v9);
            sprite.setXrepeat(v9);
        } else {
            int v10 = Anim.BuildAnim(a1, 41, Globals.nItemAnimInfo[v4].field_0, sprite.getX(), sprite.getY(), sprite.getZ(), sprite.getSectnum(), Globals.nItemAnimInfo[v4].field_2, 20);
            int v6 = Anim.GetAnimSprite(v10);
            Sprite spr2 = Main.boardService.getSprite(v6);
            if (spr2 == null) {
                return;
            }
            if (v4 == 44) {
                spr2.setCstat(spr2.getCstat() | 2);
            }
            Main.engine.changespritestat(v6, sprite.getStatnum());
            spr2.setOwner(v10);
            spr2.setHitag(sprite.getHitag());
        }
    }

    public static void SetBelow(int a1, int a2) {
        Globals.SectBelow[a1] = a2;
    }

    public static void SetAbove(int a1, int a2) {
        Globals.SectAbove[a1] = a2;
    }

    public static void ProcessSpriteTag(int nSprite, int nStatnum, int a3) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if ((pSprite.getCstat() & 0x30) == 48) {
            pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFCF);
        }
        int ch = RunList.AllocChannel(a3 % 1000);
        if (nStatnum < 6 || nStatnum > 60) {
            if (nStatnum >= 900 && nStatnum <= 949) {
                Map.ProcessTrailSprite(nSprite, nStatnum, a3);
                return;
            }
            int nVelocity = nStatnum / 1000;
            if (nVelocity == 0) {
                nVelocity = 1;
            }
            int v7 = nStatnum % 1000;
            if (!Globals.bNoCreatures || v7 < 100 || v7 > 118) {
                int v8;
                int v9 = 0;
                for (v8 = 39; v8 >= 0 && v9 < word_14032.length && word_14032[v9++] != v7 - 61; --v8) {
                }
                switch (v8) {
                    case 0: {
                        Main.engine.mydeletesprite(nSprite);
                        return;
                    }
                    case 1: {
                        SpiritHead.nSpiritSprite = nSprite;
                        pSprite.setCstat(pSprite.getCstat() | 0x8000);
                        return;
                    }
                    case 2: {
                        Globals.nNetStartSprite[Globals.nNetStartSprites] = nSprite;
                        pSprite.setCstat(32768);
                        ++Globals.nNetStartSprites;
                        return;
                    }
                    case 3: {
                        Main.engine.changespritestat(nSprite, 405);
                        pSprite.setCstat(32768);
                        return;
                    }
                    case 4: {
                        Object.BuildDrip(nSprite);
                        return;
                    }
                    case 5: {
                        RunList.AddRunRec(RunList.channel[ch].head, Object.BuildFireBall(nSprite, a3, nVelocity));
                        return;
                    }
                    case 6: {
                        Object.BuildObject(nSprite, 1, a3);
                        return;
                    }
                    case 7: {
                        Object.BuildObject(nSprite, 0, a3);
                        return;
                    }
                    case 8: {
                        RunList.AddRunRec(RunList.channel[ch].head, Object.BuildArrow(nSprite, nVelocity));
                        return;
                    }
                    case 9: {
                        Light.AddFlow(nSprite, nVelocity, 1);
                        short s = pSprite.getSectnum();
                        Globals.SectFlag[s] = Globals.SectFlag[s] | 0x320;
                        Main.engine.mydeletesprite(nSprite);
                        return;
                    }
                    case 10: 
                    case 13: {
                        Globals.SectSpeed[pSprite.getSectnum()] = nVelocity;
                        Globals.SectFlag[pSprite.getSectnum()] = pSprite.getAng() | Globals.SectFlag[pSprite.getSectnum()];
                        Main.engine.mydeletesprite(nSprite);
                        return;
                    }
                    case 11: {
                        short s = pSprite.getSectnum();
                        Globals.SectFlag[s] = Globals.SectFlag[s] | 0x2000;
                        Main.engine.mydeletesprite(nSprite);
                        return;
                    }
                    case 12: {
                        Light.AddFlow(nSprite, nVelocity, 0);
                        break;
                    }
                    case 14: {
                        Object.BuildObject(nSprite, 3, a3);
                        return;
                    }
                    case 15: {
                        Map.BuildBubbleMachine(nSprite);
                        return;
                    }
                    case 16: {
                        Globals.SectDepth[pSprite.getSectnum()] = a3 << 8;
                        break;
                    }
                    case 17: {
                        Map.AddSectorBob(pSprite.getSectnum(), a3, 0);
                        break;
                    }
                    case 18: {
                        int v20 = a3 >> 2;
                        if (v20 == 0) {
                            v20 = 1;
                        }
                        short s = pSprite.getSectnum();
                        Globals.SectFlag[s] = Globals.SectFlag[s] | 0x4000;
                        Globals.SectDamage[pSprite.getSectnum()] = v20;
                        Main.engine.mydeletesprite(nSprite);
                        return;
                    }
                    case 19: {
                        Map.AddSectorBob(pSprite.getSectnum(), a3, 1);
                        break;
                    }
                    case 20: {
                        Map.SetBelow(pSprite.getSectnum(), a3);
                        PSSector.SnapSectors(pSprite.getSectnum(), a3, 1);
                        break;
                    }
                    case 21: {
                        Map.SetAbove(pSprite.getSectnum(), a3);
                        short s = pSprite.getSectnum();
                        Globals.SectFlag[s] = Globals.SectFlag[s] | 0x2000;
                        break;
                    }
                    case 22: {
                        if (Globals.bNoCreatures) break;
                        Anubis.BuildAnubis(nSprite, 0, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 23: {
                        if (Globals.bNoCreatures) break;
                        Mummy.BuildMummy(nSprite, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 24: {
                        if (Globals.bNoCreatures) break;
                        Lion.BuildLion(nSprite, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 25: {
                        if (Globals.bNoCreatures) break;
                        Roach.BuildRoach(0, nSprite, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 26: {
                        if (Globals.bNoCreatures) break;
                        Roach.BuildRoach(1, nSprite, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 27: {
                        if (Globals.bNoCreatures) break;
                        Spider.BuildSpider(nSprite, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 28: {
                        if (Globals.bNoCreatures) break;
                        Fish.BuildFish(nSprite, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 29: {
                        if (Globals.bNoCreatures) break;
                        Rex.BuildRex(nSprite, 0, 0, 0, 0, 0, ch);
                        return;
                    }
                    case 30: {
                        if (Globals.bNoCreatures) break;
                        LavaDude.BuildLava(nSprite, 0, 0, 0, 0, ch);
                        return;
                    }
                    case 31: {
                        if (Globals.bNoCreatures) break;
                        Set.BuildSet(nSprite, 0, 0, 0, 0, 0, ch);
                        return;
                    }
                    case 32: {
                        Scorp.BuildScorp(nSprite, 0, 0, 0, 0, 0, ch);
                        return;
                    }
                    case 33: {
                        Queen.BuildQueen(nSprite, 0, 0, 0, 0, 0, ch);
                        return;
                    }
                    case 34: {
                        Rat.BuildRat(nSprite, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 35: {
                        Rat.BuildRat(nSprite, 0, 0, 0, 0, -1);
                        return;
                    }
                    case 36: {
                        if (Globals.bNoCreatures) break;
                        Wasp.BuildWasp(nSprite, 0, 0, 0, 0, 0);
                        return;
                    }
                    case 37: {
                        if (Globals.bNoCreatures) break;
                        Anubis.BuildAnubis(nSprite, 0, 0, 0, 0, 0, 1);
                        return;
                    }
                    case 38: {
                        Light.AddGlow(pSprite.getSectnum(), nVelocity);
                        break;
                    }
                    case 39: {
                        Light.AddFlicker(pSprite.getSectnum(), nVelocity);
                    }
                }
            }
        } else {
            if (nStatnum < 16) {
                if (nStatnum < 12) {
                    if (nStatnum == 8) {
                        a3 = 3 * (a3 / 3);
                    }
                } else if (nStatnum == 12) {
                    a3 = 40;
                } else if (nStatnum == 13) {
                    a3 = 160;
                } else if (nStatnum == 14) {
                    a3 = -200;
                }
                pSprite.setHitag(a3);
                Main.engine.changespritestat(nSprite, nStatnum + 900);
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                Map.BuildItemAnim(nSprite);
                return;
            }
            if (nStatnum > 16) {
                if (!LoadSave.gClassicMode) {
                    switch (nStatnum) {
                        case 25: {
                            int index;
                            while (!Map.changeitem(nSprite, index = (int)(7.0 + 44.0 * Math.random()))) {
                            }
                            Main.engine.changespritestat(nSprite, index + 900);
                            pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                            Map.BuildItemAnim(nSprite);
                            return;
                        }
                        case 59: {
                            Main.engine.mydeletesprite(nSprite);
                            return;
                        }
                    }
                }
                if (nStatnum == 27) {
                    pSprite.setHitag(1);
                    Main.engine.changespritestat(nSprite, 909);
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                    Map.BuildItemAnim(nSprite);
                    return;
                }
                if ((nStatnum == 25 || nStatnum == 59) && Globals.nNetPlayerCount != 0) {
                    Main.engine.mydeletesprite(nSprite);
                    return;
                }
                pSprite.setHitag(a3);
                Main.engine.changespritestat(nSprite, nStatnum + 900);
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                Map.BuildItemAnim(nSprite);
                return;
            }
        }
        Main.engine.mydeletesprite(nSprite);
    }

    public static boolean changeitem(int spr, int index) {
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            return false;
        }
        switch (index) {
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: 
            case 38: 
            case 49: {
                pSprite.setHitag(1);
                return true;
            }
            case 50: {
                pSprite.setHitag(10);
                return true;
            }
            case 6: {
                pSprite.setHitag(6);
                pSprite.setPicnum(877);
                return true;
            }
            case 7: {
                pSprite.setHitag(25);
                pSprite.setPicnum(879);
                return true;
            }
            case 8: {
                pSprite.setHitag(50);
                pSprite.setPicnum(882);
                return true;
            }
            case 27: {
                pSprite.setHitag(1);
                pSprite.setPicnum(878);
                return true;
            }
            case 20: {
                pSprite.setHitag(1);
                pSprite.setPicnum(752);
                return true;
            }
            case 23: {
                pSprite.setHitag(1);
                pSprite.setPicnum(754);
                return true;
            }
            case 28: {
                pSprite.setHitag(6);
                pSprite.setPicnum(488);
                return true;
            }
            case 29: {
                pSprite.setHitag(1);
                pSprite.setPicnum(490);
                return true;
            }
            case 30: {
                pSprite.setHitag(1);
                pSprite.setPicnum(491);
                return true;
            }
            case 32: {
                pSprite.setPicnum(899);
                pSprite.setHitag(1);
                return true;
            }
            case 33: {
                pSprite.setHitag(1);
                pSprite.setPicnum(3455);
                return true;
            }
        }
        return false;
    }

    public static void ExamineSprites() {
        Sprite spr;
        int i;
        Globals.nNetStartSprites = 0;
        Globals.nCurStartSprite = 0;
        for (i = 0; i < 4096; i = (int)((short)(i + 1))) {
            spr = Main.boardService.getSprite(i);
            if (spr == null || spr.getStatnum() != 0) continue;
            if (spr.getLotag() != 0) {
                short lotag = spr.getLotag();
                short hitag = spr.getHitag();
                spr.setLotag(0);
                spr.setHitag(0);
                Map.ProcessSpriteTag(i, lotag, hitag);
                continue;
            }
            Main.engine.changespritestat(i, 0);
        }
        if (Globals.nNetPlayerCount == 0) {
            return;
        }
        i = Main.engine.insertsprite(Globals.initsect, 0);
        spr = Main.boardService.getSprite(i);
        if (spr != null) {
            spr.setX(Globals.initx);
            spr.setY(Globals.inity);
            spr.setZ(Globals.initz);
            spr.setCstat(32768);
        }
        Globals.nNetStartSprite[Globals.nNetStartSprites] = i;
        ++Globals.nNetStartSprites;
    }

    static {
        sTrap = new TrapStruct[40];
        nTrapInterval = new int[40];
        showCredits = () -> {
            Cinema.GoToTheCinema(9, Main.game.rMenu);
            Globals.nPlayerLives[0] = 0;
        };
        toNextMap = () -> {
            Globals.levelnew = Globals.levelnum + 1;
            Map.checkNextMap();
        };
        word_14032 = new int[]{938, 937, 57, 56, 55, 54, 52, 51, 50, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 29, 28, 27, 19, 18, 17, 16, 15, 14, 10, 9, 2, 1, 0};
    }
}

